/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Stub;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.dopriv.GetClassLoaderPrivileged;
import java.lang.ref.WeakReference;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JITClassLoader
extends ClassLoader {
    private static final String CLASS_NAME = JITClassLoader.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");
    private static final String OMG_STUB_PREFIX = "org.omg.stub.";
    private static final ProtectionDomain svPD;
    private static WeakHashMap<ClassLoader, WeakReference<JITClassLoader>> svInstanceMap;
    private final ClassLoader ivParent;
    private final CompoundClassLoader ivAppCL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JITClassLoader getJITClassLoader(ClassLoader parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader: " + parent);
        }
        if (parent instanceof JITClassLoader) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getClassLoader: " + parent);
            }
            return (JITClassLoader)parent;
        }
        JITClassLoader jitCL = null;
        WeakHashMap<ClassLoader, WeakReference<JITClassLoader>> weakHashMap = svInstanceMap;
        synchronized (weakHashMap) {
            WeakReference<JITClassLoader> clRef = svInstanceMap.get(parent);
            if (clRef != null) {
                jitCL = (JITClassLoader)clRef.get();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "existing JITCL found for parent : " + jitCL);
                }
            }
            if (jitCL == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "existing JITCL not found - creating new one");
                }
                jitCL = new JITClassLoader(parent);
                clRef = new WeakReference<JITClassLoader>(jitCL);
                svInstanceMap.put(parent, clRef);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader: " + jitCL);
        }
        return jitCL;
    }

    private JITClassLoader() {
        throw new IllegalStateException("Unsupported constructor");
    }

    private JITClassLoader(ClassLoader parent) {
        super(parent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "JITClassLoader.<init>: " + parent);
        }
        this.ivParent = parent;
        this.ivAppCL = parent instanceof CompoundClassLoader ? (CompoundClassLoader)parent : null;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findClass: " + className);
        }
        Class<?> stubClass = null;
        String remoteInterfaceName = JIT_Stub.getRemoteInterfaceName(className);
        if (remoteInterfaceName != null) {
            block20: {
                if (!className.startsWith(OMG_STUB_PREFIX)) {
                    String omgClassName = OMG_STUB_PREFIX + className;
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempting load of class: " + omgClassName);
                        }
                        stubClass = this.ivParent.loadClass(omgClassName);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "findClass: " + stubClass);
                        }
                        return stubClass;
                    }
                    catch (Throwable ex) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "org.omg.stub load failed: " + ex);
                    }
                }
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "loading remote interface: " + remoteInterfaceName);
                }
                Class<?> remoteInterface = this.ivParent.loadClass(remoteInterfaceName);
                byte[] classbytes = JIT_Stub.generateStubBytes(remoteInterface);
                ClassLoader interfaceCL = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new GetClassLoaderPrivileged(remoteInterface));
                if (interfaceCL instanceof CompoundClassLoader) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "define using interface classloader: " + interfaceCL);
                    }
                    CompoundClassLoader appCL = (CompoundClassLoader)interfaceCL;
                    stubClass = appCL.defineApplicationClass(className, classbytes);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "define using this classloader: " + this);
                    }
                    stubClass = this.defineApplicationClass(className, classbytes);
                }
            }
            catch (ClassNotFoundException cnfex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "findClass failed: " + cnfex);
                }
                throw new ClassNotFoundException(className, cnfex);
            }
            catch (Throwable ex) {
                FFDCFilter.processException(ex, CLASS_NAME + ".findClass", "95", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "findClass failed: " + ex);
                }
                throw new ClassNotFoundException(className, ex);
            }
        }
        if (stubClass == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findClass: ClassNotFoundException: " + className);
            }
            throw new ClassNotFoundException(className);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findClass: " + stubClass);
        }
        return stubClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> defineApplicationClass(String className, byte[] bytecode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "defineApplicationClass: " + className);
        }
        Class<?> appClass = null;
        if (this.ivAppCL != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "delegating to parent : " + this.ivAppCL);
            }
            appClass = this.ivAppCL.defineApplicationClass(className, bytecode);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "defineApplicationClass: " + appClass);
            }
            return appClass;
        }
        JITClassLoader jITClassLoader = this;
        synchronized (jITClassLoader) {
            appClass = this.findLoadedClass(className);
            if (appClass == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling defineClass on this");
                }
                appClass = this.defineClass(className, bytecode, 0, bytecode.length, svPD);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "class has already been loaded");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "defineApplicationClass: " + appClass);
        }
        return appClass;
    }

    static {
        svInstanceMap = new WeakHashMap();
        Permissions pc = new Permissions();
        ((PermissionCollection)pc).add(new AllPermission());
        svPD = new ProtectionDomain(null, pc);
    }
}

