/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyGenerator;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;

public class WSKeyReference
extends KeyReference {
    private static final TraceComponent tc = Tr.register(WSKeyReference.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private Key key = null;
    private KeyGenerator keyGenerationClassImpl = null;
    private String keyGenerationClass = null;

    public WSKeyReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference kref, WSKeySet keySet, WSKeyStore ks) {
        super(kref, keySet, ks);
        this.keyGenerationClass = keySet.getKeyGenerationClass();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyReference");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyReference", new Object[]{this.toString()});
        }
    }

    public WSKeyReference(com.ibm.websphere.models.config.ipc.ssl.KeyReference kref, Key key, WSKeySet keySet, WSKeyStore ks) throws KeyException {
        super(kref, keySet, ks);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyReference (import key)");
        }
        try {
            this.keyGenerationClass = keySet.getKeyGenerationClass();
            KeyStore jkstore = ks.getKeyStore(false, false);
            this.importKey(key, jkstore);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSKeyPairReference import key initialization failed.", new Object[]{e});
            }
            if (e instanceof KeyException) {
                throw (KeyException)e;
            }
            throw new KeyException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyReference (import key)", new Object[]{this.toString()});
        }
    }

    public WSKeyReference(SecurityConfigObject kref, WSKeySet keySet, WSKeyStore ks) {
        super(kref, keySet, ks);
        this.keyGenerationClass = keySet.getKeyGenerationClass();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyReference");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyReference", new Object[]{this.toString()});
        }
    }

    public WSKeyReference(SecurityConfigObject kref, Key key, WSKeySet keySet, WSKeyStore ks) throws KeyException {
        super(kref, keySet, ks);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeyReference (import key)");
        }
        try {
            this.keyGenerationClass = keySet.getKeyGenerationClass();
            KeyStore jkstore = ks.getKeyStore(false, false);
            this.importKey(key, jkstore);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSKeyPairReference import key initialization failed.", new Object[]{e});
            }
            if (e instanceof KeyException) {
                throw (KeyException)e;
            }
            throw new KeyException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeyReference (import key)", new Object[]{this.toString()});
        }
    }

    public Key getKey() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey");
        }
        if (this.key == null) {
            try {
                KeyStore jkstore = null;
                String name = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreName");
                String type = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreType");
                String provider = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreProvider");
                String location = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
                String kspassword = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
                String scope = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreScope");
                jkstore = KeyStoreManager.getInstance().getKeyStore(name, type, provider, location, kspassword, scope, true, null);
                if (jkstore != null) {
                    String alias = this.getKeyAlias();
                    String password = this.getPassword();
                    this.key = jkstore.getKey(alias, password.toCharArray());
                    if (this.key == null && this.isValidKeyStoreType()) {
                        this.key = this.initializeReferenceIfNotInKeyStore(jkstore);
                    }
                }
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception getting Key from KeyStore.", new Object[]{e});
                Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSKeyReference.getKey", "173", this);
                Tr.error(tc, "crypto.key.getkey.error.CWPKI0201E", new Object[]{this.getKeySetName(), this.getKeyAlias(), e.getMessage()});
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                throw new KeyException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey");
        }
        return this.key;
    }

    public Key initializeReferenceIfNotInKeyStore(KeyStore jkstore) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeReferenceIfNotInKeyStore", new Object[]{jkstore.getType(), jkstore.getProvider()});
        }
        FileOutputStream fos = null;
        try {
            if (jkstore == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot generate keys because Java KeyStore cannot be obtained.");
                }
                throw new KeyException("Java KeyStore is NULL.");
            }
            if (this.keyGenerationClass == null || this.keyGenerationClass.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot generate keys as auto-generation class is not specified.");
                }
                throw new KeyException("Key is not present and keyGenerationClass is null.");
            }
            KeyGenerator keyGen = (KeyGenerator)this.getKeyGeneratorImpl();
            Key key = keyGen.generateKey();
            if (key != null) {
                String alias = this.getKeyAlias();
                String password = this.getPassword();
                jkstore.setKeyEntry(alias, key, password.toCharArray(), null);
                String keyStoreLocation = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
                String keyStorePassword = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
                fos = new FileOutputStream(keyStoreLocation);
                jkstore.store(fos, keyStorePassword.toCharArray());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "initializeReferenceIfNotInKeyStore (generated)");
                }
                Key key2 = key;
                return key2;
            }
            try {
                throw new KeyException("KeyGenerator " + this.keyGenerationClass + " did not return a Key.");
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception generating Key.", new Object[]{e});
                Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSKeySet.generate", "240", this);
                Tr.error(tc, "crypto.key.generate.configuration.error.CWPKI0200E", new Object[]{this.getKeySetName(), e.getMessage()});
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.generate.configuration.error.CWPKI0200E", new Object[]{this.getKeySetName(), e.getMessage()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys.  The detailed message is: " + e.getMessage()));
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void importKey(Key key, KeyStore jkstore) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importKey");
        }
        FileOutputStream fos = null;
        try {
            if (jkstore == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot update keys because Java KeyStore cannot be obtained.");
                }
                throw new KeyException("Java KeyStore is NULL.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyStore type is \"" + jkstore.getType() + "\" and the provider is \"" + jkstore.getProvider() + "\".");
            }
            if (key == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot updates keys as the Key is not specified.");
                }
                throw new KeyException("Key was not passed in.");
            }
            String alias = this.getKeyAlias();
            String password = this.getPassword();
            jkstore.setKeyEntry(alias, key, password.toCharArray(), null);
            String keyStoreLocation = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStore");
            String keyStorePassword = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStorePassword");
            fos = new FileOutputStream(keyStoreLocation);
            jkstore.store(fos, keyStorePassword.toCharArray());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importKey (imported)");
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception updating KeyStore with keys.", new Object[]{e});
            Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSKeyPairReference.importKey", "307", this);
            Tr.error(tc, "crypto.key.import.error.CWPKI0203E", new Object[]{this.getKeySetName(), e.getMessage()});
            if (e instanceof KeyException) {
                throw (KeyException)e;
            }
            throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.import.error.CWPKI0203E", new Object[]{this.getKeySetName(), e.getMessage()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys.  The detailed message is: " + e.getMessage()));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private Object getKeyGeneratorImpl() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyGeneratorImpl");
        }
        if (this.keyGenerationClassImpl == null) {
            if (this.keyGenerationClass != null && !this.keyGenerationClass.equals("")) {
                Object wrapperObj;
                block11: {
                    wrapperObj = null;
                    try {
                        Class<?> wrapperClass = Class.forName(this.keyGenerationClass);
                        wrapperObj = wrapperClass.newInstance();
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "Could not load using class using current class loader.");
                    }
                }
                if (wrapperObj == null) {
                    ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                    Class<?> wrapperClass = Class.forName(this.keyGenerationClass, true, contextCL);
                    wrapperObj = wrapperClass.newInstance();
                }
                if (wrapperObj != null && wrapperObj instanceof KeyGenerator) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Instantiating new KeyGenerator: " + this.keyGenerationClass);
                    }
                    this.keyGenerationClassImpl = wrapperObj;
                    if (this.getWSKeySet().getCustomProperties() != null) {
                        this.keyGenerationClassImpl.init(this.getWSKeySet().getCustomProperties());
                    }
                    return this.keyGenerationClassImpl;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getKeyGeneratorImpl is not an implementation of KeyGenerator.");
                }
                throw new KeyException("The custom key generator class " + this.keyGenerationClass + " is not an implementation of com.ibm.websphere.crypto.KeyGenerator.");
            }
            Tr.error(tc, "crypto.key.generate.configuration.error.CWPKI0202E", new Object[]{this.getKeySetName()});
            throw new KeyException(TraceNLSHelper.getInstance().getFormattedMessage("crypto.key.generate.configuration.error.CWPKI0202E", new Object[]{this.getKeySetName()}, "An attempt to generate keys using KeySet " + this.getKeySetName() + " occurred when the KeySet is not configured to generate keys."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyGeneratorImpl");
        }
        return this.keyGenerationClassImpl;
    }

    private boolean isValidKeyStoreType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidKeyStoreType");
        }
        if (this.getWSKeyStore() != null) {
            String readOnly = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreReadOnly");
            if (readOnly == null || readOnly.equals("")) {
                readOnly = this.getWSKeyStore().getProperty("com.ibm.ssl.trustStoreReadOnly");
            }
            if (readOnly != null && readOnly.equals("true")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidKeyStoreType (readonly) -> false");
                }
                return false;
            }
            String ksType = this.getWSKeyStore().getProperty("com.ibm.ssl.keyStoreType");
            if (ksType == null || ksType.equals("")) {
                ksType = this.getWSKeyStore().getProperty("com.ibm.ssl.trustStoreType");
            }
            if (ksType != null && (ksType.equals("JCEKS") || ksType.equals("JCECCAKS"))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidKeyStoreType -> true");
                }
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidKeyStoreType -> false keyStoreType is " + ksType);
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidKeyStoreType (null keystore) -> false");
        }
        return false;
    }
}

