/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.ssl.config.AdminContextHelper;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.EList;

public class KeySetManager {
    private static final TraceComponent tc = Tr.register(KeySetManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static KeySetManager thisClass = null;
    private static ConcurrentHashMap<String, KeySetManager> instanceCache = new ConcurrentHashMap();
    private static Object lockObject = new Object();
    private HashMap keySetMap = new HashMap();

    private KeySetManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeySetManager getInstance() {
        KeySetManager instance;
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if ((uuid = AdminContextHelper.peekAdminContext()) == null) {
            uuid = "admin";
        }
        if ((instance = instanceCache.get(uuid)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInstance did not find KeySetManager in the cache");
            }
            Object object = lockObject;
            synchronized (object) {
                instance = instanceCache.get(uuid);
                if (instance == null && (instance = new KeySetManager()) != null) {
                    instanceCache.put(uuid, instance);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInstance found KeySetManager in the cache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    public static void releaseInstance() {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseInstance");
        }
        if ((uuid = AdminContextHelper.peekAdminContext()) == null) {
            uuid = "admin";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseInstance using uuid " + uuid);
        }
        instanceCache.remove(uuid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseInstance");
        }
    }

    public synchronized void initializeKeySets(Security security2, boolean reinitialize) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeySets");
        }
        try {
            EList keySetList;
            if (reinitialize) {
                this.keySetMap.clear();
            }
            if ((keySetList = security2.getKeySets()) != null && keySetList.size() > 0) {
                for (int i = 0; i < keySetList.size(); ++i) {
                    KeySet ks = (KeySet)keySetList.get(i);
                    if (ks == null) continue;
                    String scope = ks.getManagementScope().getScopeName();
                    if (scope != null && !ManagementScopeManager.getInstance().currentScopeContained(scope)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping keyset name \"" + ks.getName() + "\" having scope \"" + scope + "\".");
                        continue;
                    }
                    WSKeySet kset = new WSKeySet(ks);
                    if (kset == null) continue;
                    this.keySetMap.put(ks.getName(), kset);
                }
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception initializing KeySets.", new Object[]{e});
            Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.KeySetManager.initializeKeySets", "104", this);
            throw new KeyException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeySets");
        }
    }

    public synchronized void initializeKeySets(SecurityConfigObject security2, boolean reinitialize) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeySets " + reinitialize);
        }
        try {
            SecurityConfigObjectList keySetList;
            if (reinitialize) {
                this.keySetMap.clear();
            }
            if ((keySetList = security2.getObjectList("keySets")) != null && keySetList.size() > 0) {
                for (int i = 0; i < keySetList.size(); ++i) {
                    SecurityConfigObject ks = keySetList.get(i);
                    if (ks == null) continue;
                    String scope = ks.getObject("managementScope").getString("scopeName");
                    if (scope != null && !ManagementScopeManager.getInstance().currentScopeContained(scope)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping keyset name \"" + ks.getString("name") + "\" having scope \"" + scope + "\".");
                        continue;
                    }
                    WSKeySet kset = new WSKeySet(ks);
                    if (kset == null) continue;
                    this.keySetMap.put(ks.getString("name"), kset);
                }
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception initializing KeySets.", new Object[]{e});
            Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.KeySetManager.initializeKeySets", "156", this);
            throw new KeyException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeySets");
        }
    }

    public WSKeySet getKeySet(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeySet -> " + name);
        }
        boolean found = false;
        WSKeySet wsks = (WSKeySet)this.keySetMap.get(name);
        if (wsks != null) {
            found = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeySet -> " + found);
        }
        return wsks;
    }
}

