/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.ssl.config.AdminContextHelper;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.EList;

public class KeySetGroupManager {
    private static final TraceComponent tc = Tr.register(KeySetGroupManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static ConcurrentHashMap<String, KeySetGroupManager> instanceCache = new ConcurrentHashMap();
    private static Object lockObject = new Object();
    private HashMap keySetGroupMap = new HashMap();
    private boolean isInitialized = false;

    private KeySetGroupManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeySetGroupManager getInstance() {
        KeySetGroupManager instance;
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if ((uuid = AdminContextHelper.peekAdminContext()) == null) {
            uuid = "admin";
        }
        if ((instance = instanceCache.get(uuid)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInstance did not find KeySetGroupManager in the cache");
            }
            Object object = lockObject;
            synchronized (object) {
                instance = instanceCache.get(uuid);
                if (instance == null && (instance = new KeySetGroupManager()) != null) {
                    instanceCache.put(uuid, instance);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInstance found KeySetGroupManager in the cache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    public static void releaseInstance() {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseInstance");
        }
        if ((uuid = AdminContextHelper.peekAdminContext()) == null) {
            uuid = "admin";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseInstance using uuid " + uuid);
        }
        instanceCache.remove(uuid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseInstance");
        }
    }

    public void initializeKeySetGroups(Security security2, boolean reinitialize) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeySetGroups");
        }
        try {
            if (reinitialize) {
                this.keySetGroupMap.clear();
            }
            KeySetManager.getInstance().initializeKeySets(security2, reinitialize);
            EList keySetGroupList = security2.getKeySetGroups();
            if (keySetGroupList != null && keySetGroupList.size() > 0) {
                for (int i = 0; i < keySetGroupList.size(); ++i) {
                    KeySetGroup ksg = (KeySetGroup)keySetGroupList.get(i);
                    if (ksg == null) continue;
                    String scope = ksg.getManagementScope().getScopeName();
                    if (scope != null && !ManagementScopeManager.getInstance().currentScopeContained(scope)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping keyset group name \"" + ksg.getName() + "\" having scope \"" + scope + "\".");
                        continue;
                    }
                    WSKeySetGroup ksetgroup = new WSKeySetGroup(ksg);
                    if (ksetgroup == null) continue;
                    this.keySetGroupMap.put(ksg.getName(), ksetgroup);
                }
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception initializing KeySetGroups.", new Object[]{e});
            Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.KeySetGroupManager.initializeKeySetGroups", "111", this);
            throw new KeyException(e);
        }
        this.isInitialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeySetGroups");
        }
    }

    public void initializeKeySetGroups(SecurityConfigObject security2, boolean reinitialize) throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeySetGroups " + reinitialize);
        }
        try {
            if (reinitialize) {
                this.keySetGroupMap.clear();
            }
            KeySetManager.getInstance().initializeKeySets(security2, reinitialize);
            SecurityConfigObjectList keySetGroupList = security2.getObjectList("keySetGroups");
            if (keySetGroupList != null && keySetGroupList.size() > 0) {
                for (int i = 0; i < keySetGroupList.size(); ++i) {
                    SecurityConfigObject ksg = keySetGroupList.get(i);
                    if (ksg == null) continue;
                    String scope = ksg.getObject("managementScope").getString("scopeName");
                    if (scope != null && !ManagementScopeManager.getInstance().currentScopeContained(scope)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping keyset group name \"" + ksg.getString("name") + "\" having scope \"" + scope + "\".");
                        continue;
                    }
                    WSKeySetGroup ksetgroup = new WSKeySetGroup(ksg);
                    if (ksetgroup == null) continue;
                    this.keySetGroupMap.put(ksg.getString("name"), ksetgroup);
                }
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception initializing KeySetGroups.", new Object[]{e});
            Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.KeySetGroupManager.initializeKeySetGroups", "168", this);
            throw new KeyException(e);
        }
        this.isInitialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeySetGroups");
        }
    }

    public WSKeySetGroup getKeySetGroup(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeySetGroup -> " + name);
        }
        boolean found = false;
        WSKeySetGroup wsksgroup = (WSKeySetGroup)this.keySetGroupMap.get(name);
        if (wsksgroup != null) {
            found = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeySetGroup -> " + found);
        }
        return wsksgroup;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

