/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ResourceCache {
    private char separator;
    Set frontMatter = new HashSet(3);

    public ResourceCache(char sep) {
        this.separator = sep;
    }

    public void add(String element, char sep) {
        String front = this.split(element, sep);
        this.frontMatter.add(front);
    }

    public boolean contains(String element, char sep) {
        String front = this.split(element, sep);
        return this.frontMatter.contains(front);
    }

    public boolean containsDir(String dirElement, char sep) {
        if (this.frontMatter.contains(dirElement = this.split(dirElement, sep))) {
            return true;
        }
        Iterator i = this.frontMatter.iterator();
        String next = null;
        while (i.hasNext()) {
            next = (String)i.next();
            if (next == null || !next.startsWith(dirElement)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.frontMatter.clear();
    }

    private String split(String element, char sep) {
        String front = null;
        if (sep == this.separator) {
            int lastSeparator = element.lastIndexOf(this.separator);
            front = lastSeparator >= 0 ? element.substring(0, lastSeparator) : "";
        } else {
            char[] sb = element.toCharArray();
            int lastSeparator = -1;
            for (int i = 0; i < sb.length; ++i) {
                if (sb[i] != sep) continue;
                sb[i] = this.separator;
                lastSeparator = i;
            }
            front = lastSeparator >= 0 ? new String(sb, 0, lastSeparator) : "";
        }
        return front;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(" contents: ");
        if (this.frontMatter == null) {
            sb.append("null");
        } else {
            Iterator iter = this.frontMatter.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                if (!first) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(iter.next());
                sb.append('\"');
                first = false;
            }
        }
        return sb.toString();
    }
}

