/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JarClassLoader
extends ReloadableClassLoader {
    private static final TraceComponent tc = Tr.register(JarClassLoader.class, "Websphere ClassLoader", null);
    protected Map jarPaths = new LinkedHashMap();
    protected Set libraryClassLoaderSet = new LinkedHashSet();
    protected boolean delegationMode = false;

    public JarClassLoader(String[] jarPaths, ClassLoader parent, boolean delegationMode) {
        super(parent);
        this.initialize(jarPaths, delegationMode);
    }

    public JarClassLoader(String[] jarPaths, ClassLoader parent, boolean delegationMode, boolean resrcReloadingDisabled) {
        super(parent, resrcReloadingDisabled);
        this.initialize(jarPaths, delegationMode);
    }

    protected void initialize(String[] jarPaths, boolean delegationMode) {
        this.setPaths(jarPaths);
        this.delegationMode = delegationMode;
        this.createLoader();
    }

    public void dispose(boolean deepDispose) {
        super.dispose(deepDispose);
        this.jarPaths.clear();
        this.jarPaths = null;
    }

    public String[] getPaths() {
        Set pathSet = this.jarPaths.keySet();
        String[] paths = new String[pathSet.size()];
        pathSet.toArray(paths);
        return paths;
    }

    protected boolean addPath(String path) {
        return this.jarPaths.put(path, Boolean.TRUE) == null;
    }

    public void addPaths(String[] paths) {
        if (paths != null && paths.length != 0) {
            ArrayList<String> newPaths = new ArrayList<String>();
            for (int i = 0; i < paths.length; ++i) {
                if (!this.addPath(paths[i])) continue;
                newPaths.add(paths[i]);
            }
            if (this.classLoader != null) {
                this.classLoader.addPaths(newPaths.toArray(new String[newPaths.size()]));
            }
        }
    }

    public void addNativeLibPaths(String[] nlpaths) {
        if (this.classLoader != null) {
            this.classLoader.addNativeLibPaths(nlpaths);
        }
    }

    public void addLibraryClassLoaders(CompoundClassLoader[] libraryClassLoaders) {
        if (libraryClassLoaders != null && libraryClassLoaders.length != 0 && this.classLoader != null) {
            ArrayList<CompoundClassLoader> newLoaders = new ArrayList<CompoundClassLoader>();
            for (int i = 0; i < libraryClassLoaders.length; ++i) {
                if (!this.libraryClassLoaderSet.add(libraryClassLoaders[i])) continue;
                newLoaders.add(libraryClassLoaders[i]);
            }
            this.classLoader.addLibraryClassLoaders(newLoaders.toArray(new CompoundClassLoader[newLoaders.size()]));
        }
    }

    protected boolean removePath(String path) {
        return this.jarPaths.remove(path) != null;
    }

    public void removePaths(String[] paths) {
        ArrayList<String> removedPaths = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            if (!this.removePath(paths[i])) continue;
            removedPaths.add(paths[i]);
        }
        if (this.classLoader != null) {
            String[] removedPathsArray = new String[removedPaths.size()];
            removedPaths.toArray(removedPathsArray);
            this.classLoader.removePaths(removedPathsArray);
        }
    }

    protected void setPaths(String[] paths) {
        this.jarPaths = new LinkedHashMap();
        this.addPaths(paths);
    }

    public boolean getDelegationMode() {
        return this.delegationMode;
    }
}

