/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.secure;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.file.NativeFile;
import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.channelfw.secure.FirstChannelActionsService;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.exception.NotSupportedException;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.tcp.channel.impl.BindInfo;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FirstChannelActions
extends WsComponentImpl
implements FirstChannelActionsService {
    private static int MIN_EARLY_BIND_PORT = 0;
    private static int MAX_EARLY_BIND_PORT = 1023;
    private Map bindsAttempted;
    private static final TraceComponent tc = Tr.register(FirstChannelActions.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        IDinfo ids = null;
        Iterator iter = null;
        Server server = null;
        ConfigObject root = null;
        EndPointMgr epManager = null;
        ConfigObject tChannel2 = null;
        EndPointMgr.EndPointInfo endPoint = null;
        ConfigService configService = null;
        EndPointMgr.NodeEndPoints nodeEPs = null;
        EndPointMgr.ServerEndPoints serverEPs = null;
        boolean leave = false;
        boolean isUserPrivileged = false;
        this.bindsAttempted = null;
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> Entry initialize(Object)");
        }
        try {
            configService = WsServiceRegistry.getService(this, ConfigService.class);
        }
        catch (Exception e) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("initialize: caught exception getting the config service: " + e);
            }
            throw new RuntimeException("Can not obtain Configuration Service");
        }
        if (!FirstChannelActions.isCurrentOSUnixVariant()) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("initialize: NOT Running on Unix Variant");
            }
            leave = true;
        } else {
            block37: {
                try {
                    isUserPrivileged = ProcessFactory.isUserPrivileged();
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("initialize: isUserPrivileged=" + isUserPrivileged);
                    }
                }
                catch (Exception e) {
                    if (!LoggingServices.debugEnabled) break block37;
                    LoggingServices.out.println("initialize: Caught exception calling ProcessFactory.isUserPrivilaged(); exception=" + e);
                }
            }
            if (!isUserPrivileged) {
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("initialize: User is not privileged");
                }
                leave = true;
            } else {
                ids = this.findIDs(configService);
                if (ids == null) {
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("initialize: IDs not found");
                    }
                    leave = true;
                }
            }
        }
        try {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("initialize: add ourself as a service");
            }
            WsServiceRegistry.addService(this, FirstChannelActionsService.class);
        }
        catch (Exception ex) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("initialize: caught exception adding service: " + ex);
            }
            this.doPrivilegedOperations(isUserPrivileged, ids);
            leave = true;
        }
        if (leave) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("< Exit initialize(Object) return early, no binds attempted");
            }
            return;
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("initialize: get config services");
        }
        try {
            server = WsServiceRegistry.getService(this, Server.class);
            epManager = WsServiceRegistry.getService(this, EndPointMgr.class);
        }
        catch (Exception ex) {
            this.doPrivilegedOperations(isUserPrivileged, ids);
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("initialize: caught Exception: " + ex);
            }
            ConfigurationError ce = new ConfigurationError(ex);
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("initialize: throws Exception: " + ce);
            }
            throw ce;
        }
        nodeEPs = epManager.getNodeEndPoints(server.getNodeName());
        serverEPs = nodeEPs.getServerEndPoints(server.getName());
        root = FirstChannelActions.getTransportChannelService(configService);
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("initialize: Search the Enabled Chains for TCP Inbound Channels");
        }
        List chains = root.getObjectList("chains");
        for (ConfigObject chain : chains) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("initialize: chain name found: " + chain.getString("name", "__null__"));
            }
            if (!chain.isSet("enable")) continue;
            List transportChannels = chain.getObjectList("transportChannels");
            for (ConfigObject tChannel2 : transportChannels) {
                if (!tChannel2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "TCPInboundChannel")) continue;
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("initialize: transportChannel: " + tChannel2.getString("name", "__null__"));
                }
                if ((endPoint = serverEPs.getEndPointInfo(tChannel2.getString("endPointName", "__null__"))) == null) continue;
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("initialize: EndPointInfo: host: " + endPoint.getHost() + "  port: " + String.valueOf(endPoint.getPort()));
                }
                if (!this.bindEarly(endPoint.getPort())) continue;
                BindInfo bind = new BindInfo();
                this.setBindProperties(bind, tChannel2, endPoint);
                this.bindConnection(bind, tChannel2.getString("name", "__null__"));
                if (this.bindsAttempted == null) {
                    this.bindsAttempted = new HashMap();
                }
                this.bindsAttempted.put(new Integer(endPoint.getPort()), bind);
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("initialize: entry added to bind HashMap");
                }
                if (bind.getBindException() == null) continue;
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("initialize: got/throw exception: " + bind.getBindException());
                }
                this.doPrivilegedOperations(isUserPrivileged, ids);
                ConfigurationError ce = new ConfigurationError(bind.getBindException());
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("< Exit initialize(Object) throwing ConfigurationError exception");
                }
                throw ce;
            }
        }
        this.doPrivilegedOperations(isUserPrivileged, ids);
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit initialize(Object)");
        }
    }

    private void setBindProperties(BindInfo _b, ConfigObject _c, EndPointMgr.EndPointInfo _e) throws ConfigurationError {
        List customProps = null;
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> Entry setBindProperties(BindInfo, ConfigObject, EndPointInfo)");
        }
        _b.setHostname(_e.getHost());
        _b.setPort(_e.getPort());
        customProps = _c.getObjectList("properties");
        if (customProps != null) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("setBindProperties: custom properties is not null, number of properties: " + customProps.size());
            }
            int result = ValidateUtils.VALIDATE_OK;
            String channelName = _c.getString("name", "__null__");
            for (int i = 0; i < customProps.size(); ++i) {
                ConfigObject prop = (ConfigObject)customProps.get(i);
                String key = prop.getString("name", null);
                if (key.equals("soReuseAddr")) {
                    String reuseAddr = prop.getString("value", null);
                    int value = new Integer(reuseAddr);
                    result = ValidateUtils.testBooleanFormat2((int)value);
                    if (result == ValidateUtils.VALIDATE_OK) {
                        _b.setReuseAddr(new Integer(reuseAddr).intValue());
                        if (!LoggingServices.debugEnabled) continue;
                        LoggingServices.out.println("setBindProperties: reuseAddr set to: " + reuseAddr);
                        continue;
                    }
                    Tr.error(tc, "CONFIG_VALUE_NOT_VALID_INT", new Object[]{channelName, key, reuseAddr, " Valid Range: 0 - False, 1 - True"});
                    ConfigurationError e = new ConfigurationError("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + channelName + " name: " + key + " value: " + reuseAddr + " Valid Range: 0 - False, 1 - True");
                    throw e;
                }
                if (key.equals("receiveBufferSize")) {
                    String recvBufferSize = prop.getString("value", null);
                    int receiveBufferSize = new Integer(recvBufferSize);
                    result = ValidateUtils.testReceiveBufferSize((int)receiveBufferSize);
                    if (result == ValidateUtils.VALIDATE_OK) {
                        _b.setRecvBufferSize(receiveBufferSize);
                        if (!LoggingServices.debugEnabled) continue;
                        LoggingServices.out.println("setBindProperties: Receive Buffer Size set to: " + receiveBufferSize);
                        continue;
                    }
                    Tr.error(tc, "CONFIG_VALUE_NOT_VALID_INT", new Object[]{channelName, key, recvBufferSize, "4", "16777216"});
                    ConfigurationError e = new ConfigurationError("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + channelName + " name: " + key + " value: " + recvBufferSize + "minimum Value: " + 4 + "maximum Value: " + 0x1000000);
                    throw e;
                }
                if (key.equals("listenBacklog")) {
                    String sBacklog = prop.getString("value", null);
                    int backlog = new Integer(sBacklog);
                    result = ValidateUtils.testListenBacklog((int)backlog);
                    if (result == ValidateUtils.VALIDATE_OK) {
                        if (LoggingServices.debugEnabled) {
                            LoggingServices.out.println("setBindProperties: Listen Backlog set to: " + backlog);
                        }
                        _b.setListenBacklog(backlog);
                        continue;
                    }
                    Tr.error(tc, "CONFIG_VALUE_NOT_VALID_INT", new Object[]{channelName, key, sBacklog, "" + ValidateUtils.LISTEN_BACKLOG_MIN, "" + ValidateUtils.LISTEN_BACKLOG_MAX});
                    ConfigurationError e = new ConfigurationError("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + channelName + " name: " + key + " value: " + sBacklog + "minimum Value: " + ValidateUtils.LISTEN_BACKLOG_MIN + "maximum Value: " + ValidateUtils.LISTEN_BACKLOG_MAX);
                    throw e;
                }
                if (!LoggingServices.debugEnabled) continue;
                LoggingServices.out.println("setBindProperties: property: " + prop.getString("name", null) + " value: " + prop.getString("value", null));
            }
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit setBindProperties(BindInfo, ConfigObject, EndPointInfo)");
        }
    }

    protected static ConfigObject getTransportChannelService(ConfigService service) {
        block7: {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("> Entry getTransportChannelService(ConfigService)");
            }
            try {
                List list = service.getDocumentObjects(service.getScope(4), "server.xml");
                for (ConfigObject server : list) {
                    List services = server.getObjectList("services");
                    for (ConfigObject current : services) {
                        if (!current.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.xmi", "TransportChannelService")) continue;
                        if (LoggingServices.debugEnabled) {
                            LoggingServices.out.println("< Exit getTransportChannelService(ConfigService) returning found instance");
                        }
                        return current;
                    }
                }
            }
            catch (Exception e) {
                if (!LoggingServices.debugEnabled) break block7;
                LoggingServices.out.println("getTransportChannelService: Caught Exception will processing configuration data" + e);
            }
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit getTransportChannelService(ConfigService) return null");
        }
        return null;
    }

    private boolean bindEarly(int port) {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> Entry bindEarly(int port) port: " + port);
        }
        if (port <= MAX_EARLY_BIND_PORT && port >= MIN_EARLY_BIND_PORT) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("< Exit bindEarly(int port) return true");
            }
            return true;
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit bindEarly(int port) return false");
        }
        return false;
    }

    public Map getEarlyBinds() {
        return this.bindsAttempted;
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println(">< Entry/Exit start()");
        }
    }

    public void stop() {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println(">< Entry/Exit stop()");
        }
    }

    public void destroy() {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println(">< Entry/Exit destroy()");
        }
    }

    public void bindConnection(BindInfo _bind, String channelName) {
        InetSocketAddress socketAddress = null;
        ServerSocket serverSocket = null;
        ServerSocketChannel ssc = null;
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> Entry bindConnection(BindInfo) hostname: " + _bind.getHostname());
        }
        String hostname = _bind.getHostname();
        int port = _bind.getPort();
        socketAddress = hostname.equals("*") ? new InetSocketAddress((InetAddress)null, port) : new InetSocketAddress(hostname, port);
        if (!socketAddress.isUnresolved()) {
            IOException bindError;
            block21: {
                try {
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("bindConnection: open ServerSocketChannel and get socket");
                    }
                    ssc = ServerSocketChannel.open();
                }
                catch (IOException x) {
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("bindConnection: TCP Channel: " + channelName + "- Problem occurred while initializing TCP Channel: " + x.getMessage());
                    }
                    _bind.setBindException((Exception)x);
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("< Exit bindConnection(BindInfo)");
                    }
                    return;
                }
                serverSocket = ssc.socket();
                _bind.setServerSocket(serverSocket);
                bindError = null;
                try {
                    int rBuffSize = _bind.getRecvBufferSize();
                    if (rBuffSize != -1 && rBuffSize >= 4 && rBuffSize <= 0x1000000) {
                        serverSocket.setReceiveBufferSize(rBuffSize);
                    }
                    if (_bind.getReuseAddr() == 1) {
                        serverSocket.setReuseAddress(true);
                    } else {
                        serverSocket.setReuseAddress(false);
                    }
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("bindConnection: serverSocket.bind(..) using hostname: " + _bind.getHostname() + " port: " + _bind.getPort() + " getRecvBufferSize: " + _bind.getRecvBufferSize() + " ReuseAddress: " + serverSocket.getReuseAddress() + " ListenBacklog: " + _bind.getListenBacklog());
                    }
                    serverSocket.bind(socketAddress, _bind.getListenBacklog());
                }
                catch (IOException ioe) {
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("bindConnection: IOE error: " + ioe);
                    }
                    bindError = ioe;
                    if (_bind.getReuseAddr() == 1) break block21;
                    try {
                        InetSocketAddress testAddr = new InetSocketAddress(hostname, port);
                        SocketChannel testChannel = SocketChannel.open(testAddr);
                        testChannel.close();
                    }
                    catch (IOException testioe) {
                        try {
                            serverSocket.setReuseAddress(true);
                            serverSocket.bind(socketAddress, _bind.getListenBacklog());
                            bindError = null;
                        }
                        catch (IOException newioe) {
                            bindError = newioe;
                            if (!LoggingServices.debugEnabled) break block21;
                            LoggingServices.out.println("bindConnection: IOE error: " + ioe);
                        }
                    }
                }
            }
            if (bindError != null) {
                _bind.setBindException((Exception)bindError);
                Tr.error(tc, "BIND_ERROR", new Object[]{channelName, hostname, String.valueOf(port)});
            }
        } else {
            IOException ioe = new IOException("local address unresolved");
            _bind.setBindException((Exception)ioe);
            Tr.error(tc, "LOCAL_HOST_UNRESOLVED", new Object[]{channelName, hostname, String.valueOf(port)});
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit bindConnection(BindInfo)");
        }
    }

    private boolean setToNewIDs(IDinfo _ids) throws ConfigurationError {
        boolean groupIdOK = false;
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> Entry setToNewIDs(IDinfo)");
        }
        if (_ids == null) {
            LoggingServices.out.println("new ids were null");
            LoggingServices.out.println("< Exit setToNewIDs(IDinfo) returning false");
            return false;
        }
        try {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("setToNewIDs: set Group ID to: " + _ids.getGroupID());
            }
            ProcessFactory.setCurrentProcessGroup((String)_ids.getGroupID());
            groupIdOK = true;
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("setToNewIDs: set User ID to: " + _ids.getUserID());
            }
            ProcessFactory.setCurrentProcessUser((String)_ids.getUserID());
        }
        catch (NotSupportedException nse) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("setToNewIDs: Caught NotSupportedException");
                LoggingServices.out.println("< Exit setToNewIDs(IDinfo) returning false");
            }
            return false;
        }
        catch (Exception ex) {
            String s;
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("setToNewIDs: Caught Exception: " + ex);
            }
            if (groupIdOK) {
                s = _ids.getUserID();
                Tr.error(tc, "USER_ID_NOT_VALID", s);
            } else {
                s = _ids.getGroupID();
                Tr.error(tc, "GROUP_ID_NOT_VALID", s);
            }
            ConfigurationError e = new ConfigurationError("Unable to use the User ID and Group ID specified");
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("< Exit setToNewIDs(IDinfo) throw ConfigurationError exception:" + e);
            }
            throw e;
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit setToNewIDs(IDinfo) returning true");
        }
        return true;
    }

    public static boolean isCurrentOSUnixVariant() {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> Entry isCurrentOSUnixVariant()");
        }
        String osName = System.getProperty("os.name", "unknown");
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("setToNewUser: OS Name is: " + osName);
        }
        if (FirstChannelActions.isLinux(osName)) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("> Entry isCurrentOSUnixVariant() found Linux, returning true");
            }
            return true;
        }
        if (FirstChannelActions.isSun(osName)) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("> Entry isCurrentOSUnixVariant() found Sun, returning true");
            }
            return true;
        }
        if (FirstChannelActions.isHPUX(osName)) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("> Entry isCurrentOSUnixVariant() found HP, returning true");
            }
            return true;
        }
        if (FirstChannelActions.isAIX(osName)) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("> Entry isCurrentOSUnixVariant() found AIX, returning true");
            }
            return true;
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> Entry isCurrentOSUnixVariant() found None, returning false");
        }
        return false;
    }

    protected static boolean isSun(String osName) {
        return osName.indexOf("SunOS") != -1 || osName.indexOf("Solaris") != -1;
    }

    protected static boolean isHPUX(String osName) {
        return osName.indexOf("HP-UX") != -1;
    }

    protected static boolean isLinux(String osName) {
        return osName.toLowerCase().indexOf("linux") != -1;
    }

    protected static boolean isAIX(String osName) {
        return osName.toLowerCase().startsWith("aix");
    }

    private IDinfo findIDs(ConfigService service) throws ConfigurationError {
        IDinfo id = null;
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> Entry findIDs(ConfigService)");
        }
        try {
            List list = service.getDocumentObjects(service.getScope(4), "server.xml");
            for (ConfigObject server : list) {
                String user = server.getString("changeUserAfterStartup", null);
                String group = server.getString("changeGroupAfterStartup", null);
                if (user != null) {
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("findIDs: found new user id: " + user);
                    }
                    if (group != null) {
                        if (LoggingServices.debugEnabled) {
                            LoggingServices.out.println("findIDs: found new group id: " + group);
                        }
                        id = new IDinfo();
                        id.setUserID(user);
                        id.setGroupID(group);
                        break;
                    }
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("findIDs: only found new user id");
                        LoggingServices.out.println("< Exit throwing exception");
                    }
                    ConfigurationError e = new ConfigurationError("New User ID specified, but no new Group ID specified");
                    throw e;
                }
                if (group == null) continue;
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("findIDs: only found new group id: " + group);
                    LoggingServices.out.println("< Exit throwing exception");
                }
                ConfigurationError e = new ConfigurationError("New Group ID specified, but no new User ID specified");
                throw e;
            }
        }
        catch (Exception ex) {
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("findIDs: Caught Exception while processing configuration data" + ex);
                LoggingServices.out.println("< Exit throwing exception");
            }
            ConfigurationError e = new ConfigurationError(ex);
            throw e;
        }
        if (LoggingServices.debugEnabled) {
            if (id == null) {
                LoggingServices.out.println("< Exit findIDs(ConfigService) returning null");
            } else {
                LoggingServices.out.println("< Exit findIDs(ConfigService) returning User: " + id.getUserID() + " Group: " + id.getGroupID());
            }
        }
        return id;
    }

    private static void setFileOwnershipAndPermissions(IDinfo idInfo, NativeFile path) {
        block13: {
            if (idInfo == null || path == null) {
                return;
            }
            if (LoggingServices.debugEnabled) {
                LoggingServices.out.println("> setFileOwnershipAndPermissions (IDinfo, NativeFile)");
            }
            try {
                if (LoggingServices.debugEnabled) {
                    LoggingServices.out.println("> setFileOwnershipAndPermissions: path=" + path);
                }
                if (path.exists()) {
                    FirstChannelActions.setOwnershipAndPermissions(idInfo, path);
                }
                if (path.isDirectory()) {
                    NativeFile[] fileList = path.listNativeFiles();
                    if (LoggingServices.debugEnabled) {
                        LoggingServices.out.println("> setFileOwnershipAndPermissions: fileList.length=" + (fileList != null ? Integer.valueOf(fileList.length) : "null"));
                    }
                    if (fileList != null) {
                        for (int i = 0; i < fileList.length; ++i) {
                            NativeFile currentPath = fileList[i];
                            if (LoggingServices.debugEnabled) {
                                LoggingServices.out.println("> setFileOwnershipAndPermissions: currentPath.isDirectory()=" + currentPath.isDirectory() + ", currentPath=" + currentPath);
                            }
                            if (currentPath.isDirectory()) {
                                FirstChannelActions.setFileOwnershipAndPermissions(idInfo, currentPath);
                                continue;
                            }
                            FirstChannelActions.setOwnershipAndPermissions(idInfo, currentPath);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!LoggingServices.debugEnabled) break block13;
                LoggingServices.out.println("setFileOwnershipAndPermissions: Caught exception changing to new user and group. Exception=" + e + "; path=" + path);
            }
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit");
        }
    }

    private static void setOwnershipAndPermissions(IDinfo idInfo, NativeFile file) throws Exception {
        if (idInfo == null || file == null) {
            return;
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> setOwnershipAndPermissions (IDinfo, NativeFile)");
        }
        file.setGroup(idInfo.getGroupID());
        file.setPermissions(7, 7, 5);
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit");
        }
    }

    private static void setToNewOwnershipAndPermissions(IDinfo ids) {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> setToNewOwnershipAndPermissions(IDinfo)");
        }
        String serverRoot = System.getProperty("server.root");
        FirstChannelActions.setFileOwnershipAndPermissions(ids, new NativeFile(serverRoot + File.separatorChar + "logs"));
        FirstChannelActions.setFileOwnershipAndPermissions(ids, new NativeFile(serverRoot + File.separatorChar + "temp"));
        FirstChannelActions.setFileOwnershipAndPermissions(ids, new NativeFile(serverRoot + File.separatorChar + "wstemp"));
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit");
        }
    }

    private void doPrivilegedOperations(boolean isUserPrivileged, IDinfo ids) throws ConfigurationError {
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("> doPrivilegedOperations(isUserPrivilaged IDinfo)");
        }
        if (isUserPrivileged) {
            FirstChannelActions.setToNewOwnershipAndPermissions(ids);
            this.setToNewIDs(ids);
        }
        if (LoggingServices.debugEnabled) {
            LoggingServices.out.println("< Exit");
        }
    }

    class IDinfo {
        String userID = null;
        String groupID = null;

        IDinfo() {
        }

        void setUserID(String _s) {
            this.userID = _s;
        }

        String getUserID() {
            return this.userID;
        }

        void setGroupID(String _s) {
            this.groupID = _s;
        }

        String getGroupID() {
            return this.groupID;
        }
    }
}

