/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.impl.CFEndPointImpl;
import com.ibm.ws.channel.framework.impl.ChainDataImpl;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.IncoherentChainException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import java.util.Map;

public class WSChainData
extends ChainDataImpl {
    private static final TraceComponent tc = Tr.register(WSChainData.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private static final long serialVersionUID = 6952496898547823880L;
    protected String _acceptorID;
    protected boolean _enabled;

    public WSChainData(String name, FlowType type, ChannelData[] channels, ChannelFrameworkImpl fw, Map inputProperties) throws IncoherentChainException {
        super(name, type, channels, fw, inputProperties);
    }

    public String getAcceptorID() {
        return this._acceptorID;
    }

    public void setAcceptorID(String acceptorID) {
        this._acceptorID = acceptorID;
    }

    public String toString() {
        if (this._acceptorID == null) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append("\n\tacceptorID = ");
        result.append(this._acceptorID);
        return result.toString();
    }

    public CFEndPoint getEndPoint() throws ChainNotInboundException, NoCFEndPointException, NullCFEndPointException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPoint");
        }
        CFEndPointImpl endPoint = null;
        try {
            if (this.getType() != FlowType.INBOUND) {
                throw new ChainNotInboundException("Chain " + this.getName() + " is an outbound chain.");
            }
            endPoint = new CFEndPointImpl(this, (WSChannelFrameworkImpl)this.framework);
        }
        catch (NoCFEndPointException exp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Chain " + this.getName() + " includes non WS channel factory.");
            }
            throw exp;
        }
        catch (NullCFEndPointException exp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception when building CFEndPoint for chain " + this.getName(), (Object)exp);
            }
            throw exp;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPoint");
        }
        return endPoint;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    protected void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }
}

