/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.ws.channel.framework.impl.ChainDataImpl;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.exception.InvalidChainNameException;
import com.ibm.wsspi.channel.framework.exception.RetryableChannelException;

public class ChainStartAlarmListener
implements AlarmListener {
    private static TraceComponent tc = Tr.register(ChainStartAlarmListener.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private int retryInterval = 0;
    private int retriesSoFar = 0;
    private int maximumRetries = 0;
    private ChainData chainData = null;
    private ChannelFrameworkImpl framework = null;

    public ChainStartAlarmListener(ChannelFrameworkImpl _framework, ChainData _chainData, int _maximumRetries, int _retryInterval) {
        this.framework = _framework;
        this.chainData = _chainData;
        this.maximumRetries = _maximumRetries;
        this.retriesSoFar = 0;
        this.retryInterval = _retryInterval;
    }

    public void alarm(Object alarmContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm");
        }
        try {
            ++this.retriesSoFar;
            this.framework.startChainInternal(this.chainData, ChainStartMode.RETRY_EACH_ON_FAIL);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during attempt " + this.retriesSoFar + " to start chain " + this.chainData.getName());
            }
            ((ChainDataImpl)this.chainData).chainStartFailed(this.retriesSoFar + 1, this.maximumRetries - this.retriesSoFar);
            if (e instanceof RetryableChannelException) {
                if (this.maximumRetries == -1 || this.retriesSoFar < this.maximumRetries) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Maximum attempts " + this.maximumRetries + " not reached so trying to start chain again.");
                    }
                    AlarmManager.createNonDeferrable(this.retryInterval, this);
                } else {
                    FFDCFilter.processException(e, "com.ibm.ws.channel.framework.impl.ChainStartAlarmListener.alarm", "90", this, new Object[]{this.chainData, new Long(this.maximumRetries), this.framework});
                    Tr.error(tc, "chain.retrystart.error", new Object[]{this.chainData.getName(), new Long(this.maximumRetries)});
                }
            }
            if (e instanceof InvalidChainNameException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Chain config no longer exists.  Ignoring this stale request to start the chain.");
                }
            }
            FFDCFilter.processException(e, "com.ibm.ws.channel.framework.impl.ChainStartAlarmListener.alarm", "103", this, new Object[]{this.chainData, this.framework});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }
}

