/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.ctm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.OutboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.channels.GenericChannelData;
import com.ibm.websphere.models.config.channelservice.channels.GenericInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.GenericOutboundChannel;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.ws.channel.framework.PlatformCheck;
import com.ibm.ws.channel.framework.impl.RCSUtil;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.config.InternalConfigService;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.channel.framework.exception.ChannelJARAlreadyLoadedException;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.runtime.config.ConfigDocument;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;

public abstract class BaseChannelTypeManager
implements ChannelTypeManager {
    protected static final TraceComponent tc = Tr.register(BaseChannelTypeManager.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    protected Set<File> _jarSet;
    protected Map<Object, Object> _typeMap = new HashMap<Object, Object>();
    private ConfigService cService = null;

    public BaseChannelTypeManager() {
        this._jarSet = new HashSet<File>();
        ArchiveInit.init();
    }

    private void addOSGiChannelFactoryTypes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addOSGiChannelFactoryTypes()");
        }
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "using an IExtensionRegistry of: " + registry);
        }
        String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".channel-framework-channel-factory-type";
        IConfigurationElement[] channels = registry.getConfigurationElementsFor(epid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "number of factory objects found: " + channels.length);
        }
        for (int j = 0; j < channels.length; ++j) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "looking at factory object: " + channels[j]);
            }
            this.addChannelFactoryMetaData(new OSGiChannelFactoryMetaDataImpl(channels[j]));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addOSGiChannelFactoryTypes()");
        }
    }

    private void addOSGiChannelTypes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addOSGiChannelTypes()");
        }
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "using an IExtensionRegistry of: " + registry);
        }
        String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".channel-framework-channel-type";
        IConfigurationElement[] channels = registry.getConfigurationElementsFor(epid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "number of channel objects found: " + channels.length);
        }
        for (int j = 0; j < channels.length; ++j) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "looking at channel object: " + channels[j]);
            }
            this.addChannelMetaData(new OSGiChannelMetaDataImpl(channels[j]));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addOSGiChannelTypes()");
        }
    }

    public int ConnTypeChannelCheck(ConfigObject input, boolean useWCCM) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ConnTypeChannelCheck(ConfigObject, boolean): " + input);
        }
        int ret = 0;
        String uri = input.getTypeURI();
        if (uri == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "ConnTypeChannelCheck() no typeURI return unknown");
            }
            return ret;
        }
        String name = input.getTypeName();
        if (name == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "ConnTypeChannelCheck() no typeName return unknown");
            }
            return ret;
        }
        String key = uri.concat(name);
        ChannelTypeManager.ChannelMetaData metaData = (ChannelTypeManager.ChannelMetaData)this._typeMap.get(key);
        if (metaData != null) {
            String connType = metaData.getConnType();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "connType: " + connType + " typeName: " + name);
            }
            if (connType != null) {
                if (connType.toLowerCase().indexOf("inbound") != -1) {
                    ret = 1;
                } else if (connType.toLowerCase().indexOf("outbound") != -1) {
                    ret = 2;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "found connection type using connType: " + ret);
                }
            }
            if (ret == 0) {
                if (name.toLowerCase().indexOf("inbound") != -1) {
                    ret = 1;
                } else if (name.toLowerCase().indexOf("outbound") != -1) {
                    ret = 2;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "found connection type using typeName: " + ret);
                }
            }
            if (ret == 0) {
                String conClass = metaData.getConfigurationClass();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "configurationClass: " + conClass);
                }
                if (conClass != null) {
                    if (conClass.toLowerCase().indexOf("inbound") != -1) {
                        ret = 1;
                    } else if (conClass.toLowerCase().indexOf("outbound") != -1) {
                        ret = 2;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "found connection type using configurationClass : " + ret);
                    }
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "metadata can't be found.  Key is: " + key);
        }
        if (ret == 0 && useWCCM) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "find channel type using WCCM");
            }
            try {
                EObject object;
                if (this.cService == null) {
                    this.cService = WsServiceRegistry.getService(this, ConfigService.class);
                }
                if ((object = ((InternalConfigService)this.cService).getEObject(input)) instanceof InboundTransportChannel) {
                    ret = 1;
                } else if (object instanceof OutboundTransportChannel) {
                    ret = 2;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "found channel type using WCCM; " + ret);
                }
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, this.getClass().getName() + ".ConnTypeChannelCheck", "1090", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ConnTypeChannelCheck(ConfigObject, boolean): RC: " + ret);
        }
        return ret;
    }

    public ChannelTypeManager.ChannelMetaData getChannelType(ConfigObject key) {
        ChannelTypeManager.ChannelMetaData type;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getChannelType(ConfigObject): " + key);
        }
        String key2 = key.getTypeURI().concat(key.getTypeName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking for key using RCS string: " + key2);
        }
        if ((type = this.getChannelType(key2)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "could not find it using RCS string, trying WCCM Object");
            }
            try {
                EObject object;
                TransportChannel wccmObject;
                if (this.cService == null) {
                    this.cService = WsServiceRegistry.getService(this, ConfigService.class);
                }
                if ((type = this.getChannelType(wccmObject = (TransportChannel)(object = ((InternalConfigService)this.cService).getEObject(key)))) == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "could not find it using WCCM Object");
                }
            }
            catch (Exception x) {
                FFDCFilter.processException(x, this.getClass().getName() + ".getChannelType", "923", this, null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getChannelType(ConfigObject): " + type);
        }
        return type;
    }

    public ChannelTypeManager.ChannelMetaData getChannelType(Object key) {
        try {
            return (ChannelTypeManager.ChannelMetaData)this.getTypeMetaData(key);
        }
        catch (ClassCastException exp) {
            return null;
        }
    }

    public ChannelTypeManager.ChannelFactoryMetaData getChannelFactoryType(Object key) {
        try {
            return (ChannelTypeManager.ChannelFactoryMetaData)this.getTypeMetaData(key);
        }
        catch (ClassCastException exp) {
            return null;
        }
    }

    public String createFullyQualifiedGenericID(ConfigObject data) {
        return BaseChannelTypeManager.createFullyQualifiedGenericID(data.getString("typeID", null));
    }

    protected Object getTypeMetaData(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTypeMetaData(): " + key);
        }
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "key is instance of String:  Returning: " + this._typeMap.get(key));
            }
            return this._typeMap.get(key);
        }
        if (key instanceof Class) {
            Object result;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "key is instance of Class");
            }
            if ((result = this._typeMap.get(key)) == null) {
                Class klass;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(1) key not found");
                }
                if ((result = this.getTypeMetaData((klass = (Class)key).getName())) == null) {
                    Class<?>[] keyInterfaces = klass.getInterfaces();
                    for (int i = 0; i < keyInterfaces.length && result == null; ++i) {
                        result = this.getTypeMetaData(keyInterfaces[i]);
                    }
                }
                if (result == null) {
                    result = this.getTypeMetaData(klass.getSuperclass());
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(1) Putting into _typeMap the following key: " + key + " and the following value: " + result);
                }
                this._typeMap.put(key, result);
            }
            return result;
        }
        Object result = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Comparing key to GenericChannelData  key is: " + key);
        }
        boolean foundOne = false;
        if (key instanceof ConfigObject) {
            ConfigObject tempKey = (ConfigObject)key;
            if (RCSUtil.instanceOfGenericChannelData(tempKey)) {
                foundOne = true;
                result = this.getTypeMetaData(this.createFullyQualifiedGenericID(tempKey));
            } else if (this.ConnTypeChannelCheck(tempKey, false) == 0) {
                boolean proceed = true;
                if (this.cService == null) {
                    try {
                        this.cService = WsServiceRegistry.getService(this, ConfigService.class);
                    }
                    catch (Exception x) {
                        FFDCFilter.processException((Throwable)x, this.getClass().getName() + ".getTypeMetaData", "1085", this);
                        proceed = false;
                    }
                }
                if (proceed && RCSUtil.instanceOfGenericChannelDataUsingWCCM(this.cService, tempKey)) {
                    foundOne = true;
                    result = this.getTypeMetaData(this.createFullyQualifiedGenericID(tempKey));
                }
            }
        }
        if (!foundOne) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "not found yet, calling getTypeMetaData with key.getClass()");
            }
            if ((result = this.getTypeMetaData(key.getClass())) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "still not found yet, checking if key is WCCM instance of Generics");
                }
                if (key instanceof GenericInboundChannel || key instanceof GenericOutboundChannel || key instanceof GenericChannelData) {
                    String id = ((GenericChannelData)key).getTypeID();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling getTypeMetaData for Generic Type ID of: " + id);
                    }
                    result = this.getTypeMetaData(id);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "result of calling getTypeMetaData for Generic Type ID is: " + result);
                    }
                }
            }
        }
        if (result == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "could not find channel or channel factory metadata for " + key);
        }
        return result;
    }

    protected void addChannelMetaData(ChannelTypeManager.ChannelMetaData metadata2) {
        String configTypeWCCM;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addChannelMetaData");
        }
        boolean okToAdd = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Channel configuration class is: " + metadata2.getConfigurationClass());
        }
        String configTypeRCS = null;
        String configType = configTypeWCCM = metadata2.getConfigurationClass();
        if (this.checkGeneric(configTypeWCCM)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Generic channel detected - TypeID: " + metadata2.getTypeID());
            }
            configType = configTypeWCCM = BaseChannelTypeManager.createFullyQualifiedGenericID(metadata2.getTypeID());
        } else if (metadata2.getTypeURI() != null && metadata2.getTypeName() != "") {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found typeURI: " + metadata2.getTypeURI());
                Tr.debug(tc, "Found typeName: " + metadata2.getTypeName());
            }
            configType = configTypeRCS = metadata2.getTypeURI().concat(metadata2.getTypeName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Using ConfigType of: " + configType);
        }
        if (PlatformCheck.validOn(metadata2.getPlatform())) {
            ChannelTypeManager.ChannelMetaData existingMetaData = (ChannelTypeManager.ChannelMetaData)this._typeMap.get(configType);
            if (existingMetaData != null) {
                if (existingMetaData.getPlatform() == null) {
                    if (metadata2.getPlatform() == null) {
                        okToAdd = false;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found redundant metadata for configType: " + configType);
                        }
                    } else {
                        okToAdd = true;
                    }
                } else {
                    okToAdd = false;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Former type exists and platform specified, configType: " + configType);
                    }
                    if (metadata2.getPlatform() != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found redundant metadata for configType: " + configType);
                    }
                }
            } else {
                okToAdd = true;
            }
        } else {
            okToAdd = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Platform does not match current system, configType: " + configType);
            }
        }
        if (okToAdd) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "associating " + configType + "/" + metadata2);
            }
            if (configTypeRCS != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(2.1) Putting into _typeMap the following key: " + configTypeRCS + " and the following value: " + metadata2);
                }
                this._typeMap.put(configTypeRCS, metadata2);
            }
            if (configTypeWCCM != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(2.2) Putting into _typeMap the following key: " + configTypeWCCM + " and the following value: " + metadata2);
                }
                this._typeMap.put(configTypeWCCM, metadata2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addChannelMetaData");
        }
    }

    protected void addChannelFactoryMetaData(ChannelTypeManager.ChannelFactoryMetaData metadata2) {
        String configTypeWCCM;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addChannelFactoryMetaData");
        }
        boolean okToAdd = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Factory configuration class is: " + metadata2.getConfigurationClass());
        }
        String configTypeRCS = null;
        String configType = configTypeWCCM = metadata2.getConfigurationClass();
        if (this.checkGeneric(configTypeWCCM)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Generic factory detected - TypeID: " + metadata2.getTypeID());
            }
            configType = configTypeWCCM = BaseChannelTypeManager.createFullyQualifiedGenericID(metadata2.getTypeID());
        } else if (metadata2.getTypeURI() != null && metadata2.getTypeURI() != "") {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found typeURI: " + metadata2.getTypeURI());
                Tr.debug(tc, "Found typeName: " + metadata2.getTypeName());
            }
            configType = configTypeRCS = metadata2.getTypeURI().concat(metadata2.getTypeName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Using ConfigType of: " + configType);
        }
        if (PlatformCheck.validOn(metadata2.getPlatform())) {
            ChannelTypeManager.ChannelFactoryMetaData existingMetaData = (ChannelTypeManager.ChannelFactoryMetaData)this._typeMap.get(configType);
            if (existingMetaData != null) {
                if (existingMetaData.getPlatform() == null) {
                    if (metadata2.getPlatform() == null) {
                        okToAdd = false;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found redundant metadata for configType: " + configType);
                        }
                    } else {
                        okToAdd = true;
                    }
                } else {
                    okToAdd = false;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Former type exists and platform specified, configType: " + configType);
                    }
                    if (metadata2.getPlatform() != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found redundant metadata for configType: " + configType);
                    }
                }
            } else {
                okToAdd = true;
            }
        } else {
            okToAdd = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Platform does not match current system, configType: " + configType);
            }
        }
        if (okToAdd) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "associating " + configType + "/" + metadata2);
            }
            if (configTypeRCS != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(3.1) Putting into _typeMap the following key: " + configTypeRCS + " and the following value: " + metadata2);
                }
                this._typeMap.put(configTypeRCS, metadata2);
            }
            if (configTypeWCCM != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "(3.2) Putting into _typeMap the following key: " + configTypeWCCM + " and the following value: " + metadata2);
                }
                this._typeMap.put(configTypeWCCM, metadata2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addChannelFactoryMetaData");
        }
    }

    protected boolean checkGeneric(String type) {
        return type.equals("com.ibm.websphere.models.config.channelservice.channels.GenericInboundChannel") || type.equals("com.ibm.websphere.models.config.channelservice.channels.GenericOutboundChannel") || type.equals("com.ibm.websphere.models.config.channelservice.channels.GenericChannelFactory");
    }

    protected boolean validate(File jar, ChannelTypeManager.ChannelMetaData type) {
        boolean result = true;
        if (type.getRuntimeClass() == null) {
            Tr.error(tc, "channel.descriptor.factory.missing", jar);
            result = false;
        }
        if (type.getConfigurationClass() == null) {
            Tr.error(tc, "channel.descriptor.channel.missing", jar);
            result = false;
        }
        if (type.getApplicationInterface() == null && type.getDeviceInterface().isEmpty()) {
            Tr.error(tc, "channel.descriptor.interfaces.missing", jar);
            result = false;
        }
        if (type.isSetDefaultWeight() && type.getDefaultWeight() < 0) {
            Tr.error(tc, "channel.descriptor.weight.invalid", new Object[]{jar, new Integer(type.getDefaultWeight())});
            result = false;
        }
        return result;
    }

    protected boolean validate(File jar, ChannelTypeManager.ChannelFactoryMetaData type) {
        boolean result = true;
        if (type.getRuntimeClass() == null) {
            Tr.error(tc, "channel.descriptor.factory.missing", jar);
            result = false;
        }
        if (type.getConfigurationClass() == null) {
            Tr.error(tc, "channel.descriptor.channel.config.missing", jar);
            result = false;
        }
        return result;
    }

    protected boolean loadChannelDefinitions(File[] jars) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadChannelDefinitions(File[] jar)");
        }
        this.addOSGiChannelFactoryTypes();
        this.addOSGiChannelTypes();
        boolean result = true;
        for (int i = 0; i < jars.length; ++i) {
            try {
                result &= this.loadChannelDefinitions(jars[i]);
                continue;
            }
            catch (ChannelJARAlreadyLoadedException exp) {
                Tr.error(tc, "channel.jar.already.loaded", exp.getOffendingFile().getAbsolutePath());
                result = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadChannelDefinitions");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadChannelDefinitions(File jar) throws ChannelJARAlreadyLoadedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadChannelDefinitions(File jar)");
        }
        if (jar == null) {
            return false;
        }
        if (this._jarSet.contains(jar)) {
            throw new ChannelJARAlreadyLoadedException(jar);
        }
        Archive archive = null;
        try {
            archive = CommonarchiveFactoryImpl.getActiveFactory().openArchive(jar.getAbsolutePath());
            ConfigDocument document = null;
            if (this.cService == null) {
                try {
                    this.cService = WsServiceRegistry.getService(this, ConfigService.class);
                }
                catch (Exception x) {
                    Tr.error(tc, "Can't load the Configuration Service");
                    boolean bl = false;
                    if (archive != null) {
                        archive.close();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadChannelDefinitions(File jar)");
                    }
                    return bl;
                }
            }
            document = this.cService.getDocument(new InputSource(archive.getResourceInputStream("META-INF/ws-channel.xmi")));
            for (Object o : document.getContents()) {
                WCCMChannelFactoryMetaDataImpl factoryType;
                if (!(o instanceof ConfigObject)) continue;
                if (RCSUtil.instanceOfChannelType((ConfigObject)o)) {
                    WCCMChannelMetaDataImpl channelType = new WCCMChannelMetaDataImpl(jar, (ConfigObject)o);
                    if (!this.validate(jar, channelType)) continue;
                    this.addChannelMetaData(channelType);
                    continue;
                }
                if (!RCSUtil.instanceOfChannelFactoryType((ConfigObject)o) || !this.validate(jar, factoryType = new WCCMChannelFactoryMetaDataImpl(jar, (ConfigObject)o))) continue;
                this.addChannelFactoryMetaData(factoryType);
            }
            this._jarSet.add(jar);
            boolean bl = true;
            return bl;
        }
        catch (ConfigurationError exp) {
            Tr.error(tc, "config.load.error", new Object[]{jar, exp});
        }
        catch (IOException exp) {
            Tr.error(tc, "config.load.error", new Object[]{jar, exp});
        }
        catch (OpenFailureException exp) {
            Tr.error(tc, "channel.jar.open.failure", new Object[]{jar, exp});
        }
        catch (ResourceLoadException exp) {
            Tr.error(tc, "channel.descriptor.parse.failure", new Object[]{jar, exp});
        }
        finally {
            if (archive != null) {
                archive.close();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "loadChannelDefinitions(File jar)");
            }
        }
        return false;
    }

    protected static String createFullyQualifiedGenericID(String typeID) {
        return typeID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WCCMChannelFactoryMetaDataImpl
    implements ChannelTypeManager.ChannelFactoryMetaData {
        private String _typeID;
        private String _typeURI;
        private String _typeName;
        private String _shortName;
        private String _configurationClass;
        private String _runtimeClass;
        private String _validatorClass;
        private String _string;
        private String _hash;
        private String _platform;
        private String _jarFile;
        private String _connType;

        public WCCMChannelFactoryMetaDataImpl(File jar, ConfigObject type) {
            this._configurationClass = this._shortName = type.getString("configurationClass", null);
            this._runtimeClass = type.getString("runtimeClass", null);
            this._validatorClass = type.getString("validatorClass", null);
            this._jarFile = jar.getName();
            this._typeID = type.getID();
            this._typeURI = type.getTypeURI();
            this._typeName = type.getTypeName();
            this._hash = this._jarFile + '#' + this._typeID;
            if (this._shortName != null) {
                this._shortName = this._shortName.substring(this._shortName.lastIndexOf(46) + 1);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Created: " + this);
            }
        }

        @Override
        public Class<?> getClass(String className) throws ClassNotFoundException {
            if (null == className) {
                return null;
            }
            ClassLoader cl = ExtClassLoader.getInstance();
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            return Class.forName(className, true, cl);
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuilder temp = new StringBuilder();
                temp.append(this._shortName);
                temp.append(", typeID=");
                temp.append(this._typeID);
                temp.append(" (configClass=");
                temp.append(this._configurationClass);
                temp.append(", runtimeClass=");
                temp.append(this._runtimeClass);
                temp.append(", validator=");
                temp.append(this._validatorClass);
                temp.append(')');
                this._string = temp.toString();
            }
            return this._string;
        }

        @Override
        public String getConfigurationClass() {
            return this._configurationClass;
        }

        @Override
        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        @Override
        public String getValidatorClass() {
            return this._validatorClass;
        }

        @Override
        public String getTypeID() {
            return this._typeID;
        }

        @Override
        public String getTypeURI() {
            return this._typeURI;
        }

        @Override
        public String getTypeName() {
            return this._typeName;
        }

        @Override
        public String getConnType() {
            return this._connType;
        }

        @Override
        public String getPlatform() {
            return this._platform;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OSGiChannelFactoryMetaDataImpl
    implements ChannelTypeManager.ChannelFactoryMetaData {
        private String _typeID;
        private String _typeURI;
        private String _typeName;
        private String _shortName;
        private String _configurationClass;
        private String _runtimeClass;
        private String _validatorClass;
        private String _string;
        private String _hash;
        private String _platform;
        private String _bundleName;
        private String _connType;

        public OSGiChannelFactoryMetaDataImpl(IConfigurationElement config) {
            this._bundleName = config.getContributor().getName();
            this._shortName = config.getAttribute("configurationClass");
            this._configurationClass = config.getAttribute("configurationClass");
            this._runtimeClass = config.getAttribute("runtimeClass");
            this._validatorClass = config.getAttribute("validatorClass");
            this._typeID = config.getAttribute("id");
            this._platform = config.getAttribute("platform");
            this._hash = this._bundleName + '#' + this._typeID;
            this._typeURI = config.getAttribute("typeURI");
            this._typeName = config.getAttribute("typeName");
            this._connType = config.getAttribute("connectionType");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Created: " + this);
            }
        }

        @Override
        public Class<?> getClass(final String className) throws ClassNotFoundException {
            if (null == className) {
                return null;
            }
            final Bundle bundle = Platform.getBundle((String)this._bundleName);
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        return bundle.loadClass(className);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                if (pae.getCause() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)pae.getCause();
                }
                throw new ClassNotFoundException(className, pae);
            }
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuilder temp = new StringBuilder();
                temp.append(this._shortName);
                temp.append(", typeID=");
                temp.append(this._typeID);
                temp.append(" (configClass=");
                temp.append(this._configurationClass);
                temp.append(", runtimeClass=");
                temp.append(this._runtimeClass);
                temp.append(", validator=");
                temp.append(this._validatorClass);
                temp.append(')');
                this._string = temp.toString();
            }
            return this._string;
        }

        @Override
        public String getConfigurationClass() {
            return this._configurationClass;
        }

        @Override
        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        @Override
        public String getValidatorClass() {
            return this._validatorClass;
        }

        @Override
        public String getTypeID() {
            return this._typeID;
        }

        @Override
        public String getTypeURI() {
            return this._typeURI;
        }

        @Override
        public String getTypeName() {
            return this._typeName;
        }

        @Override
        public String getConnType() {
            return this._connType;
        }

        @Override
        public String getPlatform() {
            return this._platform;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OSGiChannelMetaDataImpl
    implements ChannelTypeManager.ChannelMetaData {
        private String _jarFile;
        private String _typeID;
        private String _shortName;
        private String _runtimeClass;
        private String _configurationClass;
        private String _validatorClass;
        private int _defaultWeight;
        private boolean _setDefaultWeight;
        private String _appInterface;
        private List<String> _deviceInterface;
        private ChannelTypeManager.ChannelKind _kind;
        private String _platform;
        private String _string;
        private String _hash;
        private String _bundleName;
        private String _typeURI;
        private String _typeName;
        private String _connType;

        public OSGiChannelMetaDataImpl(IConfigurationElement config) {
            this._bundleName = config.getContributor().getName();
            this._shortName = config.getAttribute("configurationClass");
            this._configurationClass = config.getAttribute("configurationClass");
            this._runtimeClass = config.getAttribute("runtimeClass");
            this._validatorClass = config.getAttribute("validatorClass");
            this._appInterface = config.getAttribute("applicationInterface");
            this._deviceInterface = new ArrayList<String>();
            this._connType = config.getAttribute("connectionType");
            String deviceListString = config.getAttribute("deviceInterface");
            if (deviceListString != null) {
                StringTokenizer stDeviceList = new StringTokenizer(deviceListString, " ");
                while (stDeviceList.hasMoreTokens()) {
                    this._deviceInterface.add(stDeviceList.nextToken());
                }
            }
            this._kind = ChannelTypeManager.ChannelKind.getKind(config.getAttribute("kind"));
            this._typeID = config.getAttribute("id");
            this._platform = config.getAttribute("platform");
            this._hash = this._bundleName + '#' + this._typeID;
            this._typeURI = config.getAttribute("typeURI");
            this._typeName = config.getAttribute("typeName");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Created: " + this);
            }
        }

        @Override
        public Class<?> getClass(final String className) throws ClassNotFoundException {
            if (null == className) {
                return null;
            }
            final Bundle bundle = Platform.getBundle((String)this._bundleName);
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        return bundle.loadClass(className);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                if (pae.getCause() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)pae.getCause();
                }
                throw new ClassNotFoundException(className, pae);
            }
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuilder temp = new StringBuilder();
                temp.append(this._shortName);
                temp.append(" (jarFile=");
                temp.append(this._jarFile);
                temp.append(", typeID=");
                temp.append(this._typeID);
                temp.append(") (kind=");
                temp.append(this._kind);
                temp.append(", configChannel=");
                temp.append(this._configurationClass);
                temp.append(", runtimeFactory=");
                temp.append(this._runtimeClass);
                temp.append(", validator=");
                temp.append(this._validatorClass);
                temp.append(", weight=");
                temp.append(this._defaultWeight);
                if (this._deviceInterface != null && !this._deviceInterface.isEmpty()) {
                    temp.append(", deviceInterface=[");
                    Iterator<String> i = this._deviceInterface.iterator();
                    temp.append((Object)i.next());
                    while (i.hasNext()) {
                        temp.append(' ');
                        temp.append((Object)i.next());
                    }
                    temp.append(']');
                }
                temp.append(')');
                this._string = temp.toString();
            }
            return this._string;
        }

        @Override
        public String getApplicationInterface() {
            return this._appInterface;
        }

        @Override
        public String getConfigurationClass() {
            return this._configurationClass;
        }

        @Override
        public int getDefaultWeight() {
            return this._defaultWeight;
        }

        @Override
        public List<?> getDeviceInterface() {
            return this._deviceInterface;
        }

        @Override
        public ChannelTypeManager.ChannelKind getKind() {
            return this._kind;
        }

        @Override
        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        @Override
        public String getValidatorClass() {
            return this._validatorClass;
        }

        @Override
        public boolean isSetDefaultWeight() {
            return this._setDefaultWeight;
        }

        @Override
        public String getJARFile() {
            return this._jarFile;
        }

        @Override
        public String getTypeID() {
            return this._typeID;
        }

        @Override
        public String getTypeURI() {
            return this._typeURI;
        }

        @Override
        public String getTypeName() {
            return this._typeName;
        }

        @Override
        public String getConnType() {
            return this._connType;
        }

        @Override
        public String getPlatform() {
            return this._platform;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WCCMChannelMetaDataImpl
    implements ChannelTypeManager.ChannelMetaData {
        private String _jarFile;
        private String _typeID;
        private String _shortName;
        private String _runtimeClass;
        private String _configurationClass;
        private String _validatorClass;
        private int _defaultWeight;
        private boolean _setDefaultWeight;
        private String _appInterface;
        private List<String> _deviceInterface;
        private ChannelTypeManager.ChannelKind _kind;
        private String _platform;
        private String _string;
        private String _hash;
        private String _typeURI;
        private String _typeName;
        private String _connType;

        public WCCMChannelMetaDataImpl(File jar, ConfigObject type) {
            this._shortName = type.getString("configurationClass", null);
            this._configurationClass = type.getString("configurationClass", null);
            this._runtimeClass = type.getString("runtimeClass", null);
            this._validatorClass = type.getString("validatorClass", null);
            this._defaultWeight = type.getInt("defaultWeight", 0);
            this._setDefaultWeight = type.isSet("defaultWeight");
            this._kind = ChannelTypeManager.ChannelKind.getKind(type.getString("kind", "CONNECTOR"));
            this._appInterface = type.getString("applicationInterface", null);
            this._deviceInterface = new ArrayList<String>();
            List temp = type.getStringList("deviceInterface");
            Iterator it = temp.iterator();
            while (it.hasNext()) {
                this._deviceInterface.add((String)it.next());
            }
            this._jarFile = jar.getName();
            this._typeURI = type.getTypeURI();
            this._typeName = type.getTypeName();
            this._typeID = type.getID();
            this._hash = this._jarFile + '#' + this._typeID;
            Collections.sort(this._deviceInterface);
            if (this._shortName != null) {
                this._shortName = this._shortName.substring(this._shortName.lastIndexOf(46) + 1);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Created: " + this);
            }
        }

        @Override
        public Class<?> getClass(String className) throws ClassNotFoundException {
            if (null == className) {
                return null;
            }
            ClassLoader cl = ExtClassLoader.getInstance();
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            return Class.forName(className, true, cl);
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuilder temp = new StringBuilder();
                temp.append(this._shortName);
                temp.append(" (jarFile=");
                temp.append(this._jarFile);
                temp.append(", typeID=");
                temp.append(this._typeID);
                temp.append(") (kind=");
                temp.append(this._kind);
                temp.append(", configChannel=");
                temp.append(this._configurationClass);
                temp.append(", runtimeFactory=");
                temp.append(this._runtimeClass);
                temp.append(", validator=");
                temp.append(this._validatorClass);
                temp.append(", weight=");
                temp.append(this._defaultWeight);
                if (this._deviceInterface != null && !this._deviceInterface.isEmpty()) {
                    temp.append(", deviceInterface=[");
                    Iterator<String> i = this._deviceInterface.iterator();
                    temp.append((Object)i.next());
                    while (i.hasNext()) {
                        temp.append(' ');
                        temp.append((Object)i.next());
                    }
                    temp.append(']');
                }
                temp.append(')');
                this._string = temp.toString();
            }
            return this._string;
        }

        @Override
        public String getApplicationInterface() {
            return this._appInterface;
        }

        @Override
        public String getConfigurationClass() {
            return this._configurationClass;
        }

        @Override
        public int getDefaultWeight() {
            return this._defaultWeight;
        }

        @Override
        public List<?> getDeviceInterface() {
            return this._deviceInterface;
        }

        @Override
        public ChannelTypeManager.ChannelKind getKind() {
            return this._kind;
        }

        @Override
        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        @Override
        public String getValidatorClass() {
            return this._validatorClass;
        }

        @Override
        public boolean isSetDefaultWeight() {
            return this._setDefaultWeight;
        }

        @Override
        public String getJARFile() {
            return this._jarFile;
        }

        @Override
        public String getTypeID() {
            return this._typeID;
        }

        @Override
        public String getTypeURI() {
            return this._typeURI;
        }

        @Override
        public String getTypeName() {
            return this._typeName;
        }

        @Override
        public String getConnType() {
            return this._connType;
        }

        @Override
        public String getPlatform() {
            return this._platform;
        }
    }
}

