/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.common;

import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.ws.channel.common.ChannelPoolObject;
import com.ibm.ws.channel.common.ChannelUtilsBase;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelUtilsLogger
extends ChannelUtilsBase {
    private static final String ME = ChannelUtilsLogger.class.getName();
    private static ChannelUtilsLogger chLogger = new ChannelUtilsLogger();

    public static ChannelPoolObject getChannelObject(Logger log, String desc, ObjectPool pool) {
        return chLogger.getObject(log, desc, pool, log.isLoggable(Level.FINEST), log.isLoggable(Level.FINE));
    }

    public static boolean releaseChannelObject(Logger log, String desc, ChannelPoolObject obj, ObjectPool pool) {
        return chLogger.releaseObject(log, desc, obj, pool, log.isLoggable(Level.FINEST), log.isLoggable(Level.FINE));
    }

    public static void printDebugStackTrace(Logger log, Throwable t, String message) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceDebugStack(log, t, message);
    }

    public static void printThreadStackTrace(Logger log, Thread thread2) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceThreadStack(log, thread2);
    }

    public static void displayChannels(Logger log, ChannelFramework cfw, String message, String prefix) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        if (cfw == null) {
            chLogger.debugTrace(log, prefix + ", no cfw");
        } else {
            chLogger.traceChannels(log, cfw, message, prefix);
        }
    }

    public static void displayChains(Logger log, ChannelFramework cfw, Class<?> factory, String message, String prefix) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceChains((Object)log, cfw, factory, message, prefix);
    }

    public static void displayChains(Logger log, ChannelFramework cfw, String groupName, String message, String prefix) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceChains((Object)log, cfw, groupName, message, prefix);
    }

    public static void displayChains(Logger log, ChainData[] chains, String message, String prefix) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        if (chains == null || chains.length == 0) {
            chLogger.debugTrace(log, prefix + ", no chains to trace (" + message + ")");
        } else {
            chLogger.traceChains(log, Arrays.asList(chains), message, prefix);
        }
    }

    public static void displayChains(Logger log, List<?> lchain, String message, String prefix) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        chLogger.traceChains(log, lchain, message, prefix);
    }

    @Override
    protected void debugTrace(Object logTool, String msg) {
        ((Logger)logTool).finest(msg);
    }

    @Override
    protected void entryTrace(Object logTool, String m_name, Object parms) {
        ((Logger)logTool).entering(ME, m_name, parms);
    }

    @Override
    protected void exitTrace(Object logTool, String m_name, Object result) {
        ((Logger)logTool).exiting(ME, m_name, result);
    }
}

