/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.common;

import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.common.ChannelPoolObject;
import com.ibm.ws.channel.common.PlatformConstants;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ChannelUtilsBase {
    private static Map<ObjectPool, Integer> stats = new HashMap<ObjectPool, Integer>();
    protected boolean traceObtainRelease = Boolean.getBoolean("com.ibm.ws.channel.common.ChannelUtilsBase.traceObtainRelease");

    protected ChannelUtilsBase() {
    }

    protected final ChannelPoolObject getObject(Object logTool, String desc, ObjectPool pool, boolean debugEnabled, boolean entryEnabled) {
        boolean removedFromPool;
        ChannelPoolObject obj = (ChannelPoolObject)pool.remove();
        boolean bl = removedFromPool = obj != null;
        if (debugEnabled && this.traceObtainRelease) {
            this.trackObjectPool(logTool, desc, pool, -1, removedFromPool);
        }
        return obj;
    }

    protected final boolean releaseObject(Object logTool, String desc, ChannelPoolObject obj, ObjectPool pool, boolean debugEnabled, boolean entryEnabled) {
        boolean addedToPool = false;
        if (obj != null) {
            obj.poolReset();
            addedToPool = pool.add(obj);
            if (debugEnabled && this.traceObtainRelease) {
                this.trackObjectPool(logTool, desc, pool, 1, addedToPool);
            }
        }
        return addedToPool;
    }

    protected final void traceChains(Object logTool, ChannelFramework cfw, Class<?> factory, String message, String prefix) {
        ChainData[] chains = null;
        String fstring = "(" + (factory == null ? "no factory specified" : factory.getName()) + ")";
        if (cfw == null) {
            this.debugTrace(logTool, prefix + " - No cfw to test factory " + fstring);
            return;
        }
        try {
            chains = factory != null ? cfw.getAllChains(factory) : cfw.getAllChains();
        }
        catch (Exception e) {
            this.debugTrace(logTool, "Caught Exception while trying to display configured chains: " + e);
            e.printStackTrace();
            return;
        }
        if (chains == null || chains.length <= 0) {
            this.debugTrace(logTool, prefix + " - No chains found for factory " + fstring);
        } else {
            this.traceChains(logTool, Arrays.asList(chains), message, prefix);
        }
    }

    protected final void traceChains(Object logTool, ChannelFramework cfw, String groupName, String message, String prefix) {
        String gstring = "(" + (groupName == null ? "no group specified" : groupName) + ")";
        if (cfw == null) {
            this.debugTrace(logTool, prefix + " - No cfw to test group " + gstring);
        } else if (groupName == null) {
            this.debugTrace(logTool, prefix + " - No group specified");
        }
        if (cfw == null || groupName == null) {
            return;
        }
        ChainGroupData chainGroup = null;
        ChainData[] chains = null;
        try {
            chainGroup = cfw.getChainGroup(groupName);
            if (chainGroup != null) {
                chains = chainGroup.getChains();
            }
        }
        catch (Exception e) {
            this.debugTrace(logTool, "Caught Exception while trying to display configured chains: " + e);
            e.printStackTrace();
            return;
        }
        if (chains == null || chains.length <= 0) {
            this.debugTrace(logTool, prefix + " - No chains defined for group " + gstring);
        } else {
            this.traceChains(logTool, Arrays.asList(chains), message, prefix);
        }
    }

    protected final void traceChains(Object logTool, List<?> lchain, String message, String prefix) {
        if (lchain == null || lchain.size() <= 0) {
            this.debugTrace(logTool, prefix + " - Specified chain list is empty");
            return;
        }
        StringBuilder traceMessage = new StringBuilder(300);
        traceMessage.append(message);
        traceMessage.append(PlatformConstants.EOLN);
        for (ChainData chain : lchain) {
            traceMessage.append(prefix + "-chain ");
            traceMessage.append(chain.getName());
            traceMessage.append(chain.getType() == FlowType.OUTBOUND ? " - OUTBOUND" : " - INBOUND");
            traceMessage.append(PlatformConstants.EOLN);
            List<ChannelData> lchannel = Arrays.asList(chain.getChannelList());
            for (ChannelData channel : lchannel) {
                traceMessage.append(prefix + "-chain ");
                traceMessage.append(chain.getName());
                traceMessage.append(":       +  ");
                traceMessage.append(channel.getName());
                traceMessage.append(" - ");
                traceMessage.append(channel.getFactoryType());
                traceMessage.append(PlatformConstants.EOLN);
            }
        }
        this.debugTrace(logTool, traceMessage.toString());
    }

    protected final void traceChannels(Object logTool, ChannelFramework cfw, String message, String prefix) {
        if (cfw == null) {
            this.debugTrace(logTool, prefix + " - No cfw to trace channels");
            return;
        }
        StringBuilder traceMessage = new StringBuilder(300);
        traceMessage.append(prefix + ": Configured Channels - ");
        if (message != null) {
            traceMessage.append(message);
        }
        traceMessage.append(PlatformConstants.EOLN);
        ChannelData[] channelList = cfw.getAllChannels();
        List<ChannelData> lchannel = Arrays.asList(channelList);
        for (ChannelData channel : lchannel) {
            traceMessage.append(prefix + ":    ");
            traceMessage.append(channel.getName());
            traceMessage.append(" - ");
            traceMessage.append(channel.getFactoryType());
            traceMessage.append(PlatformConstants.EOLN);
        }
        this.debugTrace(logTool, traceMessage.toString());
    }

    protected final void traceDebugStack(Object logTool, Throwable t, String message) {
        StackTraceElement[] stack = t.getStackTrace();
        if (stack != null) {
            StringBuilder stackTrace = new StringBuilder();
            for (int i = 0; i < stack.length; ++i) {
                stackTrace.append(PlatformConstants.EOLN + stack[i].toString());
            }
            this.debugTrace(logTool, message + PlatformConstants.EOLN + stackTrace.toString());
        }
    }

    public final void traceThreadStack(Object logTool, Thread thread2) {
        StackTraceElement[] stack = thread2.getStackTrace();
        if (stack != null) {
            StringBuilder stackTrace = new StringBuilder("TRACEBACK for Thread " + thread2.getName() + ": ");
            for (int i = 0; i < stack.length; ++i) {
                stackTrace.append(PlatformConstants.EOLN + stack[i].toString());
            }
            this.debugTrace(logTool, PlatformConstants.EOLN + stackTrace.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void trackObjectPool(Object logTool, String desc, ObjectPool pool, int increment, boolean poolUsed) {
        if (!this.traceObtainRelease) {
            return;
        }
        int count = 0;
        if (poolUsed) {
            Map<ObjectPool, Integer> map = stats;
            synchronized (map) {
                Integer o = stats.get(pool);
                if (o == null) {
                    stats.put(pool, increment);
                } else {
                    count = o;
                    stats.put(pool, count + increment);
                }
            }
        }
        StringBuilder str = new StringBuilder("ChannelObjectPool: ");
        str.append(count);
        str.append(" objects in ");
        str.append(pool.getName());
        str.append(" (");
        str.append(desc);
        str.append(")");
        this.debugTrace(logTool, str.toString());
    }

    protected abstract void debugTrace(Object var1, String var2);

    protected abstract void entryTrace(Object var1, String var2, Object var3);

    protected abstract void exitTrace(Object var1, String var2, Object var3);
}

