/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.bootstrap.NlvPrintStream;
import com.ibm.ws.bootstrap.SelectiveBundleMetadataMgr;
import com.ibm.ws.bootstrap.TimeBomb;
import com.ibm.wsspi.bootstrap.WSPreLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

public class WSLauncher {
    public static boolean debug = Boolean.getBoolean("ws.ext.debug");
    public static PrintStream out = System.out;
    private static ExtClassLoader extClassLoader = null;
    private static ResourceBundle bundle = null;
    private static Thread shutdownHook = new OnExit();
    private static final boolean isZOS;
    private static final boolean overrideZOS;
    private static final boolean isIseries;
    private static final boolean isWindows;
    private static Object[] handlers;
    static final String WAS_PROPERTY_FILE = "cmd.properties.file";

    public static void main(String[] args) {
        block21: {
            String encoding;
            if (args.length < 1) {
                out.println("usage: WSLauncher <className>");
                System.exit(-1);
            }
            if ((encoding = System.getProperty("ws.output.encoding")) != null && !encoding.equals("file")) {
                if (encoding.equals("console")) {
                    String currentEncoding = System.getProperty("file.encoding");
                    encoding = currentEncoding.equalsIgnoreCase("Cp1252") ? "Cp850" : null;
                }
                if (encoding != null) {
                    try {
                        System.setOut(new NlvPrintStream((OutputStream)System.out, true, encoding));
                        System.setErr(new NlvPrintStream((OutputStream)System.err, true, encoding));
                    }
                    catch (UnsupportedEncodingException ex) {
                        if (!debug) break block21;
                        ex.printStackTrace();
                    }
                }
            }
        }
        out = System.out;
        WSPreLauncher.processPropertiesFile();
        String wsDirs = "";
        String wasInstallRoot = System.getProperty("was.install.root");
        if (wasInstallRoot == null) {
            WSLauncher.debug("was.install.root not set ... looking for something that looks like an install root.");
            String ws_ext_dirs = System.getProperty("ws.ext.dirs", "");
            StringTokenizer st = new StringTokenizer(ws_ext_dirs, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File f;
                String path = st.nextToken();
                if (path.endsWith("lib")) {
                    path = path.substring(0, path.length() - 4);
                }
                if (!(f = new File(path + File.separator + "plugins")).exists()) continue;
                wasInstallRoot = path;
                break;
            }
        }
        if (wasInstallRoot != null) {
            File eclipseDir = new File(wasInstallRoot + File.separator + "plugins");
            wsDirs = WSLauncher.searchPlugins(eclipseDir, wsDirs);
        } else {
            LoggingServices.trace("WSVR0614W");
        }
        wsDirs = wsDirs + System.getProperty("ws.ext.dirs");
        extClassLoader = new ExtClassLoader((String)null);
        WSLauncher.addSelectiveActivationClasspaths(wasInstallRoot);
        extClassLoader.addPath(wsDirs);
        if (debug) {
            out.println("ws.ext.dirs=" + wsDirs);
            URL[] urls = extClassLoader._getURLs();
            for (int i = 0; i < urls.length; ++i) {
                out.println("ws.ext.classpath[" + i + "]=" + urls[i]);
            }
        }
        Thread.currentThread().setContextClassLoader(extClassLoader);
        if (!(WSLauncher.isISeries() || WSLauncher.isZOS() || TimeBomb.checkLicense(true) || args[0].indexOf("WsServerStop") >= 0)) {
            System.exit(-1);
        }
        Class<?> mainClass = null;
        try {
            if (debug) {
                out.println("ws.ext.main.class=" + args[0]);
            }
            mainClass = extClassLoader.loadClass(args[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace(out);
            System.exit(-1);
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        if (debug) {
            for (int i = 0; i < newArgs.length; ++i) {
                out.println("ws.ext.mains.args[" + i + "]=" + newArgs[i]);
            }
        }
        Method main = null;
        Object ret = null;
        try {
            main = mainClass.getMethod("main", String[].class);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            newArgs = WSLauncher.preInvoke(args[0], newArgs, extClassLoader);
            newArgs = WSLauncher.removeProfileName(args[0], newArgs);
            ret = main.invoke(null, new Object[]{newArgs});
        }
        catch (Exception ex) {
            ex.printStackTrace(out);
        }
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        WSLauncher.onExit();
    }

    private static String searchPlugins(File directory, String path) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return path;
        }
        File[] jarsAndZips = directory.listFiles(new JarZipFilter());
        if (jarsAndZips != null && jarsAndZips.length > 0) {
            try {
                path = directory.getCanonicalPath() + File.pathSeparator + path;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File[] subdirs = directory.listFiles(new DirectoryFilter());
        for (int i = 0; i < subdirs.length; ++i) {
            path = WSLauncher.searchPlugins(subdirs[i], path);
        }
        return path;
    }

    public static boolean isZOS() {
        return isZOS;
    }

    public static boolean isISeries() {
        return isIseries;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static void debug(String msg) {
        if (debug) {
            out.println("[Debug]: " + msg);
        }
    }

    static void onExit() {
        WSLauncher.postInvoke();
    }

    private static String[] preInvoke(String mainClass, String[] args, ClassLoader classloader) throws Exception {
        StringBuffer bootFileName = new StringBuffer();
        bootFileName.append(System.getProperty("was.install.root"));
        bootFileName.append(File.separator);
        bootFileName.append("bin");
        bootFileName.append(File.separator);
        bootFileName.append("boot");
        bootFileName.append(File.separator);
        bootFileName.append(mainClass);
        bootFileName.append(".boot");
        File bootFile = new File(bootFileName.toString());
        if (!bootFile.exists()) {
            return args;
        }
        BufferedReader reader = new BufferedReader(new FileReader(bootFile));
        Vector<String> handlersVec = new Vector<String>();
        String next = null;
        while ((next = reader.readLine()) != null) {
            handlersVec.add(next.trim());
        }
        reader.close();
        handlers = new Object[handlersVec.size()];
        Class[] argTypes = new Class[]{mainClass.getClass(), args.getClass()};
        for (int i = 0; i < handlers.length; ++i) {
            Class<?> clazz = classloader.loadClass((String)handlersVec.get(i));
            try {
                Constructor<?> ctor = clazz.getConstructor(null);
                WSLauncher.handlers[i] = ctor.newInstance(null);
                Method method2 = clazz.getMethod("preInvoke", argTypes);
                args = (String[])method2.invoke(handlers[i], mainClass, args);
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return args;
    }

    private static void postInvoke() {
        if (handlers == null) {
            return;
        }
        for (int i = handlers.length - 1; i >= 0; --i) {
            if (handlers[i] == null) continue;
            Method method2 = null;
            try {
                method2 = handlers[i].getClass().getMethod("postInvoke", null);
                method2.invoke(handlers[i], null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String[] removeProfileName(String mainClass, String[] args) {
        String[] newArgs = args;
        String name = mainClass.substring(mainClass.lastIndexOf(46) + 1, mainClass.length()).trim();
        if (!(name.equals("WSProfileCLI") || name.equals("WsProfile") || Boolean.getBoolean("KeepProfileName"))) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-profileName")) continue;
                int numArgsToRemove = 1;
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    numArgsToRemove = 2;
                }
                newArgs = new String[args.length - numArgsToRemove];
                System.arraycopy(args, 0, newArgs, 0, i);
                System.arraycopy(args, i + numArgsToRemove, newArgs, i, newArgs.length - i);
                break;
            }
        }
        return newArgs;
    }

    public static void doPreload(String[] args, ExtClassLoader extClassLoader) {
    }

    private static void addSelectiveActivationClasspaths(String wasInstallRoot) {
        File wasInstallRootFile = null;
        if (wasInstallRoot != null) {
            wasInstallRootFile = new File(wasInstallRoot);
        }
        WSLauncher.debug("wasInstallRoot = " + wasInstallRootFile.getAbsolutePath());
        String profileDirectory = System.getProperty("user.install.root");
        if (profileDirectory == null && (profileDirectory = System.getenv("USER_INSTALL_ROOT")) == null) {
            LoggingServices.trace("WSVR0615W");
            return;
        }
        WSLauncher.debug("profileDirectory = " + profileDirectory);
        File configurationDirectory = null;
        if (profileDirectory != null) {
            configurationDirectory = new File(profileDirectory, "configuration");
        }
        SelectiveBundleMetadataMgr metadataMgr = null;
        SelectiveBundleMetadataMgr.SelectiveBundleData selectiveBundleData = null;
        try {
            metadataMgr = new SelectiveBundleMetadataMgr(wasInstallRootFile, configurationDirectory);
            selectiveBundleData = metadataMgr.getSelectiveBundleData();
        }
        catch (Exception e) {
            LoggingServices.trace("WSVR0616W");
            e.printStackTrace();
        }
        if (selectiveBundleData != null) {
            WSLauncher.debug("adding classpaths to ExtClassLoader");
            Set<File> classpathFiles = selectiveBundleData.bundlesToAdd;
            for (File classpathFile : classpathFiles) {
                WSLauncher.debug("   adding classpath, " + classpathFile.getAbsolutePath());
                extClassLoader.addPath(classpathFile.getAbsolutePath());
            }
        }
    }

    static {
        overrideZOS = Boolean.getBoolean("com.ibm.websphere.zos.forcedist");
        handlers = null;
        String os2 = System.getProperty("os.name").trim();
        isZOS = (os2.equals("OS/390") || os2.equals("z/OS")) && !overrideZOS;
        isIseries = os2.equals("OS/400");
        String osLC = os2.toLowerCase();
        isWindows = Pattern.matches("^.*windows.*$", osLC);
    }

    private static class OnExit
    extends Thread {
        private OnExit() {
        }

        public void run() {
            WSLauncher.onExit();
        }
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }

    private static class JarZipFilter
    implements FileFilter {
        private JarZipFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".jar") || pathname.getName().endsWith(".zip");
        }
    }
}

