/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.WSLauncher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

public class PathChecksum {
    private static Checksum cs = null;

    public static void main(String[] args) {
        String pathToCheck = args[0];
        if (pathToCheck != null) {
            PathChecksum.pathChecksum(args[0]);
        } else {
            System.out.println("Syntax is DirectoryChecksum [directory names]");
        }
    }

    public static long pathChecksum(String pathToCheck) {
        if (cs == null) {
            cs = new Adler32();
        }
        cs.reset();
        StringTokenizer st = new StringTokenizer(pathToCheck, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            PathChecksum.scanDirectory(new File(entry));
        }
        WSLauncher.debug("CRC: " + cs.getValue());
        return cs.getValue();
    }

    public static long streamChecksum(String prefixString, RandomAccessFile file) throws IOException {
        int numread;
        if (cs == null) {
            cs = new Adler32();
        }
        cs.reset();
        byte[] filename = prefixString.getBytes();
        cs.update(filename, 0, filename.length);
        byte[] buffer = new byte[4096];
        while ((numread = file.read(buffer)) != -1) {
            cs.update(buffer, 0, numread);
        }
        return cs.getValue();
    }

    private static void scanDirectory(File f) {
        block6: {
            block5: {
                byte[] filename = f.getAbsolutePath().getBytes();
                cs.update(filename, 0, filename.length);
                if (!f.isDirectory()) break block5;
                String[] children = f.list();
                if (children == null) break block6;
                for (int i = 0; i < children.length; ++i) {
                    PathChecksum.scanDirectory(new File(f, children[i]));
                }
                break block6;
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                CheckedInputStream cis = new CheckedInputStream(fis, cs);
                byte[] buffer = new byte[4096];
                while (cis.read(buffer) != -1) {
                }
                cis.close();
                fis.close();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

