/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class ClassLoaderGateway
implements ExtClassLoader.Gateway {
    private static final ClassLoaderGateway instance;
    private Bundle gatewayBundle = null;
    private static TreeSet specialCaseResources;
    public static final String GATEWAY_BUNDLE_SYMBOLIC_NAME = "com.ibm.ws.runtime.gateway";
    private static final String SYSTEM_BUNDLE_SYMBOLIC_NAME = "system.bundle";

    public ClassLoader getClassLoader() {
        ClassLoader cl = null;
        if (this.gatewayBundle != null) {
            try {
                Class activator = this.gatewayBundle.loadClass("com.ibm.ws.gateway.GatewayBundleActivator");
                cl = activator.getClassLoader();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return cl;
    }

    private ClassLoaderGateway() {
        try {
            this.gatewayBundle = Platform.getBundle((String)GATEWAY_BUNDLE_SYMBOLIC_NAME);
            if (this.gatewayBundle != null && this.gatewayBundle.getState() != 32) {
                this.gatewayBundle.start();
            }
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
    }

    public static final ClassLoaderGateway instance() {
        return instance;
    }

    private Bundle[] getBundles() {
        BundleContext bc = BundleContextMap.instance().get(this.getClass().getClassLoader());
        if (bc != null) {
            return bc.getBundles();
        }
        return new Bundle[0];
    }

    private boolean checkSpecialCases(String name) {
        return specialCaseResources.contains(name);
    }

    public URL findResource(final String name) {
        URL result = null;
        boolean specialCase = this.checkSpecialCases(name);
        if (specialCase) {
            result = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Bundle[] bundles = ClassLoaderGateway.this.getBundles();
                    for (int i = 0; i < bundles.length; ++i) {
                        URL url;
                        Bundle b = bundles[i];
                        if (b == ClassLoaderGateway.this.gatewayBundle || b.getSymbolicName().equals(ClassLoaderGateway.SYSTEM_BUNDLE_SYMBOLIC_NAME) || (url = b.getResource(name)) == null) continue;
                        return url;
                    }
                    return null;
                }
            });
        }
        return result;
    }

    public URL[] findResources(final String name) {
        URL[] result = null;
        boolean specialCase = this.checkSpecialCases(name);
        if (specialCase) {
            result = (URL[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ArrayList resources = new ArrayList();
                    Bundle[] bundles = ClassLoaderGateway.this.getBundles();
                    for (int i = 0; i < bundles.length; ++i) {
                        Bundle b = bundles[i];
                        if (b == ClassLoaderGateway.this.gatewayBundle || b.getSymbolicName().equals(ClassLoaderGateway.SYSTEM_BUNDLE_SYMBOLIC_NAME)) continue;
                        try {
                            Enumeration resourceEnum = b.getResources(name);
                            if (resourceEnum == null) continue;
                            while (resourceEnum.hasMoreElements()) {
                                resources.add(resourceEnum.nextElement());
                            }
                            continue;
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    URL[] urls = new URL[resources.size()];
                    return resources.toArray(urls);
                }
            });
        }
        return result;
    }

    static {
        IExtension[] extensions;
        String epid;
        IExtensionPoint point;
        specialCaseResources = new TreeSet();
        instance = new ClassLoaderGateway();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry != null && (point = registry.getExtensionPoint(epid = "com.ibm.ws.bootstrap.resource-file")) != null && (extensions = point.getExtensions()) != null) {
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] res = extensions[i].getConfigurationElements();
                for (int j = 0; j < res.length; ++j) {
                    String name = res[j].getAttribute("name");
                    specialCaseResources.add(name);
                    if (!LoggingServices.debugEnabled) continue;
                    LoggingServices.out.println("Added special case resource:" + name);
                }
            }
        }
    }
}

