/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTS;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.Delegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTS.GlobalTID;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationData;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationDataHelper;
import com.ibm.ws.Transaction.JTS.WSCascadedPropagationDataHelper;
import com.ibm.ws.Transaction.TxProperties;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.BOSSObjectKey;
import com.ibm.ws.tx.jta.TransactionImpl;
import com.ibm.ws.util.ImplFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.omg.CORBA.Any;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.TransIdentityHelper;
import org.omg.CosTransactions.otid_t;
import org.omg.PortableInterceptor.ClientRequestInfo;

public final class TxInterceptorHelper {
    private static final TraceComponent tc = Tr.register(TxInterceptorHelper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int OMG_TRANSACTION_SERVICE_ID = 0;
    public static final int IMPLEMENTATION_SPECIFIC_CONTEXT = 0;
    public static final int DEFERRED_BEGIN_CONTEXT = 1;
    public static final int INTEROP_CONTEXT = 2;
    public static final int NON_INTEROP_CONTEXT = 3;
    public static final int RRS_CASCADED_CONTEXT = 4;
    public static final int FORMATID_WASC = 1463898947;
    public static final int FORMATID_CB390 = -1010695802;
    public static final int FORMATID_RRS = -640035614;
    private static HashSet<String> _nonTransactionalOperations;
    private static Class<?> _WLMNotifierClass;
    private static final String wlmNotifierImplKey = "com.ibm.ws.transaction.WLMNotifier";

    public static final PropagationContext demarshalContext(byte[] bytes, ORB orb) {
        PropagationContext propContext;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "demarshalContext", Util.toHexString((byte[])bytes));
            }
            CDRInputStream inputStream = ORB.createCDRInputStream((ORB)orb, (byte[])bytes, (int)bytes.length);
            inputStream.consumeEndian();
            propContext = new PropagationContext();
            propContext.timeout = inputStream.read_ulong();
            propContext.current = TransIdentityHelper.read((InputStream)inputStream);
            int _len0 = inputStream.read_long();
            propContext.parents = new TransIdentity[_len0];
            for (int _o1 = 0; _o1 < propContext.parents.length; ++_o1) {
                propContext.parents[_o1] = TransIdentityHelper.read((InputStream)inputStream);
            }
            try {
                propContext.implementation_specific_data = inputStream.read_any();
            }
            catch (OutOfMemoryError e) {
                FFDCFilter.processException(e, "com.ibm.ws.Transaction.JTS.TxInterceptorHelper.demarshalContext", "105");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                Tr.event(tc, "Exception processing prop context any", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "demarshalContext", propContext);
        }
        return propContext;
    }

    public static final byte[] marshalContext(PropagationContext propContext, ORB orb) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "marshalContext");
        }
        byte[] result = null;
        CDROutputStream outputStream = ORB.createCDROutputStream((ORB)orb);
        outputStream.putEndian();
        PropagationContextHelper.write((OutputStream)outputStream, propContext);
        result = outputStream.toByteArray();
        outputStream.releaseBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "marshalContext", result);
        }
        return result;
    }

    public static int determineContextType(PropagationContext propContext) {
        Any any;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "determineContextType", propContext);
        }
        if (propContext.current == null || propContext.current.otid.formatID == -1) {
            Tr.warning(tc, "WTRN0007_CANT_IMPORT_NULL_CONTEXT");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "determineContextType", "context has null transaction identifier");
            }
            throw new TRANSACTION_REQUIRED();
        }
        if (propContext.parents.length > 0) {
            Tr.warning(tc, "WTRN0008_CANT_IMPORT_NESTED_TRAN", new GlobalTID(propContext.current.otid));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "determineContextType", "INVALID_TRANSACTION");
            }
            throw new INVALID_TRANSACTION();
        }
        int contextType = propContext.current.coord == null ? (propContext.current.otid.formatID == 1463898947 || propContext.current.otid.formatID == -1010695802 ? 1 : (propContext.current.otid.formatID == -640035614 ? ((any = propContext.implementation_specific_data) != null && any.type().equal(WSCascadedPropagationDataHelper.type()) ? 4 : 3) : ((any = propContext.implementation_specific_data) != null && any.type().kind() != TCKind.tk_boolean ? 0 : 3))) : (propContext.current.otid.formatID == -640035614 ? ((any = propContext.implementation_specific_data) != null && any.type().equal(WSCascadedPropagationDataHelper.type()) ? 4 : 2) : ((any = propContext.implementation_specific_data) != null && any.type().equal(WSCascadedPropagationDataHelper.type()) ? 4 : 2));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "determineContextType", contextType == 1 ? "DEFERRED_BEGIN_CONTEXT" : (contextType == 3 ? "NON_INTEROP_CONTEXT" : (contextType == 4 ? "RRS_CASCADED_CONTEXT" : (contextType == 0 ? "IMPLEMENTATION_SPECIFIC_CONTEXT" : "INTEROP_CONTEXT"))));
        }
        return contextType;
    }

    public static boolean isTransactional(ClientRequestInfo info) {
        boolean isTransactional;
        block8: {
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "isTransactional", info);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Two-way operation: " + info.response_expected());
                }
            }
            boolean bl = isTransactional = TxInterceptorHelper.isTransactional(info.operation()) && info.response_expected();
            if (isTransactional && TxProperties.isZOS) {
                ObjectImpl oi = null;
                try {
                    BOSSObjectKey bossKey;
                    Delegate d;
                    IOR ior;
                    Profile p;
                    ObjectKey objectKey;
                    oi = (ObjectImpl)info.effective_target();
                    if (oi != null && (objectKey = (p = (ior = (d = (Delegate)oi._get_delegate()).locatedIOR()).getProfile()).getObjectKeyObject()) != null && objectKey.getMagic() == -690371886 && (bossKey = (BOSSObjectKey)objectKey).getFlag(Integer.MIN_VALUE)) {
                        isTransactional = false;
                    }
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "Object key manipulation falied", new Object[]{oi, t});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isTransactional", new Boolean(isTransactional));
        }
        return isTransactional;
    }

    public static boolean isTransactional(String operation) {
        boolean transactional;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isTransactional", operation);
        }
        if (_nonTransactionalOperations == null) {
            String property = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String property = System.getProperty("com.ibm.ejs.jts.jts.knownNonTransactional", "_is_a:_get_handle");
                    return property;
                }
            });
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "knownNonTransactional: " + property);
            }
            StringTokenizer token = new StringTokenizer(property, ":");
            HashSet<String> set = new HashSet<String>();
            while (token.hasMoreElements()) {
                set.add(token.nextToken());
            }
            _nonTransactionalOperations = set;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Set of non-transactional operations: " + _nonTransactionalOperations);
            }
        }
        boolean bl = transactional = !_nonTransactionalOperations.contains(operation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isTransactional", transactional);
        }
        return transactional;
    }

    static otid_t createOtidFromTransaction(TransactionImpl tx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createOtidFromTransaction", tx);
        }
        GlobalTID globalTID = new GlobalTID(tx.getXid());
        otid_t otid = globalTID.getRealTID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createOtidFromTransaction", otid);
        }
        return otid;
    }

    static otid_t createJTA2OtidFromTransaction(TransactionImpl tx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createJTA2OtidFromTransaction", tx);
        }
        Xid xid = tx.getXid();
        otid_t otid = new otid_t(xid.getFormatId(), 0, xid.getGlobalTransactionId());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createJTA2OtidFromTransaction", otid);
        }
        return otid;
    }

    public static int calculateSubordinateTimeout(TransactionImpl transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "calculateSubordinateTimeout", transaction);
        }
        int subordinateTimeout = 0;
        long expirationTime = transaction.getExpirationTime();
        if (transaction.getExpirationTime() != 0L) {
            long subTime = (expirationTime - System.currentTimeMillis() + 999L) / 1000L + 10L;
            int n = subordinateTimeout = subTime > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)subTime;
            if (subordinateTimeout <= 0) {
                block8: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Timeout for subordinate <= 0. Marking rollback only");
                    }
                    try {
                        transaction.setRollbackOnly();
                    }
                    catch (IllegalStateException ise) {
                        FFDCFilter.processException(ise, "com.ibm.ws.Transaction.JTS.TxInterceptorHelper.calculateSubordinateTimeout.", "242");
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block8;
                        Tr.event(tc, "IllegalStateException setting tx rollback only");
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "calculateSubordinateTimeout");
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "calculateSubordinateTimeout", new Integer(subordinateTimeout));
        }
        return subordinateTimeout;
    }

    public static String getTaskId(PropagationContext propagationContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskId", propagationContext);
        }
        String taskId = null;
        TypeCode isdType = propagationContext.implementation_specific_data.type();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ISD type", isdType);
        }
        if (isdType.equal(TaskIdPropagationDataHelper.type())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracting taskId from TaskIdPropagationData");
            }
            TaskIdPropagationData taskIdPropagationData = TaskIdPropagationDataHelper.extract(propagationContext.implementation_specific_data);
            taskId = taskIdPropagationData.taskId;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTaskId", taskId);
        }
        return taskId;
    }

    static void notifyWLM(TransactionImpl importedTx) {
        if (_WLMNotifierClass != null) {
            TxInterceptorHelper.notifyWLM(importedTx, importedTx.getXid().getGlobalTransactionId());
        }
    }

    static void notifyWLM(TransactionImpl importedTx, byte[] gtid) {
        if (_WLMNotifierClass != null) {
            block5: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "notifyWLM", new Object[]{_WLMNotifierClass, importedTx});
                }
                try {
                    Method m = _WLMNotifierClass.getMethod("init", Transaction.class, byte[].class);
                    m.invoke(_WLMNotifierClass.newInstance(), importedTx, gtid);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.Transaction.JTS.TxInterceptorHelper.notifyWLM", "390");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Failed to notify WLM", t);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyWLM");
            }
        }
    }

    static {
        try {
            _WLMNotifierClass = ImplFactory.loadClassFromKey(wlmNotifierImplKey);
        }
        catch (Throwable t) {
            if (t instanceof NoClassDefFoundError) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WLMNotifier class definition not found by ImplFactory - assume key not defined");
                }
            } else {
                FFDCFilter.processException(t, "com.ibm.ws.Transaction.JTS.TxInterceptorHelper.<clinit>", "108");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to load WLMNotifier class", t);
                }
            }
            _WLMNotifierClass = null;
        }
    }
}

