/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTS.ControlImpl;
import com.ibm.ws.Transaction.JTS.CoordinatorImpl;
import com.ibm.ws.Transaction.JTS.TerminatorImpl;
import com.ibm.ws.Transaction.JTS.TxStatusHelper;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.Transaction.client.NonRecoverableTranManagerSet;
import com.ibm.ws.Transaction.client.NonRecoverableTransactionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EnvironmentType;
import com.ibm.ws.tx.jta.TranManagerSet;
import com.ibm.ws.tx.jta.TransactionImpl;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions._CurrentImplBase;

public final class CurrentImpl
extends _CurrentImplBase {
    private static final Current _instance = new CurrentImpl();
    private static WebSphereTransactionManager _tranManager;
    private static int _environmentType;
    private static final TraceComponent tc;

    public static Current instance() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "instance");
        }
        if (_tranManager == null) {
            _environmentType = EnvironmentType.getEnvironmentType();
            if (_environmentType == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server environment. Delegating to TranManagerSet");
                }
                _tranManager = TransactionManagerFactory.getTransactionManager();
            } else if (_environmentType == 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client environment. Delegating to NonRecoverableTranManagerSet");
                }
                _tranManager = NonRecoverableTranManagerSet.instance();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "instance", _instance);
        }
        return _instance;
    }

    public void begin() throws SubtransactionsUnavailable {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "begin");
        }
        try {
            _tranManager.begin();
        }
        catch (NotSupportedException nse) {
            FFDCFilter.processException((Throwable)nse, "com.ibm.ws.Transaction.JTS.CurrentImpl.begin", "93", this);
            throw new SubtransactionsUnavailable();
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.Transaction.JTS.CurrentImpl.begin", "98", this);
            throw new INTERNAL();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "begin");
            }
        }
    }

    public void commit(boolean reportHeuristics) throws HeuristicMixed, HeuristicHazard {
        TransactionImpl transaction;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", reportHeuristics);
        }
        if (_environmentType == 0 && (transaction = ((TranManagerSet)_tranManager).getTransactionImpl()) != null && transaction.isSubordinate()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The transaction may only be committed by its originator");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
            throw new NO_PERMISSION();
        }
        try {
            _tranManager.commit();
        }
        catch (HeuristicMixedException hme) {
            throw new HeuristicMixed();
        }
        catch (HeuristicRollbackException hrbe) {
            throw new HeuristicHazard();
        }
        catch (RollbackException rbe) {
            throw new TRANSACTION_ROLLEDBACK();
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.Transaction.JTS.CurrentImpl.commit", "132", this);
            throw new INTERNAL();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
        }
    }

    public Control get_control() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get_control");
        }
        if (_environmentType == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Control is not available in a client environment");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "get_control");
            }
            throw new NO_IMPLEMENT();
        }
        TransactionImpl transaction = ((TranManagerSet)_tranManager).getTransactionImpl();
        ControlImpl control = null;
        if (transaction != null) {
            CoordinatorImpl coord = CoordinatorImpl.lookupCoordinator((TransactionImpl)transaction);
            if (coord == null) {
                coord = new CoordinatorImpl(transaction);
            }
            if ((control = coord.getControl()) == null) {
                TerminatorImpl term = null;
                if (!transaction.isSubordinate()) {
                    term = new TerminatorImpl(transaction);
                }
                ControlImpl cImpl = new ControlImpl((Coordinator)coord, (Terminator)term);
                coord.setControl(cImpl);
                control = cImpl;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "get_control", control);
        }
        return control;
    }

    public Status get_status() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get_status");
        }
        Status status = Status.StatusUnknown;
        try {
            status = TxStatusHelper.getCORBAStatus(_tranManager.getStatus());
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.Transaction.JTS.CurrentImpl.get_status", "161", this);
            throw new INTERNAL();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "get_status", TxStatusHelper.getCORBAStatusAsString(status));
            }
        }
        return status;
    }

    public String get_transaction_name() {
        String name;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "get_transaction_name");
            }
            name = null;
            try {
                Transaction transaction = _tranManager.getTransaction();
                if (transaction == null) break block7;
                name = _environmentType == 1 ? Util.toHexString((byte[])((NonRecoverableTransactionImpl)transaction).getTID()) : Util.toHexString((byte[])((TransactionImpl)transaction).getTID());
            }
            catch (SystemException se) {
                try {
                    FFDCFilter.processException((Throwable)se, "com.ibm.ws.Transaction.JTS.CurrentImpl.get_transaction_name", "183", this);
                    throw new INTERNAL();
                }
                catch (Throwable throwable) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "get_tranasction_name", name);
                    }
                    throw throwable;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "get_tranasction_name", name);
        }
        return name;
    }

    public void resume(Control control) throws InvalidControl {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", control);
            Tr.exit(tc, "resume");
        }
        throw new NO_IMPLEMENT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback_only() throws NoTransaction {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback_only");
        }
        try {
            _tranManager.setRollbackOnly();
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.Transaction.JTS.CurrentImpl.rollback_only", "201", this);
            throw new NoTransaction();
        }
        catch (SystemException systemException) {
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback_only");
            }
        }
    }

    public void rollback() {
        TransactionImpl transaction;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        if (_environmentType == 0 && (transaction = ((TranManagerSet)_tranManager).getTransactionImpl()) != null && transaction.isSubordinate()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "The transaction may only be rolledback by its originator");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "commit");
            }
            throw new NO_PERMISSION();
        }
        try {
            _tranManager.rollback();
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.Transaction.JTS.CurrentImpl.rollback", "231", this);
            throw new INTERNAL();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "rollback");
            }
        }
    }

    public void set_timeout(int timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "set_timeout", timeout);
        }
        try {
            _tranManager.setTransactionTimeout(timeout);
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.Transaction.JTS.CurrentImpl.set_timeout", "250", this);
            throw new INTERNAL();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "set_timeout");
            }
        }
    }

    public Control suspend() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
            Tr.exit(tc, "suspend");
        }
        throw new NO_IMPLEMENT();
    }

    static {
        tc = Tr.register(CurrentImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    }
}

