/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandMgrInitializer;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import java.io.InputStream;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IPlatformRunnable;

public class AdminClientTest
implements IPlatformRunnable {
    private static TraceComponent tc;

    public AdminClientTest() {
        System.out.println("AdminClientTest has been constructed");
    }

    private static void doSOAP(Properties clientProperties, String host, String port) {
        System.out.println("\n\n===================================================");
        System.out.println("jdh -- set properties for SOAP Connector .........\n\n");
        clientProperties.setProperty("type", "SOAP");
        clientProperties.setProperty("host", host);
        clientProperties.setProperty("port", port);
        clientProperties.setProperty("com.ibm.SOAP.ConfigURL", "/home/jheath/XFER/tacBundled/adminClient/soap.client.props");
        clientProperties.setProperty("securityEnabled", "false");
        clientProperties.setProperty("location", "remote");
        System.out.println("jdh -- properties were set for SOAP Connector .........\n\n");
    }

    private static void doRMI(Properties clientProperties, String host, String port) {
        System.out.println("\n\n===================================================");
        System.out.println("jdh -- set properties for RMI Connector .........\n\n");
        clientProperties.setProperty("type", "RMI");
        clientProperties.setProperty("host", host);
        clientProperties.setProperty("port", port);
        clientProperties.setProperty("securityEnabled", "false");
        clientProperties.setProperty("location", "remote");
        System.out.println("jdh -- properties were set for RMI Connector .........\n\n");
    }

    public static void main(String[] args) throws Exception {
        Tr.entry(tc, "main");
        System.out.println("jdh -- in AdminClientTest:main()");
        new AdminClientTest().executeUtility();
    }

    public Object run(Object o) throws Exception {
        Tr.entry(tc, "run");
        System.out.println("jdh -- in AdminClientTest:run()");
        new AdminClientTest().executeUtility();
        return null;
    }

    private void executeUtility() throws Exception {
        PLoader ploader = new PLoader();
        Properties wsProperties = ploader.loadProperties("wsproperties");
        wsProperties.list(System.out);
        AdminClient adminClient = null;
        Properties clientProperties = new Properties();
        AdminClientTest.doSOAP(clientProperties, (String)wsProperties.get("HOST_NAME"), (String)wsProperties.get("SOAP_PORT"));
        boolean connected = false;
        try {
            adminClient = AdminClientFactory.createAdminClient(clientProperties);
            System.out.println("adminClient = " + adminClient);
            connected = true;
            String connectorType = adminClient.getType();
            System.out.println("jdh -- adminClient created; connectorType = " + connectorType);
            Integer mbeanCount = new Integer(0);
            System.out.println("jdh -- try to getMBeanCount()");
            mbeanCount = adminClient.getMBeanCount();
            System.out.println("jdh -- getMBeanCount() returned:  " + mbeanCount);
            System.out.println("jdh -- try to geterverMBean()");
            ObjectName serverMBean = adminClient.getServerMBean();
            System.out.println("jdh -- getServerMBean() returned:  " + serverMBean);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(" Exception caught = " + ex.getMessage());
            System.exit(1);
        }
        if (connected) {
            System.out.println("Connected");
        } else {
            System.out.println("Not connected");
            System.exit(1);
        }
        AdminClientTest.cfgSvcTestCode(adminClient, "Node=" + wsProperties.get("NODE_NAME") + ":Server=" + wsProperties.get("SERVER_NAME"));
        AdminClientTest.cmdFrameworkTest(adminClient, (String)wsProperties.get("NODE_NAME"));
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cmdFrameworkTest(AdminClient adminClient, String nodeName) {
        System.out.println("in  cmdFrameWorkTest()");
        Object session = null;
        try {
            CommandMgrInitializer.initializeClientMode(adminClient);
            AdminClientTest.jafter("CommandMgrInitializer.initializeClientMode()");
            CommandMgr cmdMgr = CommandMgr.getCommandMgr();
            AdminClientTest.jafter("CommandMgr.getCommandMgr()");
            AdminCommand getNodeBaseProductVersion = null;
            getNodeBaseProductVersion = cmdMgr.createCommand("getNodeBaseProductVersion");
            AdminClientTest.jafter("cmdMgr.createCommand");
            getNodeBaseProductVersion.setParameter("nodeName", nodeName);
            AdminClientTest.jafter("getNodeBaseProductVersion.setParameter()");
            getNodeBaseProductVersion.execute();
            AdminClientTest.jafter("getNodeBaseProductVersion.execute()");
            CommandResult result = getNodeBaseProductVersion.getCommandResult();
            AdminClientTest.jafter("getNodeBaseProductVersion.getCommandResult()");
            System.out.println("CmdFrameworkTest got result:" + result.getResult());
        }
        catch (Throwable t) {
            System.out.println("caught exception in CmdFrameWorkTest()");
            t.printStackTrace();
        }
        finally {
            if (session != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cfgSvcTestCode(AdminClient adminClient, String nodeAndServer) {
        System.out.println("jdh -- enter cfgSvcTestCode()");
        ConfigServiceProxy configService = null;
        Session session = null;
        try {
            Object portNum;
            AttributeList address;
            AdminClientTest.jbefore("ConfigServiceProxy");
            configService = new ConfigServiceProxy(adminClient);
            AdminClientTest.jafter("ConfigServiceProxy");
            AdminClientTest.jbefore("Session");
            session = new Session();
            AdminClientTest.jafter("Session");
            AdminClientTest.jafter("resolve");
            ObjectName server1 = configService.resolve(session, nodeAndServer)[0];
            AdminClientTest.jbefore("resolve");
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "HTTPTransport");
            ObjectName[] transports = configService.queryConfigObjects(session, server1, pattern, null);
            AdminClientTest.jafter("queryConfigObjects");
            for (int i = 0; i < transports.length; ++i) {
                address = (AttributeList)configService.getAttribute(session, transports[i], "address");
                AdminClientTest.jafter("configService.getAttribute() #1");
                portNum = ConfigServiceHelper.getAttributeValue(address, "port");
                AdminClientTest.jafter("configService.getAttribute()Value");
                Object isSSLEnabled = configService.getAttribute(session, transports[i], "sslEnabled");
                AdminClientTest.jafter("configService.getAttribute() #2");
                if (Boolean.TRUE.equals(isSSLEnabled)) {
                    System.out.print("HTTPS transport listens on port ");
                } else {
                    System.out.print("HTTP transport listens on port ");
                }
                System.out.println(portNum + ".");
            }
            pattern = ConfigServiceHelper.createObjectName(null, "SOAPConnector");
            AdminClientTest.jafter("ConfigServiceHelper.createObjectName()");
            ObjectName soap = configService.queryConfigObjects(session, server1, pattern, null)[0];
            address = (AttributeList)configService.getAttribute(session, soap, "SOAP_CONNECTOR_ADDRESS");
            portNum = ConfigServiceHelper.getAttributeValue(address, "port");
            System.out.println("soap connector listens on port " + portNum + ".");
            pattern = ConfigServiceHelper.createObjectName(null, "NameServer");
            ObjectName nameServer = configService.queryConfigObjects(session, server1, pattern, null)[0];
            address = (AttributeList)configService.getAttribute(session, nameServer, "BOOTSTRAP_ADDRESS");
            portNum = ConfigServiceHelper.getAttributeValue(address, "port");
            System.out.println("NameServer bootstrap port listens on port " + portNum + ".");
            if (session == null) return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            configService.discard(session);
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        finally {
            if (session != null) {
                try {
                    configService.discard(session);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static void jbefore(String s) {
        System.out.println("jdh -- before event:  " + s);
    }

    private static void jafter(String s) {
        System.out.println("jdh -- after event:  " + s);
    }

    static {
        System.out.println("jdh -- AdminClientTest v 2.1 is loaded");
        tc = Tr.register(AdminClientTest.class, "Admin", "com.ibm.ws.client");
    }

    class PLoader {
        private static final boolean THROW_ON_LOAD_FAILURE = true;
        private static final boolean LOAD_AS_RESOURCE_BUNDLE = false;
        private static final String SUFFIX = ".props";

        PLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties loadProperties(String name, ClassLoader loader) {
            if (name == null) {
                throw new IllegalArgumentException("null input: name");
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (name.endsWith(SUFFIX)) {
                name = name.substring(0, name.length() - SUFFIX.length());
            }
            Properties result = null;
            InputStream in = null;
            try {
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                if (!(name = name.replace('.', '/')).endsWith(SUFFIX)) {
                    name = name.concat(SUFFIX);
                }
                if ((in = loader.getResourceAsStream(name)) != null) {
                    result = new Properties();
                    result.load(in);
                }
            }
            catch (Exception e) {
                result = null;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
            if (result == null) {
                throw new IllegalArgumentException("could not load [" + name + "]" + " as " + "a classloader resource");
            }
            return result;
        }

        public Properties loadProperties(String name) {
            return this.loadProperties(name, Thread.currentThread().getContextClassLoader());
        }
    }
}

