/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class JSSEHelper {
    private static final TraceComponent tc = Tr.register(JSSEHelper.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static JSSEHelper thisClass = null;
    private static final WebSphereRuntimePermission GET_SSLCONFIG = new WebSphereRuntimePermission("getSSLConfig");
    private static final WebSphereRuntimePermission SET_SSLCONFIG = new WebSphereRuntimePermission("setSSLConfig");
    public static final String DIRECTION_INBOUND = "inbound";
    public static final String DIRECTION_OUTBOUND = "outbound";
    public static final String DIRECTION_UNKNOWN = "unknown";
    public static final String ENDPOINT_IIOP = "IIOP";
    public static final String ENDPOINT_HTTP = "HTTP";
    public static final String ENDPOINT_SIP = "SIP";
    public static final String ENDPOINT_JMS = "JMS";
    public static final String ENDPOINT_BUS_CLIENT = "BUS_CLIENT";
    public static final String ENDPOINT_BUS_TO_WEBSPHERE_MQ = "BUS_TO_WEBSPHERE_MQ";
    public static final String ENDPOINT_BUS_TO_BUS = "BUS_TO_BUS";
    public static final String ENDPOINT_CLIENT_TO_WEBSPHERE_MQ = "CLIENT_TO_WEBSPHERE_MQ";
    public static final String ENDPOINT_LDAP = "LDAP";
    public static final String ENDPOINT_ADMIN_SOAP = "ADMIN_SOAP";
    public static final String ENDPOINT_ADMIN_IPC = "ADMIN_IPC";
    public static final String CONNECTION_INFO_DIRECTION = "com.ibm.ssl.direction";
    public static final String CONNECTION_INFO_ENDPOINT_NAME = "com.ibm.ssl.endPointName";
    public static final String CONNECTION_INFO_REMOTE_HOST = "com.ibm.ssl.remoteHost";
    public static final String CONNECTION_INFO_REMOTE_PORT = "com.ibm.ssl.remotePort";
    public static final String CONNECTION_INFO_CERT_MAPPING_HOST = "com.ibm.ssl.certMappingHost";
    public static final String CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND = "com.ibm.ssl.isWebContainerInbound";

    public static JSSEHelper getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (thisClass == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new instance of JSSEHelper.");
            }
            thisClass = new JSSEHelper();
            if (!SSLConfigManager.getInstance().isServerProcess()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting to initialize client configuration, if not already done.");
                }
                SSLConfigManager.getInstance().initializeClientSSL();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", thisClass);
        }
        return thisClass;
    }

    public void setSSLPropertiesOnThread(Properties props) {
        SSLConfig config;
        String alias;
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            String debug = "Clearing thread properties.";
            if (props != null) {
                debug = props != null && props.getProperty("com.ibm.ssl.alias") != null ? "Setting thread properties: " + props.getProperty("com.ibm.ssl.alias") : "Setting thread properties: " + props.toString();
            }
            Tr.entry(tc, "setSSLPropertiesOnThread", new Object[]{debug});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SET_SSLCONFIG.toString());
            }
            sm.checkPermission(SET_SSLCONFIG);
        }
        if (props != null && (alias = props.getProperty("com.ibm.ssl.alias")) != null && (config = SSLConfigManager.getInstance().getSSLConfig(alias)) == null && (config = new SSLConfig(props)) != null) {
            try {
                SSLConfigManager.getInstance().addSSLConfigToMap(alias, config);
            }
            catch (Exception e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "The following exception occurred in setSSLPropertiesOnThread().", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.setSSLPropertiesOnThread", "303", this);
            }
        }
        ThreadManager.getInstance().setPropertiesOnThread(props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSSLPropertiesOnThread");
        }
    }

    public Properties getSSLPropertiesOnThread() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLPropertiesOnThread");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            sm.checkPermission(GET_SSLCONFIG);
        }
        Properties props = ThreadManager.getInstance().getPropertiesOnThread();
        if (tc.isEntryEnabled()) {
            String debug = "Thread properties are NULL.";
            if (props != null) {
                debug = props != null && props.getProperty("com.ibm.ssl.alias") != null ? "Found thread properties: " + props.getProperty("com.ibm.ssl.alias") : "Found thread properties: " + props.toString();
            }
            Tr.entry(tc, "getSSLPropertiesOnThread", new Object[]{debug});
        }
        return props;
    }

    public Properties getProperties(String sslAliasName) throws SSLException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", new Object[]{sslAliasName});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            sm.checkPermission(GET_SSLCONFIG);
        }
        try {
            Properties directSelectionProperties;
            if (sslAliasName != null && sslAliasName.length() > 0 && (directSelectionProperties = SSLConfigManager.getInstance().getProperties(sslAliasName)) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProperties -> direct");
                }
                return directSelectionProperties;
            }
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getProperties().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getProperties", "408", this);
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties -> null");
        }
        return null;
    }

    public SSLContext getSSLContext(Map connectionInfo, Properties props) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContext", new Object[]{connectionInfo});
        }
        if (props != null) {
            SSLConfig newConfig = new SSLConfig(props);
            String contextProvider = props.getProperty("com.ibm.ssl.contextProvider");
            if (contextProvider == null) {
                contextProvider = "IBMJSSE2";
            }
            SSLContext context = null;
            try {
                context = JSSEProviderFactory.getInstance(contextProvider).getSSLContext(connectionInfo, newConfig);
            }
            catch (Exception e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "The following exception occurred getting the SSLContext.", new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getSSLContext", "452", this);
                if (e instanceof SSLException) {
                    throw (SSLException)e;
                }
                throw new SSLException(e.getMessage(), e);
            }
            if (context == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The SSLContext is null.  Throwing exception.");
                }
                throw new SSLException("The SSLContext returned is null.  Validate the Properties passed in.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLContext");
            }
            return context;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSL client config properties are missing. The property 'com.ibm.SSL.ConfigURL' may not be set properly.");
        }
        String message = TraceNLSHelper.getInstance().getString("ssl.no.properties.error.CWPKI0315E", "SSL configuration properites are null. Could be a problem parsing the SSL client configuraton.");
        throw new SSLException(message);
    }

    public URLStreamHandler getURLStreamHandler(Properties props) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getURLStreamHandler");
        }
        try {
            SSLConfig newConfig = new SSLConfig(props);
            String contextProvider = newConfig.getProperty("com.ibm.ssl.contextProvider");
            if (contextProvider == null) {
                contextProvider = "IBMJSSE2";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getURLStreamHandler");
            }
            return JSSEProviderFactory.getInstance(contextProvider).getURLStreamHandler(newConfig);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred getting the SSLContext.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getSSLContext", "495", this);
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e.getMessage(), e);
        }
    }

    public SSLServerSocketFactory getSSLServerSocketFactory(Properties props) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLServerSocketFactory");
        }
        try {
            SSLConfig newConfig = new SSLConfig(props);
            String contextProvider = newConfig.getProperty("com.ibm.ssl.contextProvider");
            if (contextProvider == null) {
                contextProvider = "IBMJSSE2";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLServerSocketFactory");
            }
            return JSSEProviderFactory.getInstance(contextProvider).getSSLServerSocketFactory(newConfig);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLServerSocketFactory().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getSSLServerSocketFactory", "538", this);
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
    }

    public SSLSocketFactory getSSLSocketFactory(Map connectionInfo, Properties props) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLSocketFactory");
        }
        try {
            SSLConfig newConfig = new SSLConfig(props);
            String contextProvider = newConfig.getProperty("com.ibm.ssl.contextProvider");
            if (contextProvider == null) {
                contextProvider = "IBMJSSE2";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLSocketFactory");
            }
            return JSSEProviderFactory.getInstance(contextProvider).getSSLSocketFactory(connectionInfo, newConfig);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLSocketFactory().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getSSLSocketFactory", "579", this);
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
    }

    public SSLContext getSSLContext(String sslAliasName, Map connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContext", new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            sm.checkPermission(GET_SSLCONFIG);
        }
        try {
            SSLConfig props = (SSLConfig)this.getProperties(sslAliasName, connectionInfo, listener);
            if (props != null) {
                SSLContext context;
                String contextProvider = props.getProperty("com.ibm.ssl.contextProvider");
                if (contextProvider == null) {
                    contextProvider = "IBMJSSE2";
                }
                if ((context = JSSEProviderFactory.getInstance(contextProvider).getSSLContext(connectionInfo, props)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSSLContext");
                    }
                    return context;
                }
                throw new SSLException("SSLContext could not be created from specified SSL properties.");
            }
            throw new SSLException("SSLContext could not be created due to null SSL properties.");
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLContext().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getSSLContext", "704", this);
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
    }

    public URLStreamHandler getURLStreamHandler(String sslAliasName, Map connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getURLStreamHandler", new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            sm.checkPermission(GET_SSLCONFIG);
        }
        URLStreamHandler urlStreamHandler = null;
        try {
            Properties sslProperties = this.getProperties(sslAliasName, connectionInfo, listener);
            String contextProvider = "IBMJSSE2";
            if (sslProperties != null && (contextProvider = sslProperties.getProperty("com.ibm.ssl.contextProvider")) == null) {
                contextProvider = "IBMJSSE2";
            }
            urlStreamHandler = JSSEProviderFactory.getInstance(contextProvider).getURLStreamHandler((SSLConfig)sslProperties);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getURLStreamHandler().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getURLStreamHandler", "766", this);
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getURLStreamHandler");
        }
        return urlStreamHandler;
    }

    public SSLSocketFactory getSSLSocketFactory(String sslAliasName, Map connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLSocketFactory", new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            sm.checkPermission(GET_SSLCONFIG);
        }
        SSLSocketFactory sslSocketFactory = null;
        try {
            SSLConfig sslProperties = (SSLConfig)this.getProperties(sslAliasName, connectionInfo, listener);
            String contextProvider = sslProperties.getProperty("com.ibm.ssl.contextProvider");
            if (contextProvider == null) {
                contextProvider = "IBMJSSE2";
            }
            sslSocketFactory = JSSEProviderFactory.getInstance(contextProvider).getSSLSocketFactory(connectionInfo, sslProperties);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLSocketFactory().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getSSLSocketFactory", "825", this);
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLSocketFactory");
        }
        return sslSocketFactory;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory(String sslAliasName, Map connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLServerSocketFactory", new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            sm.checkPermission(GET_SSLCONFIG);
        }
        SSLServerSocketFactory sslServerSocketFactory = null;
        try {
            SSLConfig sslProperties = (SSLConfig)this.getProperties(sslAliasName, connectionInfo, listener);
            String contextProvider = sslProperties.getProperty("com.ibm.ssl.contextProvider");
            if (contextProvider == null) {
                contextProvider = "IBMJSSE2";
            }
            sslServerSocketFactory = JSSEProviderFactory.getInstance(contextProvider).getSSLServerSocketFactory(sslProperties);
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLServerSocketFactory().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getSSLServerSocketFactory", "883", this);
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLServerSocketFactory");
        }
        return sslServerSocketFactory;
    }

    public Properties getProperties(String sslAliasName, Map connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", new Object[]{sslAliasName, connectionInfo, listener});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            sm.checkPermission(GET_SSLCONFIG);
        }
        try {
            String configCertAliases;
            Properties directSelectionProperties;
            Properties programmaticProperties = this.getSSLPropertiesOnThread();
            if (programmaticProperties != null) {
                SSLConfig programmaticConfig = new SSLConfig(programmaticProperties);
                if (listener != null) {
                    String alias = programmaticConfig.getProperty("com.ibm.ssl.alias");
                    if (alias == null) {
                        alias = sslAliasName;
                    }
                    this.registerEvent(listener, alias, programmaticConfig, "thread", connectionInfo);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProperties -> programmatic");
                }
                return programmaticConfig;
            }
            SSLConfig dynamicSelectionConfig = (SSLConfig)SSLConfigManager.getInstance().getPropertiesFromDynamicSelectionInfo(connectionInfo);
            if (dynamicSelectionConfig != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProperties -> dynamic");
                }
                if (listener != null) {
                    String alias = dynamicSelectionConfig.getProperty("com.ibm.ssl.alias");
                    if (alias == null) {
                        alias = sslAliasName;
                    }
                    this.registerEvent(listener, alias, dynamicSelectionConfig, "dynamic", connectionInfo);
                }
                return dynamicSelectionConfig;
            }
            if (sslAliasName != null && sslAliasName.length() > 0 && (directSelectionProperties = SSLConfigManager.getInstance().getProperties(sslAliasName)) != null) {
                directSelectionProperties = SSLConfigManager.getInstance().determineIfCSIv2SettingsApply(directSelectionProperties, connectionInfo);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProperties -> direct");
                }
                if (listener != null) {
                    this.registerEvent(listener, sslAliasName, directSelectionProperties, "direct", connectionInfo);
                }
                return directSelectionProperties;
            }
            if (SSLConfigManager.getInstance().isServerProcess() && (configCertAliases = ManagementScopeManager.getInstance().getConfigAndCertAliasesFromGroups(connectionInfo)) != null) {
                Properties groupSelectionProperties;
                String configAlias = null;
                String certAlias = null;
                StringTokenizer t = new StringTokenizer(configCertAliases, ",");
                String[] aliases = new String[t.countTokens()];
                int i = 0;
                while (t.hasMoreTokens()) {
                    aliases[i++] = t.nextToken();
                }
                if (aliases != null && aliases.length == 2) {
                    configAlias = aliases[0];
                    certAlias = aliases[1];
                } else if (aliases != null && aliases.length == 1) {
                    configAlias = aliases[0];
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configAlias: " + configAlias + ", certAlias: " + certAlias);
                }
                if (configAlias != null && (groupSelectionProperties = SSLConfigManager.getInstance().getProperties(configAlias)) != null) {
                    if (certAlias != null) {
                        groupSelectionProperties = (Properties)groupSelectionProperties.clone();
                    }
                    if (certAlias != null && connectionInfo != null) {
                        String direction = (String)connectionInfo.get(CONNECTION_INFO_DIRECTION);
                        if (direction != null && direction.equals(DIRECTION_INBOUND)) {
                            groupSelectionProperties.setProperty("com.ibm.ssl.keyStoreServerAlias", certAlias);
                        } else if (direction != null && direction.equals(DIRECTION_OUTBOUND)) {
                            groupSelectionProperties.setProperty("com.ibm.ssl.keyStoreClientAlias", certAlias);
                        }
                    } else if (certAlias != null) {
                        groupSelectionProperties.setProperty("com.ibm.ssl.keyStoreServerAlias", certAlias);
                        groupSelectionProperties.setProperty("com.ibm.ssl.keyStoreClientAlias", certAlias);
                    }
                    groupSelectionProperties = SSLConfigManager.getInstance().determineIfCSIv2SettingsApply(groupSelectionProperties, connectionInfo);
                    if (listener != null) {
                        this.registerEvent(listener, configAlias, groupSelectionProperties, "scoped", connectionInfo);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getProperties -> group");
                    }
                    return groupSelectionProperties;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getProperties -> default");
            }
            return SSLConfigManager.getInstance().getDefaultSSLConfig();
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLContext().", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.getSSLContext", "1059", this);
            throw new SSLException(e);
        }
    }

    private void registerEvent(SSLConfigChangeListener listener, String alias, Properties config, String selection, Map connInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerEvent", new Object[]{listener, alias, selection});
        }
        if (listener != null) {
            SSLConfigChangeEvent event2 = new SSLConfigChangeEvent(alias, config, selection, connInfo);
            SSLConfigManager.getInstance().registerSSLConfigChangeListener(listener, event2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerEvent");
        }
    }

    public void registerSSLConfigChangeListener(String sslAliasName, Map connectionInfo, SSLConfigChangeListener listener) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSSLConfigChangeListener", new Object[]{sslAliasName, connectionInfo, listener});
        }
        this.getProperties(sslAliasName, connectionInfo, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSSLConfigChangeListener");
        }
    }

    public void deregisterSSLConfigChangeListener(SSLConfigChangeListener listener) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterSSLConfigChangeListener", new Object[]{listener});
        }
        SSLConfigManager.getInstance().deregisterSSLConfigChangeListener(listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterSSLConfigChangeListener");
        }
    }

    public boolean doesSSLConfigExist(String sslAliasName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesSSLConfigExist", new Object[]{sslAliasName});
        }
        if (sslAliasName == null) {
            throw new IllegalArgumentException("sslAliasName is null.");
        }
        boolean exists = false;
        Properties props = SSLConfigManager.getInstance().getProperties(sslAliasName);
        if (props != null) {
            exists = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesSSLConfigExist -> " + exists);
        }
        return exists;
    }

    public void loadClientSSLPropertiesFromURL(String configURL, boolean reinitialize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseClientSSLPropertiesURL", new Object[]{configURL});
        }
        if (configURL == null) {
            throw new IllegalArgumentException("configURL is null.");
        }
        if (configURL != null && configURL.indexOf("soap.client.props") != -1) {
            SSLConfigManager.getInstance().parseConfigURL(ENDPOINT_ADMIN_SOAP, configURL, reinitialize);
        } else if (configURL != null && configURL.indexOf("sas.client.props") != -1) {
            SSLConfigManager.getInstance().parseConfigURL(ENDPOINT_IIOP, configURL, reinitialize);
        } else {
            SSLConfigManager.getInstance().parseSSLConfigURL(configURL, reinitialize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseClientSSLPropertiesURL");
        }
    }

    public void reinitializeClientDefaultSSLProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reinitializeClientDefaultSSLProperties");
        }
        SSLConfigManager.getInstance().reinitializeClientSSL();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reinitializeClientDefaultSSLProperties");
        }
    }

    public void validateSSLProperties(Properties props) throws SSLException {
        SSLConfig testConfig = new SSLConfig(props);
        try {
            testConfig.validateSSLConfig();
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred validating the SSL properties.", new Object[]{e});
            }
            Manager.Ffdc.log(e, this, "com.ibm.websphere.ssl.JSSEHelper.validateSSLProperties", "1208", this);
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e.getMessage(), e);
        }
    }

    public Map getInboundConnectionInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundConnectionInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundConnectionInfo");
        }
        return ThreadManager.getInstance().getInboundConnectionInfo();
    }

    public void setInboundConnectionInfo(Map connectionInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInboundConnectionInfo");
        }
        ThreadManager.getInstance().setInboundConnectionInfo(connectionInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInboundConnectionInfo");
        }
    }

    public Map getOutboundConnectionInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundConnectionInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundConnectionInfo");
        }
        return ThreadManager.getInstance().getOutboundConnectionInfo();
    }

    public void setOutboundConnectionInfo(Map connectionInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOutboundConnectionInfo");
        }
        ThreadManager.getInstance().setOutboundConnectionInfo(connectionInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOutboundConnectionInfo");
        }
    }
}

