/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.security.auth.WSLoginHelperImpl;
import com.ibm.ws.security.common.auth.util.WSStdinLoginPrompt;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSStdinCallbackHandlerImpl
implements CallbackHandler {
    private static final String realmNamePrompt = SecurityMessages.getMsgOrUseDefault("RealmName", "Realm (Cell) Name");
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static int stdinRetry = 0;
    private String userName = "";
    private String password = "";
    private String realmName = "";
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private boolean passwordEcho = false;
    private static final TraceComponent tc = Tr.register(WSStdinCallbackHandlerImpl.class, null, "com.ibm.ejs.resources.security");

    public WSStdinCallbackHandlerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSStdinCallbackHandlerImpl()");
        }
        this.realmName = WSLoginHelperImpl.getDefaultRealmName();
        if (this.realmName == null || this.realmName.length() == 0) {
            this.realmName = "<default>";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Realm Name: " + this.realmName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSStdinCallbackHandlerImpl()");
        }
    }

    public WSStdinCallbackHandlerImpl(String r_name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSStdinCallbackHandlerImpl(r_name) " + r_name);
        }
        if (r_name != null && r_name.length() != 0) {
            this.realmName = r_name;
        } else {
            this.realmName = WSLoginHelperImpl.getDefaultRealmName();
            if (this.realmName == null || this.realmName.length() == 0) {
                this.realmName = "<default>";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSStdinCallbackHandlerImpl(r_name) " + this.realmName);
        }
    }

    public WSStdinCallbackHandlerImpl(String r_name, String t_input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSStdinCallbackHandlerImpl(String, String)", new Object[]{"Default realm: " + r_name});
        }
        if (r_name != null && r_name.length() != 0) {
            this.realmName = r_name;
        } else {
            this.realmName = WSLoginHelperImpl.getDefaultRealmName();
            if (this.realmName == null || this.realmName.length() == 0) {
                this.realmName = "<default>";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSStdinCallbackHandlerImpl(String, String) ");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i;
        StringBuffer sb;
        int len = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(callbacks)");
        }
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of callbacks: " + len);
            sb = new StringBuffer();
            sb.append("{ ");
            for (i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
        }
        if (this.userName == null || this.userName.length() == 0 || this.password == null || this.password.length() == 0) {
            if (tc.isEntryEnabled()) {
                sb = new StringBuffer();
                sb.append("{ ");
                for (i = 0; i < len; ++i) {
                    sb.append(callbacks[i].getClass().getName());
                    if (i >= len - 1) continue;
                    sb.append(", ");
                }
                sb.append(" }");
                Tr.entry(tc, "handle(callbacks = \"" + sb.toString() + "\")");
            }
            for (int i2 = 0; i2 < len; ++i2) {
                Callback c = callbacks[i2];
                if (c instanceof NameCallback) {
                    this.userNamePrompt = ((NameCallback)c).getPrompt();
                    this.userName = ((NameCallback)c).getDefaultName();
                    continue;
                }
                if (c instanceof PasswordCallback) {
                    this.passwordPrompt = ((PasswordCallback)c).getPrompt();
                    this.passwordEcho = ((PasswordCallback)c).isEchoOn();
                    continue;
                }
                if (!(c instanceof WSRealmNameCallbackImpl)) continue;
                this.realmName = ((WSRealmNameCallbackImpl)c).getRealmName();
                if (this.realmName != null && !this.realmName.equals("")) continue;
                this.realmName = ((WSRealmNameCallbackImpl)c).getDefaultRealmName();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Realm Name: " + this.realmName);
            }
            String[] usernameAndPassword = null;
            try {
                if (stdinRetry < 1) {
                    System.out.print(realmNamePrompt + ": " + this.realmName + NEW_LINE);
                    System.out.flush();
                    WSStdinLoginPrompt wstd = new WSStdinLoginPrompt(this.userNamePrompt, this.passwordPrompt);
                    usernameAndPassword = wstd.getUidAndPassword();
                    if (usernameAndPassword != null) {
                        this.password = usernameAndPassword[1];
                        this.userName = RealmSecurityName.getSecurityName(usernameAndPassword[0]);
                        stdinRetry = 0;
                    } else {
                        ++stdinRetry;
                        this.userName = null;
                        this.password = null;
                    }
                } else {
                    stdinRetry = 0;
                    this.userName = null;
                    this.password = null;
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl.handle", "197", this);
                Tr.error(tc, "security.jaas.SystemInputError", new Object[]{e});
            }
        }
        for (int i3 = 0; i3 < len; ++i3) {
            Callback c = callbacks[i3];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this.userName);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this.password == null ? new char[]{} : this.password.toCharArray());
                continue;
            }
            if (c instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)c).setRealmName(this.realmName);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Un-use handle(callbacks = \"" + callbacks[i3].getClass().getName() + "\")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks) " + callbacks);
        }
    }
}

