/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.portletcontainer.portlet.PortletUtils;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.SingleSignonConfig;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.lang.reflect.Method;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.security.auth.AuthPermission;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WSSecurityHelper {
    private static final TraceComponent tc = Tr.register(WSSecurityHelper.class, null, "com.ibm.ejs.resources.security");
    private static final AuthPermission GETPROPATTRIBUTE_PERM = new AuthPermission("wssecurity.getPropagationAttributes");
    private static final AuthPermission SETPROPATTRIBUTE_PERM = new AuthPermission("wssecurity.addPropagationAttribute");
    private static Class webAttributesClass = null;
    private static Method createLogoutCookiesMethod = null;
    private static boolean isSSOEnabled = false;

    public static boolean isServerSecurityEnabled() {
        return ContextManagerFactory.getInstance().isServerSecurityEnabled();
    }

    public static boolean isGlobalSecurityEnabled() {
        return ContextManagerFactory.getInstance().isCellSecurityEnabled();
    }

    public static String getFirstCaller() {
        WSSecurityPropagationHelper propHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstCaller");
        }
        if (!((propHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        String[] callerList = WSSecurityHelper.getCallerList();
        if (callerList != null && callerList.length > 0) {
            String caller = callerList[0];
            if (caller != null) {
                int callerIndex = caller.indexOf(":");
                callerIndex = caller.indexOf(":", callerIndex + 1);
                callerIndex = caller.indexOf(":", callerIndex + 1);
                caller = caller.substring(callerIndex + 1);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getFirstCaller() returns " + caller);
                }
                return RealmSecurityName.getSecurityName(caller);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller() returns null.");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstCaller() returns null.");
        }
        return null;
    }

    public static String getFirstServer() {
        WSSecurityPropagationHelper propHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstServer");
        }
        if (!((propHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        String[] serverList = WSSecurityHelper.getServerList();
        if (serverList != null && serverList.length > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstServer() returns " + serverList[0]);
            }
            return serverList[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstServer() returns null.");
        }
        return null;
    }

    public static String[] getCallerList() {
        WSSecurityPropagationHelper propHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerList");
        }
        if (!((propHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        try {
            PropagationToken token = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
            if (token != null) {
                String[] callerArray = token.getAttributes("com.ibm.wsspi.security.propagation.callers");
                if (callerArray != null && callerArray.length > 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCallerList() returns " + callerArray);
                    }
                    return callerArray;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCallerList() returns null, attribute not present.");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCallerList() returns null, token not present.");
            }
            return null;
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred calling getCallerList().", new Object[]{e});
            }
            Manager.Ffdc.log(e, WSSecurityHelper.class, "com.ibm.websphere.security.WSSecurityHelper.getCallerList", "254");
            return null;
        }
    }

    public static String[] getServerList() {
        WSSecurityPropagationHelper propHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerList");
        }
        if (!((propHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        try {
            PropagationToken token = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
            if (token != null) {
                String[] serverArray = token.getAttributes("com.ibm.wsspi.security.propagation.hosts");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerList() returns " + serverArray);
                }
                return serverArray;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerList() returns null, token not present.");
            }
            return null;
        }
        catch (Exception e) {
            Tr.error(tc, "The following exception occurred calling getServerList().", new Object[]{e});
            Manager.Ffdc.log(e, WSSecurityHelper.class, "com.ibm.websphere.security.WSSecurityHelper.getServerList", "308");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred calling getServerList().", new Object[]{e});
            }
            return null;
        }
    }

    public static String[] getPropagationAttributes(String key) throws WSSecurityException {
        PropagationToken token;
        WSSecurityPropagationHelper propHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropagationAttributes: " + key);
        }
        if (!((propHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GETPROPATTRIBUTE_PERM);
        }
        if ((token = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1")) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropagationAttributes: success");
            }
            return token.getAttributes(key);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropagationAttributes: no PropagationToken found on thread");
        }
        return null;
    }

    public static String[] addPropagationAttribute(String key, String value) throws WSSecurityException {
        ContextManager ctxMgr;
        PropagationToken token;
        WSSecurityPropagationHelper propHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPropagationAttribute");
        }
        if (!((propHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || propHelper.isRMIOutboundPropagationEnabled() || propHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SETPROPATTRIBUTE_PERM);
        }
        if ((token = (ctxMgr = ContextManagerFactory.getInstance()).getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1")) == null && (token = ctxMgr.createPropagationToken(null)) != null) {
            ctxMgr.setPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1", token);
        }
        if (token != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addPropagationAttribute: success");
            }
            return token.addAttribute(key, value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPropagationAttribute: attribute not set");
        }
        return null;
    }

    public static byte[] convertCookieStringToBytes(String cookieString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCookieStringToBytes");
        }
        try {
            return StringUtil.getBytes(Base64Coder.base64Decode(cookieString));
        }
        catch (Exception e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertCookieStringToBytes: failed", new Object[]{e});
            }
            Manager.Ffdc.log(e, WSSecurityHelper.class, "com.ibm.websphere.security.WSSecurityHelper.convertCookieStringToBytes", "475");
            return null;
        }
    }

    public static void revokeSSOCookies(HttpServletRequest req, HttpServletResponse res) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "revokeSSOCookies");
        }
        if (!WSSecurityHelper.isGlobalSecurityEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No action because global security was not enabled");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "revokeSSOCookies");
            }
            return;
        }
        if (webAttributesClass == null) {
            try {
                SingleSignonConfig sso;
                webAttributesClass = Class.forName("com.ibm.ws.security.web.WebAttributes");
                createLogoutCookiesMethod = webAttributesClass.getMethod("createLogoutCookiesStatic", HttpServletRequest.class, HttpServletResponse.class);
                SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                AuthMechanismConfig ltpa = security2.getAuthMechanism("LTPA");
                if (ltpa == null) {
                    Tr.warning(tc, "ltpa is null");
                }
                if ((sso = ltpa.getSingleSignon()) == null) {
                    Tr.warning(tc, "ltpa's sso is null");
                }
                isSSOEnabled = sso.getBoolean("enabled");
            }
            catch (Exception e) {
                Tr.error(tc, "Initialization revokeSSOCookies failed with Exception:", new Object[]{e});
                throw new RuntimeException(e.getMessage());
            }
        }
        if (isSSOEnabled) {
            if (createLogoutCookiesMethod == null) {
                Tr.error(tc, "revokeSSOCookies init condition incorrect.");
            } else {
                try {
                    createLogoutCookiesMethod.invoke(null, req, res);
                }
                catch (Exception e) {
                    Tr.error(tc, "Invoke createLogoutCookie failed with Exception:", new Object[]{e});
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
    }

    public static void revokeSSOCookiesForPortlets(ActionRequest actionReq, ActionResponse actionRes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "revokeSSOCookiesForPortlets");
        }
        HttpServletRequest req = PortletUtils.getHttpServletRequest((ActionRequest)actionReq);
        HttpServletResponse res = PortletUtils.getHttpServletResponse((ActionResponse)actionRes);
        WSSecurityHelper.revokeSSOCookies(req, res);
        PortletSession session = actionReq.getPortletSession(false);
        if (session != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalidating existing portlet Session");
            }
            session.invalidate();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Existing portlet Session does not exist, nothing to invalidate");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "revokeSSOCookiesForPortlets");
        }
    }
}

