/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.scripting.launcherHelper;

import com.ibm.websphere.scripting.launcherHelper.ScriptingLauncherHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ScriptingLauncherHelperFactory {
    private static final String PROPERTY_WS_EXT_DIRS = "com.ibm.websphere.scripting.launcher.extDirs";
    private static final String PROPERTY_CLASSPATH = "com.ibm.websphere.scripting.launcher.classPath";
    private static final String PROPERTY_JAVA_LIBRARY_PATH = "com.ibm.websphere.scripting.launcher.javalibrarypath";
    private static final String PROPERTY_OTHERS = "com.ibm.websphere.scripting.launcher.others";
    private static final String PROPERTY_JYTHON_PATH = "com.ibm.websphere.scripting.launcher.jythonPath";
    private static final String VARIABLE_WASHOME = "\\$\\{WAS_ROOT\\}";
    private static final String VARIABLE_USERHOME = "\\$\\{USER_ROOT\\}";

    private static void trace(String data) {
        System.out.println("ScriptingLauncherHelperFactory - " + data);
    }

    static void getPropertiesFromFile(String fileName, Properties properties) throws IOException {
        URL systemPropFile = Thread.currentThread().getContextClassLoader().getResource(fileName);
        InputStream is = null;
        if (systemPropFile != null) {
            try {
                is = systemPropFile.openStream();
                properties.load(is);
                is.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            String msg = "File not found: " + fileName;
            ScriptingLauncherHelperFactory.trace(msg);
            throw new RuntimeException(msg);
        }
    }

    private static List getProperties(String wasHome, String propertyName, Properties properties) {
        String value;
        String propertyNamePrefix = propertyName + ".";
        ArrayList<String> propertyList = new ArrayList<String>();
        int i = 1;
        while ((value = (String)properties.get(propertyNamePrefix + i)) != null) {
            if (!(value = value.replace('\\', '/')).startsWith("/")) {
                value = "/" + value;
            }
            value = wasHome + value;
            propertyList.add(value.replace('/', File.separatorChar));
            ++i;
        }
        return propertyList;
    }

    private static String getProperty(String wasHome, String propertyName, Properties properties) {
        String value;
        String propertyNamePrefix = propertyName + ".";
        String propPath = null;
        int i = 1;
        while (true) {
            value = (String)properties.get(propertyNamePrefix + i);
            if (!(value = value.replace('\\', '/')).startsWith("/")) {
                value = "/" + value;
            }
            value = wasHome + value;
            boolean pathExist = new File(value = value.replace('/', File.separatorChar)).exists();
            if (pathExist) break;
            ++i;
        }
        propPath = value;
        return propPath;
    }

    public static String doSubstitutions(String wasHome, String value) {
        return ScriptingLauncherHelperFactory.doSubstitutions(wasHome, wasHome, value);
    }

    public static String doSubstitutions(String wasHome, String profileHome, String value) {
        value = value.replaceAll(VARIABLE_WASHOME, wasHome);
        value = value.replaceAll(VARIABLE_USERHOME, profileHome);
        return value;
    }

    private static List getOthersProperties(String wasHome, String profileHome, String propertyName, Properties properties) {
        String value;
        String propertyNamePrefix = propertyName + ".";
        ArrayList<String> propertyList = new ArrayList<String>();
        int i = 1;
        while ((value = (String)properties.get(propertyNamePrefix + i)) != null) {
            value = ScriptingLauncherHelperFactory.doSubstitutions(wasHome, profileHome, value);
            propertyList.add(value);
            ++i;
        }
        return propertyList;
    }

    public static ScriptingLauncherHelper getScriptingLauncherHelper(String wasHome, String profileHome) throws FileNotFoundException, IOException {
        return new ScriptingLauncherHelperImpl(wasHome, profileHome);
    }

    public static class ScriptingLauncherHelperImpl
    implements ScriptingLauncherHelper {
        private String _wasHome;
        private String _profileHome;
        private String _fileName;
        private Properties _properties = new Properties();
        private static final String MAIN_CLASS_NAME = "com.ibm.wsspi.bootstrap.WSPreLauncher";
        private static final String[] PROGRAM_ARGUMENTS = new String[]{"-nosplash", "-application", "com.ibm.ws.bootstrap.WSLauncher", "com.ibm.ws.admin.services.WsAdmin"};
        private static final String DEFAULT_PROPERTIES_FILE_NAME = "com/ibm/websphere/scripting/launcherHelper/ScriptingLauncherHelper.properties";

        ScriptingLauncherHelperImpl(String wasHome, String profileHome) throws FileNotFoundException, IOException {
            this._wasHome = wasHome.replace('\\', '/');
            this._profileHome = profileHome.replace('\\', '/');
            ScriptingLauncherHelperFactory.getPropertiesFromFile(DEFAULT_PROPERTIES_FILE_NAME, this._properties);
        }

        public String[] getWSExtDirs() {
            List result = ScriptingLauncherHelperFactory.getProperties(this._wasHome, ScriptingLauncherHelperFactory.PROPERTY_WS_EXT_DIRS, this._properties);
            return result.toArray(new String[result.size()]);
        }

        public String getJavaLibraryPath() {
            List paths = ScriptingLauncherHelperFactory.getProperties(this._wasHome, ScriptingLauncherHelperFactory.PROPERTY_JAVA_LIBRARY_PATH, this._properties);
            String result = null;
            StringBuffer buf = new StringBuffer();
            if (!paths.isEmpty()) {
                buf.append(paths.get(0));
                for (int i = 1; i < paths.size(); ++i) {
                    String element = (String)paths.get(i);
                    buf.append(File.pathSeparatorChar).append(element);
                }
                if (System.getProperty("java.library.path") != null) {
                    buf.append(File.pathSeparatorChar).append(System.getProperty("java.library.path").replaceAll("\"", ""));
                }
                result = buf.toString();
            }
            return result;
        }

        public String getMainClassName() {
            return MAIN_CLASS_NAME;
        }

        public String[] getProgramArguments() {
            return PROGRAM_ARGUMENTS;
        }

        public String[] getOthers() {
            List properties = ScriptingLauncherHelperFactory.getOthersProperties(this._wasHome, this._profileHome, ScriptingLauncherHelperFactory.PROPERTY_OTHERS, this._properties);
            return properties.toArray(new String[properties.size()]);
        }

        public String getJythonPath() {
            String jythonPath = ScriptingLauncherHelperFactory.getProperty(this._wasHome, ScriptingLauncherHelperFactory.PROPERTY_JYTHON_PATH, this._properties);
            return jythonPath;
        }

        public String[] getClasspath() {
            String jythonPath;
            List result = ScriptingLauncherHelperFactory.getProperties(this._wasHome, ScriptingLauncherHelperFactory.PROPERTY_CLASSPATH, this._properties);
            if (!this._wasHome.equals(this._profileHome)) {
                String profilePropertiesPath = this._profileHome.replace('/', File.separatorChar) + File.separatorChar + "properties";
                result.add(0, profilePropertiesPath);
            }
            if ((jythonPath = this.getJythonPath()) != null) {
                result.add(0, jythonPath);
            }
            return result.toArray(new String[result.size()]);
        }

        public String getWasInstallRoot() {
            return this._wasHome;
        }

        public String getUserInstallRoot() {
            return this._profileHome;
        }

        public String getWasRepositoryRoot() {
            String wasRepRoot = this._profileHome + File.separatorChar + "config";
            return wasRepRoot;
        }

        public String getOSGIInstall() {
            return this._wasHome;
        }

        public String getOSGIConfig() {
            String osgiConfig = this._profileHome + File.separatorChar + "configuration";
            return osgiConfig;
        }

        public String getIbmItpLocation() {
            String itpLoc = this._wasHome + File.separatorChar + "bin";
            return itpLoc;
        }

        public String getClientSOAPPath() {
            String cSOAP = "file:" + this._profileHome + "properties" + File.separatorChar + "soap.client.props";
            return cSOAP;
        }

        public String getClientSASPath() {
            String cSAS = "file:" + this._profileHome + "properties" + File.separatorChar + "sas.client.props";
            return cSAS;
        }

        public String getJythonLibPath() {
            String jythonLib = this._wasHome + File.separatorChar + "optionalLibraries" + File.separatorChar + "jython" + File.separatorChar + "Lib";
            return jythonLib;
        }

        public String getScriptLibraryList() {
            ArrayList<String> scriptLibList = new ArrayList<String>();
            StringBuffer buf = new StringBuffer();
            String libList = null;
            String path = this.getScriptLibraryPath();
            if (path.indexOf(";") > 0) {
                StringTokenizer tok = new StringTokenizer(path, ";");
                while (tok.hasMoreTokens()) {
                    String scriptPath = tok.nextToken();
                    File libDir = new File(scriptPath);
                    File[] files = libDir.listFiles();
                    String dirPath = libDir.getAbsolutePath();
                    for (int i = 0; i < files.length; ++i) {
                        if (!files[i].getName().endsWith(".py")) continue;
                        String file = dirPath + File.separator + files[i].getName();
                        char sep = File.separatorChar;
                        if (scriptLibList.contains(file = file.substring(file.lastIndexOf(sep) + 1, file.length() - 3))) continue;
                        scriptLibList.add(file);
                        buf.append(file);
                        buf.append(";");
                    }
                }
            }
            libList = buf.toString().substring(0, buf.toString().length() - 1);
            return libList;
        }

        public String getScriptLibraryPath() {
            String path = "";
            Vector pathV = new Vector();
            Vector scriptLibPaths = new Vector();
            String scriptLibPath = System.getProperty("wsadmin.script.libraries");
            if (scriptLibPath != null) {
                File libDir = null;
                if (scriptLibPath.indexOf(";") > 0) {
                    StringTokenizer tok = new StringTokenizer(scriptLibPath, ";");
                    while (tok.hasMoreTokens()) {
                        String scriptPath = tok.nextToken();
                        libDir = new File(scriptPath);
                        scriptLibPaths = this.fileSearch(libDir, pathV);
                    }
                } else {
                    libDir = new File(scriptLibPath);
                    scriptLibPaths = this.fileSearch(libDir, pathV);
                }
            }
            this._wasHome = System.getProperty("was.install.root");
            if (this._wasHome != null) {
                File scriptLibDir = new File(this._wasHome + File.separator + "scriptLibraries");
                if (scriptLibDir == null || !scriptLibDir.exists() || !scriptLibDir.isDirectory()) {
                    return path;
                }
                scriptLibPaths = this.fileSearch(scriptLibDir, pathV);
                for (int i = 0; i < scriptLibPaths.size(); ++i) {
                    String libPath = scriptLibPaths.get(i).toString();
                    path = !path.equals("") ? path + File.pathSeparator + libPath : libPath;
                }
            } else {
                System.out.println("WARNING: system property was.install.root is not set.  Websphere classes may not be found.");
            }
            return path;
        }

        private Vector fileSearch(File directory, Vector pathV) {
            Vector libPaths = new Vector();
            File[] files = directory.listFiles();
            String dirPath = directory.getAbsolutePath();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.fileSearch(files[i], pathV);
                    continue;
                }
                if (!files[i].getName().endsWith(".py")) continue;
                String path = dirPath;
                pathV.add(path);
            }
            for (int j = 0; j < pathV.size(); ++j) {
                if (libPaths.contains(pathV.get(j))) continue;
                libPaths.add(pathV.get(j));
            }
            return libPaths;
        }
    }
}

