/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.utils;

import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.utils.HistoryInfoEntityResolver;
import com.ibm.websphere.product.utils.SimpleXMLParser;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class EventHistoryInfo {
    private Document m_documentEventHistory = null;
    private SimpleXMLParser m_sxpEventHistory = null;
    private HashSet m_hashsetInstalledMaintenanceId = new HashSet();
    private static String S_NODE_PATH_UPDATE_EVENT_PTF = "event-history/update-event";
    private static String S_UPDATE_EVENT_PTF_ID = "id";
    private static String S_UPDATE_EVENT_PTF_UPDATE_ACTION = "update-action";
    private static String S_UPDATE_EVENT_PTF_RESULT = "result";
    private static String S_UPDATE_ACTION_INSTALL = "install";
    private static String S_UPDATE_ACTION_UNINSTALL = "uninstall";
    private static String S_RESULT_FAILURE = "failure";

    public EventHistoryInfo(File fileEventHistory, String sVersionDirPath) {
        if (fileEventHistory != null && fileEventHistory.exists() && sVersionDirPath != null) {
            try {
                String sDTDDirPath = WASProduct.getDTDDirName(sVersionDirPath);
                HistoryInfoEntityResolver hierThis = new HistoryInfoEntityResolver(sDTDDirPath);
                this.m_sxpEventHistory = new SimpleXMLParser(fileEventHistory, true, (EntityResolver)hierThis);
                this.m_documentEventHistory = this.m_sxpEventHistory.getDocument();
                if (this.m_documentEventHistory.getDocumentElement().hasChildNodes()) {
                    this.parseEventHistoryFromDocument();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public HashSet getInstalledMaintenanceSet() {
        return this.m_hashsetInstalledMaintenanceId;
    }

    private void parseEventHistoryFromDocument() {
        Vector vUpdateEventPTF = this.m_sxpEventHistory.getNodes(S_NODE_PATH_UPDATE_EVENT_PTF);
        for (Node nodeThis : vUpdateEventPTF) {
            String sId = SimpleXMLParser.getNodeAttributeValue(nodeThis, S_UPDATE_EVENT_PTF_ID);
            if (sId == null) continue;
            String sUpdateAction = SimpleXMLParser.getNodeAttributeValue(nodeThis, S_UPDATE_EVENT_PTF_UPDATE_ACTION);
            String sResult = SimpleXMLParser.getNodeAttributeValue(nodeThis, S_UPDATE_EVENT_PTF_RESULT);
            if (sUpdateAction.equals(S_UPDATE_ACTION_INSTALL) && !sResult.equals(S_RESULT_FAILURE)) {
                this.m_hashsetInstalledMaintenanceId.add(sId);
                continue;
            }
            if (!sUpdateAction.equals(S_UPDATE_ACTION_UNINSTALL) || sResult.equals(S_RESULT_FAILURE)) continue;
            this.m_hashsetInstalledMaintenanceId.remove(sId);
        }
    }
}

