/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.metadata;

import com.ibm.websphere.product.history.xml.enumEventType;
import com.ibm.websphere.product.history.xml.includedEFix;
import com.ibm.websphere.product.history.xml.ptfApplied;
import com.ibm.websphere.product.history.xml.ptfDriver;
import com.ibm.websphere.product.history.xml.updateEvent;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponentUpdate;
import com.ibm.websphere.product.metadata.WASMetadataNameValuePair;
import com.ibm.websphere.product.utils.SimpleXMLParser;
import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.xml.efix.ptf;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class WASMaintenancePackage {
    private WASDirectoryLogger logger;
    private String maintenancePackageID = null;
    private String description = null;
    private String packageFileName = null;
    private String buildDate = null;
    private String action = null;
    private String result = null;
    private String timestamp = null;
    private String logFileName = null;
    private String backupFileName = null;
    private boolean isInstalledAsMaintenance = false;
    private Vector componentUpdateListThisMaintenance = new Vector();
    private String[] aparList = null;
    private Vector nameValuePairParams = new Vector();
    private String packageType = null;
    private int order = 0;
    private String installRoot = null;
    private ptf ptfThis = new ptf();
    private ptfApplied ptfAppliedThis = new ptfApplied();
    private ptfDriver ptfDriverThis = new ptfDriver();
    private includedEFix[] includedEFixList = null;
    private updateEvent updateEventThis = new updateEvent();

    public WASMaintenancePackage(String installRoot, Node nodeNIFPackageEntry) {
        this.logger = WASDirectoryLogger.getWASDirectoryLogger(installRoot);
        this.logger.entering(this.getClass().getName(), "WASMaintenancePackage");
        this.setInstallRoot(WASDirectoryHelper.normalizeLocationAccordingToPlatform(installRoot, false));
        this.setMaintenancePackageID(SimpleXMLParser.getNodeAttributeValue(nodeNIFPackageEntry, "name"));
        String sOrder = SimpleXMLParser.getNodeAttributeValue(nodeNIFPackageEntry, "order");
        this.setOrder(Integer.parseInt(sOrder));
        this.setDefinedParamsForThisNode(nodeNIFPackageEntry);
        this.setAttributeValuesForThisMaintenancePackage();
        this.setIncludedEFixListFromAPARList();
        this.setPTFForThisMaintenancePackage();
        this.setPTFAppliedForThisMaintenancePackage();
        this.setPTFDriverForThisMaintenancePackage();
        this.logger.exiting(this.getClass().getName(), "WASMaintenancePackage");
    }

    public String getParamValue(String paramName) {
        for (int i = 0; i < this.nameValuePairParams.size(); ++i) {
            WASMetadataNameValuePair pairThis = (WASMetadataNameValuePair)this.nameValuePairParams.elementAt(i);
            if (!pairThis.getName().equals(paramName)) continue;
            return pairThis.getValue();
        }
        return null;
    }

    public Vector getParamValues(String paramName) {
        Vector<String> returnValues = new Vector<String>();
        for (int i = 0; i < this.nameValuePairParams.size(); ++i) {
            WASMetadataNameValuePair pairThis = (WASMetadataNameValuePair)this.nameValuePairParams.elementAt(i);
            if (!pairThis.getName().equals(paramName)) continue;
            returnValues.add(pairThis.getValue());
        }
        returnValues.trimToSize();
        return returnValues;
    }

    private void setDefinedParamsForThisNode(Node nodeThis) {
        this.logger.entering(this.getClass().getName(), "setDefinedParamsForThisNode");
        Vector vnodesParams = SimpleXMLParser.getAllNamedChildNodes(nodeThis, "param");
        if (vnodesParams.size() == 0) {
            this.logger.logThisMessage(Level.FINER, this.getClass().getName(), "setDefinedParamsForThisNode", "There is no parameter nodes in this maintenance package.");
        }
        for (int i = 0; i < vnodesParams.size(); ++i) {
            Node nodeParamThis = (Node)vnodesParams.elementAt(i);
            String sParamName = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "name");
            String sParamValue = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "value");
            this.nameValuePairParams.add(new WASMetadataNameValuePair(sParamName, sParamValue));
        }
        this.logger.exiting(this.getClass().getName(), "setDefinedParamsForThisNode");
    }

    protected void setAttributeValuesForThisMaintenancePackage() {
        this.logger.entering(this.getClass().getName(), "setAttributeValuesForThisMaintenancePackage");
        this.setDescription(this.getParamValue("info"));
        this.setBuildDate(this.getParamValue("builddate"));
        this.setPackageFileName(this.getParamValue("filename"));
        this.setAction(this.getParamValue("action"));
        this.setResult(this.getParamValue("status"));
        this.setTimestamp(this.getParamValue("timestamp"));
        this.setPackageType(this.getParamValue("packagetype"));
        this.setLogFileName(WASDirectoryHelper.getLogDirPath(this.getInstallRoot()), this.getMaintenancePackageID(), this.getAction());
        this.setBackupFileName(WASDirectoryHelper.getBackupDirPath(this.getInstallRoot()), this.getPackageFileName());
        this.setInstallAsMaintenance(Boolean.valueOf(this.getParamValue("wasinstalledasmaintenance")));
        Vector aparVector = this.getParamValues("apar");
        this.setAparList(aparVector.toArray(new String[aparVector.size()]));
        Vector componentVector = this.getParamValues("component");
        for (int i = 0; i < componentVector.size(); ++i) {
            String componentName = (String)componentVector.get(i);
            WASComponentUpdate wasComponentUpdate = new WASComponentUpdate(this.getMaintenancePackageID(), componentName, this.getAction(), "maintenance package", "replace", this.getTimestamp(), this.getResult(), this.getBackupFileName(), this.getLogFileName(), this.getPackageFileName(), this.getInstallRoot());
            this.addComponentUpdateToList(wasComponentUpdate);
        }
        this.logger.exiting(this.getClass().getName(), "setAttributeValuesForThisMaintenancePackage");
    }

    public String[] getAparList() {
        return this.aparList;
    }

    protected void setAparList(String[] aparList) {
        for (int i = 0; i < aparList.length; ++i) {
            this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setAparList", "apar number: " + aparList[i]);
        }
        this.aparList = aparList;
    }

    public String getAction() {
        return this.action;
    }

    protected void setAction(String action) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setAction", "action is: " + action);
        this.action = action;
    }

    public String getBackupFileName() {
        return this.backupFileName;
    }

    protected void setBackupFileName(String backupDirPath, String packageFileName) {
        String backupFileName = backupDirPath + File.separator + packageFileName;
        File fileBackupFile = new File(backupFileName);
        this.backupFileName = this.getAction().equals("install") && !this.getResult().equals("failure") && fileBackupFile.exists() ? backupFileName : "";
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setBackupFileName", "backup file name is: " + this.backupFileName);
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    protected void setBuildDate(String buildDate) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setBuildDate", "build date is: " + buildDate);
        this.buildDate = buildDate;
    }

    public WASComponentUpdate[] getComponentUpdateList() {
        return this.componentUpdateListThisMaintenance.toArray(new WASComponentUpdate[this.componentUpdateListThisMaintenance.size()]);
    }

    public void addComponentUpdateToList(WASComponentUpdate thisComponentUpdate) {
        if (thisComponentUpdate != null) {
            this.componentUpdateListThisMaintenance.add(thisComponentUpdate);
            this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "addComponentUpdateToList", "Added componentUpdate for component: " + thisComponentUpdate.getComponentName());
        }
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setDescription", "description is: " + description);
        this.description = description;
    }

    protected void setInstallAsMaintenance(boolean isInstalledAsMaintenance) {
        this.isInstalledAsMaintenance = isInstalledAsMaintenance;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setInstallAsMaintenance", "isInstallAsMaintenance flag is: " + isInstalledAsMaintenance);
    }

    public boolean isInstallAsMaintenance() {
        return this.isInstalledAsMaintenance;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    protected void setInstallRoot(String installRoot) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setInstallRoot", "installRoot is: " + installRoot);
        this.installRoot = installRoot;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    protected void setLogFileName(String logDirPath, String maintenancePackageID, String action) {
        String logFileName = logDirPath + File.separator + maintenancePackageID + "." + action + File.separator + "updatelog" + ".txt";
        File fileLogFile = new File(logFileName);
        this.logFileName = fileLogFile.exists() ? logFileName : "";
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setLogFileName", "log file name is: " + this.logFileName);
    }

    public String getMaintenancePackageID() {
        return this.maintenancePackageID;
    }

    protected void setMaintenancePackageID(String maintenancePackageID) {
        this.maintenancePackageID = maintenancePackageID;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setMaintenancePackageID", "maintenancePackageID is: " + maintenancePackageID);
    }

    public int getOrder() {
        return this.order;
    }

    protected void setOrder(int order) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setOrder", "order is: " + order);
        this.order = order;
    }

    public String getPackageFileName() {
        return this.packageFileName;
    }

    protected void setPackageFileName(String packageFileName) {
        this.packageFileName = packageFileName;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPAckageFileName", "Package file name is: " + packageFileName);
    }

    public String getPackageType() {
        return this.packageType;
    }

    protected void setPackageType(String packageType) {
        this.packageType = packageType;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPackageType", "Package type is: " + packageType);
    }

    public String getResult() {
        return this.result;
    }

    protected void setResult(String result) {
        this.result = result;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setResult", "Result status is: " + result);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    protected void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setTimestamp", "Timestamp is: " + timestamp);
    }

    public includedEFix[] getIncludedEFixListForThisMaintenancePackage() {
        return this.includedEFixList;
    }

    private void setIncludedEFixListFromAPARList() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setIncludedEFixListFromAPARList", "Set included efix list with size of apar list: " + this.aparList.length);
        Vector<includedEFix> vIncludedEFix = new Vector<includedEFix>();
        for (int i = 0; i < this.aparList.length; ++i) {
            includedEFix includedEFixThis = new includedEFix();
            includedEFixThis.setEFixId(this.aparList[i]);
            vIncludedEFix.add(includedEFixThis);
        }
        this.includedEFixList = vIncludedEFix.toArray(new includedEFix[vIncludedEFix.size()]);
    }

    public ptf getPTFForThisMaintenancePackage() {
        return this.ptfThis;
    }

    private void setPTFForThisMaintenancePackage() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPTFForThisMaintenancePackage", "Set ptf with ptfID: " + this.maintenancePackageID);
        this.ptfThis.setId(this.maintenancePackageID);
        this.ptfThis.setBuildDate(this.buildDate);
        this.ptfThis.setBuildVersion(this.buildDate);
        this.ptfThis.setShortDescription(this.description);
        for (int i = 0; i < this.componentUpdateListThisMaintenance.size(); ++i) {
            this.ptfThis.addComponentName(((WASComponentUpdate)this.componentUpdateListThisMaintenance.elementAt(i)).getComponentName());
        }
    }

    public ptfApplied getPTFAppliedForThisMaintenancePackage() {
        return this.ptfAppliedThis;
    }

    private void setPTFAppliedForThisMaintenancePackage() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPTFAppliedForThisMaintenancePackage", "Set ptfApplied with ptfID: " + this.maintenancePackageID);
        this.ptfAppliedThis.setPTFId(this.maintenancePackageID);
        for (int i = 0; i < this.componentUpdateListThisMaintenance.size(); ++i) {
            this.ptfAppliedThis.addComponentApplied(((WASComponentUpdate)this.componentUpdateListThisMaintenance.elementAt(i)).getComponentApplied());
        }
    }

    public ptfDriver getPTFDriverForThisMaintenancePackage() {
        return this.ptfDriverThis;
    }

    private void setPTFDriverForThisMaintenancePackage() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setPTFDriverForThisMaintenancePackage", "Set ptfDriver with ptfID: " + this.maintenancePackageID);
        this.ptfDriverThis.setId(this.maintenancePackageID);
        this.ptfDriverThis.setBuildDate(this.buildDate);
        this.ptfDriverThis.setShortDescription(this.description);
        for (int i = 0; i < this.componentUpdateListThisMaintenance.size(); ++i) {
            this.ptfDriverThis.addComponentUpdate(((WASComponentUpdate)this.componentUpdateListThisMaintenance.elementAt(i)).getComponentUpdate());
        }
        for (int j = 0; j < this.includedEFixList.length; ++j) {
            this.ptfDriverThis.addIncludedEFix(this.includedEFixList[j]);
        }
    }

    public updateEvent getUpdateEventForThisMaintenancePackage() {
        return this.updateEventThis;
    }

    private void setUpdateEventForThisMaintenancePackage() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setUpdateEventForThisMaintenancePackage", "Set updateEvent with maintenance package ID: " + this.maintenancePackageID);
        this.updateEventThis.setBackupName(this.backupFileName);
        this.updateEventThis.setEventType("ptf");
        this.updateEventThis.setId(this.maintenancePackageID);
        this.updateEventThis.setLogName(this.logFileName);
        this.updateEventThis.setPrimaryContent(this.packageFileName);
        this.updateEventThis.setResult(this.result);
        this.updateEventThis.setStartTimeStamp(this.timestamp);
        this.updateEventThis.setUpdateAction(this.action);
        this.updateEventThis.setUpdateType("replace");
        for (int i = 0; i < this.componentUpdateListThisMaintenance.size(); ++i) {
            updateEvent componentUpdateEvent = new updateEvent();
            componentUpdateEvent.setEventType(enumEventType.COMPONENT_EVENT_TYPE);
            componentUpdateEvent.setParentId(this.maintenancePackageID);
            componentUpdateEvent.setId(((WASComponentUpdate)this.componentUpdateListThisMaintenance.elementAt(i)).getComponentName());
            componentUpdateEvent.setUpdateAction(this.action);
            componentUpdateEvent.setUpdateType("replace");
            componentUpdateEvent.setStartTimeStamp(this.timestamp);
            componentUpdateEvent.setResult(this.result);
            this.updateEventThis.addUpdateEvent(componentUpdateEvent);
        }
    }
}

