/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.WASProductInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WASProductFile {
    private String m_sDtdDir = null;
    private String m_sVersionDir = null;
    private String m_sFileName = null;
    private Vector m_vWASProductInfoVec = new Vector(1);
    private static Hashtable container = new Hashtable();
    private static final String PATTERN_PRODUCT_NODE = "<product\\s*(.*?)\\s*</product>";
    private static final String PATTERN_NAME = "name=\"(.*?)\"";
    private static final String PATTERN_ID = "<id>\\s*(.*?)\\s*</id>";
    private static final String PATTERN_VERSION = "<version>\\s*(.*?)\\s*</version>";
    private static final String PATTERN_DATE = "date=\"(.*?)\"";
    private static final String PATTERN_LEVEL = "level=\"(.*?)\"";

    public static void main(String[] args) {
        if (args.length < 1) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String wasHome = args[i];
            String dtdDir = wasHome + File.separator + "properties/version/dtd";
            String versionDir = wasHome + File.separator + "properties/version";
            String fileName = "BASE.product";
            WASProductFile obj = WASProductFile.getWASProductFileInstance(dtdDir, versionDir, fileName);
        }
    }

    public static WASProductFile getWASProductFileInstance(String dtdDir, String versionDir, String fileName) {
        if (dtdDir == null || versionDir == null || fileName == null) {
            return null;
        }
        File dtdDirFile = new File(dtdDir);
        if (dtdDirFile == null || !dtdDirFile.exists() || !dtdDirFile.isDirectory()) {
            return null;
        }
        File versionDirFile = new File(versionDir);
        if (versionDirFile == null || !versionDirFile.exists() || !versionDirFile.isDirectory()) {
            return null;
        }
        File productFile = new File(versionDirFile.getAbsolutePath() + File.separator + fileName);
        if (productFile == null || !productFile.exists() || productFile.isDirectory()) {
            return null;
        }
        String productFilePath = productFile.getAbsolutePath();
        WASProductFile obj = (WASProductFile)container.get(productFilePath);
        if (obj == null) {
            obj = new WASProductFile(dtdDir, versionDir, fileName);
            container.put(productFilePath, obj);
        }
        return obj;
    }

    public void setDtdDir(String dtdDir) {
        this.m_sDtdDir = dtdDir;
    }

    public String getDtdDir() {
        return this.m_sDtdDir;
    }

    public void setVersionDir(String versionDir) {
        this.m_sVersionDir = versionDir;
    }

    public String getVersionDir() {
        return this.m_sVersionDir;
    }

    public void setFileName(String fileName) {
        this.m_sFileName = fileName;
    }

    public String getFileName() {
        return this.m_sFileName;
    }

    public WASProductInfo[] getWASProductInfoArray() {
        WASProductInfo[] arr = new WASProductInfo[this.m_vWASProductInfoVec.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (WASProductInfo)this.m_vWASProductInfoVec.elementAt(i);
        }
        return arr;
    }

    public static boolean refreshCache() {
        if (container != null) {
            container.clear();
            return true;
        }
        return false;
    }

    private void parse() {
        String fileContent = this.readFile(this.m_sVersionDir + this.m_sFileName);
        if (fileContent == null) {
            return;
        }
        Pattern productPattern = Pattern.compile(PATTERN_PRODUCT_NODE, 32);
        Matcher productMatcher = productPattern.matcher(fileContent);
        while (productMatcher.find()) {
            String productString = productMatcher.group();
            this.parseProductString(productString);
        }
    }

    private void parseProductString(String productString) {
        String name = "";
        String id = "";
        String version = "";
        String date = "";
        String level = "";
        Pattern pattern = Pattern.compile(PATTERN_NAME, 32);
        Matcher matcher = pattern.matcher(productString);
        if (matcher.find()) {
            String nameString = matcher.group();
            name = nameString.substring(nameString.indexOf(34) + 1, nameString.lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_ID, 32)).matcher(productString)).find()) {
            String idString = matcher.group();
            id = idString.substring(idString.indexOf("<id>") + 4, idString.indexOf("</id>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_VERSION, 32)).matcher(productString)).find()) {
            String versionString = matcher.group();
            version = versionString.substring(versionString.indexOf("<version>") + 9, versionString.indexOf("</version>"));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_DATE, 32)).matcher(productString)).find()) {
            String dateString = matcher.group();
            date = dateString.substring(dateString.indexOf(34) + 1, dateString.lastIndexOf(34));
        }
        if ((matcher = (pattern = Pattern.compile(PATTERN_LEVEL, 32)).matcher(productString)).find()) {
            String levelString = matcher.group();
            level = levelString.substring(levelString.indexOf(34) + 1, levelString.lastIndexOf(34));
        }
        WASProductInfo info = new WASProductInfo(name, id, version, date, level);
        this.m_vWASProductInfoVec.addElement(info);
    }

    private String readFile(String filePath) {
        String fileContents = null;
        try {
            FileInputStream inputStream = new FileInputStream(filePath);
            byte[] abTotal = new byte[inputStream.available()];
            inputStream.read(abTotal);
            fileContents = new String(abTotal, "UTF-8");
            inputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileContents;
    }

    private WASProductFile(String dtdDir, String versionDir, String fileName) {
        if (versionDir != null && !versionDir.endsWith(File.separator)) {
            versionDir = versionDir + File.separator;
        }
        if (dtdDir != null && !dtdDir.endsWith(File.separator)) {
            dtdDir = dtdDir + File.separator;
        }
        this.m_sDtdDir = dtdDir;
        this.m_sVersionDir = versionDir;
        this.m_sFileName = fileName;
        this.parse();
    }

    private WASProductFile() {
    }
}

