/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.WASProductException;
import com.ibm.websphere.product.filters.ComponentFilenameFilter;
import com.ibm.websphere.product.filters.EFixFilenameFilter;
import com.ibm.websphere.product.filters.ExtensionFilenameFilter;
import com.ibm.websphere.product.filters.PTFFilenameFilter;
import com.ibm.websphere.product.filters.ProductFilenameFilter;
import com.ibm.websphere.product.filters.RegistrarFilenameFilter;
import com.ibm.websphere.product.history.WASHistory;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponent;
import com.ibm.websphere.product.metadata.WASMaintenancePackage;
import com.ibm.websphere.product.metadata.WASMetadata;
import com.ibm.websphere.product.metadata.WASMetadataHelper;
import com.ibm.websphere.product.utils.HistoryInfoGenerator;
import com.ibm.websphere.product.xml.BaseFactory;
import com.ibm.websphere.product.xml.BaseHandler;
import com.ibm.websphere.product.xml.BaseHandlerException;
import com.ibm.websphere.product.xml.component.ComponentHandler;
import com.ibm.websphere.product.xml.component.component;
import com.ibm.websphere.product.xml.efix.EFixHandler;
import com.ibm.websphere.product.xml.efix.efix;
import com.ibm.websphere.product.xml.efix.ptf;
import com.ibm.websphere.product.xml.extension.ExtensionHandler;
import com.ibm.websphere.product.xml.extension.extension;
import com.ibm.websphere.product.xml.product.ProductHandler;
import com.ibm.websphere.product.xml.product.ProductWriter;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.websphere.product.xml.registrar.RegistrarHandler;
import com.ibm.websphere.product.xml.registrar.registrar;
import com.ibm.websphere.product.xml.websphere.WebSphereHandler;
import com.ibm.websphere.product.xml.websphere.websphere;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import org.xml.sax.SAXParseException;

public class WASProduct {
    public static final String pgmVersion = "1.61";
    public static final String pgmUpdate = "8/8/08";
    public static final String PRODUCTID_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String PRODUCTID_EXPRESS = "EXPRESS";
    public static final String PRODUCTID_BASE = "BASE";
    public static final String PRODUCTID_ND = "ND";
    public static final String PRODUCTID_XD = "XD";
    public static final String PRODUCTID_WXD = "WXD";
    public static final String PRODUCTID_PME = "PME";
    public static final String PRODUCTID_CLIENT = "CLIENT";
    public static final String PRODUCTID_JDK = "JDK";
    static final String PRODUCTID_EXPRESS_TRIAL = "EXPRESSTRIAL";
    static final String PRODUCTID_BASE_TRIAL = "BASETRIAL";
    public static final String[] PRODUCT_IDS = new String[]{"embeddedEXPRESS", "EXPRESS", "BASE", "ND", "XD", "WXD", "PME", "CLIENT", "JDK"};
    public static final String REGISTRARID_BASE = "BASE";
    public static final String REGISTRARID_ADD = "ADD";
    public static final String bundleIdMsg = "com.ibm.websphere.product.WASProductNLS";
    public static final String bundleIdText = "com.ibm.websphere.product.WASProductNLSText";
    public static ResourceBundle msgs = null;
    public static ResourceBundle texts = null;
    private WASMetadata metadataInstance = null;
    private WASDirectoryLogger logger = null;
    protected ArrayList boundExceptions;
    protected ArrayList recoverableErrors;
    protected ArrayList warnings;
    public static final String INSTALL_ROOT_PROPERTY_NAME = "was.install.root";
    public static final String VERSION_DIR_PROPERTY_NAME = "was.version.dir";
    public static final String DTD_DIR_PROPERTY_NAME = "was.version.dtd.dir";
    public static final String LOG_DIR_PROPERTY_NAME = "was.version.log.dir";
    public static final String BACKUP_DIR_PROPERTY_NAME = "was.version.backup.dir";
    public static final String TMP_DIR_PROPERTY_NAME = "was.version.tmp.dir";
    public static final String JAVA_TMP_DIR_PROPERTY_NAME = "java.io.tmpdir";
    public static final String PROPERTIES_DIR_NAME = "properties";
    public static final String VERSION_DIR_NAME = "version";
    public static final String DTD_DIR_NAME = "dtd";
    public static final String LOG_DIR_NAME = "logs";
    public static final String UPDATE_DIR_NAME = "update";
    public static final String BACKUP_DIR_NAME = "backup";
    public static final String DEFAULT_TMP_DIR_NAME = "tmp";
    public static final String FULL_INSTALL_DIR_NAME = "install";
    public static final String CURRENT_VERSION_DIR_NAME = "6.1.0.0";
    public static final String NIF_DIR_NAME = "nif";
    protected ArrayList products = null;
    protected ArrayList productNames = null;
    protected ArrayList components = null;
    protected ArrayList componentNames = null;
    protected ArrayList efixes = null;
    protected ArrayList efixNames = null;
    protected ArrayList ptfs = null;
    protected ArrayList ptfNames = null;
    protected ArrayList extensions = null;
    protected ArrayList extensionNames = null;
    protected ArrayList registrars = null;
    protected ArrayList registrarNames = null;
    protected HashMap versionInfo;
    public static final String PRODUCT_TYPE = "product";
    public static final String COMPONENT_TYPE = "component";
    public static final String EFIX_TYPE = "efix";
    public static final String PTF_TYPE = "ptf";
    public static final String EXTENSION_TYPE = "extension";
    protected File productDir;
    protected String productDirName;
    protected File versionDir;
    protected String versionDirName;
    protected File dtdDir;
    protected String dtdDirName;
    protected File logDir;
    protected String logDirName;
    protected File backupDir;
    protected String backupDirName;
    private long lastModifyHistoryFile = 0L;

    public static void InitResourceBundle() {
        ResourceBundle retrievedBundleMsg = null;
        ResourceBundle retrievedBundleText = null;
        try {
            retrievedBundleMsg = ResourceBundle.getBundle(bundleIdMsg);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            retrievedBundleText = ResourceBundle.getBundle(bundleIdText);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        msgs = retrievedBundleMsg;
        texts = retrievedBundleText;
    }

    protected static String getString(String msgCode) {
        if (msgs == null || texts == null) {
            WASProduct.InitResourceBundle();
        }
        String sReturn = "com.ibm.websphere.product.WASProductNLS:" + msgCode;
        if (msgs != null) {
            try {
                return msgs.getString(msgCode);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        if (texts != null) {
            try {
                return texts.getString(msgCode);
            }
            catch (MissingResourceException ex) {
                sReturn = "com.ibm.websphere.product.WASProductNLSText:" + msgCode;
            }
        }
        return sReturn;
    }

    protected static String getString(String msgCode, Object arg) {
        String rawMessage = WASProduct.getString(msgCode);
        Object[] msgArgs = new Object[]{arg};
        return MessageFormat.format(rawMessage, msgArgs);
    }

    protected static String getString(String msgCode, Object arg1, Object arg2) {
        String rawMessage = WASProduct.getString(msgCode);
        Object[] msgArgs = new Object[]{arg1, arg2};
        return MessageFormat.format(rawMessage, msgArgs);
    }

    protected static String getString(String msgCode, Object[] msgArgs) {
        String rawMessage = WASProduct.getString(msgCode);
        return MessageFormat.format(rawMessage, msgArgs);
    }

    protected void addException(WASProductException e) {
        this.boundExceptions.add(e);
    }

    public int numExceptions() {
        return this.boundExceptions.size();
    }

    public Iterator getExceptions() {
        return this.boundExceptions.iterator();
    }

    protected void addRecoverableError(SAXParseException e) {
        this.recoverableErrors.add(e);
    }

    public int numRecoverableErrors() {
        return this.recoverableErrors.size();
    }

    public Iterator getRecoverableErrors() {
        return this.recoverableErrors.iterator();
    }

    protected void addWarning(SAXParseException e) {
        this.warnings.add(e);
    }

    public int numWarnings() {
        return this.warnings.size();
    }

    public Iterator getWarnings() {
        return this.warnings.iterator();
    }

    protected void transferErrors(BaseFactory factory) {
        Iterator errors = factory.getRecoverableErrors();
        while (errors.hasNext()) {
            SAXParseException nextError = (SAXParseException)errors.next();
            this.addRecoverableError(nextError);
        }
        Iterator warnings = factory.getWarnings();
        while (warnings.hasNext()) {
            SAXParseException nextWarning = (SAXParseException)warnings.next();
            this.addWarning(nextWarning);
        }
    }

    protected void clearExceptions() {
        this.boundExceptions = new ArrayList();
        this.recoverableErrors = new ArrayList();
        this.warnings = new ArrayList();
    }

    protected void addException(String msgKey) {
        this.addException(WASProduct.createException(msgKey, null, null));
    }

    protected void addException(String msgKey, Exception e) {
        this.addException(WASProduct.createException(msgKey, null, e));
    }

    protected void addException(String msgKey, Object[] msgArgs, Exception e) {
        this.addException(WASProduct.createException(msgKey, msgArgs, e));
    }

    protected static WASProductException createException(String msgKey, Object[] msgArgs, Exception e) {
        return new WASProductException(msgKey, msgArgs, e);
    }

    public static String computeProductDirName() throws WASProductException {
        String productDirName = System.getProperty(INSTALL_ROOT_PROPERTY_NAME);
        if (productDirName == null) {
            throw WASProduct.createException("WVER0001E", null, null);
        }
        productDirName = WASProduct.preparePath(productDirName, false);
        return productDirName;
    }

    public static String computeVersionDirName(String productDirName) {
        String versionDirName = System.getProperty(VERSION_DIR_PROPERTY_NAME);
        versionDirName = versionDirName == null ? WASProduct.getVersionDirName(productDirName) : WASProduct.preparePath(versionDirName, false);
        return versionDirName;
    }

    public static String getVersionDirName(String productDirName) {
        productDirName = WASProduct.preparePath(productDirName, false);
        return productDirName + File.separator + PROPERTIES_DIR_NAME + File.separator + VERSION_DIR_NAME;
    }

    public static String computeDTDDirName(String versionDirName) throws WASProductException {
        String dtdDirName = System.getProperty(DTD_DIR_PROPERTY_NAME);
        if (dtdDirName == null) {
            if (versionDirName == null) {
                throw WASProduct.createException("WVER0019", null, null);
            }
            dtdDirName = WASProduct.getDTDDirName(versionDirName);
        } else {
            dtdDirName = WASProduct.preparePath(dtdDirName, false);
        }
        return dtdDirName;
    }

    public static String getDTDDirName(String versionDirName) {
        versionDirName = WASProduct.preparePath(versionDirName, false);
        return versionDirName + File.separator + DTD_DIR_NAME;
    }

    public static String computeLogDirName(String productDirName) throws WASProductException {
        String logDirName = System.getProperty(LOG_DIR_PROPERTY_NAME);
        if (logDirName == null) {
            if (productDirName == null) {
                throw WASProduct.createException("WVER0017", null, null);
            }
            logDirName = WASProduct.getLogDirName(productDirName);
        } else {
            logDirName = WASProduct.preparePath(logDirName, false);
        }
        return logDirName;
    }

    public static String getLogDirName(String productDirName) {
        productDirName = WASProduct.preparePath(productDirName, false);
        return productDirName + File.separator + LOG_DIR_NAME;
    }

    public static String computeBackupDirName(String versionDirName) throws WASProductException {
        String backupDirName = System.getProperty(BACKUP_DIR_PROPERTY_NAME);
        if (backupDirName == null) {
            if (versionDirName == null) {
                throw WASProduct.createException("WVER0018", null, null);
            }
            backupDirName = WASProduct.getBackupDirName(versionDirName);
        } else {
            backupDirName = WASProduct.preparePath(backupDirName, false);
        }
        return backupDirName;
    }

    public static String getBackupDirName(String versionDirName) {
        String sBackupDirName = (versionDirName = WASProduct.preparePath(versionDirName, false)) + File.separator + UPDATE_DIR_NAME + File.separator + BACKUP_DIR_NAME;
        if (new File(sBackupDirName).exists()) {
            return sBackupDirName;
        }
        return versionDirName + File.separator + NIF_DIR_NAME + File.separator + BACKUP_DIR_NAME;
    }

    public static String getTmpDirName() {
        String tmpDirName = System.getProperty(TMP_DIR_PROPERTY_NAME);
        if (tmpDirName == null && (tmpDirName = System.getProperty(JAVA_TMP_DIR_PROPERTY_NAME)) == null) {
            tmpDirName = DEFAULT_TMP_DIR_NAME;
        }
        tmpDirName = WASProduct.preparePath(tmpDirName, false);
        return tmpDirName;
    }

    public static String preparePath(String path, boolean trailSeparator) {
        path = path.replace('/', File.separatorChar);
        if ((path = path.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            if (!trailSeparator) {
                path = path.substring(0, path.length() - File.separator.length());
            }
        } else if (trailSeparator) {
            path = path + File.separator;
        }
        return path;
    }

    public WASProduct() {
        this.clearExceptions();
        try {
            String productDirName = WASProduct.computeProductDirName();
            String versionDirName = WASProduct.computeVersionDirName(productDirName);
            String dtdDirName = WASProduct.computeDTDDirName(versionDirName);
            String logDirName = WASProduct.computeLogDirName(productDirName);
            String backupDirName = WASProduct.computeBackupDirName(versionDirName);
            this.initialize(productDirName, versionDirName, dtdDirName, logDirName, backupDirName);
        }
        catch (WASProductException e) {
            this.addException(e);
        }
    }

    public WASProduct(String productDirName) {
        this.clearExceptions();
        try {
            String versionDirName = WASProduct.computeVersionDirName(productDirName);
            String dtdDirName = WASProduct.computeDTDDirName(versionDirName);
            String logDirName = WASProduct.computeLogDirName(productDirName);
            String backupDirName = WASProduct.computeBackupDirName(versionDirName);
            this.initialize(productDirName, versionDirName, dtdDirName, logDirName, backupDirName);
        }
        catch (WASProductException e) {
            this.addException(e);
        }
    }

    public WASProduct(String productDirName, String versionDirName, String dtdDirName, String logDirName, String backupDirName) {
        this.clearExceptions();
        this.initialize(productDirName, versionDirName, dtdDirName, logDirName, backupDirName);
    }

    protected void initialize(String useProductDirName, String useVersionDirName, String useDTDDirName, String useLogDirName, String useBackupDirName) {
        this.productDir = new File(useProductDirName);
        this.traceFileProperties(this.productDir);
        this.productDirName = this.productDir.getAbsolutePath();
        if (!this.productDir.exists()) {
            this.addException("WVER0048E", new Object[]{this.productDirName}, null);
        } else if (!this.productDir.isDirectory()) {
            this.addException("WVER0049E", new Object[]{this.productDirName}, null);
        }
        this.versionDir = new File(useVersionDirName);
        this.traceFileProperties(this.versionDir);
        this.versionDirName = this.versionDir.getAbsolutePath();
        if (!this.versionDir.exists()) {
            this.addException("WVER0040E", new Object[]{this.versionDirName}, null);
        } else if (!this.versionDir.isDirectory()) {
            this.addException("WVER0041E", new Object[]{this.versionDirName}, null);
        }
        this.dtdDir = new File(useDTDDirName);
        this.traceFileProperties(this.dtdDir);
        this.dtdDirName = this.dtdDir.getAbsolutePath();
        if (!this.dtdDir.exists()) {
            this.addException("WVER0042E", new Object[]{this.dtdDirName}, null);
        } else if (!this.dtdDir.isDirectory()) {
            this.addException("WVER0043E", new Object[]{this.dtdDirName}, null);
        }
        this.logDir = new File(useLogDirName);
        this.traceFileProperties(this.logDir);
        this.logDirName = this.logDir.getAbsolutePath();
        this.backupDir = new File(useBackupDirName);
        this.traceFileProperties(this.backupDir);
        this.backupDirName = this.backupDir.getAbsolutePath();
        this.versionInfo = new HashMap();
        this.logger = WASDirectoryLogger.getWASDirectoryLogger(this.productDirName);
    }

    public boolean initializeLogAndBackup() {
        this.clearExceptions();
        boolean result = true;
        if (!this.logDir.exists()) {
            if (!this.logDir.mkdirs()) {
                this.addException("WVER0044E", new Object[]{this.logDirName}, null);
                result = false;
            }
        } else if (!this.logDir.isDirectory()) {
            this.addException("WVER0045E", new Object[]{this.logDirName}, null);
            result = false;
        }
        if (!this.backupDir.exists()) {
            if (!this.backupDir.mkdirs()) {
                this.addException("WVER0046E", new Object[]{this.backupDirName}, null);
                result = false;
            }
        } else if (!this.backupDir.isDirectory()) {
            this.addException("WVER0047E", new Object[]{this.backupDirName}, null);
            result = false;
        }
        return result;
    }

    public websphere getPlatform() {
        return (websphere)this.getVersionInfo("platform.websphere");
    }

    public product getProductByFilename(String basename) {
        if (!ProductHandler.accepts(basename)) {
            return null;
        }
        return (product)this.getVersionInfo(basename);
    }

    public product getProductById(String id) {
        product selectedProduct = null;
        Iterator products = this.getProducts();
        while (selectedProduct == null && products.hasNext()) {
            product nextProduct = (product)products.next();
            if (!nextProduct.getId().equals(id)) continue;
            selectedProduct = nextProduct;
        }
        return selectedProduct;
    }

    public boolean productPresent(String id) {
        return this.getProductById(id) != null;
    }

    public boolean addProduct(product aProduct) {
        this.clearExceptions();
        String baseName = aProduct.getId() + ".product";
        String fullName = this.getVersionFileName(baseName);
        BaseHandlerException exception = BaseFactory.saveSingleton(aProduct, new ProductWriter(), fullName);
        if (exception == null) {
            this.addProductName(baseName);
            this.basicAddProduct(aProduct);
            return true;
        }
        this.addException("WVER0021E", new String[]{aProduct.getId(), fullName}, exception);
        return false;
    }

    public boolean removeProduct(product aProduct) {
        this.clearExceptions();
        String baseName = aProduct.getId() + ".product";
        String fullName = this.getVersionFileName(baseName);
        File productFile = new File(fullName);
        this.traceFileProperties(productFile);
        boolean result = productFile.delete();
        if (result) {
            this.removeProductName(baseName);
            this.basicRemoveProduct(aProduct);
        } else {
            this.addException("WVER0029E", new String[]{aProduct.getId(), fullName}, null);
        }
        return result;
    }

    public component getComponentByFilename(String basename) {
        if (!ComponentHandler.accepts(basename)) {
            return null;
        }
        if (this.initMetadataInstance()) {
            try {
                WASComponent wasComponent = this.metadataInstance.getInstalledComponentByName(basename.substring(0, basename.indexOf(".")));
                if (wasComponent != null) {
                    return wasComponent.getComponent();
                }
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        return null;
    }

    public component getComponentByName(String name) {
        if (this.initMetadataInstance()) {
            try {
                WASComponent wasComponent = this.metadataInstance.getInstalledComponentByName(name);
                if (wasComponent != null) {
                    return wasComponent.getComponent();
                }
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        return null;
    }

    public boolean componentPresent(String name) {
        return this.getComponentByName(name) != null;
    }

    public boolean addComponent(component aComponent) {
        return true;
    }

    public boolean removeComponent(component aComponent) {
        return true;
    }

    public efix getEFixByFilename(String basename) {
        if (!EFixHandler.acceptsEFixFileName(basename)) {
            return null;
        }
        return (efix)this.getVersionInfo(basename);
    }

    public efix getEFixById(String id) {
        efix selectedEFix = null;
        Iterator efixes = this.getEFixes();
        while (selectedEFix == null && efixes.hasNext()) {
            efix nextEFix = (efix)efixes.next();
            if (!nextEFix.getId().equals(id)) continue;
            selectedEFix = nextEFix;
        }
        return selectedEFix;
    }

    public boolean efixPresent(String id) {
        return this.getEFixById(id) != null;
    }

    public ptf getPTFByFilename(String basename) {
        if (!EFixHandler.acceptsPTFFileName(basename)) {
            return null;
        }
        if (this.initMetadataInstance()) {
            try {
                WASMaintenancePackage mpThis = this.metadataInstance.getInstalledMaintenancePackageByID(basename.substring(0, basename.lastIndexOf(".")));
                if (mpThis != null) {
                    return mpThis.getPTFForThisMaintenancePackage();
                }
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        return null;
    }

    public ptf getPTFById(String id) {
        if (this.initMetadataInstance()) {
            try {
                WASMaintenancePackage mpThis = this.metadataInstance.getInstalledMaintenancePackageByID(id);
                if (mpThis != null) {
                    return mpThis.getPTFForThisMaintenancePackage();
                }
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        return null;
    }

    public boolean ptfPresent(String id) {
        return this.getPTFById(id) != null;
    }

    public extension getExtensionByFilename(String basename) {
        if (!ExtensionHandler.accepts(basename)) {
            return null;
        }
        return (extension)this.getVersionInfo(basename);
    }

    public extension getExtensionByName(String name) {
        extension selectedExtension = null;
        Iterator extensions = this.getExtensions();
        while (selectedExtension == null && extensions.hasNext()) {
            extension nextExtension = (extension)extensions.next();
            if (!nextExtension.getName().equals(name)) continue;
            selectedExtension = nextExtension;
        }
        return selectedExtension;
    }

    public boolean extensionPresent(String name) {
        return this.getExtensionByName(name) == null;
    }

    public registrar getRegistrarById(String id) {
        registrar selectedRegistrar = null;
        Iterator registrars = this.getRegistrars();
        while (selectedRegistrar == null && registrars.hasNext()) {
            registrar nextRegistrar = (registrar)registrars.next();
            if (!nextRegistrar.getId().equals(id)) continue;
            selectedRegistrar = nextRegistrar;
        }
        return selectedRegistrar;
    }

    public boolean registrarPresent(String id) {
        return this.getRegistrarById(id) != null;
    }

    public Iterator getProducts() {
        if (this.products == null) {
            this.products = this.basicGetProducts();
        }
        return this.products.iterator();
    }

    protected ArrayList basicGetProducts() {
        Iterator productNames = this.getProductNames();
        return this.collectVersionInfo(productNames);
    }

    protected void basicAddProduct(product aProduct) {
        this.products.add(aProduct);
    }

    protected void basicRemoveProduct(product aProduct) {
        this.products.remove(this.products.indexOf(aProduct));
    }

    public Iterator getProductNames() {
        if (this.productNames == null) {
            this.productNames = this.basicGetProductNames();
        }
        return this.productNames.iterator();
    }

    protected ArrayList basicGetProductNames() {
        ArrayList results = this.listFileNames(new ProductFilenameFilter());
        return results;
    }

    protected void addProductName(String productName) {
        this.productNames.add(productName);
    }

    protected void removeProductName(String productName) {
        this.productNames.remove(this.productNames.indexOf(productName));
    }

    public Iterator getComponents() {
        Vector componentVector = new Vector(0);
        if (this.initMetadataInstance()) {
            try {
                return this.metadataInstance.getComponentVector().iterator();
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        return componentVector.iterator();
    }

    protected void basicAddComponent(component aComponent) {
        this.components.add(aComponent);
    }

    protected void basicRemoveComponent(component aComponent) {
        this.components.remove(this.components.indexOf(aComponent));
    }

    protected ArrayList basicGetComponents() {
        Iterator componentNames = this.getComponentNames();
        return this.collectVersionInfo(componentNames);
    }

    public Iterator getComponentNames() {
        Vector componentVector = new Vector(0);
        if (this.initMetadataInstance()) {
            try {
                componentVector = this.metadataInstance.getComponentVector();
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        Vector<String> componentNames = new Vector<String>();
        for (int i = 0; i < componentVector.size(); ++i) {
            componentNames.add(((component)componentVector.elementAt(i)).getName() + ".component");
        }
        return componentNames.iterator();
    }

    protected ArrayList basicGetComponentNames() {
        ArrayList results = this.listFileNames(new ComponentFilenameFilter());
        return results;
    }

    protected void addComponentName(String componentName) {
        this.componentNames.add(componentName);
    }

    protected void removeComponentName(String componentName) {
        this.componentNames.remove(this.componentNames.indexOf(componentName));
    }

    public boolean saveEFix(efix anEFix) {
        return true;
    }

    public boolean removeEFix(efix anEFix) {
        return true;
    }

    protected void addEFix(efix anEFix) {
        this.efixes.add(anEFix);
    }

    protected void basicRemoveEFix(efix anEFix) {
        this.efixes.remove(this.efixes.indexOf(anEFix));
    }

    public Iterator getEFixes() {
        if (this.efixes == null) {
            this.efixes = this.basicGetEFixes();
        }
        return this.efixes.iterator();
    }

    public int getEFixCount() {
        return this.efixes.size();
    }

    protected ArrayList basicGetEFixes() {
        Iterator efixNames = this.getEFixNames();
        return this.collectVersionInfo(efixNames);
    }

    protected void addEFixName(String efixName) {
        this.efixNames.add(efixName);
    }

    protected void removeEFixName(String efixName) {
        this.efixNames.remove(this.efixNames.indexOf(efixName));
    }

    public Iterator getEFixNames() {
        if (this.efixNames == null) {
            this.efixNames = this.basicGetEFixNames();
        }
        return this.efixNames.iterator();
    }

    protected ArrayList basicGetEFixNames() {
        ArrayList results = this.listFileNames(new EFixFilenameFilter());
        return results;
    }

    public boolean savePTF(ptf aPTF) {
        return true;
    }

    public boolean removePTF(ptf aPTF) {
        return true;
    }

    protected void addPTF(ptf aPTF) {
        this.ptfs.add(aPTF);
    }

    protected void basicRemovePTF(ptf aPTF) {
        this.ptfs.remove(this.ptfs.indexOf(aPTF));
    }

    public Iterator getPTFs() {
        Vector ptfVector = new Vector(0);
        if (this.initMetadataInstance()) {
            try {
                return this.metadataInstance.getPTFVector().iterator();
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        return ptfVector.iterator();
    }

    protected ArrayList basicGetPTFs() {
        Iterator ptfNames = this.getPTFNames();
        return this.collectVersionInfo(ptfNames);
    }

    protected void addPTFName(String ptfName) {
        this.ptfNames.add(ptfName);
    }

    protected void removePTFName(String ptfName) {
        this.ptfNames.remove(this.ptfNames.indexOf(ptfName));
    }

    public Iterator getPTFNames() {
        Vector ptfVector = new Vector(0);
        if (this.initMetadataInstance()) {
            try {
                ptfVector = this.metadataInstance.getPTFVector();
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        Vector<String> ptfNames = new Vector<String>();
        for (int i = 0; i < ptfVector.size(); ++i) {
            ptfNames.add(((ptf)ptfVector.elementAt(i)).getId() + ".ptf");
        }
        return ptfNames.iterator();
    }

    protected ArrayList basicGetPTFNames() {
        ArrayList results = this.listFileNames(new PTFFilenameFilter());
        return results;
    }

    public Iterator getExtensions() {
        if (this.extensions == null) {
            this.extensions = this.basicGetExtensions();
        }
        return this.extensions.iterator();
    }

    protected ArrayList basicGetExtensions() {
        Iterator extensionNames = this.getExtensionNames();
        return this.collectVersionInfo(extensionNames);
    }

    public Iterator getExtensionNames() {
        if (this.extensionNames == null) {
            this.extensionNames = this.basicGetExtensionNames();
        }
        return this.extensionNames.iterator();
    }

    protected ArrayList basicGetExtensionNames() {
        ArrayList result = this.listFileNames(new ExtensionFilenameFilter());
        return result;
    }

    public Iterator getRegistrars() {
        if (this.registrars == null) {
            this.registrars = this.basicGetRegistrars();
        }
        return this.registrars.iterator();
    }

    protected ArrayList basicGetRegistrars() {
        Iterator registrarNames = this.getRegistrarNames();
        return this.collectVersionInfo(registrarNames);
    }

    public Iterator getRegistrarNames() {
        if (this.registrarNames == null) {
            this.registrarNames = this.basicGetRegistrarNames();
        }
        return this.registrarNames.iterator();
    }

    protected ArrayList basicGetRegistrarNames() {
        ArrayList results = this.listFileNames(new RegistrarFilenameFilter());
        return results;
    }

    protected ArrayList collectVersionInfo(Iterator names) {
        ArrayList<Object> collectedInfo = new ArrayList<Object>();
        boolean encounteredError = false;
        while (!encounteredError && names.hasNext()) {
            String nextName = (String)names.next();
            Object nextInfo = this.getVersionInfo(nextName);
            if (nextInfo == null) continue;
            collectedInfo.add(nextInfo);
        }
        return collectedInfo;
    }

    protected Object getVersionInfo(String filename) {
        Object info = this.versionInfo.get(filename);
        if (info == null && (info = this.loadVersionInfo(filename)) != null) {
            this.versionInfo.put(filename, info);
        }
        return info;
    }

    protected Object loadVersionInfo(String filename) {
        BaseHandler handler = WebSphereHandler.accepts(filename) ? new WebSphereHandler() : (ProductHandler.accepts(filename) ? new ProductHandler() : (ComponentHandler.accepts(filename) ? new ComponentHandler() : (EFixHandler.acceptsEFixFileName(filename) || EFixHandler.acceptsPTFFileName(filename) ? new EFixHandler() : (ExtensionHandler.accepts(filename) ? new ExtensionHandler() : (RegistrarHandler.accepts(filename) ? new RegistrarHandler() : null)))));
        if (handler == null) {
            this.addException("WVER0002E", new Object[]{filename}, null);
            return null;
        }
        BaseFactory factory = new BaseFactory(handler, null);
        List loaded = null;
        try {
            loaded = factory.load(this.getDTDDirName(), this.getVersionDirName(), filename);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        this.transferErrors(factory);
        BaseHandlerException handlerException = factory.getException();
        if (handlerException != null) {
            this.addException("WVER0013E", new Object[]{filename}, handlerException);
            return null;
        }
        return loaded.iterator().next();
    }

    public String[] loadAllVersionInfoByType(String type) {
        FilenameFilter filter;
        if (this.isMetadataFileModified(this.productDirName)) {
            try {
                HistoryInfoGenerator.transformHistoryXmls(this.getBackupDirName(), WASProduct.getLogDirName(this.productDirName), WASHistory.getHistoryDirName(this.versionDirName), this.versionDirName);
            }
            catch (Exception e) {
                this.addException("WVER0203E", new Object[]{e.getMessage()}, e);
            }
        }
        if ((filter = type.equalsIgnoreCase(PRODUCT_TYPE) ? new ProductFilenameFilter() : (type.equalsIgnoreCase(COMPONENT_TYPE) ? new ComponentFilenameFilter() : (type.equalsIgnoreCase(EFIX_TYPE) ? new EFixFilenameFilter() : (type.equalsIgnoreCase(PTF_TYPE) ? new PTFFilenameFilter() : (type.equalsIgnoreCase(EXTENSION_TYPE) ? new ExtensionFilenameFilter() : null))))) == null) {
            return null;
        }
        File[] files = this.listFiles(filter);
        if (files == null) {
            return new String[0];
        }
        String[] data = new String[files.length];
        for (int fileNo = 0; fileNo < files.length; ++fileNo) {
            data[fileNo] = this.loadVersionInfoAsXMLString(files[fileNo].getName(), false);
        }
        return data;
    }

    protected String loadVersionInfoAsXMLString(String filename, boolean doXSLTransform) {
        File versionFile;
        String result = "";
        if (doXSLTransform) {
            try {
                HistoryInfoGenerator.transformHistoryXmls(this.getBackupDirName(), WASProduct.getLogDirName(this.productDirName), WASHistory.getHistoryDirName(this.versionDirName), this.versionDirName);
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        if ((versionFile = new File(this.getVersionDir(), filename)) != null && versionFile.exists()) {
            try {
                result = this.loadFile(versionFile, filename);
            }
            catch (FileNotFoundException e) {
                this.addException("WVER0014E", new Object[]{filename}, e);
            }
            catch (IOException e) {
                this.addException("WVER0014E", new Object[]{filename}, e);
            }
        }
        return result;
    }

    public String loadVersionInfoAsXMLString(String filename) {
        if (this.isMetadataFileModified(this.productDirName)) {
            return this.loadVersionInfoAsXMLString(filename, true);
        }
        return this.loadVersionInfoAsXMLString(filename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadFile(File file, String fileName) throws FileNotFoundException, IOException {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        FileReader fileReader = new FileReader(file);
        BufferedReader reader = new BufferedReader(fileReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                pwriter.println(line);
            }
        }
        finally {
            reader.close();
        }
        pwriter.close();
        String result = writer.toString();
        return result;
    }

    protected File getProductDir() {
        return this.productDir;
    }

    public String getProductDirName() {
        return this.productDirName;
    }

    protected File getVersionDir() {
        return this.versionDir;
    }

    public String getVersionDirName() {
        return this.versionDirName;
    }

    public String getVersionFileName(String baseName) {
        String versionDirName = this.getVersionDirName();
        File versionDirFile = new File(versionDirName);
        File[] allFiles = versionDirFile.listFiles();
        for (int i = 0; i < allFiles.length; ++i) {
            String fileName = allFiles[i].getName();
            if (!fileName.equalsIgnoreCase(baseName)) continue;
            return allFiles[i].getAbsolutePath();
        }
        String fullName = versionDirName + File.separator + baseName;
        File fullFile = new File(fullName);
        this.traceFileProperties(fullFile);
        return fullFile.getAbsolutePath();
    }

    public String getDTDDirName() {
        return this.dtdDirName;
    }

    public String getLogDirName() {
        return this.logDirName;
    }

    public String getBackupDirName() {
        return this.backupDirName;
    }

    protected ArrayList listFileNames(FilenameFilter filter) {
        File[] files = this.listFiles(filter);
        ArrayList result = this.listFileNames(files);
        return result;
    }

    protected ArrayList listFileNames(File[] files) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int fileNo = 0; fileNo < files.length; ++fileNo) {
            fileNames.add(files[fileNo].getName());
        }
        return fileNames;
    }

    protected File[] listFiles(FilenameFilter filter) {
        File[] results = this.getVersionDir().listFiles(filter);
        return results;
    }

    public String toString() {
        return "WASProduct: " + this.getProductDirName() + " :: " + this.getVersionDirName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void traceFileProperties(File f) {
        boolean exists = f.exists();
        if (!exists) return;
        try {
            File target = f.getCanonicalFile();
            if (f.equals(target)) return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean initMetadataInstance() {
        if (this.metadataInstance != null) {
            return true;
        }
        this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "initialize", "About to init metadata instance.");
        try {
            this.metadataInstance = WASMetadata.getWASMetadataInstance(this.productDirName);
            if (this.metadataInstance != null) {
                this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "initialize", "Metadata instance initialized.");
                return true;
            }
            this.logger.logThisMessage(Level.WARNING, this.getClass().getName(), "initialize", "Metadata instance is null.");
        }
        catch (Exception e) {
            this.addException("WVER0242E", e);
        }
        return false;
    }

    private boolean isMetadataFileModified(String installRoot) {
        try {
            File historyXmlFile = new File(WASMetadataHelper.getHistoryXmlPath(installRoot));
            if (!historyXmlFile.exists()) {
                return false;
            }
            if (this.lastModifyHistoryFile != 0L && this.lastModifyHistoryFile == historyXmlFile.lastModified()) {
                return false;
            }
            this.lastModifyHistoryFile = historyXmlFile.lastModified();
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }
}

