/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.WASDirectoryException;
import com.ibm.websphere.product.WASProductFile;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponent;
import com.ibm.websphere.product.metadata.WASMaintenancePackage;
import com.ibm.websphere.product.metadata.WASMetadata;
import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.utils.WASPlatformConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class WASDirectory {
    public static final String ID_BASE = "BASE";
    public static final String ID_EXPRESS = "EXPRESS";
    public static final String ID_ND = "ND";
    public static final String ID_NDDMZ = "NDDMZ";
    public static final String ID_PME = "PME";
    public static final String ID_WBI = "WBI";
    public static final String ID_JDK = "JDK";
    public static final String ID_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String ID_XD = "XD";
    public static final String ID_CLIENT = "CLIENT";
    public static final String ID_PLUGIN = "PLG";
    public static final String ID_IHS = "IHS";
    public static final String ID_WXD = "WXD";
    private String m_sWasLocation = "";
    private WASProductInfo[] m_wpiWASProductInstances = null;
    private WASMetadata wasMetadataInstance = null;
    private WASDirectoryLogger logger = null;
    private static String PRODUCT_FILE_EXTENSION = ".product";
    private static final String S_LIB_NAME_FOR_ARCH_DETECTION_ON_WAS = "libWs60ProcessManagement";
    private static final String S_URI_PATH_SEPARATOR = "/";
    private static final String S_BIN_DIR_NAME = "bin";
    private static final String S_MODULES_DIR_NAME = "modules";

    public WASDirectory() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, WASDirectoryException {
        this.init(WASDirectoryHelper.getInstallRootPath());
    }

    public WASDirectory(String wasLocation) {
        this.init(wasLocation);
    }

    public WASProductInfo[] getWASProductInfoInstances() {
        return this.m_wpiWASProductInstances;
    }

    public WASProductInfo getWASProductInfo(String id) {
        if (id == null) {
            return null;
        }
        if ((id = WASDirectoryHelper.normalizedProductID(id)).equalsIgnoreCase(ID_PME)) {
            for (int i = 0; this.m_wpiWASProductInstances != null && i < this.m_wpiWASProductInstances.length; ++i) {
                String sCurrentProductID = this.m_wpiWASProductInstances[i].getId();
                if (!sCurrentProductID.equalsIgnoreCase(ID_ND) && !sCurrentProductID.equalsIgnoreCase(ID_BASE) && !sCurrentProductID.equalsIgnoreCase(ID_EXPRESS)) continue;
                return this.m_wpiWASProductInstances[i];
            }
        } else {
            for (int i = 0; this.m_wpiWASProductInstances != null && i < this.m_wpiWASProductInstances.length; ++i) {
                if (!this.m_wpiWASProductInstances[i].getId().equalsIgnoreCase(id)) continue;
                return this.m_wpiWASProductInstances[i];
            }
        }
        return null;
    }

    public boolean isThisProductInstalled(String id) {
        WASProductInfo p = this.getWASProductInfo(id);
        return p != null;
    }

    public String getName(String id) {
        WASProductInfo p = this.getWASProductInfo(id);
        if (p != null) {
            return p.getName();
        }
        return null;
    }

    public String getVersion(String id) {
        WASProductInfo p = this.getWASProductInfo(id);
        if (p != null) {
            return p.getVersion();
        }
        return null;
    }

    public String getBuildDate(String id) {
        WASProductInfo p = this.getWASProductInfo(id);
        if (p != null) {
            return p.getBuildDate();
        }
        return null;
    }

    public String getBuildLevel(String id) {
        WASProductInfo p = this.getWASProductInfo(id);
        if (p != null) {
            return p.getBuildLevel();
        }
        return null;
    }

    public String getWasLocation() {
        return this.m_sWasLocation;
    }

    public static boolean refreshProductInfoCache() {
        return WASProductFile.refreshCache();
    }

    public String getOfficialArchNameFromNativeFile() {
        String os2 = WASPlatformConstants.getCurrentPlatformCode();
        String arch = null;
        try {
            arch = this.getArchFromNativeFile();
            if (arch == null) {
                return arch;
            }
        }
        catch (IOException ioe) {
            return null;
        }
        String archName = WASPlatformConstants.getOfficialArchNameByOSArchKeyword(os2, arch);
        if (archName == null) {
            return arch;
        }
        return archName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getArchFromNativeFile() throws IOException {
        String installLocation = this.getWasLocation();
        String os2 = WASPlatformConstants.getCurrentPlatformCode();
        String sInstallRootPath = WASDirectoryHelper.normalizeLocationNoEndingSlash(installLocation);
        String sLibFilePath = this.getLibraryFilePathByPlatform(os2, sInstallRootPath);
        if (os2.equals("windows")) {
            if (sLibFilePath == null || !new File(sLibFilePath).exists()) return null;
            return WASPlatformConstants.getArchByDllDecoder(sLibFilePath);
        }
        if (os2.equals("aix")) {
            if (sLibFilePath == null || !new File(sLibFilePath).exists()) return null;
            return WASPlatformConstants.getArchByXcoffDecoder(sLibFilePath);
        }
        if (os2.equals("solaris") || os2.equals("linux")) {
            if (sLibFilePath == null || !new File(sLibFilePath).exists()) return null;
            return WASPlatformConstants.getArchByElfDecoder(sLibFilePath);
        }
        if (os2.equals("hpux")) {
            if (this.isThisProductInstalled(ID_IHS)) {
                if (sLibFilePath == null || !new File(sLibFilePath).exists()) return null;
                String arch = WASPlatformConstants.getArchByElfDecoder(sLibFilePath);
                if (arch == null) return "pa-risc";
                return arch;
            }
            if (sLibFilePath == null || !new File(sLibFilePath).exists()) return "ia64";
            return "pa-risc";
        }
        if (os2.equals("os400")) {
            return "ppc64";
        }
        if (!os2.equals("zos")) return null;
        return "s390";
    }

    public WASComponent getInstalledComponentByName(String componentName) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getInstalledComponentByName(componentName);
        }
        return null;
    }

    public WASComponent[] getInstalledComponentList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getInstalledComponentList();
        }
        return new WASComponent[0];
    }

    public WASMaintenancePackage[] getHistoryMaintenancePackageList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getHistoryMaintenancePackageList();
        }
        return new WASMaintenancePackage[0];
    }

    public WASMaintenancePackage getInstalledMaintenancePackageByID(String mpID) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getInstalledMaintenancePackageByID(mpID);
        }
        return null;
    }

    public WASMaintenancePackage[] getInstalledMaintenancePackageList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.initMetadataInstance()) {
            return this.wasMetadataInstance.getInstalledMaintenancePackageList();
        }
        return new WASMaintenancePackage[0];
    }

    public boolean isComponentInstalled(String componentName) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return this.getInstalledComponentByName(componentName) != null;
    }

    public boolean isMaintenancePackageInstalled(String ID) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return this.getInstalledMaintenancePackageByID(ID) != null;
    }

    protected String getLibraryFilePathByPlatform(String os2, String sInstallRootPath) {
        File fileLibDir = null;
        String sLibDirPath = null;
        sLibDirPath = this.isThisProductInstalled(ID_IHS) ? sInstallRootPath + S_URI_PATH_SEPARATOR + S_MODULES_DIR_NAME + S_URI_PATH_SEPARATOR : sInstallRootPath + S_URI_PATH_SEPARATOR + S_BIN_DIR_NAME;
        fileLibDir = new File(sLibDirPath);
        File[] libFileList = null;
        if (os2.equals("windows")) {
            if (this.isWASOrNDDMZInstalled()) {
                return sLibDirPath + S_URI_PATH_SEPARATOR + S_LIB_NAME_FOR_ARCH_DETECTION_ON_WAS + ".dll";
            }
            libFileList = fileLibDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".dll");
                }
            });
        } else if (os2.equals("aix") || os2.equals("solaris") || os2.equals("linux")) {
            if (this.isWASOrNDDMZInstalled()) {
                return sLibDirPath + S_URI_PATH_SEPARATOR + S_LIB_NAME_FOR_ARCH_DETECTION_ON_WAS + ".so";
            }
            libFileList = fileLibDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".so");
                }
            });
        } else if (os2.equals("hpux")) {
            if (this.isWASOrNDDMZInstalled()) {
                return sLibDirPath + S_URI_PATH_SEPARATOR + S_LIB_NAME_FOR_ARCH_DETECTION_ON_WAS + ".sl";
            }
            libFileList = this.isThisProductInstalled(ID_IHS) ? fileLibDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".so");
                }
            }) : fileLibDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".sl");
                }
            });
        }
        if (libFileList != null && libFileList.length > 0) {
            return libFileList[0].getAbsolutePath();
        }
        return null;
    }

    protected void init(String wasLocation) {
        this.setWasLocation(new File(wasLocation).getAbsolutePath());
        this.setLogger(WASDirectoryLogger.getWASDirectoryLogger(this.m_sWasLocation));
        this.m_wpiWASProductInstances = this.parse();
    }

    protected boolean initMetadataInstance() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (this.wasMetadataInstance == null) {
            this.wasMetadataInstance = WASMetadata.getWASMetadataInstance(this.m_sWasLocation);
            if (this.wasMetadataInstance == null) {
                return false;
            }
        }
        return true;
    }

    protected void setLogger(WASDirectoryLogger logger) {
        this.logger = logger;
    }

    private boolean isWASOrNDDMZInstalled() {
        WASProductInfo p = this.getWASProductInfo(ID_ND);
        return p != null || (p = this.getWASProductInfo(ID_BASE)) != null || (p = this.getWASProductInfo(ID_EXPRESS)) != null || (p = this.getWASProductInfo(ID_NDDMZ)) != null;
    }

    private void setWasLocation(String wasLocation) {
        this.m_sWasLocation = wasLocation;
    }

    private String[] getAllProductFilesDirectlyUnderDir(String dir) {
        String[] toBeReturned = null;
        String[] list = new File(dir).list();
        if (list == null) {
            return null;
        }
        Vector<String> productFileVec = new Vector<String>(3);
        for (int i = 0; i < list.length; ++i) {
            File f;
            if (!list[i].endsWith(PRODUCT_FILE_EXTENSION) || (f = new File(list[i])) == null || f.isDirectory()) continue;
            productFileVec.add(list[i]);
        }
        if (productFileVec.size() >= 0) {
            toBeReturned = new String[productFileVec.size()];
            for (int x = 0; x < toBeReturned.length; ++x) {
                toBeReturned[x] = (String)productFileVec.elementAt(x);
            }
        }
        return toBeReturned;
    }

    private WASProductInfo[] parse() {
        String versionDir = WASDirectoryHelper.getVersionDirPath(this.getWasLocation());
        String dtdDir = WASDirectoryHelper.getDTDDirPath(this.getWasLocation());
        String[] fileNames = this.getAllProductFilesDirectlyUnderDir(versionDir);
        WASProductInfo[] toBeReturned = null;
        if (fileNames != null) {
            Vector<WASProductInfo> productVec = new Vector<WASProductInfo>();
            for (int i = 0; i < fileNames.length; ++i) {
                WASProductFile wasproductfileThis = WASProductFile.getWASProductFileInstance(dtdDir, versionDir, fileNames[i]);
                if (wasproductfileThis == null) continue;
                WASProductInfo[] pArray = wasproductfileThis.getWASProductInfoArray();
                for (int x = 0; x < pArray.length; ++x) {
                    productVec.add(pArray[x]);
                }
            }
            if (productVec.size() >= 0) {
                toBeReturned = new WASProductInfo[productVec.size()];
                for (int x = 0; x < toBeReturned.length; ++x) {
                    toBeReturned[x] = (WASProductInfo)productVec.elementAt(x);
                }
            }
        }
        return toBeReturned;
    }
}

