/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.RangeStatisticImpl;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiUtil;

public class StatsUtil {
    public static String statsToTclAttrString(Stats stats, DataDescriptor dd, String nodeName, String serverName) {
        return StatsUtil.statsToTclAttrString(null, stats, dd, nodeName, serverName);
    }

    public static String statsToTclAttrString(String desc, Stats stats, DataDescriptor dd, String nodeName, String serverName) {
        Stats[] substats;
        if (stats == null) {
            return "";
        }
        StringBuffer rv = new StringBuffer(256);
        String childdesc = desc;
        String modName = stats.getStatsType();
        if (modName == null) {
            modName = dd.getModuleName();
        }
        if (desc == null) {
            if (modName.equals("pmi")) {
                desc = "PMI data for server";
                childdesc = null;
            } else {
                PmiModuleConfig config = PerfModules.getConfig(PmiUtil.statsTypeToModuleID(modName));
                childdesc = desc = config.getDescription();
            }
        }
        rv.append("{Description ").append(desc).append("} ");
        rv.append("{Descriptor ").append(StatsUtil.safeString(StatsUtil.pmiDescriptorToTclAttrString(modName, dd, nodeName, serverName))).append("} ");
        rv.append("{Level ").append(stats.getLevel()).append("}");
        DataDescriptor mydd = null;
        Statistic[] dataMembers = stats.listStatistics();
        if (dataMembers != null && dataMembers.length > 0) {
            rv.append(" {Data {");
            for (int i = 0; i < dataMembers.length; ++i) {
                mydd = new DataDescriptor(dd, dataMembers[i].getId());
                rv.append("{").append(StatsUtil.statisticToTclAttrString(dataMembers[i], stats.getTime(), modName, mydd, nodeName, serverName)).append("}");
                if (i >= dataMembers.length - 1) continue;
                rv.append(" ");
            }
            rv.append("}}");
        }
        if ((substats = stats.listSubStats()) != null && substats.length > 0) {
            rv.append(" {SubCollections {");
            for (int i = 0; i < substats.length; ++i) {
                mydd = new DataDescriptor(dd, substats[i].getName());
                rv.append("{").append(StatsUtil.statsToTclAttrString(childdesc, substats[i], mydd, nodeName, serverName)).append("}");
                if (i >= substats.length - 1) continue;
                rv.append(" ");
            }
            rv.append("}}");
        }
        return rv.toString();
    }

    public static String statisticToTclAttrString(Statistic stats, long time2, String modName, DataDescriptor dd, String nodeName, String serverName) {
        if (stats == null) {
            return "";
        }
        StringBuffer rv = new StringBuffer(256);
        rv.append("{Id ").append(stats.getId()).append("} ");
        rv.append("{Descriptor ").append(StatsUtil.safeString(StatsUtil.pmiDescriptorToTclAttrString(modName, dd, nodeName, serverName))).append("} ");
        rv.append("{PmiDataInfo ").append(StatsUtil.safeString(StatsUtil.pmiDataInfoToTclAttrString(stats.getDataInfo()))).append("} ");
        rv.append("{Time ").append(time2).append("} ");
        rv.append("{Value ").append(StatsUtil.statisticToValue(stats)).append("}");
        return rv.toString();
    }

    public static String statisticToTclAttrString(Statistic stats, long time2, DataDescriptor dd, String nodeName, String serverName) {
        return StatsUtil.statisticToTclAttrString(stats, time2, dd.getModuleName(), dd, nodeName, serverName);
    }

    private static String statisticToValue(Statistic statData) {
        if (statData == null) {
            return "";
        }
        StringBuffer rv = new StringBuffer();
        if (statData instanceof CountStatisticImpl) {
            CountStatisticImpl tmp = (CountStatisticImpl)statData;
            rv.append("{Count ").append(tmp.getCount()).append("} ");
        } else if (statData instanceof TimeStatisticImpl) {
            TimeStatisticImpl tmp = (TimeStatisticImpl)statData;
            rv.append("{Total ").append(tmp.getTotal()).append("} ");
            rv.append("{Count ").append(tmp.getCount()).append("} ");
            rv.append("{Mean ").append(tmp.getMean()).append("} ");
        } else if (statData instanceof RangeStatisticImpl) {
            RangeStatisticImpl tmp = (RangeStatisticImpl)statData;
            rv.append("{Current ").append(tmp.getCurrent()).append("} ");
            rv.append("{LowWaterMark ").append(tmp.getLowWaterMark()).append("} ");
            rv.append("{HighWaterMark ").append(tmp.getHighWaterMark()).append("} ");
            rv.append("{MBean ").append(tmp.getMean()).append("} ");
        }
        return rv.toString();
    }

    public static String pmiDataInfoToTclAttrString(PmiDataInfo pmi2) {
        if (pmi2 == null) {
            return "";
        }
        StringBuffer rv = new StringBuffer();
        rv.append("{Name ").append(StatsUtil.safeString(pmi2.getName())).append("} ");
        rv.append("{Id ").append(pmi2.getId()).append("} ");
        rv.append("{Description ").append(StatsUtil.safeString(pmi2.getDescription())).append("} ");
        rv.append("{Level ").append(pmi2.getLevel()).append("} ");
        rv.append("{Comment ").append(StatsUtil.safeString(pmi2.getComment())).append("} ");
        rv.append("{SubmoduleName ").append(StatsUtil.safeString(pmi2.getSubmoduleName())).append("} ");
        rv.append("{Type ").append(pmi2.getType()).append("} ");
        rv.append("{Unit ").append(pmi2.getUnit()).append("} ");
        rv.append("{Resettable ").append(pmi2.isResettable()).append("}");
        return rv.toString();
    }

    public static String pmiDescriptorToTclAttrString(String modName, DataDescriptor dd, String nodeName, String serverName) {
        StringBuffer rv = new StringBuffer();
        rv.append("{Node ").append(StatsUtil.safeString(nodeName)).append("} ");
        rv.append("{Server ").append(StatsUtil.safeString(serverName)).append("} ");
        if (dd.getType() != 12) {
            rv.append("{Module ").append(StatsUtil.safeString(modName)).append("} ");
            rv.append("{Name ").append(StatsUtil.safeString(dd.getName())).append("} ");
        }
        rv.append("{Type ").append(StatsUtil.pdTypeToString(dd.getType())).append("}");
        return rv.toString();
    }

    public static String pmiDescriptorToTclAttrString(DataDescriptor dd, String nodeName, String serverName) {
        return StatsUtil.pmiDescriptorToTclAttrString(dd.getModuleName(), dd, nodeName, serverName);
    }

    public static String pdTypeToString(int i) {
        switch (i) {
            case 10: {
                return "ROOT";
            }
            case 11: {
                return "NODE";
            }
            case 12: {
                return "SERVER";
            }
            case 13: {
                return "MODULE";
            }
            case 14: {
                return "INSTANCE";
            }
            case 15: {
                return "SUBMODULE";
            }
            case 16: {
                return "SUBINSTANCE";
            }
            case 17: {
                return "COLLECTION";
            }
            case 18: {
                return "DATA";
            }
            case 24: {
                return "MODULEROOT";
            }
        }
        return "UNKNOWN";
    }

    private static String safeString(String in) {
        if (null == in) {
            return in;
        }
        if (-1 != in.indexOf(" ")) {
            return "{" + in + "}";
        }
        return in;
    }
}

