/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdData;
import java.io.Serializable;
import java.util.ArrayList;

public class StatsImpl
implements Stats,
WpdCollection,
PmiConstants,
Serializable {
    private static final long serialVersionUID = -5812710047173154854L;
    protected String statsType;
    protected String name;
    protected int type;
    protected int instrumentationLevel = -1;
    protected ArrayList dataMembers;
    protected ArrayList subCollections;
    protected long time = PmiUtil.currentTime();
    private transient boolean bInitStaticInfo = false;

    public StatsImpl(String name, int type) {
        this(name, type, -1, null, null);
    }

    public StatsImpl(String name, int type, int level) {
        this(name, type, level, null, null);
    }

    public StatsImpl(String name, int type, int level, ArrayList dataMembers, ArrayList subCollections) {
        if (name == null) {
            name = "Undefined";
        }
        this.name = name;
        this.type = type == 11 || type == 12 || type == 13 ? type : 17;
        this.instrumentationLevel = level;
        this.dataMembers = dataMembers;
        this.subCollections = subCollections;
    }

    public StatsImpl(String statsType, String name, int type, int level, ArrayList dataMembers, ArrayList subCollections) {
        this(name, type, level, dataMembers, subCollections);
        this.statsType = statsType;
    }

    public String getName() {
        return this.name;
    }

    public String getStatsType() {
        return this.statsType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatsType(String modName) {
        this.statsType = modName;
    }

    public int getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public int getLevel() {
        return this.instrumentationLevel;
    }

    public void setLevel(int level) {
        this.instrumentationLevel = level;
    }

    public void setStatistics(ArrayList dataMembers) {
        this.dataMembers = dataMembers;
    }

    public void setSubStats(ArrayList subCollections) {
        this.subCollections = subCollections;
    }

    public Statistic getStatistic(int dataId) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return null;
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        for (int i = 0; i < this.dataMembers.size(); ++i) {
            Statistic data = (Statistic)this.dataMembers.get(i);
            if (data.getId() != dataId) continue;
            return data;
        }
        return null;
    }

    public com.ibm.websphere.management.statistics.Statistic getStatistic(String name) {
        if (this.dataMembers == null) {
            return null;
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        Statistic statistic = null;
        for (int i = 0; i < this.dataMembers.size(); ++i) {
            statistic = (Statistic)this.dataMembers.get(i);
            if (!statistic.getName().equals(name)) continue;
            return statistic;
        }
        return null;
    }

    public com.ibm.websphere.management.statistics.Statistic[] getStatistics() {
        if (this.dataMembers == null || this.dataMembers.size() == 0) {
            return new Statistic[0];
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        com.ibm.websphere.management.statistics.Statistic[] ret = new Statistic[this.dataMembers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Statistic)this.dataMembers.get(i);
        }
        return ret;
    }

    public String[] getStatisticNames() {
        if (this.dataMembers == null) {
            return new String[0];
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        String[] ret = new String[this.dataMembers.size()];
        for (int i = 0; i < ret.length; ++i) {
            if (this.dataMembers.get(i) == null) continue;
            ret[i] = ((Statistic)this.dataMembers.get(i)).getName();
        }
        return ret;
    }

    public Stats getStats(String name) {
        if (this.subCollections == null) {
            return null;
        }
        Stats stat = null;
        for (int i = 0; i < this.subCollections.size(); ++i) {
            stat = (Stats)this.subCollections.get(i);
            if (!stat.getName().equals(name)) continue;
            return stat;
        }
        return null;
    }

    public Stats[] getSubStats() {
        return this.listSubStats();
    }

    public String[] listStatisticNames() {
        if (this.dataMembers == null) {
            return new String[0];
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        String[] ret = new String[this.dataMembers.size()];
        for (int i = 0; i < ret.length; ++i) {
            if (this.dataMembers.get(i) == null) continue;
            ret[i] = ((Statistic)this.dataMembers.get(i)).getName();
        }
        return ret;
    }

    public Statistic[] listStatistics() {
        if (this.dataMembers == null || this.dataMembers.size() == 0) {
            return new Statistic[0];
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        Statistic[] ret = new Statistic[this.dataMembers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Statistic)this.dataMembers.get(i);
        }
        return ret;
    }

    public Stats[] listSubStats() {
        if (this.subCollections == null || this.subCollections.size() == 0) {
            return new Stats[0];
        }
        Stats[] ret = new Stats[this.subCollections.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Stats)this.subCollections.get(i);
        }
        return ret;
    }

    public synchronized boolean add(Statistic newMember) {
        if (this.dataMembers == null) {
            this.dataMembers = new ArrayList();
        }
        if (newMember == null) {
            return false;
        }
        this.dataMembers.add(newMember);
        return true;
    }

    public synchronized boolean add(Stats newMember) {
        if (this.subCollections == null) {
            this.subCollections = new ArrayList();
        }
        if (newMember == null) {
            return false;
        }
        this.subCollections.add(newMember);
        return true;
    }

    public synchronized boolean remove(int dataId) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return false;
        }
        for (int i = this.dataMembers.size() - 1; i >= 0; --i) {
            if (((Statistic)this.dataMembers.get(i)).getId() != dataId) continue;
            this.dataMembers.remove(i);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String name) {
        if (this.subCollections == null || this.subCollections.size() <= 0) {
            return false;
        }
        for (int i = this.subCollections.size() - 1; i >= 0; --i) {
            Stats collection = (Stats)this.subCollections.get(i);
            if (!collection.getName().equals(name)) continue;
            this.subCollections.remove(i);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        int i;
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        String myIndent = indent + "  ";
        String typeString = null;
        switch (this.type) {
            case 10: {
                typeString = "PMIROOT";
                break;
            }
            case 11: {
                typeString = "NODE";
                break;
            }
            case 12: {
                typeString = "SERVER";
                break;
            }
            case 13: {
                typeString = "MODULE";
                break;
            }
            case 15: {
                typeString = "SUBMODULE";
                break;
            }
            case 14: {
                typeString = "INSTANCE";
                break;
            }
            case 16: {
                typeString = "SUBINSTANCE";
                break;
            }
            case 17: {
                typeString = "COLLECTION";
                break;
            }
            default: {
                typeString = "WRONG_TYPE";
            }
        }
        StringBuffer res = new StringBuffer();
        res.append("\n");
        res.append(indent);
        res.append("Stats name=");
        res.append(this.name);
        res.append(" type=");
        res.append(typeString);
        res.append("\n");
        if (this.dataMembers != null) {
            for (i = 0; i < this.dataMembers.size(); ++i) {
                Statistic data = (Statistic)this.dataMembers.get(i);
                if (data == null) continue;
                res.append(myIndent);
                res.append(((Object)data).toString());
                res.append("\n");
            }
        }
        if (this.subCollections != null) {
            for (i = 0; i < this.subCollections.size(); ++i) {
                Stats col = (Stats)this.subCollections.get(i);
                if (col == null) continue;
                res.append(col.toString(myIndent));
            }
        }
        return res.toString();
    }

    public void setConfig(PmiModuleConfig config) {
        int i;
        if (config == null) {
            return;
        }
        this.bInitStaticInfo = true;
        if (this.dataMembers != null) {
            for (i = 0; i < this.dataMembers.size(); ++i) {
                Statistic data = (Statistic)this.dataMembers.get(i);
                if (data == null) continue;
                data.setDataInfo(config);
            }
        }
        if (this.subCollections != null) {
            for (i = 0; i < this.subCollections.size(); ++i) {
                Stats col = (Stats)this.subCollections.get(i);
                if (col == null) continue;
                col.setConfig(config);
            }
        }
    }

    public boolean add(WpdData newMember) {
        return false;
    }

    public boolean add(WpdCollection newMember) {
        if (newMember instanceof Stats) {
            return this.add((Stats)((Object)newMember));
        }
        return false;
    }

    public String toXML() {
        return null;
    }

    public void setDataMembers(ArrayList dataMembers) {
        this.setStatistics(dataMembers);
    }

    public void setSubcollections(ArrayList subCollections) {
        this.setSubStats(subCollections);
    }

    public ArrayList dataMembers() {
        return this.dataMembers;
    }

    public ArrayList subCollections() {
        return this.subCollections;
    }

    public WpdData getData(int dataId) {
        System.err.println("Warning: this method is defunc'ed - call getStatistic(dataId) instead");
        return null;
    }

    public WpdCollection getSubcollection(String name) {
        System.err.println("Warning: this method is defunc'ed - call getStats(name) instead");
        return null;
    }

    public synchronized void update(Stats newStats, boolean keepOld, boolean recursiveUpdate) {
        if (newStats == null) {
            return;
        }
        if (!this.name.equals(newStats.getName()) || this.type != newStats.getType()) {
            return;
        }
        this.myupdate(newStats, keepOld, recursiveUpdate);
    }

    private synchronized void myupdate(Stats newStats, boolean keepOld, boolean recursiveUpdate) {
        if (newStats == null) {
            return;
        }
        this.instrumentationLevel = newStats.getLevel();
        this.updateMembers(newStats, keepOld);
        if (recursiveUpdate) {
            this.updateSubcollection(newStats, keepOld, recursiveUpdate);
        }
    }

    private synchronized void updateMembers(Stats grp, boolean keepOld) {
        if (!keepOld) {
            this.dataMembers = null;
        }
        if (grp == null) {
            return;
        }
        if (this.dataMembers == null || this.dataMembers.size() == 0) {
            this.dataMembers = ((StatsImpl)grp).dataMembers;
        } else {
            Statistic[] otherdata = grp.listStatistics();
            if (otherdata == null || otherdata.length == 0) {
                return;
            }
            for (int i = 0; i < otherdata.length; ++i) {
                boolean found = false;
                Statistic myData = null;
                for (int n = 0; n < this.dataMembers.size(); ++n) {
                    myData = (Statistic)this.dataMembers.get(n);
                    if (otherdata[i].getId() != myData.getId()) continue;
                    found = true;
                    myData.update(otherdata[i]);
                    break;
                }
                if (found) continue;
                this.dataMembers.add(otherdata[i]);
            }
        }
    }

    private synchronized void updateSubcollection(Stats otherStats, boolean keepOld, boolean recursiveUpdate) {
        if (!keepOld) {
            this.subCollections = null;
        }
        if (otherStats == null) {
            return;
        }
        if (this.subCollections == null || this.subCollections.size() == 0) {
            this.subCollections = ((StatsImpl)otherStats).subCollections;
        } else {
            Stats[] newSubStats = otherStats.listSubStats();
            if (newSubStats == null || newSubStats.length == 0) {
                return;
            }
            Stats thisStats = null;
            for (int i = 0; i < newSubStats.length; ++i) {
                boolean found = false;
                int cmp = 0;
                int index = -1;
                for (int j = 0; j < this.subCollections.size(); ++j) {
                    thisStats = (Stats)this.subCollections.get(j);
                    cmp = newSubStats[i].getName().compareTo(thisStats.getName());
                    if (cmp == 0) {
                        found = true;
                        thisStats.update(newSubStats[i], keepOld, recursiveUpdate);
                        break;
                    }
                    if (cmp >= 0) continue;
                    index = i;
                    break;
                }
                if (!found && index > 0) {
                    this.subCollections.add(index, newSubStats[i]);
                    continue;
                }
                if (found || index != -1) continue;
                this.subCollections.add(newSubStats[i]);
            }
        }
    }

    public void resetOnClient(boolean recursive) {
        int i;
        if (this.dataMembers != null) {
            Statistic data = null;
            for (i = 0; i < this.dataMembers.size(); ++i) {
                data = (Statistic)this.dataMembers.get(i);
                data.resetOnClient(null);
            }
        }
        if (!recursive) {
            return;
        }
        if (this.subCollections != null) {
            Stats col = null;
            for (i = 0; i < this.subCollections.size(); ++i) {
                col = (Stats)this.subCollections.get(i);
                col.resetOnClient(recursive);
            }
        }
    }

    protected void initPmiModuleConfig() {
        PmiModuleConfig cfg = StatsConfigHelper.getStatsConfig(this.getStatsType());
        if (cfg != null) {
            this.setConfig(cfg);
        }
    }
}

