/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.pmi.stat.StatDescriptor;
import java.io.Serializable;
import javax.management.ObjectName;

public class MBeanStatDescriptor
implements Serializable {
    public static final long serialVersionUID = 8434304601722208723L;
    ObjectName mName = null;
    StatDescriptor sd = null;

    public MBeanStatDescriptor(ObjectName mName) {
        this(mName, null);
    }

    public MBeanStatDescriptor(ObjectName mName, StatDescriptor sd) {
        this.mName = mName;
        this.sd = sd;
    }

    public ObjectName getObjectName() {
        return this.mName;
    }

    public StatDescriptor getStatDescriptor() {
        return this.sd;
    }

    public boolean isSame(MBeanStatDescriptor msd) {
        if (msd == null || msd.getObjectName() == null || this.mName == null) {
            return false;
        }
        if (!msd.getObjectName().toString().equals(this.mName.toString())) {
            return false;
        }
        if (this.sd == null && msd.getStatDescriptor() == null) {
            return true;
        }
        if (this.sd == null) {
            return false;
        }
        return this.sd.isSame(msd.getStatDescriptor());
    }

    public String getIdentifier() {
        if (this.mName == null) {
            return null;
        }
        if (this.sd == null) {
            return this.mName.getKeyProperty("name") + "///" + this.mName.getKeyProperty("mbeanIdentifier");
        }
        return this.mName.getKeyProperty("name") + "///" + this.mName.getKeyProperty("mbeanIdentifier") + "///" + this.sd.toString();
    }

    public String getName() {
        if (this.mName == null) {
            return null;
        }
        if (this.sd == null) {
            return this.mName.getKeyProperty("name");
        }
        return this.sd.getName();
    }

    public String toString() {
        if (this.mName == null) {
            if (this.sd == null) {
                return null;
            }
            return "///" + this.sd.toString();
        }
        if (this.sd == null) {
            return this.mName.toString();
        }
        return this.mName.toString() + "///" + this.sd.toString();
    }
}

