/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;

public class DoubleStatisticImpl
extends StatisticImpl {
    private static final long serialVersionUID = 6508148569801698815L;
    protected double count = 0.0;
    private DoubleStatisticImpl baseValue = null;

    public DoubleStatisticImpl(int dataId) {
        super(dataId);
    }

    public DoubleStatisticImpl(int dataId, double count, long startTime, long lastSampleTime) {
        super(dataId, null, null, null, startTime, lastSampleTime);
        this.count = count;
    }

    public DoubleStatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        super(id, name, unit, description, startTime, lastSampleTime);
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean resetAll) {
        if (resetAll) {
            super.reset();
        }
        this.count = 0.0;
    }

    public void set(double count, long startTime, long lastSampleTime) {
        this.count = count;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
    }

    public double getDouble() {
        if (this.baseValue == null) {
            return this.count;
        }
        return this.count - this.baseValue.getDouble();
    }

    public void combine(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        DoubleStatisticImpl other = (DoubleStatisticImpl)otherStat;
        this.count += other.count;
    }

    public void setDouble(double value) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        this.count = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += 1.0;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count += 1.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(double val) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += val;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count += val;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= 1.0;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count -= 1.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(double val) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= val;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count -= val;
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer str = new StringBuffer();
        str.append(indent);
        str.append("DoubleStatisticImpl: ");
        str.append(super.toString(""));
        str.append(" count=");
        str.append(this.count);
        return str.toString();
    }

    public void update(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        DoubleStatisticImpl other = (DoubleStatisticImpl)otherStat;
        if (this.baseValue == null) {
            this.count = other.getDouble();
            this.startTime = other.getStartTime();
        } else {
            this.count = other.count - this.baseValue.count;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.lastSampleTime = other.lastSampleTime;
    }

    public Statistic delta(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        DoubleStatisticImpl other = (DoubleStatisticImpl)otherStat;
        DoubleStatisticImpl newData = new DoubleStatisticImpl(this.id);
        newData.count = this.count - other.getDouble();
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    public void resetOnClient(Statistic other) {
        if (other == null) {
            if (this.baseValue == null) {
                this.baseValue = new DoubleStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (!this.validate(other)) {
            this.baseValue = (DoubleStatisticImpl)other;
            this.update(this.baseValue);
        }
    }

    private boolean validate(Statistic other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof DoubleStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be DoubleStatisticImpl");
            return false;
        }
        if (other.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + other.getId());
            return false;
        }
        return true;
    }
}

