/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.PerfLevelSpec;
import com.ibm.ws.pmi.server.ModuleConfigParser;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.ObjectName;

public class PerfModules
implements PmiConstants {
    public static final String[] moduleIDs50;
    public static final String[] moduleIDs40;
    public static String[] moduleIDs;
    private static String modulePrefix;
    private static HashMap moduleConfigs;
    private static ModuleConfigParser parser;
    static final int MODULE_INDEX = 1;
    static final int SUBMODULE_INDEX = 3;
    static final int METHOD_PATH = 5;
    private static final TraceComponent tc;
    private static Exception parseException;
    private static Method mGetPmiModuleConfigMethod;
    private static boolean bEnableStatsTemplateLookup;
    private static ArrayList lookupList;
    private static String ENABLE_PARSING_FLAG;

    private static synchronized void initConfigs() {
        for (int i = 0; i < moduleIDs.length; ++i) {
            PerfModules.getConfigFromXMLFile(PerfModules.getXmlFileName(modulePrefix + moduleIDs[i]), true, false);
        }
    }

    public static PmiModuleConfig getConfig(String moduleID) {
        int hasDot;
        if (moduleID == null) {
            return null;
        }
        PmiModuleConfig config = (PmiModuleConfig)moduleConfigs.get(moduleID);
        if (config == null && (hasDot = moduleID.indexOf(46)) == -1) {
            String preDefinedMod = "com.ibm.websphere.pmi.xml." + moduleID;
            config = PerfModules.getConfigFromXMLFile(PerfModules.getXmlFileName(preDefinedMod), true, false);
        }
        if (config == null) {
            config = PerfModules.getConfigFromXMLFile(PerfModules.getXmlFileName(moduleID), true, true);
        }
        return config;
    }

    public static PmiModuleConfig findConfig(PmiModuleConfig[] configs, String moduleID) {
        if (moduleID == null) {
            return null;
        }
        for (int i = 0; i < configs.length; ++i) {
            if (!configs[i].getUID().equals(moduleID)) continue;
            return configs[i];
        }
        return null;
    }

    public static PmiModuleConfig findConfig(PmiModuleConfig[] configs, ObjectName on) {
        if (on == null) {
            return null;
        }
        String type = on.getKeyProperty("type");
        if (type.equals("Servlet")) {
            type = "WebModule";
        } else if (type.equals("EntityBean") || type.equals("StatefulSessionBean") || type.equals("StatelessSessionBean") || type.equals("MessageDrivenBean")) {
            type = "EJBModule";
        }
        for (int i = 0; i < configs.length; ++i) {
            String mtype = configs[i].getMbeanType();
            if (mtype == null || !mtype.equals(type)) continue;
            return configs[i];
        }
        return null;
    }

    public static synchronized PmiModuleConfig getConfigFromXMLFile(String xmlFilePath, boolean bFromCache, boolean bValidate) {
        PmiModuleConfig config = null;
        String modUID = PerfModules.getModuleUID(xmlFilePath);
        config = (PmiModuleConfig)moduleConfigs.get(modUID);
        if (bFromCache) {
            if (config != null) {
                return config;
            }
        } else if (config != null) {
            return config.copy();
        }
        if (bEnableStatsTemplateLookup) {
            int lookupCount = lookupList.size();
            for (int i = 0; !(i >= lookupCount || (config = ((StatsTemplateLookup)lookupList.get(i)).getTemplate(modUID)) != null || modUID.startsWith("com.ibm.websphere.pmi.xml.") && (config = ((StatsTemplateLookup)lookupList.get(i)).getTemplate(modUID.substring(26))) != null); ++i) {
            }
            if (config != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StatsTemplateLookup available for: " + xmlFilePath);
                }
                config.setMbeanType("");
                moduleConfigs.put(config.getUID(), config);
                if (!bFromCache) {
                    return config.copy();
                }
                return config;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "StatsTemplateLookup NOT available for: " + xmlFilePath);
            }
        }
        final String _xmlFile = xmlFilePath;
        final boolean _bDTDValidation = bValidate;
        parseException = null;
        try {
            config = (PmiModuleConfig)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return parser.parse(_xmlFile, _bDTDValidation);
                }
            });
        }
        catch (PrivilegedActionException e) {
            parseException = e.getException();
        }
        if (config != null) {
            if (bFromCache) {
                config.setMbeanType("");
                moduleConfigs.put(config.getUID(), config);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Read PMI config for stats type: " + config.getUID());
                }
                return config;
            }
            return config.copy();
        }
        return config;
    }

    public static PmiModuleConfig getConfigFromXMLFile(String xmlFilePath) {
        return PerfModules.getConfigFromXMLFile(xmlFilePath, true, true);
    }

    public static PmiModuleConfig[] getConfigs40() {
        int index = modulePrefix.indexOf("xml.");
        if (index > 0) {
            moduleIDs = moduleIDs40;
            modulePrefix = modulePrefix.substring(0, index);
            moduleConfigs = new HashMap();
        }
        PerfModules.initConfigs();
        return PerfModules.getConfigs();
    }

    public static String getDataName(String moduleName, int dataId) {
        PmiModuleConfig config = PerfModules.getConfig(moduleName);
        if (config == null) {
            return null;
        }
        PmiDataInfo info = config.getDataInfo(dataId);
        if (info == null) {
            return null;
        }
        return info.getName();
    }

    public static int getDataId(String moduleName, String dataName) {
        PmiModuleConfig config = PerfModules.getConfig(moduleName);
        if (dataName.indexOf(46) < 0) {
            dataName = moduleName + "." + dataName;
        }
        if (config != null) {
            return config.getDataId(dataName);
        }
        return -1;
    }

    public static PmiModuleConfig[] getConfigs() {
        if (moduleConfigs.size() == 0) {
            PerfModules.initConfigs();
        }
        PmiModuleConfig[] res = new PmiModuleConfig[moduleConfigs.size()];
        Object[] values = moduleConfigs.values().toArray();
        for (int i = 0; i < values.length; ++i) {
            res[i] = (PmiModuleConfig)values[i];
        }
        return res;
    }

    public static synchronized PmiModuleConfig addModuleInfo(String key) {
        return null;
    }

    public static String getGroupName(PerfLevelSpec pld) {
        if (pld == null) {
            return null;
        }
        String moduleName = pld.getModuleName();
        String[] path = pld.getPath();
        if (path != null && path.length > 5 && path[5].equals("beanModule.methods")) {
            return path[5];
        }
        if (path != null && path.length >= 3) {
            if (moduleName.equals("cacheModule") || moduleName.equals("orbPerfModule") || moduleName.equals("wlmModule")) {
                return path[2];
            }
            if (path.length > 3) {
                return path[3];
            }
        }
        return null;
    }

    public static String getXmlFileName(String moduleID) {
        String fileName = "/" + moduleID.replace('.', '/') + ".xml";
        return fileName;
    }

    public static String getModuleUID(String templateName) {
        String ftype = templateName.replace('/', '.');
        if (ftype.charAt(0) == '.') {
            ftype = ftype.substring(1);
        }
        return ftype.substring(0, ftype.length() - 4);
    }

    public static String getParseExceptionMsg() {
        if (parseException != null) {
            return parseException.getMessage();
        }
        return null;
    }

    public static void registerTemplateLookupClass(StatsTemplateLookup lookupClass) {
        lookupList.add(lookupClass);
    }

    static {
        block6: {
            moduleIDs50 = new String[]{"beanModule", "cacheModule", "connectionPoolModule", "j2cModule", "jvmRuntimeModule", "orbPerfModule", "systemModule", "servletSessionsModule", "threadPoolModule", "transactionModule", "webAppModule", "wlmModule", "webServicesModule", "wsgwModule"};
            moduleIDs40 = new String[]{"beanModule", "connectionPoolModule", "jvmRuntimeModule", "jvmpiModule", "servletSessionsModule", "threadPoolModule", "transactionModule", "webAppModule"};
            moduleIDs = moduleIDs50;
            modulePrefix = "com.ibm.websphere.pmi.xml.";
            moduleConfigs = new HashMap();
            parser = new ModuleConfigParser();
            tc = Tr.register(PerfModules.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
            bEnableStatsTemplateLookup = true;
            lookupList = new ArrayList(3);
            ENABLE_PARSING_FLAG = "com.ibm.websphere.pmi.enableModuleConfigParsing";
            String enableParsingFlag = System.getProperty(ENABLE_PARSING_FLAG);
            if (enableParsingFlag != null && enableParsingFlag.equalsIgnoreCase("true")) {
                bEnableStatsTemplateLookup = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "com.ibm.websphere.pmi.enableModuleConfigParsing is enabled. Disabling StatsTemplateLookup.");
                }
            } else {
                bEnableStatsTemplateLookup = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Enabling StatsTemplateLookup.");
                }
                try {
                    Class<?> lookupClass = Class.forName("com.ibm.ws.pmi.preprocess.pmi_StatsTemplateLookup");
                    StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)lookupClass.newInstance());
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "PMI StatsTemplateLookup class not found.");
                }
            }
        }
    }
}

