/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.RasUtil;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsnInitialContextFactory
implements InitialContextFactory {
    private static final TraceComponent _tc = Tr.register(WsnInitialContextFactory.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static String _className;
    private static Constructor _constructor;
    private InitialContextFactory _initCtxFactory = null;

    private static synchronized void initClass(Hashtable<?, ?> env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initClass", "env=" + env);
        }
        if (_constructor == null) {
            Object o = env.get("com.ibm.ws.naming.wsn.factory.initial");
            if (o instanceof String) {
                _className = (String)o;
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "initClass", "implementation class=" + _className);
                }
                Class<?> implClass = null;
                try {
                    implClass = Class.forName(_className);
                    _constructor = implClass.getConstructor(null);
                }
                catch (Throwable t) {
                    RasUtil.logException(t, _tc, CLASS_NAME, "initClass", "121");
                    Tr.warning(_tc, "cannotGetClassObj", _className);
                    String message = "Failed to create Class object for the class " + _className + ".";
                    ConfigurationException ce = new ConfigurationException(message);
                    ce.initCause(t);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "initClass", ce);
                    }
                    throw ce;
                }
                if (!InitialContextFactory.class.isAssignableFrom(implClass)) {
                    _constructor = null;
                    String message = "Class " + _className + " does not implement " + InitialContextFactory.class.getName();
                    ConfigurationException ce = new ConfigurationException(message);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "initClass", ce);
                    }
                    throw ce;
                }
            } else {
                Tr.warning(_tc, "noInitCtxFactoryImpl");
                ConfigurationException ce = new ConfigurationException("The property com.ibm.ws.naming.wsn.factory.initial is not set or is not a string.  The most likely cause is that the jar which contains the file com/ibm/websphere/naming/jndiprovider.properties cannot be found by  the class loader.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "initClass", ce);
                }
                throw ce;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initClass");
        }
    }

    public WsnInitialContextFactory() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>");
        }
        this._initCtxFactory = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext", "env=" + env);
        }
        CommonHelpers.mergeWsnJndiProperties(env);
        if (this._initCtxFactory == null) {
            if (_constructor == null) {
                WsnInitialContextFactory.initClass(env);
            }
            this.initInstance();
        }
        Context ctx = this._initCtxFactory.getInitialContext(env);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInitialContext");
        }
        return ctx;
    }

    private void initInstance() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initInstance");
        }
        try {
            this._initCtxFactory = (InitialContextFactory)_constructor.newInstance(null);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "initInstance", "216", this);
            Tr.warning(_tc, "cannotCreateObj", _className);
            this._initCtxFactory = null;
            String message = "Could not create an instance of the class " + _className + ".";
            ConfigurationException ce = new ConfigurationException(message);
            ce.initCause(t);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "initInstance", ce);
            }
            throw ce;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initInstance");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_className=");
        stringBuilder.append(_className);
        stringBuilder.append(", _initCtxFactory=");
        stringBuilder.append(this._initCtxFactory);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/websphere/naming/WsnInitialContextFactory.java, WAS.naming, WAS70.SERV1, q0834.18, ver. 1.24");
        }
        CLASS_NAME = WsnInitialContextFactory.class.getName();
        _className = null;
        _constructor = null;
    }
}

