/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.descriptor.channel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ChannelKind
extends AbstractEnumerator {
    public static final int CONNECTOR = 0;
    public static final int FILTER = 1;
    public static final int PROTOCOL = 2;
    public static final int ACCEPTOR = 3;
    public static final ChannelKind CONNECTOR_LITERAL = new ChannelKind(0, "CONNECTOR", "CONNECTOR");
    public static final ChannelKind FILTER_LITERAL = new ChannelKind(1, "FILTER", "FILTER");
    public static final ChannelKind PROTOCOL_LITERAL = new ChannelKind(2, "PROTOCOL", "PROTOCOL");
    public static final ChannelKind ACCEPTOR_LITERAL = new ChannelKind(3, "ACCEPTOR", "ACCEPTOR");
    private static final ChannelKind[] VALUES_ARRAY = new ChannelKind[]{CONNECTOR_LITERAL, FILTER_LITERAL, PROTOCOL_LITERAL, ACCEPTOR_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ChannelKind get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ChannelKind result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ChannelKind getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ChannelKind result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ChannelKind get(int value) {
        switch (value) {
            case 0: {
                return CONNECTOR_LITERAL;
            }
            case 1: {
                return FILTER_LITERAL;
            }
            case 2: {
                return PROTOCOL_LITERAL;
            }
            case 3: {
                return ACCEPTOR_LITERAL;
            }
        }
        return null;
    }

    private ChannelKind(int value, String name, String literal) {
        super(value, name, literal);
    }
}

