/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.process.impl;

import com.ibm.websphere.models.config.process.CustomService;
import com.ibm.websphere.models.config.process.ExecutionState;
import com.ibm.websphere.models.config.process.Extension;
import com.ibm.websphere.models.config.process.MessageFormatKind;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.websphere.models.config.process.RolloverType;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ServerInstance;
import com.ibm.websphere.models.config.process.StateManageable;
import com.ibm.websphere.models.config.process.StatisticsProvider;
import com.ibm.websphere.models.config.process.StreamRedirect;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.models.config.process.impl.CustomServiceImpl;
import com.ibm.websphere.models.config.process.impl.ExtensionImpl;
import com.ibm.websphere.models.config.process.impl.ServerImpl;
import com.ibm.websphere.models.config.process.impl.ServerInstanceImpl;
import com.ibm.websphere.models.config.process.impl.StateManageableImpl;
import com.ibm.websphere.models.config.process.impl.StatisticsProviderImpl;
import com.ibm.websphere.models.config.process.impl.StreamRedirectImpl;
import com.ibm.websphere.models.config.process.impl.ThreadPoolImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class ProcessFactoryImpl
extends EFactoryImpl
implements ProcessFactory {
    public static ProcessFactory init() {
        try {
            ProcessFactory theProcessFactory = (ProcessFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
            if (theProcessFactory != null) {
                return theProcessFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new ProcessFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createServer();
            }
            case 2: {
                return this.createCustomService();
            }
            case 3: {
                return this.createThreadPool();
            }
            case 4: {
                return this.createStreamRedirect();
            }
            case 9: {
                return this.createStateManageable();
            }
            case 10: {
                return this.createStatisticsProvider();
            }
            case 11: {
                return this.createExtension();
            }
            case 13: {
                return this.createServerInstance();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.createMessageFormatKindFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createExecutionStateFromString(eDataType, initialValue);
            }
            case 16: {
                return this.createRolloverTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 14: {
                return this.convertMessageFormatKindToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertExecutionStateToString(eDataType, instanceValue);
            }
            case 16: {
                return this.convertRolloverTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Server createServer() {
        ServerImpl server = new ServerImpl();
        return server;
    }

    public CustomService createCustomService() {
        CustomServiceImpl customService = new CustomServiceImpl();
        return customService;
    }

    public ThreadPool createThreadPool() {
        ThreadPoolImpl threadPool = new ThreadPoolImpl();
        return threadPool;
    }

    public StreamRedirect createStreamRedirect() {
        StreamRedirectImpl streamRedirect = new StreamRedirectImpl();
        return streamRedirect;
    }

    public StateManageable createStateManageable() {
        StateManageableImpl stateManageable = new StateManageableImpl();
        return stateManageable;
    }

    public StatisticsProvider createStatisticsProvider() {
        StatisticsProviderImpl statisticsProvider = new StatisticsProviderImpl();
        return statisticsProvider;
    }

    public Extension createExtension() {
        ExtensionImpl extension2 = new ExtensionImpl();
        return extension2;
    }

    public ServerInstance createServerInstance() {
        ServerInstanceImpl serverInstance = new ServerInstanceImpl();
        return serverInstance;
    }

    public MessageFormatKind createMessageFormatKindFromString(EDataType eDataType, String initialValue) {
        MessageFormatKind result = MessageFormatKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertMessageFormatKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ExecutionState createExecutionStateFromString(EDataType eDataType, String initialValue) {
        ExecutionState result = ExecutionState.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertExecutionStateToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RolloverType createRolloverTypeFromString(EDataType eDataType, String initialValue) {
        RolloverType result = RolloverType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRolloverTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ProcessPackage getProcessPackage() {
        return (ProcessPackage)this.getEPackage();
    }

    public static ProcessPackage getPackage() {
        return ProcessPackage.eINSTANCE;
    }
}

