/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.multibroker.drsclient;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class DRSSerializationKind
extends AbstractEnumerator {
    public static final int BYTES = 0;
    public static final int OBJECT = 1;
    public static final DRSSerializationKind BYTES_LITERAL = new DRSSerializationKind(0, "BYTES", "BYTES");
    public static final DRSSerializationKind OBJECT_LITERAL = new DRSSerializationKind(1, "OBJECT", "OBJECT");
    private static final DRSSerializationKind[] VALUES_ARRAY = new DRSSerializationKind[]{BYTES_LITERAL, OBJECT_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static DRSSerializationKind get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DRSSerializationKind result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DRSSerializationKind getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DRSSerializationKind result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DRSSerializationKind get(int value) {
        switch (value) {
            case 0: {
                return BYTES_LITERAL;
            }
            case 1: {
                return OBJECT_LITERAL;
            }
        }
        return null;
    }

    private DRSSerializationKind(int value, String name, String literal) {
        super(value, name, literal);
    }
}

