/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.init;

import com.ibm.websphere.models.config.init.ConfigInitDebug;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CompatibilityRegistry {
    public static CompatibilityRegistry singleton;
    protected Map compatibilityMapping = new HashMap();
    public static final int PREFIX_OFFSET = 0;
    public static final int NS_URI_OFFSET = 1;

    public static CompatibilityRegistry getInstance() {
        if (singleton == null) {
            singleton = new CompatibilityRegistry();
        }
        return singleton;
    }

    protected CompatibilityRegistry() {
    }

    protected Map getCompatibilityMapping() {
        return this.compatibilityMapping;
    }

    public Iterator getPackagePrefixes() {
        return this.getCompatibilityMapping().keySet().iterator();
    }

    public String getNamespaceURI(String prefix) {
        return (String)this.getCompatibilityMapping().get(prefix);
    }

    public void register(String[][] mappingData) {
        boolean isDebugEnabled = ConfigInitDebug.getDebugEnabled();
        if (isDebugEnabled) {
            CompatibilityRegistry.debug("Registering package compatibility data:");
            CompatibilityRegistry.debug("Registration has [ " + mappingData.length + " ] elements.");
        }
        Map useMapping = this.getCompatibilityMapping();
        for (int mappingNo = 0; mappingNo < mappingData.length; ++mappingNo) {
            String nextPrefix = mappingData[mappingNo][0];
            String nextURI = mappingData[mappingNo][1];
            if (isDebugEnabled) {
                CompatibilityRegistry.debug(" [ " + mappingNo + " ]: [ " + nextPrefix + " ] [ " + nextURI + " ]");
                String priorURI = (String)useMapping.get(nextPrefix);
                if (priorURI != null) {
                    if (priorURI.equals(nextURI)) {
                        CompatibilityRegistry.debug("Warning: Redunandant registration");
                    } else {
                        CompatibilityRegistry.debug("Warning: Override registration");
                        CompatibilityRegistry.debug("The prior registration was [ " + nextPrefix + " ] to [ " + priorURI + " ]");
                    }
                }
            }
            useMapping.put(nextPrefix, nextURI);
        }
    }

    public static void debug(String text) {
        ConfigInitDebug.debug(CompatibilityRegistry.class.getName(), text);
    }

    public static void debug(String text, Object arg) {
        ConfigInitDebug.debug(CompatibilityRegistry.class.getName(), text, arg);
    }

    public static void dumpStack(String text) {
        ConfigInitDebug.dumpStack(CompatibilityRegistry.class.getName(), text);
    }

    static {
        CompatibilityRegistry.debug("Class Initialization");
    }
}

