/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.init;

import com.ibm.websphere.models.config.init.CompatibilityRegistry;
import com.ibm.websphere.models.config.init.ConfigInitDebug;

public class CompatibilityInit {
    protected static boolean initialized;
    protected static final String[][] COMPATIBILITY_MAPPING_DATA;

    public static boolean getInitialized() {
        return initialized;
    }

    public static synchronized void init() {
        CompatibilityInit.debug("Model initialization ...");
        if (initialized) {
            CompatibilityInit.debug("Model initialization ... already complete");
            return;
        }
        CompatibilityInit.populateCompatibilityRegistry();
        initialized = true;
        CompatibilityInit.debug("Model initialization ... complete");
    }

    public static String[][] getCompatibilityData() {
        return COMPATIBILITY_MAPPING_DATA;
    }

    public static void populateCompatibilityRegistry() {
        CompatibilityRegistry.getInstance().register(CompatibilityInit.getCompatibilityData());
    }

    public static void debug(String text) {
        ConfigInitDebug.debug(CompatibilityInit.class.getName(), text);
    }

    public static void debug(String text, Object arg) {
        ConfigInitDebug.debug(CompatibilityInit.class.getName(), text, arg);
    }

    public static void dumpStack(String text) {
        ConfigInitDebug.dumpStack(CompatibilityInit.class.getName(), text);
    }

    static {
        CompatibilityInit.debug("Class Initialization");
        initialized = false;
        COMPATIBILITY_MAPPING_DATA = new String[][]{{"appcfg", "http://www.ibm.com/websphere/appserver/schemas/5.0/appcfg.xmi"}, {"appdeployment", "http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi"}, {"applicationserver", "http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi"}, {"applicationserver.ejbcontainer", "http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.ejbcontainer.xmi"}, {"applicationserver.ejbcontainer.messagelistener", "http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.ejbcontainer.messagelistener.xmi"}, {"datareplicationserver", "http://www.ibm.com/websphere/appserver/schemas/5.0/datareplicationserver.xmi"}, {"ipc", "http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.xmi"}, {"pmiservice", "http://www.ibm.com/websphere/appserver/schemas/5.0/pmiservice.xmi"}, {"process", "http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi"}, {"processexec", "http://www.ibm.com/websphere/appserver/schemas/5.0/processexec.xmi"}, {"jaaslogin", "http://www.ibm.com/websphere/appserver/schemas/5.0/jaaslogin.xmi"}, {"resources", "http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi"}, {"resources.j2c", "http://www.ibm.com/websphere/appserver/schemas/5.0/resources.j2c.xmi"}, {"resources.jms", "http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.xmi"}, {"resources.jms.mqseries", "http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.mqseries.xmi"}, {"resources.mail", "http://www.ibm.com/websphere/appserver/schemas/5.0/resources.mail.xmi"}, {"scheduler", "http://www.ibm.com/websphere/appserver/schemas/5.0/scheduler.xmi"}, {"pmirm", "http://www.ibm.com/websphere/appserver/schemas/5.0/pmirm.xmi"}, {"dynacache", "http://www.ibm.com/websphere/appserver/schemas/5.0.2/dynacache.xmi"}, {"pmecluster", "http://www.ibm.com/websphere/appserver/schemas/5.0.2/pmecluster.xmi"}, {"wlmadvisor", "http://www.ibm.com/websphere/appserver/schemas/5.0.2/wlmadvisor.xmi"}, {"security", "http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi"}, {"serverindex", "http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi"}, {"topology", "http://www.ibm.com/websphere/appserver/schemas/5.0/topology.xmi"}, {"topology.cell", "http://www.ibm.com/websphere/appserver/schemas/5.0/topology.cell.xmi"}, {"topology.cluster", "http://www.ibm.com/websphere/appserver/schemas/5.0/topology.cluster.xmi"}, {"topology.node", "http://www.ibm.com/websphere/appserver/schemas/5.0/topology.node.xmi"}};
    }
}

