/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import com.ibm.ws.management.configservice.ConfigServiceFactoryInitializer;
import java.util.Properties;

public class ConfigServiceFactory {
    private static TraceComponent tc = Tr.register(ConfigServiceFactory.class, "management", "com.ibm.ws.management.resources.configservice");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");

    public static ConfigService createConfigService(boolean enable, Properties props) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigService");
        }
        ConfigService service = ConfigServiceFactoryInitializer.createConfigService(enable, props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigService", service);
        }
        return service;
    }

    public static synchronized ConfigService getConfigService() {
        ConfigService service;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigService");
        }
        if ((service = ConfigServiceFactoryInitializer.getConfigService()) == null) {
            return service;
        }
        String adminType = AdminServiceFactoryInitializer.getAdminType();
        if ("AdminAgent".equals(adminType)) {
            service = ConfigServiceFactoryInitializer.getProxy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigService", service);
        }
        return service;
    }
}

