/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.task;

import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractTask {
    private static final String defaultBundleName = "com.ibm.ws.management.resources.AppDeploymentMessages";
    protected Locale locale;
    protected String appTaskName = "xxx";
    protected ResourceBundle bundle;
    protected Scheduler scheduler;

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public void setAppTaskName(String s) {
        this.appTaskName = s;
    }

    protected String getResourceBundleName() {
        return defaultBundleName;
    }

    public void setScheduler(Scheduler sc) {
        this.scheduler = sc;
    }

    protected ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = AppUtils.getBundle(this.getResourceBundleName(), this.locale);
        }
        return this.bundle;
    }

    public abstract boolean performTask() throws AdminException;

    protected String getShortName() {
        String n = this.getClass().getName();
        return n.substring(n.lastIndexOf(46) + 1);
    }

    protected AppNotification createNotification(String subStatus, String msgKey, Object[] args) {
        String msg = AppUtils.getMessage(this.getResourceBundle(), msgKey, args);
        return new AppNotification(this.appTaskName, this.getShortName(), "InProgress", subStatus, msg);
    }

    protected AppNotification createTranslatedNotification(String subStatus, String msg, Object[] args) {
        return new AppNotification(this.appTaskName, this.getShortName(), "InProgress", subStatus, msg);
    }
}

