/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.ws.management.util.RasUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARExpander {
    private static TraceComponent tc = Tr.register(EARExpander.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String OPTION_EAR = "-ear";
    private static final String OPTION_OPERATION = "-operation";
    private static final String OPTION_OPERATION_DIR = "-operationdir";
    private static final String OPTION_EXPANSION_FLAGS = "-expansionflags";
    private static final String OPTION_VERBOSE = "-verbose";
    private static final String OPERATION_EXPAND = "expand";
    private static final String OPERATION_COLLAPSE = "collapse";
    private static final String EXPANSION_FLAGS_ALL = "all";
    private static final String EXPANSION_FLAGS_WAR = "war";
    private static final ResourceBundle resBundle;
    private static final Set<String> VALID_OPTIONS;
    private static final Set<String> VALUE_REQUIRED;
    private final String _ear;
    private final String _operationDirectory;
    private final String _expansionFlags;
    private final boolean _verbose;
    private int _exitCode = 0;

    public EARExpander(String ear, String operationDir, String expansionFlags) {
        this(ear, operationDir, expansionFlags, false);
    }

    public EARExpander(String ear, String operationDir, String expansionFlags, boolean verbose) {
        this._ear = ear;
        this._operationDirectory = operationDir;
        this._expansionFlags = expansionFlags;
        this._verbose = verbose;
    }

    protected static String usage() {
        return EARExpander.getMessage("ADMA4001I");
    }

    protected static String getMessage(String key) {
        String message = key;
        if (resBundle != null) {
            try {
                message = resBundle.getString(key);
            }
            catch (MissingResourceException e) {
                RasUtils.logException(e, tc, CLASS_NAME, "getMessage", "125");
                message = key;
            }
        }
        return message;
    }

    protected static String getMessage(String key, Object[] args) {
        String message = EARExpander.getMessage(key);
        if (args != null) {
            message = MessageFormat.format(message, args);
        }
        return message;
    }

    protected static void printCommandErrorAndExit(String key, Object[] args) {
        System.err.println(EARExpander.getMessage(key, args));
        System.err.println(EARExpander.usage());
        System.exit(-1);
    }

    protected static void printErrorAndExit(String key, Object[] args) {
        System.err.println(EARExpander.getMessage(key, args));
        System.exit(-1);
    }

    public static void main(String[] args) {
        String operation;
        Map<String, String> cmdLineArgs = EARExpander.parseCommandLineArgs(args);
        if (!cmdLineArgs.containsKey(OPTION_EAR)) {
            EARExpander.printCommandErrorAndExit("ADMA4002E", new Object[]{OPTION_EAR.substring(1)});
        }
        if (!cmdLineArgs.containsKey(OPTION_OPERATION_DIR)) {
            EARExpander.printCommandErrorAndExit("ADMA4002E", new Object[]{OPTION_OPERATION_DIR.substring(1)});
        }
        if (!cmdLineArgs.containsKey(OPTION_OPERATION)) {
            EARExpander.printCommandErrorAndExit("ADMA4002E", new Object[]{OPTION_OPERATION.substring(1)});
        }
        if ((operation = cmdLineArgs.get(OPTION_OPERATION)).equalsIgnoreCase(OPERATION_EXPAND) || operation.equalsIgnoreCase(OPERATION_COLLAPSE)) {
            String ear = cmdLineArgs.get(OPTION_EAR);
            String operationDir = cmdLineArgs.get(OPTION_OPERATION_DIR);
            String expansionFlags = cmdLineArgs.get(OPTION_EXPANSION_FLAGS);
            boolean verbose = cmdLineArgs.containsKey(OPTION_VERBOSE);
            EARExpander expander = new EARExpander(ear, operationDir, expansionFlags, verbose);
            if (operation.equalsIgnoreCase(OPERATION_EXPAND)) {
                expander.expand();
            } else {
                expander.collapse();
            }
            if (expander._exitCode == -1) {
                System.exit(-1);
            }
        } else {
            EARExpander.printCommandErrorAndExit("ADMA4005E", new Object[]{operation});
        }
    }

    private static Map<String, String> parseCommandLineArgs(String[] args) {
        HashMap<String, String> cmdLineArgs = new HashMap<String, String>();
        int index = 0;
        while (index < args.length) {
            String arg = args[index];
            String normalizedArg = arg.toLowerCase();
            if (!VALID_OPTIONS.contains(normalizedArg)) {
                System.out.println(EARExpander.usage());
                System.exit(-1);
            }
            ++index;
            String value = "";
            if (VALUE_REQUIRED.contains(normalizedArg)) {
                if (index < args.length) {
                    value = args[index];
                    ++index;
                } else {
                    EARExpander.printCommandErrorAndExit("ADMA4008E", new Object[]{arg.substring(1)});
                }
            }
            cmdLineArgs.put(normalizedArg, value);
        }
        return cmdLineArgs;
    }

    private static void closeEarFile(EARFile earFile) {
        if (earFile != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "closeEarFile", "closing EARFile");
            }
            earFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void expand() {
        File file = new File(this._ear);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            EARExpander.printErrorAndExit("ADMA4003E", new Object[]{this._ear});
        }
        if ((file = new File(this._operationDirectory)).exists() && file.isFile()) {
            EARExpander.printErrorAndExit("ADMA4004E", new Object[]{this._operationDirectory});
        }
        int extractOptions = 126;
        if (this._expansionFlags != null) {
            if (this._expansionFlags.equalsIgnoreCase(EXPANSION_FLAGS_WAR)) {
                extractOptions = 2;
            } else if (!this._expansionFlags.equalsIgnoreCase(EXPANSION_FLAGS_ALL)) {
                System.out.println(EARExpander.getMessage("ADMA4009W", new Object[]{this._expansionFlags}));
            }
        }
        EARFile earFile = null;
        try {
            try {
                System.out.println(EARExpander.getMessage("ADMA4006I", new Object[]{this._ear, this._operationDirectory}));
                earFile = EarUtils.getEarFile((String)this._ear, (boolean)false);
                EarUtils.extractEar((EARFile)earFile, (String)this._operationDirectory, (boolean)false, (int)extractOptions);
            }
            catch (Exception e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, OPERATION_EXPAND, "252", this);
                System.err.println(EARExpander.getMessage("ADMA4013E", new Object[]{e.toString()}));
                if (this._verbose) {
                    e.printStackTrace(System.err);
                }
                this._exitCode = -1;
                Object var6_5 = null;
                EARExpander.closeEarFile(earFile);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            EARExpander.closeEarFile(earFile);
            throw throwable;
        }
        EARExpander.closeEarFile(earFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void collapse() {
        File file = new File(this._operationDirectory);
        if (!file.exists() || !file.isDirectory()) {
            EARExpander.printErrorAndExit("ADMA4004E", new Object[]{this._operationDirectory});
        }
        EARFile earFile = null;
        try {
            try {
                file = new File(this._ear);
                if (file.exists()) {
                    file.delete();
                }
                System.out.println(EARExpander.getMessage("ADMA4007I", new Object[]{this._operationDirectory, this._ear}));
                CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
                Archive archive = factory.openArchive(this._operationDirectory);
                if (archive instanceof EARFile) {
                    earFile = (EARFile)archive;
                    earFile.saveAs(this._ear);
                }
                System.out.println(EARExpander.getMessage("ADMA4004E", new Object[]{this._operationDirectory}));
            }
            catch (Exception e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, OPERATION_COLLAPSE, "286", this);
                System.err.println(EARExpander.getMessage("ADMA4014E", new Object[]{e.toString()}));
                if (this._verbose) {
                    e.printStackTrace(System.err);
                }
                this._exitCode = -1;
                Object var6_7 = null;
                EARExpander.closeEarFile(earFile);
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            EARExpander.closeEarFile(earFile);
            throw throwable;
        }
        EARExpander.closeEarFile(earFile);
    }

    protected int getExitCode() {
        return this._exitCode;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/commands/EARExpander.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.6.1.1");
        }
        CLASS_NAME = EARExpander.class.getName();
        resBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
        VALID_OPTIONS = new HashSet<String>();
        VALID_OPTIONS.add(OPTION_EAR);
        VALID_OPTIONS.add(OPTION_OPERATION_DIR);
        VALID_OPTIONS.add(OPTION_OPERATION);
        VALID_OPTIONS.add(OPTION_EXPANSION_FLAGS);
        VALID_OPTIONS.add(OPTION_VERBOSE);
        VALUE_REQUIRED = new HashSet<String>();
        VALUE_REQUIRED.add(OPTION_EAR);
        VALUE_REQUIRED.add(OPTION_OPERATION_DIR);
        VALUE_REQUIRED.add(OPTION_OPERATION);
        VALUE_REQUIRED.add(OPTION_EXPANSION_FLAGS);
    }
}

