/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.ResourceMapperDefaultImpl;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceValidationHelper {
    private static final TraceComponent tc = Tr.register(ResourceValidationHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final String CLUSTER_MEMBER_ATTR = "memberName";
    public static final String CLUSTER_NODE_ATTR = "nodeName";
    private static final String WEBSPHERE_DOMAIN = "WebSphere:";
    private static final String RES_CONFIG_OBJECT = "resource.config.object";
    private static final String EMBEDDED_CONFIG_SCOPE = "WebSphere:scope=EmbeddedAppConfig";
    private static final String EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE = "WebSphere:scope=EmbeddedRarResource";
    private static final String EMBEDDED_RAR_RESOURCE_NO_URI = "noUriForEmbeddedRarTaskResource";
    private static final String VALIDATION_TASK_DATA_KEY = "resource.validation.invalidate.task.data";
    private static final String VALIDATION_MESSAGE_KEY = "resource.validation.invalidate.message";
    private static final String CLUSTER_XML = "cluster.xml";
    private static final Hashtable _mapPropertyTable;
    private AppDeploymentController _controller;
    private ResourceMapperDefaultImpl _resMapper;
    private String _operation;
    private String _sessionId;
    private List _configFilesToLoad;
    private List _inAppConfigFilesToLoad;
    private Hashtable _scopeToModuleTbl;
    private Hashtable _moduleToScopeTbl;
    private Hashtable _scopeToResourceTbl;
    private Hashtable _valueToResourceTbl;
    private Hashtable _taskToTypeTbl;
    private Hashtable _clusterToMemberTbl;

    public static void addToScopeResultTable(String type, EObject refO, Hashtable result) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToScopeResultTable", new Object[]{type, refO, result});
        }
        List<EObject> values = new ArrayList<EObject>();
        if (result.containsKey(type)) {
            values = (List)result.get(type);
        }
        values.add(refO);
        result.put(type, values);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToScopeResultTable");
        }
    }

    public static String buildTargetString(List scopes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildTargetString", new Object[]{scopes});
        }
        StringBuffer targets = new StringBuffer();
        for (int i = 0; i < scopes.size(); ++i) {
            if (i > 0) {
                targets.append("+");
            }
            targets.append((String)scopes.get(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildTargetString", new Object[]{targets.toString()});
        }
        return targets.toString();
    }

    public static int getMatchingColIndex(AppDeploymentTask task, String matchingColName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchingColIndex", new Object[]{task, matchingColName});
        }
        int colIndex = -1;
        String[] colNames = task.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            if (!matchingColName.equals(colNames[i])) continue;
            colIndex = i;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchingColIndex", new Object[]{new Integer(colIndex)});
        }
        return colIndex;
    }

    public static String[][] getExpandedTaskData(AppDeploymentTask task) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpandedTaskData", new Object[]{task});
        }
        String[][] taskData = task.getAppDeploymentController().getModifiedTaskData(task.getName(), task.getTaskData());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpandedTaskData", new Object[]{taskData});
        }
        return taskData;
    }

    public ResourceValidationHelper(String earFile, String sessionId, Hashtable prefs, String operation, boolean init) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ResourceValidationHelper", new Object[]{earFile, sessionId, prefs});
        }
        this._controller = AppManagementFactory.readArchive(earFile, prefs);
        if (this._controller != null) {
            this._controller.getAppOptions().putAll(prefs);
        }
        if (init) {
            this._init(sessionId, operation);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ResourceValidationHelper");
        }
    }

    public ResourceValidationHelper(AppDeploymentController controller, String sessionId, String operation, boolean init) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ResourceValidationHelper", new Object[]{controller, sessionId, operation});
        }
        this._controller = controller;
        if (init) {
            this._init(sessionId, operation);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ResourceValidationHelper");
        }
    }

    public void init() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this._init(this._sessionId, this._operation);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void init(String operation) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{operation});
        }
        this._init(this._sessionId, operation);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public List getResourceJNDINames(String resType) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceJNDINames", new Object[]{resType});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        ArrayList jndiNames = new ArrayList();
        Enumeration scopes = this._scopeToResourceTbl.keys();
        while (scopes.hasMoreElements()) {
            Hashtable resTypes = (Hashtable)this._scopeToResourceTbl.get((String)scopes.nextElement());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resTypes: " + resTypes);
            }
            if (resTypes == null || !resTypes.containsKey(resType)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resType for type " + resType + ": " + resTypes.get(resType));
            }
            List values = this._getResourceKeyValues(resType, (List)resTypes.get(resType));
            this._addObjectsToList(values, jndiNames);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceJNDINames", new Object[]{jndiNames});
        }
        return jndiNames;
    }

    public Hashtable getResourceObjectsWithRefKeys(String moduleUri, String resType) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceObjectsWithRefKeys", new Object[]{moduleUri, resType});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable resObjectsWithValues = this._getResourceObjectsWithRefKeys(moduleUri, resType, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceObjectsWithRefKeys", new Object[]{resObjectsWithValues});
        }
        return resObjectsWithValues;
    }

    public Hashtable taskResourceValidation(String taskName) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "taskResourceValidation", new Object[]{taskName});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable ret = (Hashtable)this._taskResourceValidation(taskName, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "taskResourceValidation", new Object[]{ret});
        }
        return ret;
    }

    public Vector appResourceValidation() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appResourceValidation");
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Vector invalidResMsgs = new Vector();
        String[] taskNames = this._controller.getAppDeploymentTaskNames();
        for (int i = 0; i < taskNames.length; ++i) {
            List msgs = (List)this._taskResourceValidation(taskNames[i], true);
            if (msgs == null || msgs.size() <= 0) continue;
            invalidResMsgs.addAll(msgs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appResourceValidation", new Object[]{invalidResMsgs});
        }
        return invalidResMsgs;
    }

    public Hashtable getAppResourceObjects() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppResourceObjects");
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable resObjects = new Hashtable();
        String[] taskNames = this._controller.getAppDeploymentTaskNames();
        for (int i = 0; i < taskNames.length; ++i) {
            AppDeploymentTask task = this._controller.getTaskByName(taskNames[i], false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Proccessing task " + taskNames[i] + ": " + task);
            }
            if (task.isTaskEmpty()) continue;
            String[][] taskData = ResourceValidationHelper.getExpandedTaskData(task);
            for (int j = 1; j < taskData.length; ++j) {
                Hashtable resConfigObject = this._getResourceConfigObject(task, j);
                Enumeration enumeration = resConfigObject.elements();
                while (enumeration.hasMoreElements()) {
                    Hashtable typeToConfigObjectTbl = (Hashtable)enumeration.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "typeToConfigObjectTbl: " + typeToConfigObjectTbl);
                    }
                    Enumeration types2 = typeToConfigObjectTbl.keys();
                    while (types2.hasMoreElements()) {
                        String type = (String)types2.nextElement();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processing type " + type);
                        }
                        Object configObject = typeToConfigObjectTbl.get(type);
                        List typeObjectList = new ArrayList();
                        if (resObjects.containsKey(type)) {
                            typeObjectList = (List)resObjects.get(type);
                        }
                        if (!typeObjectList.contains(configObject)) {
                            typeObjectList.add(configObject);
                        }
                        resObjects.put(type, typeObjectList);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppResourceObjects", new Object[]{resObjects});
        }
        return resObjects;
    }

    private Hashtable getResourceObjectsWithRefKeys(String resType) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceObjectsWithRefKeys", new Object[]{resType});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable resObjectsWithValues = new Hashtable();
        Enumeration scopes = this._scopeToResourceTbl.keys();
        while (scopes.hasMoreElements()) {
            Hashtable resTypes = (Hashtable)this._scopeToResourceTbl.get((String)scopes.nextElement());
            if (resTypes == null) continue;
            if (resTypes.containsKey(resType)) {
                List eObjects = (List)resTypes.get(resType);
                Hashtable valueWithObjTbl = this._resMapper.getResourceValuesWithObjects(resType, eObjects);
                this._addObjectsToTbl(valueWithObjTbl, resObjectsWithValues);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "scope does not obtain any resource object of type " + resType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceObjectsWithRefKeys", new Object[]{resObjectsWithValues});
        }
        return resObjectsWithValues;
    }

    private Hashtable getResourceConfigObject(String taskName, int rowIndex) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceConfigObject", new Object[]{taskName, new Integer(rowIndex)});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable configObjectNames = this._getResourceConfigObject(this._controller.getTaskByName(taskName, false), rowIndex);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceConfigObject", new Object[]{configObjectNames});
        }
        return configObjectNames;
    }

    private void _checkInit() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_checkInit");
        }
        if (this._scopeToResourceTbl == null) {
            throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0163E"), null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_checkInit");
        }
    }

    private Hashtable _getResourceConfigObject(AppDeploymentTask task, int rowIndex) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceConfigObject", new Object[]{task, new Integer(rowIndex)});
        }
        Hashtable<Integer, Hashtable> configObjectTbl = new Hashtable<Integer, Hashtable>();
        if (task != null) {
            if (!task.isTaskEmpty()) {
                String[][] taskData = ResourceValidationHelper.getExpandedTaskData(task);
                if (taskData.length <= rowIndex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Incorrect row index");
                    }
                    throw new AppDeploymentException("Incorrect row index passed in: " + rowIndex, null);
                }
                List types2 = this._resMapper.getTypesForTask(task, taskData[rowIndex]);
                Hashtable colValueTbl = this._resMapper.getColumnValue(task, taskData[rowIndex]);
                Enumeration colValueEnum = colValueTbl.keys();
                while (colValueEnum.hasMoreElements()) {
                    Integer colIndex = (Integer)colValueEnum.nextElement();
                    String colValue = (String)colValueTbl.get(colIndex);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing col index: " + colIndex + " with col value: " + colValue);
                    }
                    ArrayList<String> scopes = new ArrayList<String>();
                    scopes.add(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE);
                    ArrayList<String> configFiles = new ArrayList<String>();
                    configFiles.add(EMBEDDED_RAR_RESOURCE_NO_URI);
                    Hashtable configObjectNames = this._getResourceConfigObject(scopes, configFiles, types2, colValue, false);
                    if (configObjectNames.size() == 0) {
                        scopes.clear();
                        scopes.add(EMBEDDED_CONFIG_SCOPE);
                        configObjectNames = this._getResourceConfigObject(scopes, this._inAppConfigFilesToLoad, types2, colValue, false);
                    }
                    if (configObjectNames.size() == 0) {
                        List moduleScopes = this._getScopeForUri(task, taskData[rowIndex]);
                        configObjectNames = this._getResourceConfigObject(moduleScopes, this._configFilesToLoad, types2, colValue, true);
                    }
                    if (configObjectNames.size() <= 0) continue;
                    configObjectTbl.put(colIndex, configObjectNames);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task is empty");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Task is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceConfigObject", new Object[]{configObjectTbl});
        }
        return configObjectTbl;
    }

    private Hashtable _getResourceObjectsWithRefKeys(String moduleUri, String resType, boolean processEmbeddedConfig) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceObjectsWithRefKeys", new Object[]{moduleUri, resType, new Boolean(processEmbeddedConfig)});
        }
        Hashtable resObjectsWithValues = new Hashtable();
        moduleUri = moduleUri.replace(',', '+');
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleUri: " + moduleUri);
        }
        List moduleScopes = (List)this._moduleToScopeTbl.get(moduleUri);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleScopes: " + moduleScopes);
        }
        if ((resObjectsWithValues = this._getResourceObjectsWithRefKeys(moduleScopes, resType, processEmbeddedConfig)) != null && resObjectsWithValues.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getting node version info from each scope");
            }
            Hashtable scopeToNodeTbl = new Hashtable();
            for (int i = 0; i < moduleScopes.size(); ++i) {
                Properties scopeProp = this._getKeyProperties((String)moduleScopes.get(i));
                if (scopeProp.get("node") != null) {
                    Hashtable nodeCelLTbl = new Hashtable();
                    try {
                        scopeToNodeTbl.put(moduleScopes.get(i), AppUtils.getNodeMajorVersion((String)scopeProp.get("cell"), (String)scopeProp.get("node")));
                        continue;
                    }
                    catch (AdminException ae) {
                        RasUtils.logException((Throwable)ae, tc, CLASS_NAME, "_getResourceObjectsWithRefKeys", "639", this);
                        throw new AppDeploymentException("", ae);
                    }
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Scope " + scopeProp + " does not contain node");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeToNodeTbl: " + scopeToNodeTbl);
            }
            this._resMapper.resourceObjectsPostProcessing(scopeToNodeTbl, resType, resObjectsWithValues);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceObjectsWithRefKeys", new Object[]{resObjectsWithValues});
        }
        return resObjectsWithValues;
    }

    private Hashtable _getResourceObjectsWithRefKeys(List moduleScopes, String resType, boolean processEmbeddedConfig) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceObjectsWithRefKeys", new Object[]{moduleScopes, resType, new Boolean(processEmbeddedConfig)});
        }
        Hashtable commonResObjectsWithValues = new Hashtable();
        ArrayList<Hashtable> resObjectsWithValues = new ArrayList<Hashtable>();
        for (int i = 0; i < moduleScopes.size(); ++i) {
            Hashtable oneScopeResObjectsWithValues = this._getResourceObjectsWithRefKeysForOneScope((String)moduleScopes.get(i), resType, processEmbeddedConfig);
            Hashtable commonClusterResObjectsWithValues = this._getCommonClusterResObjectsWithValues((String)moduleScopes.get(i), resType);
            if (commonClusterResObjectsWithValues != null && commonClusterResObjectsWithValues.size() > 0) {
                this._addObjectsToTbl(commonClusterResObjectsWithValues, oneScopeResObjectsWithValues);
            }
            if (oneScopeResObjectsWithValues != null && oneScopeResObjectsWithValues.size() > 0) {
                resObjectsWithValues.add(oneScopeResObjectsWithValues);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding resource table " + oneScopeResObjectsWithValues + " for scope " + moduleScopes.get(i));
                continue;
            }
            resObjectsWithValues.clear();
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "No resource of the type is found in scope " + moduleScopes.get(i) + " - clear the scope resource table and get out");
            break;
        }
        if (resObjectsWithValues.size() > 0) {
            commonResObjectsWithValues = this._getResObjectsWithCommonValues(resObjectsWithValues);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceObjectsWithRefKeys", new Object[]{commonResObjectsWithValues});
        }
        return commonResObjectsWithValues;
    }

    private Hashtable _getResourceObjectsWithRefKeysForOneScope(String scope, String resType, boolean processEmbeddedConfig) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceObjectsWithRefKeysForOneScope", new Object[]{scope, resType, new Boolean(processEmbeddedConfig)});
        }
        Hashtable resObjectsWithValues = new Hashtable();
        if (scope != null && scope.length() > 0) {
            Hashtable parentResObjectsWithValues;
            String parents;
            ArrayList<String> moduleScopes = new ArrayList<String>();
            moduleScopes.add(scope);
            if (processEmbeddedConfig) {
                moduleScopes.add(0, EMBEDDED_CONFIG_SCOPE);
                moduleScopes.add(1, EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "moduleScopes with embedded config scope: " + moduleScopes);
                }
            }
            for (int i = 0; i < moduleScopes.size(); ++i) {
                Hashtable scopeToResObjTbl = new Hashtable();
                ArrayList<String> types2 = new ArrayList<String>();
                types2.add(resType);
                scopeToResObjTbl = EMBEDDED_CONFIG_SCOPE.equals((String)moduleScopes.get(i)) ? this._buildScopeResTypeTbl((String)moduleScopes.get(i), types2, this._inAppConfigFilesToLoad, false) : (EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE.equals((String)moduleScopes.get(i)) ? this._getEmbeddedRarResource(types2) : this._buildScopeResTypeTbl((String)moduleScopes.get(i), types2, this._configFilesToLoad, false));
                Enumeration scopeKeys = scopeToResObjTbl.keys();
                while (scopeKeys.hasMoreElements()) {
                    Hashtable resTypes = (Hashtable)scopeToResObjTbl.get((String)scopeKeys.nextElement());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resTypes: " + resTypes);
                    }
                    if (resTypes == null) continue;
                    if (resTypes.containsKey(resType)) {
                        List eObjects = (List)resTypes.get(resType);
                        Hashtable valueWithObjTbl = this._resMapper.getResourceValuesWithObjects(resType, eObjects);
                        this._addObjectsToTbl(valueWithObjTbl, resObjectsWithValues);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "scope does not obtain any resource object of type " + resType);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "seaching in parent scope");
            }
            if (processEmbeddedConfig) {
                moduleScopes.remove(EMBEDDED_CONFIG_SCOPE);
                moduleScopes.remove(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "moduleScopes with embedded config scope removed: " + moduleScopes);
                }
            }
            if ((parents = this._getParentInScope(scope)) != null && parents.length() > 0 && (parentResObjectsWithValues = this._getResourceObjectsWithRefKeysForOneScope(parents, resType, false)).size() > 0) {
                this._addObjectsToTbl(parentResObjectsWithValues, resObjectsWithValues);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceObjectsWithRefKeysForOneScope", new Object[]{resObjectsWithValues});
        }
        return resObjectsWithValues;
    }

    private Hashtable _getCommonClusterResObjectsWithValues(String moduleScopes, String resType) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getCommonClusterResObjectsWithValues", new Object[]{moduleScopes});
        }
        Hashtable commonClusterResObjectsWithValues = new Hashtable();
        List clusterMemberList = this._checkForClusterScope(moduleScopes);
        if (clusterMemberList != null && clusterMemberList.size() > 0) {
            commonClusterResObjectsWithValues = this._getResourceObjectsWithRefKeys(clusterMemberList, resType, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getCommonClusterResObjectsWithValues", new Object[]{commonClusterResObjectsWithValues});
        }
        return commonClusterResObjectsWithValues;
    }

    private Hashtable _getResObjectsWithCommonValues(List resObjectsWithValues) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResObjectsWithCommonValues", new Object[]{resObjectsWithValues});
        }
        Hashtable commonResObjects = new Hashtable();
        if (resObjectsWithValues.size() > 0) {
            Hashtable firstMemberTypeObjectTbl = (Hashtable)resObjectsWithValues.get(0);
            Enumeration resKeys = firstMemberTypeObjectTbl.keys();
            while (resKeys.hasMoreElements()) {
                boolean common = true;
                Object resKey = resKeys.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resKey: " + resKey);
                }
                List resKeyList = new ArrayList();
                if (resKey instanceof List) {
                    resKeyList = (List)resKey;
                } else {
                    resKeyList.add(resKey);
                }
                for (int j = 0; j < resKeyList.size(); ++j) {
                    ArrayList eObjectList = new ArrayList();
                    String resKeyString = (String)resKeyList.get(j);
                    for (int i = 1; common && i < resObjectsWithValues.size(); ++i) {
                        Hashtable otherMemberTypeObjectTbl = (Hashtable)resObjectsWithValues.get(i);
                        if (!otherMemberTypeObjectTbl.containsKey(resKeyString)) {
                            common = false;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "No common resource found for " + resKey);
                            continue;
                        }
                        Object value = otherMemberTypeObjectTbl.get(resKeyString);
                        if (value instanceof List) {
                            eObjectList.addAll((List)value);
                        } else {
                            eObjectList.add(value);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Adding common resource eObject: " + otherMemberTypeObjectTbl.get(resKey));
                    }
                    if (!common) continue;
                    if (eObjectList.size() > 0) {
                        Object value = firstMemberTypeObjectTbl.get(resKey);
                        if (value instanceof List) {
                            eObjectList.addAll((List)value);
                        } else {
                            eObjectList.add(value);
                        }
                        commonResObjects.put(resKey, eObjectList);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "find commom member resource - " + resKey + " " + eObjectList);
                        continue;
                    }
                    commonResObjects.put(resKey, (ArrayList<Object>)firstMemberTypeObjectTbl.get(resKey));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "find commom member resource - " + resKey + " " + firstMemberTypeObjectTbl.get(resKey));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResObjectsWithCommonValues", new Object[]{commonResObjects});
        }
        return commonResObjects;
    }

    private Object _taskResourceValidation(String taskName, boolean retMsg) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_taskResourceValidation", new Object[]{taskName, new Boolean(retMsg)});
        }
        Hashtable resourceNotFoundTbl = new Hashtable();
        ArrayList<String> msgs = new ArrayList<String>();
        List types2 = this._getTypeForTask(taskName);
        if (types2 != null && types2.size() > 0) {
            AppDeploymentTask task = this._controller.getTaskByName(taskName, false);
            if (!task.isTaskEmpty()) {
                this._resMapper.addValidationTypes(types2);
                String[][] taskData = ResourceValidationHelper.getExpandedTaskData(task);
                for (int i = 1; i < taskData.length; ++i) {
                    List moduleScopes = this._getScopeForUri(task, taskData[i]);
                    if (moduleScopes != null && moduleScopes.size() > 0) {
                        int j;
                        String[] postDataToValidate;
                        types2 = this._resMapper.getTypesForTask(task, taskData[i]);
                        List invalidResourceValidationInfo = this._taskResourceValidation(moduleScopes, task, taskData[i], types2, true);
                        if (invalidResourceValidationInfo != null && invalidResourceValidationInfo.size() > 0) {
                            if (retMsg) {
                                for (int j2 = 0; j2 < invalidResourceValidationInfo.size(); ++j2) {
                                    msgs.add(this._resMapper.buildWarningMsg(taskName, (Hashtable)invalidResourceValidationInfo.get(j2)));
                                }
                            } else {
                                for (int j3 = 0; j3 < invalidResourceValidationInfo.size(); ++j3) {
                                    resourceNotFoundTbl.put(Integer.toString(i), invalidResourceValidationInfo.get(j3));
                                }
                            }
                        }
                        if ((postDataToValidate = this._resMapper.postDataToValidate(task, taskData[i])) == null || (invalidResourceValidationInfo = this._taskResourceValidation(moduleScopes, task, postDataToValidate, types2, true)) == null || invalidResourceValidationInfo.size() <= 0) continue;
                        if (retMsg) {
                            for (j = 0; j < invalidResourceValidationInfo.size(); ++j) {
                                msgs.add(this._resMapper.buildWarningMsg(taskName, (Hashtable)invalidResourceValidationInfo.get(j)));
                            }
                            continue;
                        }
                        for (j = 0; j < invalidResourceValidationInfo.size(); ++j) {
                            resourceNotFoundTbl.put(Integer.toString(i), invalidResourceValidationInfo.get(j));
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "no target info for row " + i + "; skipping validation for this row");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "empty task");
            }
        }
        Cloneable ret = retMsg ? msgs : resourceNotFoundTbl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_taskResourceValidation", new Object[]{ret});
        }
        return ret;
    }

    private Hashtable _getResourceConfigObject(List moduleScopes, List configFiles, List types2, String valueToMatch, boolean searchInParent) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceConfigObject", new Object[]{moduleScopes, configFiles, types2, valueToMatch, new Boolean(searchInParent)});
        }
        Hashtable configObjectTbl = new Hashtable();
        Hashtable scopeToResObjTbl = new Hashtable();
        if (moduleScopes != null && moduleScopes.size() > 0) {
            for (i = 0; i < moduleScopes.size(); ++i) {
                Hashtable tbl = new Hashtable();
                tbl = EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE.equals((String)moduleScopes.get(i)) ? this._getEmbeddedRarResource(types2) : this._buildScopeResTypeTbl((String)moduleScopes.get(i), types2, configFiles, false);
                if (tbl == null || tbl.size() <= 0) continue;
                scopeToResObjTbl.putAll(tbl);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeToResObjTbl: " + scopeToResObjTbl);
        }
        for (i = 0; i < types2.size(); ++i) {
            Object configName = this._getResourceConfigObject(moduleScopes, scopeToResObjTbl, (String)types2.get(i), valueToMatch, searchInParent);
            if (configName == null) continue;
            configObjectTbl.put(types2.get(i), configName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceConfigObject", new Object[]{configObjectTbl});
        }
        return configObjectTbl;
    }

    private Object _getResourceConfigObject(List moduleScopes, List configFiles, String type, String valueToMatch, boolean searchInParent) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceConfigObject", new Object[]{moduleScopes, configFiles, type, valueToMatch, new Boolean(searchInParent)});
        }
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(type);
        Hashtable configObjectTbl = this._getResourceConfigObject(moduleScopes, configFiles, typeList, valueToMatch, searchInParent);
        Enumeration enumKeys = configObjectTbl.keys();
        Object configObject = null;
        while (enumKeys.hasMoreElements()) {
            configObject = configObjectTbl.get(enumKeys.nextElement());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceConfigObject", new Object[]{configObject});
        }
        return configObject;
    }

    private Object _getResourceConfigObject(List moduleScopes, Hashtable scopeToResObjTbl, String type, String valueToMatch, boolean searchInParent) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceConfigObject", new Object[]{moduleScopes, scopeToResObjTbl, type, valueToMatch, new Boolean(searchInParent)});
        }
        Object configObjectName = null;
        Enumeration scopeKeys = scopeToResObjTbl.keys();
        while (scopeKeys.hasMoreElements()) {
            Hashtable resObjTbl = (Hashtable)scopeToResObjTbl.get((String)scopeKeys.nextElement());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing for type " + type + "with resObjTbl " + resObjTbl);
            }
            Hashtable valueObjTbl = this._resMapper.getResourceValuesWithObjects(type, (List)resObjTbl.get(type));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "valueObjTbl: " + valueObjTbl);
            }
            if (valueObjTbl == null || !valueObjTbl.containsKey(valueToMatch)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Find matching value");
            }
            Object object = valueObjTbl.get(valueToMatch);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "object for it: " + object);
            }
            if (object instanceof String) {
                configObjectName = object;
                break;
            }
            if (object instanceof EObject) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "object is an EObject");
                }
                configObjectName = this._createConfigObjectName((EObject)object);
                break;
            }
            if (object instanceof List) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "object is a list");
                }
                if (((List)object).size() <= 0) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "get the first object from the list");
                }
                configObjectName = this._createConfigObjectName((EObject)((List)object).get(0));
                break;
            }
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Unknow object type " + object);
            break;
        }
        if (configObjectName == null && searchInParent) {
            List parents;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "seaching in parent scope");
            }
            if ((parents = this._getParentInScope(moduleScopes)).size() > 0) {
                configObjectName = this._getResourceConfigObject(parents, this._configFilesToLoad, type, valueToMatch, searchInParent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceConfigObject", new Object[]{configObjectName});
        }
        return configObjectName;
    }

    private List _getResourceKeyValues(String resType, List refO) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceKeyValues", new Object[]{resType, refO});
        }
        ArrayList values = new ArrayList();
        Hashtable valuesWithObjectTbl = this._resMapper.getResourceValuesWithObjects(resType, refO);
        Enumeration valueKeys = valuesWithObjectTbl.keys();
        while (valueKeys.hasMoreElements()) {
            values.add(valueKeys.nextElement());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceKeyValues", new Object[]{values});
        }
        return values;
    }

    private void _init(String sessionId, String operation) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_init", new Object[]{sessionId, operation});
        }
        if (this._controller == null) {
            throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0170E"), null);
        }
        this._operation = operation;
        this._sessionId = sessionId;
        this._resMapper = new ResourceMapperDefaultImpl();
        this._initScopeToModuleTable();
        this._scopeToResourceTbl = new Hashtable();
        this._initScopeToResourceTable(this._scopeToModuleTbl);
        this._initInAppResourceToResourceTable();
        this._buildClusterMemberAndResourceTable();
        this._buildValueToResourceTable();
        this._buildTaskTypeTable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_init");
        }
    }

    private void _initScopeToModuleTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_initScopeToModuleTable");
        }
        Hashtable<String, String> serverTbl = new Hashtable<String, String>();
        try {
            String[][] serverTaskData = ResourceValidationHelper.getExpandedTaskData(this._controller.getTaskByName("MapModulesToServers", false));
            if (serverTaskData != null) {
                for (int i = 0; i < serverTaskData.length; ++i) {
                    String s;
                    if (AppUtils.isEmpty(serverTaskData[i][2]) || (s = serverTaskData[i][2]).indexOf(58) == -1 && s.indexOf(44) == -1) continue;
                    serverTbl.put(util.createUniqueModuleNameFromUriString(serverTaskData[i][1]), s);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverTbl: " + serverTbl);
            }
        }
        catch (AppDeploymentException ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "_initScopeToModuleTable", "1227", this);
            throw ex;
        }
        this._scopeToModuleTbl = this._buildServerModuleTable(serverTbl);
        this._moduleToScopeTbl = this._buildModuleServerTable(serverTbl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_initScopeToModuleTable");
        }
    }

    private WorkSpace _getWorkSpace() throws AppDeploymentException {
        WorkSpace ws;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getWrokSpace");
        }
        try {
            ws = ConfigRepoHelper.getWorkSpace(this._sessionId);
        }
        catch (Throwable ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "_getWorkSpace", "1241", this);
            if (ex instanceof AppDeploymentException) {
                throw (AppDeploymentException)ex;
            }
            throw new AppDeploymentException("", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getWrokSpace", new Object[]{ws});
        }
        return ws;
    }

    private void _initScopeToResourceTable(Hashtable scopeTbl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_initScopeToResourceTable", new Object[]{scopeTbl});
        }
        WorkSpace ws = this._getWorkSpace();
        this._configFilesToLoad = this._resMapper.getConfigFilesToLoad(this._operation);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "config files to load: " + this._configFilesToLoad);
        }
        Enumeration enumeration = scopeTbl.keys();
        while (enumeration.hasMoreElements()) {
            String scope = (String)enumeration.nextElement();
            for (int i = 0; i < this._configFilesToLoad.size(); ++i) {
                String uriScope = this._addUriToScope(scope, (String)this._configFilesToLoad.get(i));
                if (this._scopeToResourceTbl.containsKey(uriScope)) continue;
                Properties scopeProp = this._getKeyProperties(scope);
                String cell = (String)scopeProp.get("cell");
                String node = (String)scopeProp.get("node");
                String server = (String)scopeProp.get("server");
                String cluster = (String)scopeProp.get("cluster");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell: " + cell + " node: " + node + " server: " + server + " cluster: " + cluster);
                }
                RepositoryContext cContext = null;
                RepositoryContext nContext = null;
                RepositoryContext sContext = null;
                RepositoryContext clusterContext = null;
                ArrayList<RepositoryContext> scopeContextOrder = new ArrayList<RepositoryContext>();
                try {
                    if (cell != null && cell.trim().length() > 0 && (cContext = AppUtils.findContext("cells", cell, null, null, ws, true)) != null) {
                        scopeContextOrder.add(cContext);
                    }
                    if (node != null && node.trim().length() > 0 && (nContext = AppUtils.findContext("nodes", node, null, cContext, ws, true)) != null) {
                        scopeContextOrder.add(0, nContext);
                    }
                    if (server != null && server.trim().length() > 0 && (sContext = AppUtils.findContext("servers", server, null, nContext, ws, true)) != null) {
                        scopeContextOrder.add(0, sContext);
                    }
                    if (cluster != null && cluster.trim().length() > 0 && (clusterContext = AppUtils.findContext("clusters", cluster, null, cContext, ws, true)) != null) {
                        scopeContextOrder.add(0, clusterContext);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scope context order: " + scopeContextOrder);
                    }
                }
                catch (Throwable th) {
                    RasUtils.logException(th, tc, CLASS_NAME, "_initScopeToResourceTable", "1327", this);
                    if (th instanceof AppDeploymentException) {
                        throw (AppDeploymentException)th;
                    }
                    throw new AppDeploymentException("", th);
                }
                for (int j = 0; j < scopeContextOrder.size(); ++j) {
                    String contextUri = this._buildUriFromContext((RepositoryContext)scopeContextOrder.get(j));
                    if (this._scopeToResourceTbl.containsKey(contextUri)) continue;
                    Hashtable resTbl = this._getRefObjects((RepositoryContext)scopeContextOrder.get(j), (String)this._configFilesToLoad.get(i));
                    this._scopeToResourceTbl.put(this._addUriToScope(contextUri, (String)this._configFilesToLoad.get(i)), resTbl);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_initScopeToResourceTable", new Object[]{this._scopeToResourceTbl});
        }
    }

    private void _initInAppResourceToResourceTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_initInAppResourceToResourceable");
        }
        this._inAppConfigFilesToLoad = this._resMapper.getInAppConfigFilesToLoad(this._operation);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "In app config files to load: " + this._inAppConfigFilesToLoad);
        }
        for (int i = 0; i < this._inAppConfigFilesToLoad.size(); ++i) {
            if (!this._scopeToResourceTbl.containsKey(this._addUriToScope(EMBEDDED_CONFIG_SCOPE, (String)this._inAppConfigFilesToLoad.get(i)))) {
                Hashtable inAppRefObjectTbl = this._getInAppRefObjects((String)this._inAppConfigFilesToLoad.get(i));
                if (inAppRefObjectTbl.size() > 0) {
                    this._scopeToResourceTbl.put(this._addUriToScope(EMBEDDED_CONFIG_SCOPE, (String)this._inAppConfigFilesToLoad.get(i)), inAppRefObjectTbl);
                }
                this._buildInAppTaskResource();
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Duplicate key " + this._inAppConfigFilesToLoad.get(i) + " in _scopeToResourceTbl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_initInAppResourceToResourceTable", new Object[]{this._scopeToResourceTbl});
        }
    }

    private void _buildInAppTaskResource() throws AppDeploymentException {
        Hashtable inAppTaskResourceTbl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildInAppTaskResource");
        }
        if ((inAppTaskResourceTbl = this._getInAppTaskResource()).size() > 0) {
            this._scopeToResourceTbl.put(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE, inAppTaskResourceTbl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildInAppTaskResource");
        }
    }

    private String _buildUriFromContext(RepositoryContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildUriFromContext", new Object[]{context});
        }
        StringBuffer buffer = new StringBuffer();
        if (context != null) {
            String contextUri = context.getURI();
            String[] tokens = contextUri.split("/");
            buffer.append(WEBSPHERE_DOMAIN);
            for (int i = 0; i < tokens.length && i + 1 < tokens.length; i += 2) {
                String key = (String)_mapPropertyTable.get(tokens[i]);
                if (key == null || key.equals("")) {
                    key = tokens[i];
                }
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(key);
                buffer.append("=");
                buffer.append(tokens[i + 1]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "context is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildUriFromContext", new Object[]{buffer.toString()});
        }
        return buffer.toString();
    }

    private String _buildOrderedScope(String target) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildOrderedScope", new Object[]{target});
        }
        Properties prop = this._getKeyProperties(target);
        StringBuffer buffer = new StringBuffer();
        buffer.append(WEBSPHERE_DOMAIN);
        if (prop.get("cell") != null) {
            buffer.append("cell=" + (String)prop.get("cell"));
        }
        if (prop.get("node") != null) {
            buffer.append(",");
            buffer.append("node=" + (String)prop.get("node"));
        }
        if (prop.get("server") != null) {
            buffer.append(",");
            buffer.append("server=" + (String)prop.get("server"));
        }
        if (prop.get("cluster") != null) {
            buffer.append(",");
            buffer.append("cluster=" + (String)prop.get("cluster"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildOrderedScope", new Object[]{buffer.toString()});
        }
        return buffer.toString();
    }

    private String _addUriToScope(String scope, String uri) {
        return scope + ",uri=" + uri;
    }

    private String _removeUriFromScope(String scope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_removeUriFromScope", new Object[]{scope});
        }
        String ret = scope;
        if (scope.indexOf(",uri=") > 0) {
            int endIndex = scope.indexOf(",uri=");
            ret = scope.substring(0, endIndex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_removeUriFromScope", new Object[]{ret});
        }
        return ret;
    }

    private Properties _getKeyProperties(String target) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getKeyProperties", new Object[]{target});
        }
        Properties result = new Properties();
        if (target.startsWith(WEBSPHERE_DOMAIN)) {
            target = target.substring(10, target.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target: " + target);
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(target, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String key = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token: " + token);
            }
            if (token.startsWith("cell")) {
                key = "cell";
            } else if (token.startsWith("node")) {
                key = "node";
            } else if (token.startsWith("server")) {
                key = "server";
            } else if (token.startsWith("cluster")) {
                key = "cluster";
            }
            if (key == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Key: " + key + " +  value: " + token.substring(token.indexOf("=") + 1));
            }
            result.setProperty(key, token.substring(token.indexOf("=") + 1));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getKeyProperties", new Object[]{result});
        }
        return result;
    }

    private Resource _load(RepositoryContext context, String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_load", new Object[]{context, uri});
        }
        Resource resource = null;
        if (context != null) {
            resource = context.getResourceSet().getResource(URI.createURI(uri), true);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_load", new Object[]{resource});
        }
        return resource;
    }

    private Hashtable _getRefObjects(RepositoryContext context, String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getRefObjects", new Object[]{context, uri});
        }
        Hashtable result = this._getRefObjects(this._load(context, uri));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getRefObjects", new Object[]{result});
        }
        return result;
    }

    private Hashtable _getRefObjects(Resource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getRefObjects", new Object[]{resource});
        }
        Hashtable result = new Hashtable();
        if (resource != null) {
            for (EObject refO : resource.getContents()) {
                String type = refO.eClass().getName();
                ResourceValidationHelper.addToScopeResultTable(type, refO, result);
                this._getSubtypesForRefObject(refO, result);
                this._getChildTypesFromParentRefObject(refO, result);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getRefObjects", new Object[]{result});
        }
        return result;
    }

    private void _getChildTypesFromParentRefObject(EObject refO, Hashtable result) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getChildTypesFromParentRefObject", new Object[]{refO, result});
        }
        Hashtable childTypes = this._resMapper.getChildTypesAndObjects(refO);
        Enumeration enumeration = childTypes.keys();
        while (enumeration.hasMoreElements()) {
            String type = (String)enumeration.nextElement();
            List obs = (List)childTypes.get(type);
            for (int i = 0; i < obs.size(); ++i) {
                ResourceValidationHelper.addToScopeResultTable(type, (EObject)obs.get(i), result);
                this._getSubtypesForRefObject((EObject)obs.get(i), result);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getChildTypesFromParentRefObject", new Object[]{result});
        }
    }

    private void _getSubtypesForRefObject(EObject refO, Hashtable result) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getSubtypesFromRefObject", new Object[]{refO, result});
        }
        List subtypes = this._resMapper.getSubtypes(refO);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "subtypes: " + subtypes);
        }
        for (int i = 0; i < subtypes.size(); ++i) {
            ResourceValidationHelper.addToScopeResultTable((String)subtypes.get(i), refO, result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getSubtypesFromRefObject");
        }
    }

    private void _buildValueToResourceTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildValueToResourceTable");
        }
        this._valueToResourceTbl = new Hashtable();
        Enumeration enumeration = this._scopeToResourceTbl.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable jndiTbl = new Hashtable();
            String scope = (String)enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scope: " + scope);
            }
            Hashtable typeToResTbl = (Hashtable)this._scopeToResourceTbl.get(scope);
            Enumeration types2 = typeToResTbl.keys();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "typeToResTbl: " + typeToResTbl);
            }
            while (types2.hasMoreElements()) {
                String type = (String)types2.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type: " + type);
                }
                List resList = (List)typeToResTbl.get(type);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resList: " + resList);
                }
                if (resList == null) continue;
                Hashtable resValueToObjTbl = this._resMapper.getResourceValuesWithObjects(type, resList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resValueToObjTbl: " + resValueToObjTbl);
                }
                if (resValueToObjTbl == null) continue;
                Enumeration valueKeys = resValueToObjTbl.keys();
                while (valueKeys.hasMoreElements()) {
                    Object resVal = valueKeys.nextElement();
                    Object resObj = resValueToObjTbl.get(resVal);
                    List<Hashtable<String, String>> list = new ArrayList();
                    if (jndiTbl.containsKey(resVal)) {
                        list = (List)jndiTbl.get(resVal);
                    }
                    Hashtable<String, String> objTbl = new Hashtable<String, String>();
                    objTbl.put("resource.type", type);
                    objTbl.put("resource.object", (String)resObj);
                    list.add(objTbl);
                    jndiTbl.put(resVal, list);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "jndiTbl: " + jndiTbl);
                }
            }
            this._valueToResourceTbl.put(scope, jndiTbl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildValueToResourceTable", new Object[]{this._valueToResourceTbl});
        }
    }

    private Hashtable _buildServerModuleTable(Hashtable serverTbl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildServerModuleTable", new Object[]{serverTbl});
        }
        Hashtable<String, Hashtable> serverToModuleTbl = new Hashtable<String, Hashtable>();
        if (serverTbl != null) {
            Enumeration enumeration = serverTbl.keys();
            while (enumeration.hasMoreElements()) {
                String module = (String)enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module: " + module);
                }
                String target = (String)serverTbl.get(module);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "target: " + target);
                }
                StringTokenizer stoken = new StringTokenizer(target, "+");
                while (stoken.hasMoreTokens()) {
                    String scope = stoken.nextToken();
                    if (this._isWebServerScope(scope)) continue;
                    scope = this._buildOrderedScope(scope);
                    Hashtable moduleTbl = new Hashtable();
                    if (serverToModuleTbl.containsKey(scope)) {
                        moduleTbl = (Hashtable)serverToModuleTbl.get(scope);
                    }
                    if (!moduleTbl.containsKey(module)) {
                        moduleTbl.put(module, new Hashtable());
                    }
                    serverToModuleTbl.put(scope, moduleTbl);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildServerModuleTable", new Object[]{serverToModuleTbl});
        }
        return serverToModuleTbl;
    }

    private Hashtable _buildModuleServerTable(Hashtable serverTbl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildModuleServerTable", new Object[]{serverTbl});
        }
        Hashtable moduleToServerTbl = new Hashtable();
        if (serverTbl != null) {
            Enumeration enumeration = serverTbl.keys();
            while (enumeration.hasMoreElements()) {
                String module = (String)enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module: " + module);
                }
                String target = (String)serverTbl.get(module);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "target: " + target);
                }
                StringTokenizer stoken = new StringTokenizer(target, "+");
                ArrayList<String> targetList = new ArrayList<String>();
                while (stoken.hasMoreTokens()) {
                    String scope = stoken.nextToken();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scope: " + scope);
                    }
                    if (this._isWebServerScope(scope)) continue;
                    scope = this._buildOrderedScope(scope);
                    targetList.add(scope);
                }
                moduleToServerTbl.put(module, targetList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildModuleServerTable", new Object[]{moduleToServerTbl});
        }
        return moduleToServerTbl;
    }

    private boolean _isWebServerScope(String strScope) throws AppDeploymentException {
        boolean bisWebServer = false;
        Properties oScopeProps = this._getKeyProperties(strScope);
        String strServer = (String)oScopeProps.get("server");
        String strNode = (String)oScopeProps.get("node");
        String strCell = (String)oScopeProps.get("cell");
        String strCluster = (String)oScopeProps.get("cluster");
        if (strCluster != null) {
            return false;
        }
        RepositoryContext oCellContext = null;
        RepositoryContext oNodeContext = null;
        try {
            WorkSpace oWorkSpace = this._getWorkSpace();
            if (strCell != null && strCell.trim().length() > 0) {
                oCellContext = AppUtils.findContext("cells", strCell, null, null, oWorkSpace, true);
            }
            if (strServer != null && strServer.trim().length() > 0) {
                oNodeContext = AppUtils.findContext("nodes", strNode, null, oCellContext, oWorkSpace, true);
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "_isWebServerScope", "1745", this);
            if (th instanceof AppDeploymentException) {
                throw (AppDeploymentException)th;
            }
            throw new AppDeploymentException("", th);
        }
        Hashtable resTbl = this._getRefObjects(oNodeContext, "serverindex.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ref objects from serverindex.xml: " + resTbl);
        }
        ServerIndex oServIndxImpl = (ServerIndex)((ArrayList)resTbl.get("ServerIndex")).get(0);
        EList oServersList = oServIndxImpl.getServerEntries();
        for (ServerEntry oServEnty : oServersList) {
            String strServName = oServEnty.getServerName();
            String strServType = oServEnty.getServerType();
            Tr.debug(tc, "the name of SERVERS is is" + oServEnty.getServerName());
            Tr.debug(tc, "the name of SERVER TYPES is is is" + oServEnty.getServerType());
            if (!strServName.equals(strServer)) continue;
            if (strServType.equals("WEB_SERVER")) {
                bisWebServer = true;
                continue;
            }
            bisWebServer = false;
        }
        return bisWebServer;
    }

    private void _buildClusterMemberAndResourceTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildClusterMemberAndResourceTable");
        }
        this._buildClusterToMemberTable();
        this._buildClusterMemberResourceTable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildClusterMemberAndResourceTable");
        }
    }

    private void _buildClusterToMemberTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildClusterToMemberTable");
        }
        if (this._scopeToModuleTbl != null) {
            WorkSpace ws = this._getWorkSpace();
            this._clusterToMemberTbl = new Hashtable();
            Enumeration scopes = this._scopeToModuleTbl.keys();
            while (scopes.hasMoreElements()) {
                List members;
                Hashtable attrValueTable;
                String scope = (String)scopes.nextElement();
                Properties scopeProp = this._getKeyProperties(scope);
                String cluster = (String)scopeProp.get("cluster");
                if (cluster == null || this._clusterToMemberTbl.containsKey(scope)) continue;
                String cell = (String)scopeProp.get("cell");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "find a cluster - cell: " + cell + " cluster: " + cluster);
                }
                RepositoryContext cContext = null;
                RepositoryContext clusterContext = null;
                try {
                    if (cell != null && cell.trim().length() > 0) {
                        cContext = AppUtils.findContext("cells", cell, null, null, ws, true);
                    }
                    if (cluster != null && cluster.trim().length() > 0) {
                        clusterContext = AppUtils.findContext("clusters", cluster, null, cContext, ws, true);
                    }
                }
                catch (Throwable th) {
                    RasUtils.logException(th, tc, CLASS_NAME, "_buildClusterToMemberTable", "1814", this);
                    if (th instanceof AppDeploymentException) {
                        throw (AppDeploymentException)th;
                    }
                    throw new AppDeploymentException("", th);
                }
                Hashtable resTbl = this._getRefObjects(clusterContext, CLUSTER_XML);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ref objects from cluster.xml: " + resTbl);
                }
                if (resTbl == null || (attrValueTable = this._resMapper.getResourceValuesWithAttrsAndObjects("ClusterMember", members = (List)resTbl.get("ClusterMember"))) == null) continue;
                ArrayList<String> memberList = new ArrayList<String>();
                Enumeration keys = attrValueTable.keys();
                while (keys.hasMoreElements()) {
                    Hashtable key = (Hashtable)keys.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "key: " + key);
                    }
                    List attrNames = this._resMapper.getResourceTypeAttr("ClusterMember");
                    String nodeName = null;
                    String serverName = null;
                    for (int i = 0; i < attrNames.size(); ++i) {
                        String attrVal = (String)key.get(attrNames.get(i));
                        if (attrVal != null && ((String)attrNames.get(i)).equals(CLUSTER_NODE_ATTR)) {
                            nodeName = attrVal;
                        }
                        if (attrVal == null || !((String)attrNames.get(i)).equals(CLUSTER_MEMBER_ATTR)) continue;
                        serverName = attrVal;
                    }
                    if (nodeName == null || serverName == null) continue;
                    memberList.add("WebSphere:cell=" + cell + ",node=" + nodeName + ",server=" + serverName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added member: WebSphere:cell=" + cell + ",node=" + nodeName + ",server=" + serverName);
                }
                this._clusterToMemberTbl.put(scope, memberList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Added cluster scope " + scope + " with members: " + memberList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildClusterToMemberTable", new Object[]{this._clusterToMemberTbl});
        }
    }

    private void _buildClusterMemberResourceTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildClusterMemberResourceTable");
        }
        if (this._clusterToMemberTbl != null && this._clusterToMemberTbl.size() > 0) {
            Enumeration clusterMembers = this._clusterToMemberTbl.elements();
            while (clusterMembers.hasMoreElements()) {
                Hashtable memberTbl = new Hashtable();
                List memberList = (List)clusterMembers.nextElement();
                for (int i = 0; i < memberList.size(); ++i) {
                    memberTbl.put(memberList.get(i), "");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "member table: " + memberTbl);
                }
                this._initScopeToResourceTable(memberTbl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildClusterMemberResourceTable");
        }
    }

    private void _buildTaskTypeTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildTaskTypeTable");
        }
        this._taskToTypeTbl = new Hashtable();
        String[] taskNames = this._controller.getAppDeploymentTaskNames();
        for (int i = 0; i < taskNames.length; ++i) {
            List types2 = this._resMapper.getTypesForTask(taskNames[i]);
            if (types2 == null || types2.size() == 0) continue;
            this._taskToTypeTbl.put(taskNames[i], types2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildTaskTypeTable");
        }
    }

    private Hashtable _buildTaskDataInTbl(AppDeploymentTask task, String[] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildTaskDataInTabl", new Object[]{task, taskData});
        }
        Hashtable<String, String> taskDataTbl = new Hashtable<String, String>();
        String[] colNames = task.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            if (task.isHiddenColumn(i)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Skipping hidden " + i + " column");
                continue;
            }
            if (taskData[i] == null) {
                taskDataTbl.put(colNames[i], "");
                continue;
            }
            taskDataTbl.put(colNames[i], taskData[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildTaskDataInTabl", new Object[]{taskDataTbl});
        }
        return taskDataTbl;
    }

    private Hashtable _getEmbeddedResources(List types2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getEmbeddedResource", new Object[]{types2});
        }
        Hashtable tbl = this._buildScopeResTypeTbl(EMBEDDED_CONFIG_SCOPE, types2, this._inAppConfigFilesToLoad, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getEmbeddedResource", new Object[]{tbl});
        }
        return tbl;
    }

    private Hashtable _getEmbeddedRarResource(List types2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getEmbeddedRarResource", new Object[]{types2});
        }
        Hashtable scopeToResObjTbl = new Hashtable();
        Hashtable typeToResObjTbl = new Hashtable();
        if (types2 != null && types2.size() > 0) {
            Hashtable resTypeTbl = (Hashtable)this._scopeToResourceTbl.get(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE);
            if (resTypeTbl != null && resTypeTbl.size() > 0) {
                for (int i = 0; i < types2.size(); ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "type: " + types2.get(i));
                    }
                    if (!resTypeTbl.containsKey(types2.get(i))) continue;
                    List typeList = new ArrayList();
                    if (typeToResObjTbl.containsKey(types2.get(i))) {
                        typeList = (List)typeToResObjTbl.get(types2.get(i));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding to existing list: " + typeList);
                        }
                    }
                    typeList.addAll((List)resTypeTbl.get(types2.get(i)));
                    typeToResObjTbl.put((String)types2.get(i), typeList);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "new or modified type list: " + typeList);
                }
            }
            if (typeToResObjTbl.size() > 0) {
                scopeToResObjTbl.put(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE, typeToResObjTbl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getEmbeddedRarResource", new Object[]{scopeToResObjTbl});
        }
        return scopeToResObjTbl;
    }

    private Hashtable _buildScopeResTypeTbl(String scope, List types2, List configFiles, boolean includeParent) {
        String parent;
        Hashtable parentTbl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildScopeResTypeTbl", new Object[]{scope, types2, configFiles, new Boolean(includeParent)});
        }
        Hashtable scopeToResObjTbl = new Hashtable();
        Hashtable typeToResObjTbl = new Hashtable();
        for (int jj = 0; jj < configFiles.size(); ++jj) {
            String uriScope = scope;
            if (scope.indexOf("uri=") == -1) {
                uriScope = this._addUriToScope(scope, (String)configFiles.get(jj));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uriScope: " + uriScope);
                }
            }
            Hashtable resTypeTbl = (Hashtable)this._scopeToResourceTbl.get(uriScope);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resTypeTbl: " + resTypeTbl);
            }
            if (resTypeTbl == null || resTypeTbl.size() <= 0) continue;
            for (int k = 0; k < types2.size(); ++k) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type: " + types2.get(k));
                }
                if (!resTypeTbl.containsKey(types2.get(k))) continue;
                List typeList = new ArrayList();
                if (typeToResObjTbl.containsKey(types2.get(k))) {
                    typeList = (List)typeToResObjTbl.get(types2.get(k));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adding to existing list: " + typeList);
                    }
                }
                typeList.addAll((List)resTypeTbl.get(types2.get(k)));
                typeToResObjTbl.put((String)types2.get(k), typeList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "new or modified type list: " + typeList);
            }
        }
        if (typeToResObjTbl.size() > 0) {
            scopeToResObjTbl.put(this._removeUriFromScope(scope), typeToResObjTbl);
        }
        if (includeParent && (parentTbl = this._buildScopeResTypeTbl(parent = this._getParentInScope(scope), types2, configFiles, includeParent)).size() > 0) {
            scopeToResObjTbl.putAll(parentTbl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildScopeResTypeTbl", new Object[]{scopeToResObjTbl});
        }
        return scopeToResObjTbl;
    }

    private Hashtable _buildScopeResValueTbl(String scope, List configFiles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildScopeResValueTbl", new Object[]{scope, configFiles});
        }
        Hashtable<String, Hashtable> scopeToResValueTbl = new Hashtable<String, Hashtable>();
        for (int jj = 0; jj < configFiles.size(); ++jj) {
            String uriScope = scope;
            if (scope.indexOf("uri=") == -1 && !EMBEDDED_RAR_RESOURCE_NO_URI.equals((String)configFiles.get(jj))) {
                uriScope = this._addUriToScope(scope, (String)configFiles.get(jj));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uri: " + uriScope);
            }
            Hashtable resValueTbl = (Hashtable)this._valueToResourceTbl.get(uriScope);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resValueTbl: " + resValueTbl);
            }
            if (resValueTbl == null || resValueTbl.size() <= 0) continue;
            Hashtable tbl = new Hashtable();
            if (scopeToResValueTbl.containsKey(this._removeUriFromScope(uriScope))) {
                tbl = (Hashtable)scopeToResValueTbl.get(this._removeUriFromScope(uriScope));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding to existing value table: " + tbl);
                }
            }
            tbl.putAll(resValueTbl);
            scopeToResValueTbl.put(this._removeUriFromScope(uriScope), tbl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildScopeResValueTbl", new Object[]{scopeToResValueTbl});
        }
        return scopeToResValueTbl;
    }

    private List _taskResourceValidation(List moduleScopes, AppDeploymentTask task, String[] taskData, List types2, boolean searchInParent) throws AppDeploymentException {
        ArrayList misTypeResInfo;
        ArrayList outOfScopeResInfo;
        String[] validationData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_taskResourceValidation", new Object[]{moduleScopes, task, taskData, types2, new Boolean(searchInParent)});
        }
        if ((validationData = this._taskResourceValidation(true, moduleScopes, task, taskData, types2, moduleScopes, searchInParent, true, true, outOfScopeResInfo = new ArrayList(), misTypeResInfo = new ArrayList())) != null && outOfScopeResInfo.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found not in scope resource ... look for mistype");
            }
            validationData = this._taskResourceValidation(false, moduleScopes, task, validationData, types2, moduleScopes, searchInParent, false, false, outOfScopeResInfo, misTypeResInfo);
        }
        ArrayList allMsgs = new ArrayList();
        if (outOfScopeResInfo.size() > 0) {
            allMsgs.addAll(outOfScopeResInfo);
        }
        if (misTypeResInfo.size() > 0) {
            allMsgs.addAll(misTypeResInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_taskResourceValidation", new Object[]{allMsgs});
        }
        return allMsgs;
    }

    private String[] _taskResourceValidation(boolean inScope, List moduleScopes, AppDeploymentTask task, String[] taskData, List types2, List targets, boolean searchInParent, boolean processEmbeddedConfig, boolean searchInAllScope, List outOfScopeMsgs, List misTypeMsgs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_taskResourceValidation", new Object[]{new Boolean(inScope), moduleScopes, task, taskData, types2, targets, new Boolean(searchInParent), new Boolean(processEmbeddedConfig), new Boolean(searchInAllScope), outOfScopeMsgs, misTypeMsgs});
        }
        Hashtable scopeTbl = new Hashtable();
        for (int i = 0; i < moduleScopes.size(); ++i) {
            Hashtable tbl = new Hashtable();
            if (inScope) {
                Hashtable typesTbl = new Hashtable();
                for (int j = 0; j < types2.size(); ++j) {
                    ArrayList scope = new ArrayList();
                    scope.add(moduleScopes.get(i));
                    Hashtable typeKeyAndObjectTbl = this._getResourceObjectsWithRefKeys(scope, (String)types2.get(j), true);
                    Hashtable commonClusterResObjectsWithValues = this._getCommonClusterResObjectsWithValues((String)moduleScopes.get(i), (String)types2.get(j));
                    if (commonClusterResObjectsWithValues.size() > 0) {
                        typeKeyAndObjectTbl.putAll(commonClusterResObjectsWithValues);
                    }
                    if (typeKeyAndObjectTbl == null || typeKeyAndObjectTbl.size() <= 0) continue;
                    typesTbl.put(types2.get(j), typeKeyAndObjectTbl);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Res obj tbl for scope " + moduleScopes.get(i) + ": " + typesTbl);
                }
                tbl.put(moduleScopes.get(i), typesTbl);
            } else {
                List<String> fileList = new ArrayList();
                if (EMBEDDED_CONFIG_SCOPE.equals((String)moduleScopes.get(i))) {
                    fileList = this._inAppConfigFilesToLoad;
                } else if (EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE.equals((String)moduleScopes.get(i))) {
                    fileList.add(EMBEDDED_RAR_RESOURCE_NO_URI);
                } else {
                    fileList = this._configFilesToLoad;
                }
                tbl = this._buildScopeResValueTbl((String)moduleScopes.get(i), fileList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Res value tbl for scope " + moduleScopes.get(i) + ": " + tbl);
                }
            }
            if (tbl.size() == 0 && searchInAllScope) {
                scopeTbl.put(moduleScopes.get(i), new Hashtable());
            }
            if (tbl.size() <= 0) continue;
            scopeTbl.putAll(tbl);
        }
        String[] validationTaskData = inScope ? this._resMapper.validateInScopeResource(task, taskData, scopeTbl, searchInAllScope, targets, outOfScopeMsgs) : this._resMapper.validateMisTypeResource(task, taskData, scopeTbl, targets, outOfScopeMsgs, misTypeMsgs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_taskResourceValidation", new Object[]{validationTaskData});
        }
        return validationTaskData;
    }

    private List _getParentInScope(List scopes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getParentInScope", new Object[]{scopes});
        }
        ArrayList<String> parentScopes = new ArrayList<String>();
        for (int i = 0; i < scopes.size(); ++i) {
            String parent = this._getParentInScope((String)scopes.get(i));
            if (parent == null || parentScopes.contains(parent)) continue;
            parentScopes.add(parent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getParentInScope", new Object[]{parentScopes});
        }
        return parentScopes;
    }

    private String _getParentInScope(String scope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getParentInScope", new Object[]{scope});
        }
        String parentScope = null;
        Properties scopeProp = this._getKeyProperties(scope);
        if (scopeProp.get("server") != null) {
            parentScope = this._buildParentScope("node", scopeProp);
        } else if (scopeProp.get("node") != null) {
            parentScope = this._buildParentScope("cell", scopeProp);
        } else if (scopeProp.get("cluster") != null) {
            parentScope = this._buildParentScope("cell", scopeProp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getParentInScope", new Object[]{parentScope});
        }
        return parentScope;
    }

    private String _buildParentScope(String scopeLevel, Properties prop) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildParentScope", new Object[]{scopeLevel, prop});
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(WEBSPHERE_DOMAIN);
        if (prop.get("cell") != null) {
            buffer.append("cell=" + (String)prop.get("cell"));
        }
        if (scopeLevel.equals("node") && prop.get("node") != null) {
            buffer.append(",");
            buffer.append("node=" + (String)prop.get("node"));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildParentScope", new Object[]{buffer.toString()});
        }
        return buffer.toString();
    }

    private List _getTypeForTask(String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getTypeForTask", new Object[]{taskName});
        }
        List types2 = (List)this._taskToTypeTbl.get(taskName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "types: " + types2);
        }
        if ((types2 == null || types2.size() == 0) && tc.isDebugEnabled()) {
            Tr.debug(tc, "Task " + taskName + " does not have resource to be validated");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getTypeForTask", new Object[]{types2});
        }
        return types2;
    }

    private List _getScopeForUri(AppDeploymentTask task, String[] taskData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getScopeForUri", new Object[]{task, taskData});
        }
        ArrayList scope = new ArrayList();
        int uriColumn = ResourceValidationHelper.getMatchingColIndex(task, "uri");
        if (uriColumn == -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task does not have uri column");
            }
        } else {
            String uri = taskData[uriColumn];
            List moduleScopes = (List)this._moduleToScopeTbl.get(uri = uri.replace(',', '+'));
            if (moduleScopes != null && moduleScopes.size() > 0) {
                scope.addAll(moduleScopes);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getScopeForUri", new Object[]{scope});
        }
        return scope;
    }

    private List _checkForClusterScope(String scope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_checkForClusterScope", new Object[]{scope});
        }
        ArrayList memberScope = new ArrayList();
        Properties scopeProp = this._getKeyProperties(scope);
        if (scopeProp.getProperty("cluster") != null) {
            List memberList = (List)this._clusterToMemberTbl.get(scope);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster members: " + memberList);
            }
            if (memberList != null) {
                memberScope.addAll(memberList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_checkForClusterScope", new Object[]{memberScope});
        }
        return memberScope;
    }

    private void _addObjectsToList(List objects, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_addObjectsToList", new Object[]{objects, list});
        }
        for (int j = 0; j < objects.size(); ++j) {
            if (list.contains(objects.get(j))) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding object " + objects.get(j) + " to list");
            }
            list.add(objects.get(j));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_addObjectsToList", new Object[]{list});
        }
    }

    private void _addObjectsToTbl(Hashtable valueWithObjTbl, Hashtable resObjsWithValuesTbl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_addObjectsToTbl", new Object[]{valueWithObjTbl, resObjsWithValuesTbl});
        }
        Enumeration enumeration = valueWithObjTbl.keys();
        while (enumeration.hasMoreElements()) {
            Object value = enumeration.nextElement();
            Object eObject = valueWithObjTbl.get(value);
            if (!resObjsWithValuesTbl.containsKey(value)) {
                resObjsWithValuesTbl.put(value, eObject);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding " + value);
                continue;
            }
            Object eObjects = resObjsWithValuesTbl.get(value);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "existingObject: " + eObjects);
            }
            List objectList = new ArrayList();
            if (eObjects instanceof EObject) {
                objectList.add(eObjects);
            } else if (eObjects instanceof List) {
                objectList = (List)eObjects;
            }
            List newObjectList = new ArrayList();
            if (eObject instanceof EObject) {
                newObjectList.add(eObject);
            } else if (eObject instanceof List) {
                newObjectList = (List)eObject;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newObjectList: " + newObjectList);
            }
            ArrayList<String> objectScopeUris = new ArrayList<String>();
            for (int k = 0; k < objectList.size(); ++k) {
                objectScopeUris.add(WorkspaceHelper.getContext((Resource)((EObject)objectList.get(k)).eResource()).getURI());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "existing object scope uri: " + objectScopeUris);
            }
            for (int j = 0; j < newObjectList.size(); ++j) {
                if (objectList.contains(newObjectList.get(j))) continue;
                String objectScopeUri = WorkspaceHelper.getContext((Resource)((EObject)newObjectList.get(j)).eResource()).getURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new object: " + newObjectList.get(j) + " with scope uri " + objectScopeUri);
                }
                boolean found = false;
                for (int k = 0; k < objectScopeUris.size(); ++k) {
                    if (((String)objectScopeUris.get(k)).indexOf(objectScopeUri) < 0) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    objectList.add(newObjectList.get(j));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Adding object to list");
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "object with overriden scope is already in the EObject list");
            }
            if (objectList.size() > 1) {
                resObjsWithValuesTbl.put(value, objectList);
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "final object list: " + objectList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_addObjectsToTbl", new Object[]{resObjsWithValuesTbl});
        }
    }

    private ObjectName _createConfigObjectName(EObject object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_createConfigObjectName", new Object[]{object});
        }
        ObjectName configObject = MOFUtil.createObjectName((EObject)object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_createConfigObjectName", new Object[]{configObject});
        }
        return configObject;
    }

    private Hashtable _getInAppTaskResource() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getInAppTaskResource");
        }
        Hashtable inAppTaskResource = new Hashtable();
        inAppTaskResource = this._resMapper.getInAppTaskResource(this._controller);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getInAppTaskResource", new Object[]{inAppTaskResource});
        }
        return inAppTaskResource;
    }

    public Hashtable _getInAppRefObjects(String uri) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getInAppRefObjects", new Object[]{uri});
        }
        Hashtable tbl = new Hashtable();
        if (this._controller.checkIfEnhancedEar()) {
            tbl = this._getRefObjects(this._controller.getEnhancedEarDeploymentResource(uri));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getInAppRefObjects", new Object[]{tbl});
        }
        return tbl;
    }

    public void printValueTable() throws AppDeploymentException {
        this._checkInit();
        System.out.println("---------------------- value Table -----------------------");
        Enumeration enumeration = this._valueToResourceTbl.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            System.out.println("======== key: " + key);
            Hashtable value = (Hashtable)this._valueToResourceTbl.get(key);
            Enumeration valueKeys = value.keys();
            System.out.println("======== value: ");
            while (valueKeys.hasMoreElements()) {
                Object valueKey = valueKeys.nextElement();
                List typeValue = (List)value.get(valueKey);
                System.out.println("     -------- key: " + valueKey);
                for (int i = 0; i < typeValue.size(); ++i) {
                    Hashtable valueTbl = (Hashtable)typeValue.get(i);
                    System.out.println("         ++++++ resType: " + valueTbl.get("resource.type"));
                    System.out.println("                resObject: " + valueTbl.get("resource.object"));
                }
                System.out.println("\n\n");
            }
        }
    }

    public void printScopeTable() throws AppDeploymentException {
        this._checkInit();
        System.out.println("---------------------- Scope Table -----------------------");
        Enumeration enumeration = this._scopeToResourceTbl.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            System.out.println("======== key: " + key);
            Hashtable value = (Hashtable)this._scopeToResourceTbl.get(key);
            Enumeration valueKeys = value.keys();
            System.out.println("======== value: ");
            while (valueKeys.hasMoreElements()) {
                String valueKey = (String)valueKeys.nextElement();
                Object typeValue = value.get(valueKey);
                System.out.println("     -------- key: " + valueKey);
                if (typeValue instanceof Hashtable) {
                    Hashtable typeValues = (Hashtable)typeValue;
                    Enumeration valueEnum = typeValues.keys();
                    while (valueEnum.hasMoreElements()) {
                        String subKey = (String)valueEnum.nextElement();
                        System.out.println("       ******** key: " + subKey);
                        Hashtable values = (Hashtable)typeValues.get(subKey);
                        Enumeration attrEnum = values.keys();
                        while (attrEnum.hasMoreElements()) {
                            String attrKey = (String)attrEnum.nextElement();
                            System.out.println("          +++++++++++++ key: " + attrKey);
                            System.out.println("              ............. " + values.get(attrKey));
                        }
                    }
                } else if (typeValue instanceof List) {
                    List values = (List)typeValue;
                    for (int i = 0; i < values.size(); ++i) {
                        System.out.println("       +++++++++++++ " + values.get(i));
                    }
                }
                System.out.println("\n\n");
            }
        }
    }

    public void printAppTable() throws AppDeploymentException {
        this._checkInit();
        System.out.println("---------------------- Scope-to-Module Table -----------------------");
        Enumeration enumeration = this._scopeToModuleTbl.keys();
        while (enumeration.hasMoreElements()) {
            String target = (String)enumeration.nextElement();
            System.out.println("======== target: " + target);
            Hashtable moduleTbl = (Hashtable)this._scopeToModuleTbl.get(target);
            Enumeration moduleKeys = moduleTbl.keys();
            while (moduleKeys.hasMoreElements()) {
                String module = (String)moduleKeys.nextElement();
                Hashtable moduleResources = (Hashtable)moduleTbl.get(module);
                System.out.println("     -------- module: " + module);
                Enumeration resKeys = moduleResources.keys();
                while (resKeys.hasMoreElements()) {
                }
            }
            System.out.println("\n\n");
        }
        System.out.println("---------------------- Module-to-Scope Table -----------------------");
        Enumeration en = this._moduleToScopeTbl.keys();
        while (en.hasMoreElements()) {
            String module = (String)en.nextElement();
            System.out.println("======== module: " + module);
            List targets = (List)this._moduleToScopeTbl.get(module);
            for (int i = 0; i < targets.size(); ++i) {
                System.out.println("    ----------- target: " + targets.get(i));
            }
            System.out.println("\n\n");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/client/ResourceValidationHelper.java, WAS.admin.installapp.validation, WAS70.SERV1, q0834.18, ver. 1.17");
        }
        CLASS_NAME = ResourceValidationHelper.class.getName();
        _mapPropertyTable = new Hashtable();
        _mapPropertyTable.put("cells", "cell");
        _mapPropertyTable.put("nodes", "node");
        _mapPropertyTable.put("servers", "server");
        _mapPropertyTable.put("clusters", "cluster");
    }
}

