/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTaskListener;
import com.ibm.websphere.management.application.client.AppDeploymentTaskValidate;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.client.AppDeploymentOptions;
import com.ibm.ws.management.application.client.DataHolder;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoder;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppDeploymentController
implements Serializable {
    private static final long serialVersionUID = -3828436921961863062L;
    private static TraceComponent tc = Tr.register(AppDeploymentController.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String taskPackageName = "com.ibm.ws.management.application.client.";
    public static final String taskHelperSuffix = "Helper";
    private static boolean encoderInit;
    private static boolean propBasedConfig;
    private DataHolder dh = DataHolder.getInstance();
    protected Vector taskInfo = null;
    protected Vector taskNames = null;
    protected Vector tasks = null;
    protected int currentTask;
    protected Hashtable preferences = new Hashtable();
    protected transient AppDeploymentInfo deploymentInfo;
    protected transient ResourceBundle resBundle;
    protected long _deploymentMode;
    protected ConfigService configService;
    protected Session configSession;
    protected AdminClient adminClient;
    protected Hashtable taskDataChangeListeners;
    protected List changedTaskProcessList;
    private static int[][] versionTable;

    public static AppDeploymentController readArchive(String ear, Hashtable preferences) throws AppDeploymentException {
        return AppManagementFactory.readArchive(ear, preferences);
    }

    public static AppDeploymentController readArchive(String ear, Hashtable preferences, Vector taskI) throws AppDeploymentException {
        return AppManagementFactory.readArchive(ear, preferences, taskI);
    }

    public AppDeploymentController(AppDeploymentInfo info, Hashtable prefs, Vector taskI) throws AppDeploymentException {
        this(info, null, prefs, taskI);
    }

    public AppDeploymentController(Vector tAll, Vector taskI, Hashtable prefs) throws AppDeploymentException {
        this(null, tAll, prefs, taskI);
    }

    public AppDeploymentController(AppDeploymentInfo info, Vector tAll, Hashtable prefs, Vector taskI) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppDeploymentController");
        }
        this.deploymentInfo = info;
        this.taskInfo = taskI;
        this.preferences = prefs;
        this.taskNames = new Vector();
        for (int i = 0; i < this.taskInfo.size(); ++i) {
            this.taskNames.addElement(((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)i)).name);
        }
        this.taskDataChangeListeners = ExtensionHelper.processAppDeploymentTaskListenerExtensions(this.preferences);
        Hashtable defaultTaskDataChangeListeners = new Hashtable();
        try {
            defaultTaskDataChangeListeners = new DefaultTaskProvider().provideAppDeploymentTaskListeners(this.preferences);
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in getting default task listeners: " + th);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "AppDeploymentCtonroller", "306");
        }
        Enumeration ee = defaultTaskDataChangeListeners.keys();
        while (ee.hasMoreElements()) {
            String key = (String)ee.nextElement();
            AppDeploymentTaskListener listener = (AppDeploymentTaskListener)defaultTaskDataChangeListeners.get(key);
            ArrayList<AppDeploymentTaskListener> list = (ArrayList<AppDeploymentTaskListener>)this.taskDataChangeListeners.get(key);
            if (list == null) {
                list = new ArrayList<AppDeploymentTaskListener>();
                this.taskDataChangeListeners.put(key, list);
            }
            list.add(listener);
        }
        this.changedTaskProcessList = new ArrayList();
        this.setDeploymentMode(prefs);
        this.handlePreferences(prefs);
        this.initializeEncoderDecoder();
        if (tAll == null) {
            this.createAppDeploymentTasks();
        } else {
            this.tasks = tAll;
            for (int i = 0; i < this.tasks.size(); ++i) {
                Object o = this.tasks.elementAt(i);
                if (o == null || !(o instanceof AppDeploymentTask)) continue;
                ((AppDeploymentTask)o).setAppDeploymentController(this);
            }
        }
        Locale locale = null;
        if (prefs != null) {
            locale = (Locale)prefs.get("app.client.locale");
        }
        this.resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppDeploymentController");
        }
    }

    protected void setDeploymentMode(Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDeploymentMode");
        }
        this._deploymentMode = 1L;
        if (this.deploymentInfo != null && this.deploymentInfo instanceof PartialDeploymentInfo) {
            long l = this._deploymentMode = ((PartialDeploymentInfo)this.deploymentInfo).isApp() ? 16L : 256L;
        }
        if ("modulefile".equals(prefs.get("contenttype"))) {
            this._deploymentMode = 0x100000L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDeploymentMode:" + this._deploymentMode);
        }
    }

    public long getDeploymentMode() {
        return this._deploymentMode;
    }

    protected void handlePreferences(Hashtable instPrefs) throws AppDeploymentException {
        Object o;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handlePreferences");
        }
        if (instPrefs == null || this.deploymentInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handlePreferences");
            }
            return;
        }
        this.configService = (ConfigService)instPrefs.get("configservice");
        this.configSession = (Session)instPrefs.get("configsession");
        this.adminClient = (AdminClient)instPrefs.get("adminclient");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "config service: " + this.configService + ", " + this.configSession + ", " + this.adminClient);
        }
        if ((o = instPrefs.get("usedefaultbindings")) != null) {
            this.handleDefaultBindings(o);
        } else {
            ((ArchiveDeploymentInfo)this.deploymentInfo).createDefaultBindings(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handlePreferences");
        }
    }

    private void handleDefaultBindings(Object o) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleDefaultBindings");
        }
        if (!(this.deploymentInfo instanceof ArchiveDeploymentInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deployment not from an ear file.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleDefaultBindings");
            }
            return;
        }
        Preferences prefs = null;
        if (o instanceof Preferences) {
            prefs = (Preferences)o;
        } else if (o instanceof DefaultBinding) {
            prefs = DefaultBindingHelper.getPreferences((DefaultBinding)o);
        } else if (o instanceof Properties) {
            prefs = DefaultBindingHelper.getPreferencesFromHashtable((Properties)o);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default bndg prefs: " + prefs);
        }
        if (prefs == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No preference data for default bindings " + o);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleDefaultBindings");
            }
            return;
        }
        ((ArchiveDeploymentInfo)this.deploymentInfo).createDefaultBindings(prefs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleDefaultBindings");
        }
    }

    protected void initializeEncoderDecoder() throws AppDeploymentException {
        if (encoderInit) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeEncoderDecoder");
        }
        try {
            EncoderDecoder encoderDecoder = (EncoderDecoder)ImplFactory.loadImplFromKey(EncoderDecoder.class);
            EncoderDecoderRegistry.getDefaultRegistry().setDefaultEncoderDecoder(encoderDecoder);
            encoderInit = true;
        }
        catch (Throwable t) {
            throw new AppDeploymentException("", t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeEncoderDecoder");
        }
    }

    protected void createAppDeploymentTasks() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAppDeploymentTasks");
        }
        this.tasks = new Vector();
        for (int i = 0; i < this.taskNames.size(); ++i) {
            this.tasks.addElement(((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)i)).helper.createTask(this, (String)this.taskNames.elementAt(i)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAppDeploymentTasks");
        }
    }

    protected static AppDeploymentTaskHelper getTaskHelper(String taskName) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskHelper");
        }
        try {
            Class<?> cls = taskName.indexOf(".") < 0 ? Class.forName(taskPackageName + taskName + taskHelperSuffix) : Class.forName(taskName + taskHelperSuffix);
            AppDeploymentTaskHelper helper = (AppDeploymentTaskHelper)cls.newInstance();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTaskHelper");
            }
            return helper;
        }
        catch (Throwable th) {
            throw new AppDeploymentException("", th);
        }
    }

    protected AppDeploymentTaskHelper getTaskHelper(int taskIndex) throws AppDeploymentException {
        if (taskIndex < this.taskInfo.size() && ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)taskIndex)).helper != null) {
            return ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)taskIndex)).helper;
        }
        throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0012E", new Object[]{(String)this.tasks.elementAt(taskIndex)}), null);
    }

    public String[] getAppDeploymentTaskNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentTaskNames");
        }
        Object[] str = new String[this.taskNames.size()];
        this.taskNames.copyInto(str);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppDeploymentTaskNames");
        }
        return str;
    }

    public AppDeploymentTask getFirstTask() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstTask");
        }
        this.currentTask = 0;
        return this.getNthTask(this.currentTask);
    }

    protected AppDeploymentTask getNthTask(int i) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNthTask");
        }
        AppDeploymentTask task = (AppDeploymentTask)this.tasks.elementAt(i);
        try {
            if (task.getTaskData() == null && !task.isTaskEmpty()) {
                this.prepareTask(i, task);
            }
        }
        catch (Throwable th) {
            String taskName = (String)this.taskNames.elementAt(i);
            throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0092E", new Object[]{taskName}), th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNthTask");
        }
        return task;
    }

    protected void prepareTask(int i, AppDeploymentTask task) throws AppDeploymentException {
        this.getTaskHelper(i).prepareTask(this.deploymentInfo, task);
        this.callListeners(task.getName(), task, "afterPrepare");
        this.callListeners("*", task, "afterPrepare");
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "taskName:  ", task.getName());
        }
        if (!this.isPartialDeploymentInfo()) {
            this.postAllPrepareTask(this.deploymentInfo, task);
        }
    }

    public AppDeploymentTask getNextTask() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextTask");
        }
        if (this.currentTask < 0) {
            return null;
        }
        if (this.currentTask + 1 >= this.tasks.size()) {
            return null;
        }
        return this.getNthTask(++this.currentTask);
    }

    public AppDeploymentTask getTaskByName(String taskName, boolean b) throws AppDeploymentException {
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskByName");
        }
        if ((index = this.taskNames.indexOf(taskName)) < 0) {
            return null;
        }
        if (b) {
            this.currentTask = index;
        }
        return this.getNthTask(index);
    }

    public Vector getAllTasks() {
        return this.tasks;
    }

    public AppDeploymentTask getTaskByName(String taskName) throws AppDeploymentException {
        return this.getTaskByName(taskName, true);
    }

    protected void getDependencyTask(int i) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDependencyTask");
        }
        if (i < this.taskInfo.size()) {
            AppDeploymentTask changedT;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "changed task: " + this.taskNames.elementAt(i));
            }
            if (!this.changedTaskProcessList.contains(changedT = (AppDeploymentTask)this.tasks.elementAt(i))) {
                block9: {
                    this.changedTaskProcessList.add(changedT);
                    try {
                        if (((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)i)).dependency != null) {
                            ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)i)).dependency.setupDependency(this, (AppDeploymentTask)this.tasks.elementAt(i));
                        }
                    }
                    catch (Throwable th) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "Exception calling dependency for " + changedT + ": " + th);
                    }
                }
                this.callListeners((String)this.taskNames.elementAt(i), changedT, "taskDataChanged");
                this.callListeners("*", changedT, "taskDataChanged");
                this.changedTaskProcessList.remove(changedT);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Circular invocation avoided for " + this.taskNames.elementAt(i));
                }
                System.out.println("Circular invocation avoided for " + this.taskNames.elementAt(i));
            }
        }
    }

    private void callListeners(String key, AppDeploymentTask changedT, String methodName) {
        List l = (List)this.taskDataChangeListeners.get(key);
        if (l == null) {
            return;
        }
        for (int j = 0; j < l.size(); ++j) {
            AppDeploymentTaskListener listener = (AppDeploymentTaskListener)l.get(j);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking listener for key=" + key + " changedT=" + changedT.getName() + " method=" + methodName);
            }
            try {
                AppDeploymentTaskListener.class.getMethod(methodName, AppDeploymentTask.class, AppDeploymentInfo.class).invoke((Object)listener, changedT, this.deploymentInfo);
                continue;
            }
            catch (Throwable th) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception calling listener " + listener + " for " + changedT + ": " + th);
            }
        }
    }

    public void getDependencyTask(String taskName) throws AppDeploymentException {
        this.getDependencyTask(this.taskNames.indexOf(taskName));
    }

    public void close(boolean bSave, boolean bValidate, boolean bClose) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close:" + bSave + ", " + bValidate + ", " + bClose);
        }
        if (bValidate) {
            String[] validateMessage;
            String warn = "WARNING";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validating ..");
            }
            if ((validateMessage = this.validate()) != null) {
                for (int i = 0; i < validateMessage.length; ++i) {
                    Pattern pat = Pattern.compile("ADMA\\d\\d\\d\\dW");
                    Matcher match = pat.matcher(validateMessage[i]);
                    if (match.find()) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Message has pattern ADMA[0-9][0-9][0-9][0-9]W.  \nFollowing message is a warning message:  ", validateMessage[i]);
                        }
                        System.out.println(validateMessage[i]);
                        validateMessage[i] = warn;
                        continue;
                    }
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug(tc, "Message:  " + validateMessage[i] + "\nDoesn't not match pattern ADMA\\d\\d\\d\\dW (e.g. ADMA0000W)");
                }
                StringBuffer errors = new StringBuffer();
                for (int i = 0; i < validateMessage.length; ++i) {
                    if (validateMessage[i].equals(warn)) continue;
                    errors.append(validateMessage[i]);
                    errors.append("\n");
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error Messages:  ", errors);
                }
                if (errors != null && errors.length() > 0) {
                    throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0014E", new Object[]{errors}), null);
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Validate only had warning messages.");
                }
            }
        }
        if (bSave) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saving ..");
            }
            this.setVariableMap(this.tasks);
            for (int i = 0; i < this.tasks.size(); ++i) {
                try {
                    AppDeploymentTask task = (AppDeploymentTask)this.tasks.elementAt(i);
                    if (!this.isPartialDeploymentInfo()) {
                        task = this.preAllCompleteTask(task);
                    }
                    this.callListeners(task.getName(), task, "beforeComplete");
                    this.callListeners("*", task, "beforeComplete");
                    this.getTaskHelper(i).completeTask(this.deploymentInfo, task);
                    this.callListeners(task.getName(), task, "afterComplete");
                    this.callListeners("*", task, "afterComplete");
                    continue;
                }
                catch (Throwable th) {
                    String taskName = (String)this.taskNames.elementAt(i);
                    throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0093E", new Object[]{taskName}), th);
                }
            }
            this.resetDataHolder();
        }
        if (bClose && this.deploymentInfo != null) {
            this.deploymentInfo.close(bSave);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public void saveAndClose() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveAndClose");
        }
        this.close(true, true, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveAndClose");
        }
    }

    public String[] validate() throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Vector<String> messages = new Vector<String>();
        String[] validateMessages = null;
        for (i = 0; i < this.tasks.size(); ++i) {
            AppDeploymentTask task;
            String[] errorMsgs;
            AppDeploymentTaskHelper helper;
            String[] errorMessages = this.getNthTask(i).validate();
            if (errorMessages != null) {
                for (int j = 0; j < errorMessages.length; ++j) {
                    messages.addElement(errorMessages[j]);
                }
            }
            if ((helper = this.getTaskHelper(i)) == null || !(helper instanceof AppDeploymentTaskValidate) || (errorMsgs = ((AppDeploymentTaskValidate)helper).validate(task = (AppDeploymentTask)this.tasks.elementAt(i), this.deploymentInfo)) == null) continue;
            for (int k = 0; k < errorMsgs.length; ++k) {
                messages.addElement(errorMsgs[k]);
            }
        }
        if (messages.size() > 0) {
            validateMessages = new String[messages.size()];
            for (i = 0; i < messages.size(); ++i) {
                validateMessages[i] = (String)messages.elementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return validateMessages;
    }

    public Hashtable getAppOptions() {
        return this.deploymentInfo.getAppOptions();
    }

    public void setAppOptions(Hashtable tbl) {
        this.deploymentInfo.setAppOptions(tbl);
    }

    public Hashtable getAppDeploymentSavedResults() {
        return this.deploymentInfo.getSavedResults();
    }

    public AppDeploymentTaskInfo getTaskInfo() {
        return (AppDeploymentTaskInfo)this.taskInfo.elementAt(this.currentTask);
    }

    public AppDeploymentTaskInfo getTaskInfo(String taskName) {
        int index = this.taskNames.indexOf(taskName);
        if (index < 0) {
            return null;
        }
        return (AppDeploymentTaskInfo)this.taskInfo.elementAt(index);
    }

    public boolean isPartialDeploymentInfo() {
        return this.deploymentInfo instanceof PartialDeploymentInfo;
    }

    public String getSecurityPolicyData() throws AppDeploymentException {
        return this.deploymentInfo.getSecurityPolicyData(this.resBundle);
    }

    public String getSecurityPolicyWarning() {
        return this.deploymentInfo.getSecurityPolicyWarning();
    }

    public void saveAsFile(String moduleUri, String fileUriInModule, InputStream inputStream) throws AppDeploymentException {
        this.deploymentInfo.saveAsFile(moduleUri, fileUriInModule, inputStream);
    }

    public void createDeploymentPlan(OutputStream out) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDeploymentPlan");
        }
        if (out == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "Null output stream for depl plan.");
            }
            return;
        }
        try {
            Vector<AppDeploymentTask> v;
            ObjectOutputStream oo = new ObjectOutputStream(out);
            Hashtable tbl = this.getAppOptions();
            if (this.deploymentInfo.isStandaloneDeployment()) {
                v = this.deploymentInfo.getAllURIStrings();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "standalone URI: " + v);
                }
                if (v.size() > 0) {
                    tbl.put("appdeplStandaloneURI", v.firstElement());
                }
            }
            oo.writeObject(tbl);
            v = new Vector<AppDeploymentTask>();
            for (int i = 0; i < this.tasks.size(); ++i) {
                v.addElement(this.getNthTask(i));
            }
            oo.writeObject(v);
            oo.flush();
            out.flush();
        }
        catch (Exception ex) {
            throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0099E", new Object[]{ex}), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDeploymentPlan");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readDeploymentPlan(File file) throws AppDeploymentException {
        if (file == null) {
            if (!tc.isDebugEnabled()) return;
            Tr.exit(tc, "Null depl plan.");
            return;
        }
        FileInputStream fIn = null;
        try {
            fIn = new FileInputStream(file);
            this.readDeploymentPlan(fIn);
            if (fIn == null) return;
        }
        catch (FileNotFoundException ex) {
            try {
                throw new AppDeploymentException("", ex);
            }
            catch (Throwable throwable) {
                if (fIn == null) throw throwable;
                try {
                    fIn.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0100E", new Object[]{ex2}), ex2);
                }
            }
        }
        try {
            fIn.close();
            return;
        }
        catch (IOException ex) {
            throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0100E", new Object[]{ex}), ex);
        }
    }

    public void readDeploymentPlan(InputStream in) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readDeploymentPlan");
        }
        try {
            Module m;
            if (in == null || in.available() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "Null depl plan.");
                }
                return;
            }
            WsObjectInputStream ii = new WsObjectInputStream(in);
            Hashtable tbl = (Hashtable)ii.readObject();
            this.getAppOptions().putAll(tbl);
            Vector v = (Vector)ii.readObject();
            String old_standaloneURI = (String)tbl.get("appdeplStandaloneURI");
            String new_standaloneURI = null;
            if (old_standaloneURI != null) {
                Vector us = this.deploymentInfo.getAllURIStrings();
                if (us.size() > 0) {
                    new_standaloneURI = (String)us.firstElement();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "oldStandaloneURI: " + old_standaloneURI + " and newStandaloneURI: " + new_standaloneURI);
                }
            }
            for (int i = 0; i < v.size(); ++i) {
                AppDeploymentTask t = (AppDeploymentTask)v.elementAt(i);
                AppDeploymentTask found = null;
                for (int j = 0; j < this.tasks.size(); ++j) {
                    AppDeploymentTask fTask = (AppDeploymentTask)this.tasks.elementAt(j);
                    if (!t.getName().equals(fTask.getName())) continue;
                    found = fTask;
                    break;
                }
                if (found == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No matching task for " + t.getName());
                    continue;
                }
                if (old_standaloneURI != null && new_standaloneURI != null) {
                    found.setTaskData(this.patchStandaloneData(t.getTaskData(), old_standaloneURI, new_standaloneURI));
                    continue;
                }
                found.setTaskData(t.getTaskData());
            }
            if (old_standaloneURI != null && this.deploymentInfo.getApplication().getModules().size() == 1 && this.getAppOptions().get("contextroot") != null && (m = (Module)this.deploymentInfo.getApplication().getModules().get(0)).isWebModule()) {
                String cr = (String)this.getAppOptions().get("contextroot");
                ((WebModule)m).setContextRoot(cr);
            }
        }
        catch (Exception ex) {
            throw new AppDeploymentException(AppUtils.getMessage(this.resBundle, "ADMA0100E", new Object[]{ex}), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readDeploymentPlan");
        }
    }

    private String[][] patchStandaloneData(String[][] data, String oldURI, String newURI) {
        if (data == null) {
            return null;
        }
        String oldModuleName = null;
        String newModuleName = null;
        try {
            String[] uriParts = oldURI.split(",");
            oldModuleName = uriParts[0];
            uriParts = newURI.split(",");
            newModuleName = uriParts[0];
        }
        catch (Exception e) {
            oldModuleName = null;
        }
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                if (oldURI.equals(data[i][j])) {
                    data[i][j] = newURI;
                    continue;
                }
                if (oldModuleName == null || !oldModuleName.equals(data[i][j])) continue;
                data[i][j] = newModuleName;
            }
        }
        return data;
    }

    public List getSelectedOptions() {
        boolean processEmbeddedCFG;
        boolean useBinaryConfig;
        boolean deployWS;
        boolean preCompileJsp;
        boolean deployEJB;
        ArrayList<String> options;
        block12: {
            options = new ArrayList<String>();
            deployEJB = false;
            preCompileJsp = false;
            deployWS = false;
            useBinaryConfig = false;
            processEmbeddedCFG = true;
            try {
                AppDeploymentOptions task = (AppDeploymentOptions)this.getTaskByName("AppDeploymentOptions", false);
                if (!task.isTaskDisabled() && task.isEJBDeployEnabled()) {
                    deployEJB = true;
                }
                if (!task.isTaskDisabled() && task.isPreCompileJSPEnabled()) {
                    preCompileJsp = true;
                }
                if (!task.isTaskDisabled() && task.isWSDeployEnabled()) {
                    deployWS = true;
                }
                if (!task.isTaskDisabled() && task.isUseBinaryConfigEnabled()) {
                    useBinaryConfig = true;
                }
                if (!task.isTaskDisabled() && !task.isProcessEmbeddedCFG()) {
                    processEmbeddedCFG = false;
                }
            }
            catch (AppDeploymentException ex) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Exception when calling getTaskByName: " + ex);
            }
        }
        if (deployEJB) {
            options.add("deployejb");
        }
        if (preCompileJsp) {
            options.add("preCompileJSPs");
        }
        if (deployWS) {
            options.add("deployws");
        }
        if (useBinaryConfig) {
            options.add("useMetaDataFromBinary");
        }
        if (processEmbeddedCFG) {
            options.add("processEmbeddedConfig");
        }
        return options;
    }

    public int getAppVersion() {
        int appVersion = ((XMLResource)this.deploymentInfo.getApplication().eResource()).getVersionID();
        Tr.debug(tc, "AppVersion " + appVersion);
        return appVersion;
    }

    public int getAppVersion(boolean checkForFeature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppVersion");
        }
        int appVersion = this.getAppVersion();
        Tr.debug(tc, "AppVersion " + appVersion);
        List options = this.getSelectedOptions();
        if (checkForFeature && options.size() > 0) {
            for (int i = 0; i < options.size(); ++i) {
                String option = (String)options.get(i);
                if (!option.equals("deployejb") && !option.equals("preCompileJsp") && !((Object)options).equals("enhancedEar") && !((Object)options).equals("deployws") && !((Object)options).equals("useMetaDataFromBinary")) continue;
                return versionTable[versionTable.length - 1][0];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppVersion " + appVersion);
        }
        return appVersion;
    }

    public int getRarVersion() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRarVersion");
        }
        int rarVersion = 99;
        int highestRarVersion = 15;
        Vector rars = this.deploymentInfo.getModuleConfig("RAR_DD");
        if (rars.size() > 0) {
            for (int i = 0; i < rars.size(); ++i) {
                Connector connector2 = (Connector)rars.elementAt(i);
                rarVersion = connector2.getVersionID();
                if (rarVersion < highestRarVersion) continue;
                rarVersion = highestRarVersion;
            }
        }
        Tr.debug(tc, "the highest rar version " + rarVersion);
        return rarVersion;
    }

    public Hashtable getServerTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTable");
        }
        Hashtable<String, String> servertbl = new Hashtable<String, String>();
        int index = this.taskNames.indexOf("MapModulesToServers");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "index for mapmod task: " + index);
        }
        if (index < 0) {
            return servertbl;
        }
        AppDeploymentTask task = (AppDeploymentTask)this.tasks.elementAt(index);
        if (task.getTaskData() == null && !task.isTaskEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task not prepared .. return whats in options");
            }
            Hashtable<String, String> tbl = (Hashtable<String, String>)this.getAppOptions().get("moduleToServer");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " table is : " + tbl);
            }
            return tbl != null ? tbl : servertbl;
        }
        if (task.isTaskEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task empty");
            }
            return servertbl;
        }
        String[][] taskData = task.getTaskData();
        for (int i = 0; i < taskData.length; ++i) {
            String s;
            if (taskData[i][2] == null || taskData[i][2].equals("") || (s = taskData[i][2]).indexOf(58) == -1 && s.indexOf(44) == -1) continue;
            servertbl.put(util.createUniqueModuleNameFromUriString(taskData[i][1]), s);
        }
        Tr.debug(tc, "servertbl " + servertbl.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTable");
        }
        return servertbl;
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    public Session getConfigSession() {
        return this.configSession;
    }

    public ConfigService getConfigService() throws Exception {
        if (this.configService == null && ConfigServiceFactory.getConfigService() != null) {
            this.configService = ConfigServiceFactory.getConfigService();
        }
        return this.configService;
    }

    public boolean checkIfEnhancedEar() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfEnhancedEar");
        }
        boolean flag = false;
        if (this.deploymentInfo instanceof ArchiveDeploymentInfo) {
            flag = ((ArchiveDeploymentInfo)this.deploymentInfo).checkIfEnhancedEar();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfEnhancedEar", new Object[]{new Boolean(flag)});
        }
        return flag;
    }

    public Resource getEnhancedEarDeploymentResource(String resName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnhancedEarDeploymentResource", new Object[]{resName});
        }
        Resource res = null;
        if (this.deploymentInfo instanceof ArchiveDeploymentInfo) {
            res = ((ArchiveDeploymentInfo)this.deploymentInfo).getEnhancedEarDeploymentResource(resName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnhancedEarDeploymentResource", new Object[]{res});
        }
        return res;
    }

    public void postAllPrepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask task) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postAllPrepareTask", new Object[]{task});
        }
        Hashtable taskInfo = null;
        String strTName = task.getName();
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "TaskName:  ", strTName);
        }
        if (task.getTaskData() == null && tc.isEntryEnabled()) {
            Tr.debug(tc, "TaskData is null for following task:  " + task.getName() + "!!! NOTHING TO DO!!!  This task doesn't apply!!!");
        }
        if (this.dh == null || this.dh.getProps() == null || this.dh.getProps().isEmpty()) {
            try {
                if (!((ArchiveDeploymentInfo)appInstallInfo).containsURI(null, "META-INF/ibm-was-config.props") && tc.isEntryEnabled()) {
                    Tr.debug(tc, "No property based config file was found.");
                }
                InputStream is = ((ArchiveDeploymentInfo)appInstallInfo).getInputStream(null, "META-INF/ibm-was-config.props");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "property config file stored under META-INF/ibm-was-config.props");
                }
                String strResourceType = "Application";
                this.dh.setProps(ConfigPropertiesHelper.getPropertiesByResourceType((InputStream)is, (String)strResourceType));
                is.close();
            }
            catch (AppDeploymentException ioex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no property based config file was found in the archive!!!");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postAllPrepareTask");
                }
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Following throwable received in prepare task:", th);
                }
                return;
            }
        }
        if ((taskInfo = this.dh.getProps().get(strTName)) != null && !taskInfo.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "TaskInfo:  ", taskInfo);
            }
            if (strTName.equals("AppDeploymentOptions")) {
                this.processSpecialTaskOption(task, taskInfo);
            } else {
                Enumeration e = taskInfo.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String[] rowKey = key.toLowerCase().split("row");
                    if (rowKey == null || rowKey.length != 2 || rowKey[1].equals("0")) continue;
                    try {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "taskData length:  " + task.getTaskData().length + "rowKey:" + rowKey[1]);
                        }
                        boolean[] mutables = task.getMutableColumns();
                        String p = null;
                        for (int ii = 0; ii < task.getColumnNames().length; ++ii) {
                            p = p + ", " + task.getColumnNames()[ii];
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "taskData mutables:  ", p);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "taskData mutables:  ", mutables);
                        }
                        int lastMutable = 0;
                        for (lastMutable = mutables.length; lastMutable > 0 && mutables[lastMutable - 1]; --lastMutable) {
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "mutalbes last column:  ", lastMutable - 1);
                        }
                        String[] data = (String[])taskInfo.get(key);
                        for (int bb = 0; bb < data.length; ++bb) {
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "Data found:  ", data[bb]);
                        }
                        if (data.length < lastMutable) {
                            if (!tc.isEntryEnabled()) break;
                            Tr.debug(tc, "Incompatible length of config property data: " + data.length + " and mutable column: " + (lastMutable - 1));
                            break;
                        }
                        String[][] moddata = task.getTaskData();
                        int rowId = this.isRowMatch(mutables, data, moddata);
                        if (rowId == -1) continue;
                        for (int i = 0; i < data.length; ++i) {
                            if (mutables[i]) {
                                if (task.getTaskData()[rowId][i] == null || task.getTaskData()[rowId][i].trim().equals("") || task.getTaskData()[rowId][i].equals("null")) continue;
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "Data modified from:  " + task.getTaskData()[rowId][i] + "  to: " + data[i]);
                                }
                                moddata[rowId][i] = data[i];
                                task.setTaskData(moddata);
                                continue;
                            }
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "Data is not mutable!", data[i]);
                        }
                    }
                    catch (Throwable th) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "ignore following row:  ", rowKey[0]);
                        }
                        if (!tc.isEntryEnabled()) continue;
                        Tr.debug(tc, "EXCEPTION:  ", th);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postAllPrepareTask");
        }
    }

    private void processSpecialTaskOption(AppDeploymentTask task, Hashtable<String, String[]> taskInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSpecialTaskOption", new Object[]{task, taskInfo});
        }
        String[] colNames = this.storeColumnName(taskInfo);
        String[] taskColNames = task.getColumnNames();
        List<String> unmutableCol = this.getAllUnmutableColumns(task);
        List<String> unmutableColNames = this.getUnmutableColumnNames(colNames, unmutableCol);
        Enumeration<String> e = taskInfo.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String[] rowKey = key.toLowerCase().split("row");
            if (rowKey == null || rowKey.length != 2 || rowKey[1].equals("0")) continue;
            try {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "taskData length:  " + task.getTaskData().length + "rowKey:" + rowKey[1]);
                }
                String[] data = taskInfo.get(key);
                for (int i = 1; i < task.getTaskData().length; ++i) {
                    for (int j = 0; j < colNames.length; ++j) {
                        if (!unmutableColNames.contains(colNames[j])) {
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "Updating column name:  ", colNames[j]);
                            }
                            for (int k = 0; k < taskColNames.length; ++k) {
                                if (taskColNames[k].equals(colNames[j])) {
                                    if (data[j] != null && !data[j].trim().equals("*")) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.debug(tc, "Data modified from:  " + task.getTaskData()[i][k] + "  to: " + data[j]);
                                        }
                                        String[][] moddata = task.getTaskData();
                                        moddata[i][k] = data[j];
                                        task.setTaskData(moddata);
                                    }
                                    task.getTaskData()[i][k] = data[j];
                                    continue;
                                }
                                if (!tc.isEntryEnabled()) continue;
                                Tr.debug(tc, "Ignore following column:  ", taskColNames[k]);
                            }
                            continue;
                        }
                        if (!tc.isEntryEnabled()) continue;
                        Tr.debug(tc, "unmutable column encountered:  ", taskColNames[j]);
                    }
                }
            }
            catch (Throwable th) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "ignore following row:  ", rowKey[0]);
                }
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "EXCEPTION:  ", th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSpecialTaskOption");
        }
    }

    private List<String> getUnmutableColumnNames(String[] colNames, List<String> unmutableCol) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnmutableColumnNames", new Object[]{colNames, unmutableCol});
        }
        ArrayList<String> index = new ArrayList<String>();
        if (colNames != null) {
            for (int i = 0; i < colNames.length; ++i) {
                if (!unmutableCol.contains(colNames[i])) continue;
                index.add(colNames[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnmutableColumnNames", index);
        }
        return index;
    }

    private List<String> getAllUnmutableColumns(AppDeploymentTask task) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllUnmutableColumns", task);
        }
        ArrayList<String> col = new ArrayList<String>();
        String[] colNames = task.getColumnNames();
        if (colNames != null) {
            for (int i = 0; i < colNames.length; ++i) {
                if (task.getMutableColumns(i)) continue;
                col.add(colNames[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllUnmutableColumns", col);
        }
        return col;
    }

    private String[] storeColumnName(Hashtable<String, String[]> taskInfo) {
        String[] data;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeColumnName", taskInfo);
        }
        if ((data = taskInfo.get("row0")) == null) {
            data = taskInfo.get("ROW0");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSpecialTaskOption", data);
        }
        return data;
    }

    private int isRowMatch(boolean[] mutables, String[] data, String[][] moddata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRowMatch", new Object[]{mutables, data, moddata});
        }
        int rowId = -1;
        for (int i = 0; i < moddata.length; ++i) {
            for (int j = 0; j < mutables.length; ++j) {
                if (!mutables[j]) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "data found:  ", new Object[]{data[j], moddata[i][j]});
                    }
                    if (!data[j].trim().equals("*") && !data[j].trim().equals(moddata[i][j].trim())) break;
                    if (!data[j].trim().equals("*")) {
                        rowId = i;
                        continue;
                    }
                    if (i == 0 || j != mutables.length - 1) continue;
                    rowId = i;
                    continue;
                }
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "This row is mutable, so ignore this one:  ", new Object[]{mutables[j], i});
            }
            if (rowId != -1) break;
            rowId = -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRowMatch", new Object[]{rowId});
        }
        return rowId;
    }

    public void setVariableMap(Vector vtask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVariableMap", new Object[]{vtask});
        }
        if (vtask != null && !vtask.isEmpty() && this.dh != null && this.dh.getVariableMap() != null && !this.dh.getVariableMap().isEmpty()) {
            for (AppDeploymentTask t : vtask) {
                String[][] data;
                if (!t.getName().equals("PropertyBasedConfig") || (data = t.getTaskData()) == null) continue;
                HashMap<String, String> varMap = this.dh.getVariableMap();
                for (int j = 0; j < data.length; ++j) {
                    String varName = "!{" + data[j][0] + "}";
                    if (!varMap.containsKey(varName)) continue;
                    varMap.put(varName, data[j][1]);
                }
                this.dh.setVariableMap(varMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVariableMap", new Object[]{this.dh.getVariableMap()});
        }
    }

    public AppDeploymentTask preAllCompleteTask(AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preAllCompleteTask", new Object[]{t});
        }
        if (this.dh != null && !this.dh.getKeyVariableTuplet().isEmpty()) {
            int j;
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "task variable tuplet: ", this.dh.getKeyVariableTuplet());
            }
            HashMap<String, String[]> map = this.dh.getKeyVariableTuplet();
            Set<String> s = map.keySet();
            for (String key : s) {
                String[] tt = map.get(key);
                for (j = 0; j < tt.length; ++j) {
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug(tc, "Task Name: " + key + " value:  ", tt[j]);
                }
            }
            String[] vars = map.get(t.getName());
            if (vars != null && vars.length > 0) {
                String[][] data = t.getTaskData();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "TaskName:" + t.getName() + " has variables: ", new Object[]{vars, data});
                }
                for (int i = 0; i < data.length; ++i) {
                    for (j = 0; j < data[i].length; ++j) {
                        for (int k = 0; k < vars.length; ++k) {
                            String temp = data[i][j];
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "Data for task: ", temp);
                            }
                            if (!temp.contains(vars[k])) continue;
                            if (this.dh != null && this.dh.getVariableMap() != null) {
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "replacing the variable:  :" + vars[k] + " with: " + this.dh.getVariableMap().get(vars[k]));
                                }
                                data[i][j] = temp.replace(vars[k], this.dh.getVariableMap().get(vars[k]));
                                continue;
                            }
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "Either dataHolder is null or variableMap is null");
                        }
                    }
                }
                t.setTaskData(data);
            } else if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Task " + t.getName() + " doesn't have any variables.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preAllCompleteTask");
        }
        return t;
    }

    public String[][] getModifiedTaskData(String taskName, String[][] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModifiedTaskData", data);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (AppDeploymentTask t : this.tasks) {
            String[][] tdata;
            if (!t.getName().equals("PropertyBasedConfig") || (tdata = t.getTaskData()) == null) continue;
            for (int kk = 0; kk < tdata.length; ++kk) {
                if (kk == 0) continue;
                map.put("!{" + tdata[kk][0] + "}", tdata[kk][1]);
            }
        }
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    Set keys = map.keySet();
                    Iterator i$ = keys.iterator();
                    while (i$.hasNext()) {
                        String temp = data[i][j];
                        String key = (String)i$.next();
                        if (temp.contains(key)) {
                            data[i][j] = temp.replace(key, (CharSequence)map.get(key));
                            continue;
                        }
                        if (!tc.isEntryEnabled()) continue;
                        Tr.debug(tc, "Either dataHolder is null or variableMap is null");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModifiedTaskData", data);
        }
        return data;
    }

    public void resetDataHolder() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetDataHolder");
        }
        this.dh.setKeyVariableTuplet(new HashMap<String, String[]>());
        this.dh.setPropFile(new Properties());
        this.dh.setProps(new Hashtable<String, Hashtable>());
        this.dh.setVariableMap(new HashMap<String, String>());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetDataHolder");
        }
    }

    public DataHolder getDataHolder() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataHolder");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataHolder");
        }
        return this.dh;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/client/AppDeploymentController.java, WAS.admin.installapp.client, WAS70.SERV1, q0834.18, ver. 1.67.2.16");
        }
        CLASS_NAME = AppDeploymentController.class.getName();
        encoderInit = false;
        propBasedConfig = false;
        versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}, {50, 6}};
    }
}

