/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import java.io.File;
import java.util.Hashtable;

public class AppManagementHelper {
    private static TraceComponent tc = Tr.register(AppManagementHelper.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");

    public static String wrapModule(String moduleFile, String earFileName, String newModuleURI, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wrapModule: " + moduleFile + ", ear=" + earFileName);
        }
        String ret = AppInstallHelper.createEarWrapper(moduleFile, earFileName, newModuleURI, prefs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "wrapModule: " + earFileName + ", uri=" + newModuleURI);
        }
        return ret;
    }

    public static boolean isSystemApp(String earPath) {
        boolean retVal;
        if (earPath == null) {
            return false;
        }
        File f = new File(earPath);
        boolean bl = retVal = f.exists() && f.isDirectory() && (new File(earPath + "/" + "META-INF/ibm-application-sa.props").exists() || new File(earPath + "/" + "META-INF/ibm-application-sa2.props").exists());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSystemApp = " + retVal);
        }
        return retVal;
    }

    public static boolean isSystemAppV6(String earPath) {
        boolean retVal;
        if (earPath == null) {
            return false;
        }
        File f = new File(earPath);
        boolean bl = retVal = f.exists() && f.isDirectory() && new File(earPath + "/" + "META-INF/ibm-application-sa.props").exists();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSystemAppV6 = " + retVal);
        }
        return retVal;
    }

    public static boolean isHiddenApp(String earPath) throws Exception {
        boolean retVal;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isHidden earPath = " + earPath);
        }
        if (earPath == null) {
            return false;
        }
        File f = new File(earPath);
        boolean bl = retVal = f.exists() && f.isDirectory() && new File(earPath + "/" + "META-INF/ibm-application-ha.props").exists();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isHidden = " + retVal);
        }
        return retVal;
    }

    public static boolean validateFilePermissionString(String perm) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateFilePermissionString: " + perm);
        }
        boolean result = AppUtils.validateFilePermissionString(perm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateFilePermissionString: " + result);
        }
        return result;
    }
}

