/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetPolicy;
import com.ibm.websphere.command.TargetPolicyDefault;
import com.ibm.websphere.command.TargetableCommand;
import com.ibm.websphere.command.UnsetInputPropertiesException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class TargetableCommandImpl
implements TargetableCommand {
    private static final TraceComponent _tc = Tr.register(TargetableCommandImpl.class);
    public static String LOCAL = "com.ibm.websphere.command.LocalTarget";
    protected static TargetPolicy targetPolicy = new TargetPolicyDefault();
    protected transient CommandTarget commandTarget = null;
    protected String commandTargetName = null;
    protected boolean hasOutputProperties = true;

    public void execute() throws CommandException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "execute");
        }
        if (!this.isReadyToCallExecute()) {
            UnsetInputPropertiesException ex = new UnsetInputPropertiesException();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "execute", (Object)ex);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "execute", "The command is not ready to execute");
            }
            throw ex;
        }
        try {
            if (targetPolicy == null) {
                IllegalStateException ex = new IllegalStateException("TargetPolicy is not set");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "execute", ex);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "execute", "Target policy is null");
                }
                throw ex;
            }
            CommandTarget commandTarget = targetPolicy.getCommandTarget(this);
            TargetableCommand returnedCommand = commandTarget.executeCommand(this);
            if (this.hasOutputProperties() && this != returnedCommand) {
                if (returnedCommand == null) {
                    CommandException ex = new CommandException("Command returned from CommandTarget was null and this command has output properties.");
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "execute", (Object)ex);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "execute", "returned command is null");
                    }
                    throw ex;
                }
                this.setOutputProperties(returnedCommand);
            }
        }
        catch (CommandException ex) {
            FFDCFilter.processException((Throwable)((Object)ex), "com.ibm.websphere.command.TargetableCommandImpl.execute", "133", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "execute", (Object)ex);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "execute", (Object)ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.websphere.command.TargetableCommandImpl.execute", "137", this);
            if (ex instanceof RemoteException) {
                RemoteException remoteException = (RemoteException)ex;
                if (remoteException.detail != null) {
                    CommandException e = new CommandException(remoteException.detail);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "execute", (Object)e);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "execute", (Object)e);
                    }
                    throw e;
                }
            }
            CommandException exc = new CommandException(ex);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "execute", (Object)exc);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "execute", (Object)exc);
            }
            throw exc;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "execute");
        }
    }

    public CommandTarget getCommandTarget() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCommandTarget");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCommandTarget", this.commandTarget);
        }
        return this.commandTarget;
    }

    public String getCommandTargetName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCommandTargetName");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCommandTargetName", this.commandTargetName);
        }
        return this.commandTargetName;
    }

    public static TargetPolicy getTargetPolicy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTargetPolicy");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getTargetPolicy", targetPolicy);
        }
        return targetPolicy;
    }

    public final boolean hasOutputProperties() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "hasOutputProperties");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "hasOutputProperties", new Boolean(this.hasOutputProperties));
        }
        return this.hasOutputProperties;
    }

    public abstract boolean isReadyToCallExecute();

    public abstract void performExecute() throws Exception;

    public abstract void reset();

    public void setCommandTarget(CommandTarget commandTarget) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCommandTarget", commandTarget);
        }
        this.commandTarget = commandTarget;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCommandTarget");
        }
    }

    public void setCommandTargetName(String commandTargetName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCommandTargetName", commandTargetName);
        }
        this.commandTargetName = commandTargetName;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCommandTargetName");
        }
    }

    public final void setHasOutputProperties(boolean inProp) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setHasOutputProperties", new Boolean(inProp));
        }
        this.hasOutputProperties = inProp;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setHasOutputProperties");
        }
    }

    public void setOutputProperties(final TargetableCommand fromCommand) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setOutputProperties", fromCommand);
        }
        try {
            final Class<?> theClass = this.getClass();
            final TargetableCommandImpl outerThis = this;
            if (!fromCommand.getClass().equals(theClass)) {
                IllegalStateException ex = new IllegalStateException("fromCommand is not of the same class");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "setOutputProperties", ex);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "setOutputProperties", "fromCommand is not of the same class");
                }
                throw ex;
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AccessibleObject[] fields = theClass.getDeclaredFields();
                    Field.setAccessible(fields, true);
                    for (int i = 0; i < fields.length; ++i) {
                        int modifiers = ((Field)fields[i]).getModifiers();
                        if (Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
                        ((Field)fields[i]).set(outerThis, ((Field)fields[i]).get(fromCommand));
                    }
                    Field.setAccessible(fields, false);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.websphere.command.TargetableCommandImpl.setOutputProperties", "371", this);
            IllegalStateException e = new IllegalStateException("Since not all your variables are public in your command, you need to override the default implementation of TargetableCommand.setOutputProperties().");
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "setOutputProperties", e);
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setOutputProperties");
        }
    }

    public static void setTargetPolicy(TargetPolicy targetPolicy) {
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setTargetPolicy", targetPolicy);
        }
        TargetableCommandImpl.targetPolicy = targetPolicy;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setTargetPolicy");
        }
    }
}

