/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.util.xml;

import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.ErrorHandlerImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMConverter {
    static Document parse(String url) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder parser2 = factory.newDocumentBuilder();
            parser2.setErrorHandler(new ErrorHandlerImpl());
            Logger.normal("Parsing the URL '" + url + "'...", 0);
            parser2.parse(url);
            Logger.normal("Done.", 0);
            return parser2.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    static Document parse(Reader in) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder parser2 = factory.newDocumentBuilder();
            parser2.setErrorHandler(new ErrorHandlerImpl());
            Logger.normal("Parsing an XML stream...", 0);
            parser2.parse(new InputSource(in));
            Logger.normal("Done.", 0);
            return parser2.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    private DOMConverter() {
    }

    public static Document toDOM(String xml) throws SAXException {
        try {
            StringReader in = new StringReader(xml);
            StringWriter out = new StringWriter();
            Document dom = DOMConverter.parse(in);
            in.close();
            out.close();
            return dom;
        }
        catch (IOException e) {
            throw new UnknownError(e.getMessage());
        }
    }

    public static Document toDOM(String string, boolean isURL) throws SAXException, IOException {
        return isURL ? DOMConverter.parse(string) : DOMConverter.toDOM(string);
    }

    public static Document toDOM(Reader in) throws IOException, SAXException {
        return DOMConverter.parse(in);
    }

    public static String toString(Node node) {
        return DOMConverter.toString(node, null);
    }

    public static String toString(Node node, String encoding) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            StringWriter out = new StringWriter();
            StreamResult result = new StreamResult(out);
            DOMSource source = new DOMSource(node);
            switch (node.getNodeType()) {
                case 9: {
                    transformer.transform(source, result);
                    break;
                }
                case 1: {
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(source, result);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported node type: " + node.getNodeType());
                }
            }
            out.flush();
            return out.getBuffer().toString();
        }
        catch (TransformerConfigurationException ex) {
            throw new UnknownError(ex.getMessage());
        }
        catch (TransformerException ex) {
            throw new UnknownError(ex.getMessage());
        }
    }
}

