/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public final class Logger {
    public static final int MIN_LEVEL = 0;
    public static final int DEFAULT_LEVEL = 4;
    public static final int MAX_LEVEL = 9;
    private static final Object lock = new Object();
    private static int currentLevel = 4;
    private static PrintWriter out = new PrintWriter(System.out);
    private static final String PROPERTY_LOG_LEVEL = "com.ibm.trl.util.logLevel";
    private static final String PROPERTY_APPLICATION_NAME = "com.ibm.trl.util.applicationName";
    private static final String PROPERTY_NO_TIME_STAMP = "com.ibm.trl.util.noTimeStamp";
    private static final String applicationName;
    private static final boolean noTimeStamp;

    private Logger() {
    }

    public static void setOut(OutputStream out) {
        Logger.setOut(new PrintWriter(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOut(PrintWriter out) {
        Object object = lock;
        synchronized (object) {
            Logger.out = out;
        }
    }

    public static void setLevel(int level) {
        if (level < 0) {
            level = 0;
        }
        if (level > 9) {
            level = 9;
        }
        currentLevel = level;
    }

    public static int getLevel() {
        return currentLevel;
    }

    public static void normal(String message) {
        Logger.normal(message, 4);
    }

    public static void normal(String message, int level) {
        if (level >= currentLevel) {
            Logger.print(message, ' ');
        }
    }

    public static void warning(String message) {
        Logger.print(message, 'W');
    }

    public static void fatal(String message) {
        Logger.print(message, 'F');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(String message, char type) {
        Object object = lock;
        synchronized (object) {
            if (out != null) {
                out.println(type + (applicationName == null ? "" : "[" + applicationName + "] ") + (noTimeStamp ? "" : "[" + Logger.getTime() + "] ") + Thread.currentThread().getName() + " \"" + message + "\"");
                out.flush();
            }
        }
    }

    private static String getTime() {
        return DateFormat.getDateTimeInstance(0, 0).format(new Date());
    }

    static {
        String value = System.getProperties().getProperty(PROPERTY_LOG_LEVEL);
        if (value != null) {
            try {
                Logger.setLevel(Integer.parseInt(value));
                Logger.normal("Set log level to " + value);
            }
            catch (NumberFormatException e) {
                Logger.warning("Logger: " + e.getMessage());
            }
        }
        applicationName = System.getProperties().getProperty(PROPERTY_APPLICATION_NAME);
        noTimeStamp = System.getProperties().getProperty(PROPERTY_NO_TIME_STAMP) != null;
    }
}

