/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.soapimpl;

import com.ibm.trl.soap.SOAPFault;
import com.ibm.trl.soapimpl.SOAPBodyEntryImpl;
import com.ibm.trl.util.xml.DOMHandler;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SOAPFaultImpl
extends SOAPBodyEntryImpl
implements SOAPFault {
    public static final int FAULT_CODE_TYPE_VERSION_MISMATCH = 1;
    public static final int FAULT_CODE_TYPE_MUST_UNDERSTAND = 2;
    public static final int FAULT_CODE_TYPE_CLIENT = 3;
    public static final int FAULT_CODE_TYPE_SERVER = 4;
    public static final int FAULT_CODE_TYPE_PROTOCOL = 5;
    public static final int TYPE_FAULT_CODE = 1;
    public static final int TYPE_FAULT_STRING = 2;
    public static final int TYPE_FAULT_ACTOR = 3;
    public static final int TYPE_DETAIL = 4;
    private static final long serialVersionUID = 831363181737552394L;
    private static final Hashtable tabFaultCode = new Hashtable();
    private static final Hashtable tabField;

    public static int getFaultCode(String faultCode) {
        Integer integer = (Integer)tabFaultCode.get(faultCode);
        if (integer == null) {
            throw new IllegalArgumentException("Unknown faultCode: " + faultCode);
        }
        return integer;
    }

    public static String getFaultCode(int faultCode) {
        switch (faultCode) {
            case 1: {
                return "SOAP-ENV:VersionMismatch";
            }
            case 2: {
                return "SOAP-ENV:MustUnderstand";
            }
            case 3: {
                return "SOAP-ENV:Client";
            }
            case 4: {
                return "SOAP-ENV:Server";
            }
            case 5: {
                return "SOAP-ENV:Protocol";
            }
        }
        throw new IllegalArgumentException("Unknown faultCode: " + faultCode);
    }

    public static int getFieldType(String fieldName) {
        Integer integer = (Integer)tabField.get(fieldName);
        if (integer == null) {
            throw new IllegalArgumentException("Unknown field name: " + fieldName);
        }
        return integer;
    }

    public static String getFieldName(int type) {
        switch (type) {
            case 1: {
                return "faultcode";
            }
            case 2: {
                return "faultstring";
            }
            case 3: {
                return "faultactor";
            }
            case 4: {
                return "detail";
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + type);
    }

    SOAPFaultImpl(Element entity) {
        super(entity);
    }

    SOAPFaultImpl(Document dom, String faultCode, String faultString, String faultActor) {
        super(dom.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Fault"));
        this.setFaultCode(faultCode);
        this.setFaultString(faultString);
        this.setFaultActor(faultActor);
    }

    SOAPFaultImpl(Document dom, String faultCode, String faultString, String faultActor, Element[] detailElements) {
        this(dom, faultCode, faultString, faultActor);
        this.setDetail(detailElements);
    }

    public void setFaultCode(String value) {
        this.setField(1, value);
    }

    public void setFaultString(String value) {
        this.setField(2, value);
    }

    public void setFaultActor(String value) {
        this.setField(3, value);
    }

    public void setDetail(Element[] detailElements) {
        if (detailElements != null && detailElements.length != 0) {
            Element detail = this.initField(4);
            for (int i = 0; i < detailElements.length; ++i) {
                if (detailElements[i] == null) continue;
                detail.appendChild(detailElements[i]);
            }
        }
    }

    public String getFaultCode() {
        return this.getField(1);
    }

    public String getFaultString() {
        return this.getField(2);
    }

    public String getFaultActor() {
        return this.getField(3);
    }

    public Element[] getDetail() {
        try {
            Vector<Node> buf = new Vector<Node>();
            NodeList list = this.getFieldElement(4).getChildNodes();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                buf.addElement(list.item(i));
            }
            Element[] elements = new Element[buf.size()];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = (Element)buf.elementAt(i);
            }
            return elements;
        }
        catch (NoSuchElementException e) {
            return new Element[0];
        }
    }

    public void removeFaultCode() {
        this.removeField(1);
    }

    public void removeFaultString() {
        this.removeField(2);
    }

    public void removeFaultActor() {
        this.removeField(3);
    }

    public void removeDetail() {
        this.removeField(4);
    }

    private Element initField(int type) {
        Element fault = this.getDOMEntity();
        Document dom = fault.getOwnerDocument();
        Element field = dom.createElement(SOAPFaultImpl.getFieldName(type));
        try {
            fault.replaceChild(field, this.getFieldElement(type));
        }
        catch (NoSuchElementException e) {
            fault.appendChild(field);
        }
        return field;
    }

    private void setField(int type, String value) {
        if (value != null && !"".equals(value)) {
            this.initField(type).appendChild(this.getDOMEntity().getOwnerDocument().createTextNode(value));
        }
    }

    private String getField(int type) {
        try {
            return DOMHandler.getNodeValue(this.getFieldElement(type));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private void removeField(int type) {
        try {
            this.getDOMEntity().removeChild(this.getFieldElement(type));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private Element getFieldElement(int type) {
        return this.getElementByName(SOAPFaultImpl.getFieldName(type));
    }

    private Element getElementByName(String name) throws NoSuchElementException {
        Element entity = this.getDOMEntity();
        if (entity == null) {
            throw new NoSuchElementException();
        }
        NodeList list = entity.getElementsByTagName(name);
        if (list.getLength() == 0) {
            throw new NoSuchElementException();
        }
        return (Element)list.item(0);
    }

    static {
        tabFaultCode.put("SOAP-ENV:VersionMismatch", new Integer(1));
        tabFaultCode.put("SOAP-ENV:MustUnderstand", new Integer(2));
        tabFaultCode.put("SOAP-ENV:Client", new Integer(3));
        tabFaultCode.put("SOAP-ENV:Server", new Integer(4));
        tabFaultCode.put("SOAP-ENV:Protocol", new Integer(5));
        tabField = new Hashtable();
        tabField.put("faultcode", new Integer(1));
        tabField.put("faultstring", new Integer(2));
        tabField.put("faultactor", new Integer(3));
        tabField.put("detail", new Integer(4));
    }
}

