/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.soapimpl;

import com.ibm.trl.soap.SOAPElement;
import com.ibm.trl.util.xml.DOMConverter;
import com.ibm.trl.util.xml.DOMHandler;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class SOAPElementImpl
implements SOAPElement {
    Element entity;

    SOAPElementImpl(Element entity) {
        this.entity = entity;
    }

    public Element getDOMEntity() {
        return this.entity;
    }

    public void setDOMEntity(Element entity) {
        this.entity = entity;
    }

    public void setEncodingStyle(String uri) {
        this.entity.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:encodingStyle", uri);
    }

    public String getEncodingStyle() {
        String value = this.entity.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        if (!"".equals(value)) {
            return value;
        }
        return null;
    }

    public void removeEncodingStyle() {
        this.entity.removeAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:encodingStyle");
    }

    public void declareNamespace(String namespaceURI, String prefix) {
        Element entity = this.getDOMEntity();
        entity.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceURI);
    }

    public String toXML() {
        return DOMConverter.toString(this.entity);
    }

    public String toXML(String encoding) {
        return DOMConverter.toString(this.entity, encoding);
    }

    public String toString() {
        return this.toXML();
    }

    public void ownedBy(Element parent) {
        this.ownedBy(parent.getOwnerDocument());
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.entity.getNamespaceURI())) {
            String prefix = DOMHandler.getPrefixForNamespaceURI(parent, "http://schemas.xmlsoap.org/soap/envelope/");
            this.entity.setPrefix(prefix);
        }
    }

    public void ownedBy(Document dom) {
        if (dom != this.entity.getOwnerDocument()) {
            this.entity = (Element)dom.importNode(this.entity, true);
        }
    }

    public int getEntryCount() {
        return this.getEntries().length;
    }

    NodeList getElementsNamed(String name) {
        return this.getDOMEntity().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", name);
    }

    Element[] getEntries() {
        NodeList list = this.getDOMEntity().getChildNodes();
        int length = list.getLength();
        Vector<Node> buf = new Vector<Node>();
        for (int i = 0; i < length; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            buf.addElement(node);
        }
        Element[] entries = new Element[buf.size()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = (Element)buf.elementAt(i);
        }
        return entries;
    }

    public void setID(String id) {
        this.getDOMEntity().setAttribute("id", id);
    }

    public void removeID() {
        this.getDOMEntity().removeAttribute("id");
    }
}

