/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.soapimpl;

import com.ibm.trl.soap.SOAPBody;
import com.ibm.trl.soap.SOAPBodyEntry;
import com.ibm.trl.soap.SOAPFault;
import com.ibm.trl.soapimpl.SOAPBodyEntryImpl;
import com.ibm.trl.soapimpl.SOAPElementImpl;
import com.ibm.trl.soapimpl.SOAPFaultImpl;
import com.ibm.trl.util.xml.DOMHandler;
import com.ibm.trl.util.xml.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class SOAPBodyImpl
extends SOAPElementImpl
implements SOAPBody {
    private static final QName QNAME_SOAP_FAULT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    private static final long serialVersionUID = 9158384640155646007L;

    SOAPBodyImpl(Element entity) {
        super(entity);
    }

    public SOAPBodyImpl(Document dom) {
        super(dom.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Body"));
    }

    public void setFault(SOAPFault fault) {
        Element body = this.getDOMEntity();
        this.removeFault();
        fault.ownedBy(body);
        body.appendChild(fault.getDOMEntity());
    }

    public SOAPFault getFault() {
        NodeList list = this.getElementsNamed("Fault");
        if (list.getLength() == 0) {
            return null;
        }
        return new SOAPFaultImpl((Element)list.item(0));
    }

    public void removeFault() {
        Element body = this.getDOMEntity();
        NodeList list = this.getElementsNamed("Fault");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            body.removeChild(list.item(i));
        }
    }

    public boolean containsFault() {
        return this.getElementsNamed("Fault").getLength() != 0;
    }

    public int getBodyEntryCount() {
        return this.getEntryCount();
    }

    public SOAPBodyEntry getBodyEntry(int index) {
        return this.createBodyEntry(this.getEntries()[index]);
    }

    public SOAPBodyEntry[] getBodyEntries() {
        Element[] entities = this.getEntries();
        SOAPBodyEntry[] entries = new SOAPBodyEntry[entities.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = this.createBodyEntry(entities[i]);
        }
        return entries;
    }

    public void addBodyEntry(SOAPBodyEntry bodyEntry) {
        Element body = this.getDOMEntity();
        bodyEntry.ownedBy(body);
        body.appendChild(bodyEntry.getDOMEntity());
    }

    public void removeBodyEntry(SOAPBodyEntry bodyEntry) {
        this.getDOMEntity().removeChild(bodyEntry.getDOMEntity());
    }

    private SOAPBodyEntry createBodyEntry(Element elem) {
        if (DOMHandler.isNodeNamedNS(elem, QNAME_SOAP_FAULT)) {
            return new SOAPFaultImpl(elem);
        }
        return new SOAPBodyEntryImpl(elem);
    }
}

